/*
 * Decompiled with CFR 0.152.
 */
package com.datastead.swing;

import com.datastead.swing.TVideoGrabberWindow;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.nio.ByteBuffer;
import javax.swing.SwingUtilities;

public class TVideoGrabber
extends com.datastead.TVideoGrabber {
    private TVideoGrabberWindow m_imagePanel;
    private final BufferedImage[] m_imageBuffers = new BufferedImage[2];
    private int m_currentBufferIndex = 0;
    private volatile boolean repaintScheduled = false;

    @Override
    public boolean startPreview() {
        return this.startAsync(() -> super.startPreview());
    }

    @Override
    public boolean startRecording() {
        return this.startAsync(() -> super.startRecording());
    }

    private void setOnUpdateFrame(updateFrameCB updateFrameCB2) {
        if (this.nativePtr != 0L && updateFrameCB2 != null) {
            this.SetOnUpdateFrame(this.nativePtr, updateFrameCB2);
        }
    }

    public void setView(TVideoGrabberWindow tVideoGrabberWindow) {
        this.m_imagePanel = tVideoGrabberWindow;
        if (this.m_imagePanel != null) {
            this.setOnUpdateFrame(this::onUpdateView);
        }
    }

    private void onUpdateView(ByteBuffer byteBuffer, int n, int n2, int n3, int n4) {
        if (this.m_imagePanel == null) {
            return;
        }
        for (int i = 0; i < 2; ++i) {
            if (this.m_imageBuffers[i] != null && this.m_imageBuffers[i].getWidth() == n && this.m_imageBuffers[i].getHeight() == n2) continue;
            this.m_imageBuffers[i] = new BufferedImage(n, n2, 5);
        }
        this.m_currentBufferIndex = 1 - this.m_currentBufferIndex;
        BufferedImage bufferedImage = this.m_imageBuffers[this.m_currentBufferIndex];
        byte[] byArray = ((DataBufferByte)bufferedImage.getRaster().getDataBuffer()).getData();
        if (n4 == 32) {
            for (int i = 0; i < n2; ++i) {
                int n5 = (n2 - 1 - i) * n3;
                int n6 = i * n * 3;
                for (int j = 0; j < n; ++j) {
                    int n7 = n5 + j * 4;
                    byArray[n6++] = byteBuffer.get(n7);
                    byArray[n6++] = byteBuffer.get(n7 + 1);
                    byArray[n6++] = byteBuffer.get(n7 + 2);
                }
            }
        } else if (n4 == 24) {
            for (int i = 0; i < n2; ++i) {
                int n8 = (n2 - 1 - i) * n3;
                int n9 = i * n * 3;
                for (int j = 0; j < n; ++j) {
                    int n10 = n8 + j * 3;
                    byArray[n9++] = byteBuffer.get(n10);
                    byArray[n9++] = byteBuffer.get(n10 + 1);
                    byArray[n9++] = byteBuffer.get(n10 + 2);
                }
            }
        } else {
            return;
        }
        if (!this.repaintScheduled) {
            this.repaintScheduled = true;
            SwingUtilities.invokeLater(() -> {
                this.m_imagePanel.setImage(bufferedImage);
                this.repaintScheduled = false;
            });
        }
    }

    private native void SetOnUpdateFrame(long var1, updateFrameCB var3);

    private static interface updateFrameCB {
        public void onUpdateFrame(ByteBuffer var1, int var2, int var3, int var4, int var5);
    }
}

