﻿// CodeGear C++Builder
// Copyright (c) 1995, 2025 by Embarcadero Technologies, Inc.
// All rights reserved

// (DO NOT EDIT: machine generated header) 'VidGrab.pas' rev: 37.00 (Windows)

#ifndef VidGrabHPP
#define VidGrabHPP

#pragma delphiheader begin
#pragma option push
#if defined(__BORLANDC__) && !defined(__clang__)
#pragma option -w-      // All warnings off
#pragma option -Vx      // Zero-length empty class member 
#endif
#pragma pack(push,8)
#include <System.hpp>
#include <SysInit.hpp>
#include <Winapi.Windows.hpp>
#include <Winapi.Messages.hpp>
#include <System.Classes.hpp>
#include <Vcl.Controls.hpp>
#include <Vcl.ComCtrls.hpp>
#include <Vcl.Menus.hpp>
#include <Vcl.Graphics.hpp>
#include <Vcl.ExtCtrls.hpp>
#include <Vcl.Forms.hpp>
#include <Winapi.ActiveX.hpp>
#include <System.UITypes.hpp>
#include <System.Types.hpp>

//-- user supplied -----------------------------------------------------------
typedef __int64 LargeInteger;
typedef __int64 Int64;

namespace Vidgrab
{
//-- forward type declarations -----------------------------------------------
struct TFrameInfo;
struct TFrameBitmapInfo;
struct TVideoHdr;
class DELPHICLASS TVideoGrabber;
//-- type declarations -------------------------------------------------------
typedef __int64 LargeInteger;

typedef System::LongWord LongWord_;

enum DECLSPEC_DENUM TJPEGPerformance : unsigned int { jpBestQuality, jpBestSpeed };

enum DECLSPEC_DENUM TVideoAlignment : unsigned int { oa_LeftTop, oa_CenterTop, oa_RightTop, oa_LeftCenter, oa_Center, oa_RightCenter, oa_LeftBottom, oa_CenterBottom, oa_RightBottom };

enum DECLSPEC_DENUM TFrameGrabber : unsigned int { fg_BothStreams, fg_PreviewStream, fg_CaptureStream, fg_Disabled };

enum DECLSPEC_DENUM TFrameGrabberRGBFormat : unsigned int { fgf_Default, fgf_RGB32, fgf_RGB24, fgf_RGB565, fgf_RGB555, fgf_RGB8, fgf_ARGB32 };

enum DECLSPEC_DENUM TAutoFileName : unsigned int { fn_Sequential, fn_DateTime, fn_Counter, fn_Modulo, fn_GUID };

enum DECLSPEC_DENUM TCompressionMode : unsigned int { cm_NoCompression, cm_CompressOnTheFly, cm_CompressAfterRecording };

enum DECLSPEC_DENUM TCompressionType : unsigned int { ct_Video, ct_Audio, ct_AudioVideo };

enum DECLSPEC_DENUM TCurrentState : unsigned int { cs_Down, cs_Preview, cs_Recording, cs_Playback, cs_Reencoding };

enum DECLSPEC_DENUM TFrameCaptureDest : unsigned int { fc_TBitmap, fc_BmpFile, fc_JpegFile, fc_Clipboard, fc_TiffFile, fc_PngFile };

enum DECLSPEC_DENUM TDVSize : unsigned int { dv_Full, dv_Half, dv_Quarter, dv_DC };

enum DECLSPEC_DENUM TTVChannelInfo : unsigned int { tci_Channel, tci_DefaultVideoFrequency, tci_OverriddenVideoFrequency, tci_TunerVideoFrequency, tci_TunerAudioFrequency, tci_Locked };

enum DECLSPEC_DENUM TWebcamStillCaptureButton : unsigned int { wb_Disabled, wb_Enabled };

enum DECLSPEC_DENUM TDVVideoStandard : unsigned int { dvs_Default, dvs_PAL, dvs_NTSC };

enum DECLSPEC_DENUM TDVVideoFormat : unsigned int { dvf_Default, dvf_DVSD, dvf_DVHD, dvf_DVSL };

enum DECLSPEC_DENUM TEncryptionMethod : unsigned int { em_Fast_Encryption, em_AES_Encryption };

enum DECLSPEC_DENUM TAVIInfoType : unsigned int { av_Duration, av_FrameCount, av_VideoWidth, av_VideoHeight, av_VideoFrameRateFps, av_VideoCodec, av_AudioCodec, av_AvgBitRate, av_AudioChannels, av_AudioSamplesPerSec, av_AudioBitsPerSample, av_FileSizeInKB, av_AudioStreams };

enum DECLSPEC_DENUM TFrameBitmapInfoType : unsigned int { fb_VideoWidth, fb_VideoHeight, fb_BitmapSize, fb_BitmapStride, fb_BitsPerPixel };

enum DECLSPEC_DENUM TDVDInfoType : unsigned int { dvd_NumberOfVolumes, dvd_TotalDuration, dvd_NumberOfTitles, dvd_TitleDuration, dvd_TitleFrameRate, dvd_SourceResolutionX, dvd_SourceResolutionY, dvd_TitleFrameCount };

enum DECLSPEC_DENUM TONVIFDeviceInfo : unsigned int { onv_Manufacturer, onv_Model, onv_HardwareId, onv_SerialNumber, onv_FirmwareVersion, onv_PTZInfo, onv_PTZPresets, onv_MacAddress, onv_AuxiliaryCommands, onv_XMLReplay, onv_XMLInfo, onv_XMLProfiles, onv_CurrentProfileName, onv_CurrentProfileToken };

enum DECLSPEC_DENUM THeaderAttribute : unsigned int { ha_Title, ha_Description, ha_Author, ha_Copyright, ha_AlbumArtist, ha_AlbumTitle, ha_Composer, ha_ContentDistributor, ha_Director, ha_EncodingTime, ha_Genre, ha_Language, ha_ParentalRating, ha_Producer, ha_Provider, ha_ToolName, ha_ToolVersion, ha_Writer, ha_IARL, ha_ICMS, ha_ICMT, ha_ICRD, ha_ICRP, ha_IDIM, ha_IDPI, ha_IENG, ha_IGNR, ha_IKEY, ha_ILGT, ha_IMED, ha_IPLT, ha_IPRD, ha_ISFT, ha_ISHP, ha_ISRC, ha_ISRF, ha_ITCH };

enum DECLSPEC_DENUM TDVCommand : unsigned int { dv_Play, dv_Stop, dv_Freeze, dv_Thaw, dv_Ff, dv_Rew, dv_Record, dv_RecordFreeze, dv_RecordStrobe, dv_StepFwd, dv_StepRev, dv_ModeShuttle, dv_PlayFastestFwd, dv_PlaySlowestFwd, dv_PlayFastestRev, dv_PlaySlowestRev };

enum DECLSPEC_DENUM TDialog : unsigned int { dlg_VideoDevice, dlg_VideoCompressor, dlg_AudioCompressor, dlg_StreamConfig, dlg_VfwFormat, dlg_VfwSource, dlg_vfwDisplay, dlg_VideoCrossbar, dlg_AudioCrossbar, dlg_TVTuner, dlg_TVAudio, dlg_AudioDevice, dlg_NetShowConfig, dlg_DScaler, dlg_FFDShowVideo, dlg_FFDShowAudio, dlg_Multiplexer, dlg_None };

enum DECLSPEC_DENUM TTriState : unsigned int { ts_Undefined, ts_False, ts_True };

enum DECLSPEC_DENUM TLogoLayout : unsigned int { lg_Centered, lg_Stretched, lg_Repeated, lg_TopLeft, lg_TopRight, lg_BottomLeft, lg_BottomRight, lg_Boxed };

enum DECLSPEC_DENUM TNotificationMethod : unsigned int { nm_Timer, nm_Thread };

enum DECLSPEC_DENUM TVideoControl : unsigned int { vc_FlipHorizontal, vc_FlipVertical, vc_ExternalTriggerEnable, vc_Trigger };

enum DECLSPEC_DENUM TCardinalDirection : unsigned int { cd_North, cd_NorthEast, cd_East, cd_SouthEast, cd_South, cd_SouthWest, cd_West, cd_NorthWest, cd_Center };

enum DECLSPEC_DENUM TVideoRotation : unsigned int { rt_0_deg, rt_90_deg, rt_180_deg, rt_270_deg, rt_0_deg_mirror, rt_90_deg_mirror, rt_180_deg_mirror, rt_270_deg_mirror, rt_custom_angle, rt_custom_angle_mirror };

enum DECLSPEC_DENUM TV360_MouseAction : unsigned int { ma_Disabled, ma_MouseUp, ma_MouseMove };

enum DECLSPEC_DENUM Tv360_InOut : unsigned int { v360_in, v360_out };

enum DECLSPEC_DENUM Tv360_Angle : unsigned int { v360_fov_Diagonal, v360_fov_Horizontal, v360_fov_Vertical };

enum DECLSPEC_DENUM Tv360_StereoFormat : unsigned int { sf_2DMono, sf_SideBySide, sf_TopBottom };

enum DECLSPEC_DENUM Tv360_Projection : unsigned int { ipp_Equirectangular, ipp_Cubemap_3_2, ipp_Cubemap_6_1, ipp_Equiangular, ipp_Flat, ipp_Dual_fisheye, ipp_Barrel, ipp_Cubemap_1_6, ipp_Stereographic, ipp_Mercator, ipp_Ball, ipp_Hammer, ipp_Sinusoidal, ipp_Fisheye, ipp_Pannini, ipp_Cylindrical, ipp_Perspective, ipp_Tetrahedron, ipp_Barrel_split, ipp_Tspyramid, ipp_Hequirectangular, ipp_Equisolid, ipp_Orthographic, ipp_Octahedron };

enum DECLSPEC_DENUM Tv360_Interpolation : unsigned int { ipl_Bilinear, ipl_Nearest, ipl_Lagrange9, ipl_Bicubic, ipl_Lanczos, ipl_Spline16, ipl_Gaussian, ipl_Mitchell };

enum DECLSPEC_DENUM TVideoDeinterlacing : unsigned int { di_Disabled, di_HalfSize, di_FullSize, di_DScaler, di_AVISynth, di_FFDShow, di_ThirdPartyDeinterlacer };

enum DECLSPEC_DENUM TThirdPartyFilterList : unsigned int { tpf_VideoSource, tpf_VideoPreview, tpf_VideoRecording, tpf_AudioSource, tpf_AudioRendering, tpf_AudioRecording, tpf_VideoRendering, tpf_VideoRenderer, tpf_AudioRenderer, tpf_ThirdPartyVideoSource, tpf_ThirdPartyAudioSource, tpf_AddToGraph };

enum DECLSPEC_DENUM TRecordingSize : unsigned int { rs_Default, rs_HalfSize, rs_QuarterSize };

enum DECLSPEC_DENUM TFormatType : unsigned int { ft_VideoInfo, ft_VideoInfo2, ft_DvInfo, ft_Mpeg1Video, ft_Mpeg2Video, ft_Mpeg1Stream, ft_Mpeg2Stream, ft_MpegStreamType, ft_MpegCustom, ft_WaveFormatEx, ft_Mpeg1Audio, ft_Mpeg2Audio, ft_Mpeg3Audio, ft_OGG, ft_GSM, ft_Unknown };

typedef TFormatType *pFormatType;

enum DECLSPEC_DENUM TAudioFormat : unsigned int { af_default, af_8000_8b_1ch, af_8000_8b_2ch, af_8000_16b_1ch, af_8000_16b_2ch, af_11025_8b_1ch, af_11025_8b_2ch, af_11025_16b_1ch, af_11025_16b_2ch, af_16000_8b_1ch, af_16000_8b_2ch, af_16000_16b_1ch, af_16000_16b_2ch, af_22050_8b_1ch, af_22050_8b_2ch, af_22050_16b_1ch, af_22050_16b_2ch, af_32000_8b_1ch, af_32000_8b_2ch, af_32000_16b_1ch, af_32000_16b_2ch, af_44100_8b_1ch, af_44100_8b_2ch, af_44100_16b_1ch, af_44100_16b_2ch, af_48000_8b_1ch, af_48000_8b_2ch, af_48000_16b_1ch, af_48000_16b_2ch };

enum DECLSPEC_DENUM TAudioChannelRenderMode : unsigned int { acrm_Normal, acrm_RenderLeft, acrm_RenderRight, acrm_MuteLeft, acrm_MuteRight, acrm_Mute_All, acrm_MixLeftAndRight, acrm_PassThru };

enum DECLSPEC_DENUM TVideoRendererPriority : unsigned int { vrp_Speed, vrp_Quality, vrp_Auto };

enum DECLSPEC_DENUM TVideoRenderer : unsigned int { vr_AutoSelect, vr_EVR, vr_VMR9, vr_VMR7, vr_StandardRenderer, vr_OverlayRenderer, vr_RecordingPriority, vr_None, vr_madVR, vr_DatasteadRealtimeRenderer };

enum DECLSPEC_DENUM TVideoRendererExternal : unsigned int { vre_None, vre_Matrox_PRO, vre_Decklink_SD, vre_Decklink_Extreme, vre_Pinnacle_MovieBoard, vre_BlackMagic_Decklink, vre_AJA };

enum DECLSPEC_DENUM TRawSampleCaptureLocation : unsigned int { rl_SourceFormat, rl_AfterCompression };

enum DECLSPEC_DENUM TFiltersSet : unsigned int { fs_Datastead };

enum DECLSPEC_DENUM TPointGreyConfig : unsigned int { pgr_SetRegister, pgr_GetRegister, pgr_SetBufferSize, pgr_GetBufferSize, pgr_SetFormat, pgr_GetFormat };

enum DECLSPEC_DENUM TAuthenticationType : unsigned int { at_PublishingPoint, at_IPCamera, at_StreamingUrl };

enum DECLSPEC_DENUM TIPCameraSetting : unsigned int { ips_ConnectionTimeout, ips_ReceiveTimeout };

enum DECLSPEC_DENUM TStoragePathMode : unsigned int { spm_AutoFileNameOnly, spm_AnyFile };

enum DECLSPEC_DENUM TSynchronizationRole : unsigned int { sr_Master, sr_Slave, sr_Mixer };

enum DECLSPEC_DENUM TTextOrientation : unsigned int { to_Horizontal, to_Vertical, to_VerticalInverted };

enum DECLSPEC_DENUM TTrackbarAction : unsigned int { tba_MouseDown, tba_MouseUp, tba_KeyDown, tba_KeyUp };

enum DECLSPEC_DENUM TTextOverlayGradientMode : unsigned int { gm_Disabled, gm_Horizontal, gm_Vertical, gm_ForwardDiagonal, gm_BackwardDiagonal };

enum DECLSPEC_DENUM TMultipurposeEncoderInstance : unsigned int { mpe_Recording, mpe_Streaming, mpe_Reencoding, mpe_Edit };

enum DECLSPEC_DENUM TGPUEncoder : unsigned int { Enc_GPU_None, Enc_GPU_Auto, Enc_GPU_Intel_QSV, Enc_GPU_NVidia_NVENC, Enc_GPU_AMD_AMF };

enum DECLSPEC_DENUM TAudioPCMFormat : unsigned int { PCM_U8, PCM_S16, PCM_S32, PCM_FLT, PCM_DBL };

enum DECLSPEC_DENUM TEncoder_str : unsigned int { Enc_OutputURL, Enc_Video_Codec, Enc_Audio_Codec, Enc_Extra_Parameters };

enum DECLSPEC_DENUM TEncoder_int : unsigned int { Enc_IsActive_bool, Enc_Bytes_Written_kb_readonly, Enc_Audio_Enabled_bool, Enc_Audio_Channels, Enc_Audio_SamplesPerSec, Enc_Audio_BitsPerSample, Enc_Audio_BitRate_kb, Enc_Audio_PCM_Format, Enc_Video_Enabled_bool, Enc_Video_Width, Enc_Video_Height, Enc_Video_BitCount, Enc_Video_AvgTimePerFrame, Enc_Video_BitRate_kb, Enc_Video_rc_MinBitRate_kb, Enc_Video_rc_MaxBitRate_kb, Enc_Video_rc_BufferSize_kb, Enc_Video_IDR_Interval, Enc_Video_Max_BFrames, Enc_Video_FrameRate_x100, Enc_IsRealTime_bool, Enc_IsScreenRecording_bool, Enc_Video_Thread_Count, Enc_Video_GPU_Encoder, Enc_Video_GPU_EncoderDevice, Enc_Video_Quality_min, Enc_Video_Quality_max, Enc_Playable_While_Being_Recorded_bool, Enc_Video_Sampling_Interval_Ms, 
	Enc_Video_Sampling_FrameRate_x100, Enc_Video_Dropped_Frame_Count_readonly, Enc_Video_Encoded_Frame_Count_readonly, Enc_Video_IDR_Interval_Frames, Enc_Video_Profile, Enc_Video_Level, Enc_Video_LowLatency_bool, Enc_Video_MaxRefFrames, Enc_Video_RateControlMode, Enc_Video_H264_CABAC_Enable_bool, Enc_Video_Deblock_Enable_bool, Enc_Video_SlicesPerFrame, Enc_Video_IntraRefresh_Enable_bool, Enc_Video_IntraRefresh_Percent };

enum DECLSPEC_DENUM TVideoSource : unsigned int { vs_VideoCaptureDevice, vs_ScreenRecording, vs_VideoFileOrURL, vs_JPEGsOrBitmaps, vs_IPCamera, vs_Mixer, vs_VideoFromImages, vs_ThirdPartyFilter, vs_StreamInterface };

enum DECLSPEC_DENUM TAudioSource : unsigned int { as_Default, as_UseExternalAudio, as_UseMixAudioSample, as_SpeakerOutput, as_DefaultWithSpeakerRecording, as_Silent, as_IPcamera };

enum DECLSPEC_DENUM TDiscoveryCallbackStatus : unsigned int { dcs_CameraFound, dcs_MulticastCompleted, dcs_IPRangeCompleted };

enum DECLSPEC_DENUM TVuMeter : unsigned int { vu_Disabled, vu_Analog, vu_Bargraph, vu_AnalogOverlay, vu_BargraphOverlay };

enum DECLSPEC_DENUM TASFDeinterlaceMode : unsigned int { adm_NotInterlaced, adm_DeinterlaceNormal, adm_DeinterlaceHalfSize, adm_DeinterlaceHalfSizeDoubleRate, adm_DeinterlaceInverseTelecine, adm_DeinterlaceVerticalHalfSizeDoubleRate };

enum DECLSPEC_DENUM TASFProfileVersion : unsigned int { apv_ProfileVersion_8, apv_ProfileVersion_9 };

enum DECLSPEC_DENUM TFileSort : unsigned int { fs_TimeAsc, fs_TimeDesc, fs_NameAsc, fs_NameDesc };

enum DECLSPEC_DENUM TTunerInput : unsigned int { ti_TunerInputCable, ti_TunerInputAntenna };

enum DECLSPEC_DENUM TRGBSelector : unsigned int { rs_Red, rs_Green, rs_Blue };

enum DECLSPEC_DENUM TCameraControl : unsigned int { cc_Pan, cc_Tilt, cc_Roll, cc_Zoom, cc_Exposure, cc_Iris, cc_Focus };

enum DECLSPEC_DENUM TPlaylist : unsigned int { pl_Add, pl_Remove, pl_Clear, pl_Loop, pl_NoLoop, pl_Play, pl_Stop, pl_Next, pl_Previous, pl_SortAlpha, pl_SortRevAlpha, pl_Random, pl_Sequential, pl_SpecifyPositions, pl_Transition };

enum DECLSPEC_DENUM TVideoQuality : unsigned int { vq_Brightness, vq_Contrast, vq_Hue, vq_Saturation, vq_Sharpness, vq_Gamma, vq_ColorEnable, vq_WhiteBalance, vq_BacklightCompensation, vq_Gain };

enum DECLSPEC_DENUM THwAccel : unsigned int { hw_None, hw_Cuda, hw_QuickSync, hw_Dxva2, hw_d3d11 };

enum DECLSPEC_DENUM TMiscDeviceControl : unsigned int { mdc_GPIO, mdc_VPD, mdc_VPD_Data };

enum DECLSPEC_DENUM TAVIMuxConfig : unsigned int { avmx_SetInterleavingMode, avmx_SetInterleave, avmx_SetPreroll };

enum DECLSPEC_DENUM TApplicationPriority : unsigned int { ap_default, ap_idle, ap_normal, ap_high, ap_realtime };

enum DECLSPEC_DENUM TRecordingMethod : unsigned int { rm_AVI, rm_ASF, rm_SendToDV, rm_MKV, rm_FLV, rm_MP4, rm_WebM, rm_MPG, rm_Multiplexer, rm_MOV, rm_TS, rm_H264, rm_MP3, rm_WMA, rm_WAV };

enum DECLSPEC_DENUM TNetworkStreaming : unsigned int { ns_Disabled, ns_ASFDirectNetworkStreaming, ns_ASFStreamingToPublishingPoint, ns_NDI };

enum DECLSPEC_DENUM TNetworkStreamingType : unsigned int { nst_AudioVideoStreaming, nst_VideoStreaming, nst_AudioStreaming };

enum DECLSPEC_DENUM TSyncPreview : unsigned int { sp_Auto, sp_Disabled, sp_Enabled };

enum DECLSPEC_DENUM TGraphState : unsigned int { gs_Stopped, gs_Paused, gs_Running };

enum DECLSPEC_DENUM TPlayerState : unsigned int { ps_Closed, ps_Stopped, ps_Paused, ps_Playing, ps_PlayingBackward, ps_FastForwarding, ps_FastRewinding, ps_Downloading, ps_DownloadCompleted, ps_DownloadCancelled, ps_Opened };

enum DECLSPEC_DENUM TRecordingTimer : unsigned int { rt_Disabled, rt_RecordToNewFile, rt_StopRecording, rt_StartRecording, rt_PauseRecording, rt_FrameCapture };

enum DECLSPEC_DENUM TAero : unsigned int { ae_Default, ae_AutoBestRenderingQuality, ae_ForceOnWhenStartingVideo, ae_ForceOffWhenStartingVideo, ae_ForceOnImmediately, ae_ForceOffImmediately };

enum DECLSPEC_DENUM TMPEGProgramSetting : unsigned int { mps_Program_Number, mps_Program_PCR_PID, mps_VideoStream_PID, mps_AudioStream_PID, mps_VideoStream_Type, mps_AudioStream_Type, mps_VideoFormat_Width, mps_VideoFormat_Height, mps_VideoAspectRatio_X, mps_VideoAspectRatio_Y, mps_ReceiveTimeoutInSeconds };

enum DECLSPEC_DENUM TFrameInfoId : unsigned int { fi_FrameNumber, fi_DroppedFrameCount, fi_SampleTime_Hour, fi_SampleTime_Min, fi_SampleTime_Sec, fi_SampleTime_Hs, fi_SampleTime_TotalMin, fi_DVTimeCode_IsAvailable, fi_DVTimeCode_Hour, fi_DVTimeCode_Min, fi_DVTimeCode_Sec, fi_DVTimeCode_Ff, fi_DVTimeCode_TrackNumber, fi_DVDateTime_IsAvailable, fi_DVDateTime_Year, fi_DVDateTime_Month, fi_DVDateTime_Day, fi_DVDateTime_Hour, fi_DVDateTime_Min, fi_DVDateTime_Sec, fi_NTPFrameTime, fi_First_NTP_time_Recorded };

enum DECLSPEC_DENUM TFrameInfoStringId : unsigned int { fis_DVTimeCode, fis_DVDateTime, fis_TimeCode, fis_FrameTime, fis_FrameNumber, fis_FullInfo, fis_NTPFrameTime };

typedef TFrameInfo *pFrameInfo;

struct DECLSPEC_DRECORD TFrameInfo
{
public:
	__int64 FrameTime;
	__int64 FrameTime_TotalMin;
	__int64 FrameTime_TotalSec;
	__int64 FrameTime_TotalHs;
	__int64 FrameNumber;
	System::LongInt DroppedFrameCount;
	System::LongInt FrameTime_Hour;
	System::LongInt FrameTime_Min;
	System::LongInt FrameTime_Sec;
	System::LongInt FrameTime_Hs;
	System::LongInt DVTimeCode_IsAvailable;
	System::LongInt DVTimeCode_Hour;
	System::LongInt DVTimeCode_Min;
	System::LongInt DVTimeCode_Sec;
	System::LongInt DVTimeCode_Ff;
	System::LongInt DVTimeCode_TrackNumber;
	System::LongInt DVDateTime_IsAvailable;
	System::LongInt DVDateTime_Year;
	System::LongInt DVDateTime_Month;
	System::LongInt DVDateTime_Day;
	System::LongInt DVDateTime_Hour;
	System::LongInt DVDateTime_Min;
	System::LongInt DVDateTime_Sec;
	TCurrentState CurrentState;
	TGraphState GraphState;
	TPlayerState PlayerState;
	System::LongInt PlaylistIndex;
	__int64 NTPFrameTime;
};


typedef TFrameBitmapInfo *pFrameBitmapInfo;

struct DECLSPEC_DRECORD TFrameBitmapInfo
{
public:
	System::LongInt BitmapWidth;
	System::LongInt BitmapHeight;
	System::LongInt BitmapBitsPerPixel;
	System::LongInt BitmapLineSize;
	System::LongInt BitmapSize;
	System::LongInt BitmapPlanes;
	Winapi::Windows::THandle BitmapHandle;
	Winapi::Windows::PByte BitmapDataPtr;
	HDC BitmapDC;
	System::LongInt CurrentXMouseLocation;
	System::LongInt CurrentYMouseLocation;
	System::LongInt LastXMouseDownLocation;
	System::LongInt LastYMouseDownLocation;
	System::LongBool IsMouseDown;
	System::Uitypes::TMouseButton LastMouseButtonClicked;
	System::LongInt Dummy1;
	Winapi::Windows::THandle hSec;
	System::LongInt Reserved0;
};


struct DECLSPEC_DRECORD TVideoHdr
{
public:
	Winapi::Windows::PByte lpData;
	System::LongWord dwBufferLength;
	System::LongWord dwBytesUsed;
	System::LongWord dwTimeCaptured;
	System::LongWord dwUser;
	System::LongWord dwFlags;
	System::StaticArray<System::PLongWord, 4> dwReserved;
};


enum DECLSPEC_DENUM TMultiplexedRole : unsigned int { mr_NotMultiplexed, mr_MultiplexedMosaic4, mr_MultiplexedMosaic16, mr_MultiplexedMaster, mr_MultiplexedSlave };

enum DECLSPEC_DENUM TNDIBandwidthType : unsigned int { nbt_MetadataOnly, nbt_AudioOnly, nbt_LowestBandwidth, nbt_HighestBandwidth };

enum DECLSPEC_DENUM TNDIFormatType : unsigned int { nft_interleaved, nft_progressive, nft_field_0, nft_field_1 };

enum DECLSPEC_DENUM TMpegStreamType : unsigned int { mpst_Default, mpst_Program, mpst_Program_DVD, mpst_Program_DVD_MC, mpst_Program_SVCD, mpst_MPEG1, mpst_MPEG1_VCD };

enum DECLSPEC_DENUM TLogType : unsigned int { e_add_filter, e_add_source_filter, e_audio_compressor_not_suitable, e_bind_moniker_to_filter, e_compressor_possibly_not_suitable, e_create_instance, e_ddraw_caps_not_suitable, e_device_in_use_in_another_graph, e_disk_full, e_failed, e_failed_to_allocate_recording_file, e_failed_to_bind_codec, e_failed_to_connect_crossbar_pin, e_failed_to_connect_to_server, e_failed_to_create_directory, e_failed_to_create_file, e_failed_to_create_temp, e_failed_to_bind_frame_grabber, e_failed_to_load_ASF_profile, e_failed_to_load_ASF_profile_custom_file, e_failed_to_load_set_of_bitmaps, e_failed_to_set_image_overlay, e_failed_to_set_logo, e_failed_to_play_backwards, e_failed_to_render_file, e_failed_to_renew_recording_file, 
	e_failed_to_set_player_speed_ratio_with_audio, e_failed_to_setup_network_streaming, e_failed_to_start_preview, e_failed_to_start_recording, e_file_in_use, e_file_name_not_specified, e_file_not_found, e_get_audio_format, e_get_interface, e_get_video_format, e_graph_error, e_graph_cant_run, e_graph_must_be_restarted, e_hw_deinterlace_not_supported, e_incompatible_options, e_index_out_of_range, e_invalid_directory, e_library_not_found, e_load_filter, e_no_audio_In_device, e_no_device_available, e_no_dialog, e_no_stream_control, e_no_tv_tuner, e_no_device_selected, e_no_video_input_device, e_not_allowed_during_network_streaming, e_not_allowed_with_streaming_URL, e_not_assigned, e_not_multiplexed_master, e_not_previewing, e_not_recording, e_not_reencoding, 
	e_not_streaming, e_out_of_memory, e_pause_resume_disabled, e_pin_not_found, e_interface_not_assigned, e_query_config_avi_mux, e_reencoding, e_recording_cannot_pause, e_render_audio_stream, e_render_video_stream, e_must_restart_master, e_recording_on_motion_failed, e_sendtodv_device_index_out_of_bound, e_sendtodv_deviceindex_and_videodevice_have_same_value, e_sendtodv_failed_to_bind_dv_device, e_set_filter_graph, e_set_interleaving_mode, e_set_master_stream, e_set_output_compatibility_index, e_set_output_file_name, e_set_format, e_start_preview_first, e_stop_player_first, e_stop_preview_first, e_stop_recording_first, e_stop_reencoding_first, e_storage_path_read_only, e_streaming_type_not_specified, e_third_party_filter_already_inserted, 
	e_third_party_filter_error, e_trace_log, e_tv_command_not_allowed_during_tv_tuning, e_tuner_input_not_selected, e_TVideoGrabber_Filter_obsolete, e_value_out_of_range, e_video_compressor_not_suitable, e_window_transparency_failed, e_invalid_size, e_invalid_window_handle, e_tuner_mode_not_supported, e_publishing_point_connection_failed, e_speaker_control_disabled, i_audio_device_associated_to_video_device, i_begin_discovering_device, i_binding_device_or_compressor, i_discovering_device, i_end_discovering_device, i_preallocated_file_size_large_enough, i_preallocated_file_size_changed, i_preallocated_file_not_suitable, i_streaming_to_publishing_point, i_third_party_filter_inserted, i_using_ASF_Profile, i_recording_videosubtype, i_ismpegstream, 
	i_new_recording_filename, i_using_property_group, i_streaming_client_connected, i_streaming_client_disconnected, i_refreshing_preview, i_recording_on_motion, i_window_found, i_limiting_preview, i_codec_recommended, i_tuner_mode, i_DV_date_time_discontinuity, w_cannot_connect_thirdparty_filter, w_cannot_connect_thirdparty_renderer, w_cannot_instantiate_thirdparty_filter, w_cannot_route_crossbar, w_cannot_use_color_key, w_command_delayed, w_does_not_apply_to_dv, w_find_audio_device, w_filter_does_not_save_properties, w_frame_grabber_requires_CPU, w_hold_recording, w_information, w_not_playing, w_player_audio_should_be_disabled, w_recording_cancelled_by_user, w_can_pause_and_ASF_incompatible, w_set_audio_format, w_storage_path_on_network, w_tv_tuner, 
	w_using_nearest_video_size, w_divx_codec_not_installed, w_codec_does_not_support_debugger, w_divx_codec_profile, w_device_partially_supported, w_excessive_grid_size, w_grid_too_large_for_dialog, w_operation_may_lock, w_audio_streaming_needs_audiorecording_property_enabled, w_network_streaming_disabled, w_server_lost_next_retry, w_overlay_mixer_not_available, w_network_streaming_change_requires_application_to_be_restarted, w_standard_renderer_recommended, w_window_transparency_and_recording_not_recommended, w_clip_not_seekable, w_only_WMV_recording_during_network_streaming, w_check_analog_video_standard, w_recording_timer_set, w_stream_time_beyong_script_time, w_generate_new_file, w_hires_timer_not_available, w_applies_to_the_current_recording_method, 
	i_leaving_full_screen_mode, i_stream_info, i_async_url_connection_in_progress, i_async_url_connection_cancelled, e_obsolete, i_codec_info, i_preview_started, i_recording_started, i_reencoding_started, i_recording_completed, i_reencoding_completed, i_player_opened, i_inactive, i_using_stream_index, e_failed_to_start_reencoding, e_recording_failed, e_failed_to_open_player, i_mpe_terminatedsuccess, e_mpe_terminatederror, i_mpe_logcallback, i_duration_updated, e_ptz_command_failed, i_ptz_command_result, w_potential_out_of_range, i_recording_paused, i_configuration_info, w_virtualmachine, i_recording_resumed, e_failed_to_write_sample, e_exception, e_failed_to_open_url, e_async_url_opening_in_progress, i_filter_info, e_not_implemented, w_format_not_specified, 
	e_encryption_decryption, e_facebook_go_live, w_need_reindexing };

enum DECLSPEC_DENUM TAspectRatio : unsigned int { ar_Box, ar_NoResize, ar_Stretch, ar_PanScan };

enum DECLSPEC_DENUM TStreamType : unsigned int { st_Video, st_Audio };

enum DECLSPEC_DENUM TTextOverlayAlign : unsigned int { tf_Left, tf_Center, tf_Right };

enum DECLSPEC_DENUM TVUMeterSetting : unsigned int { vu_Handle, vu_WarningPercent, vu_PeakPercent, vu_BkgndColor, vu_NormalColor, vu_WarningColor, vu_PeakColor, vu_TickSize, vu_TickInterval, vu_NeedleThickness, vu_OverlayLeft, vu_OverlayTop, vu_OverlayWidth, vu_OverlayHeight, vu_Transparent, vu_FlipVert, vu_FlipHorz, vu_CustomPercentValue, vu_LogarithmicScale };

enum DECLSPEC_DENUM TVMR9ImageAdjustment : unsigned int { vmr9_Brightness, vmr9_Contrast, vmr9_Hue, vmr9_Saturation, vmr9_Alpha };

enum DECLSPEC_DENUM TVideoWindowNotify : unsigned int { vwActive, vwVisible, vwAutoSize, vwEmbedded, vwEmbeddedFitParent, vwDisplayParent, vwColorKeyEnabled, vwAlphaBlendEnabled, vwFullScreen, vwStayOnTop, vwMouseMovesWindow, vwVideoPortEnabled, vwMonitor, vwAspectRatio, vwVideoWidth, vwVideoHeight, vwPanScanRatio, vwColorKeyValue, vwAlphaBlendValue, vwLeft, vwTop, vwLocation };

enum DECLSPEC_DENUM TTunerMode : unsigned int { tm_TVTuner, tm_FMRadioTuner, tm_AMRadioTuner, tm_DigitalSatelliteTuner };

enum DECLSPEC_DENUM TOpenURLAsyncStatus : unsigned int { oas_InProgress_Connecting, oas_InProgress_Connected, oas_Completed_Success, oas_Undefined, oas_Completed_Error, oas_Completed_Cancelled };

enum DECLSPEC_DENUM TThreadSyncPoint : unsigned int { tsp_SyncPoint1, tsp_SyncPoint2, tsp_SetParent, tsp_UnSetParent };

typedef void __fastcall (__closure *TOnDragDropFiles)(void * Sender, System::LongInt FileCount, System::UnicodeString FirstFile, System::UnicodeString FilesList);

typedef void __fastcall (__closure *TOnAudioBufferNegotiation)(System::TObject* Sender, System::LongInt nChannels, System::LongInt nSamplesPerSec, System::LongInt BitsPerSample, System::LongInt &ProposedBufferSize);

typedef void __fastcall (__closure *TOnAudioPeak)(System::TObject* Sender, double Left_Percent, double Left_DB, double Right_Percent, double Right_DB);

typedef void __fastcall (__closure *TOnClientConnection)(System::TObject* Sender, bool Connected, System::UnicodeString ClientInfo);

typedef void __fastcall (__closure *TOnEventNotification)(System::TObject* Sender);

typedef void __fastcall (__closure *TOnDVDiscontinuity)(System::TObject* Sender, bool &DeliverNewFrame);

typedef void __fastcall (__closure *TOnLog)(System::TObject* Sender, TLogType LogType, System::UnicodeString Severity, System::UnicodeString InfoMsg);

typedef void __fastcall (__closure *TOnSourceFileToDestFileStarted)(System::TObject* Sender, System::UnicodeString SourceFile, System::UnicodeString DestFile);

typedef void __fastcall (__closure *TOnSourceFileToDestFileCompleted)(System::TObject* Sender, System::UnicodeString SourceFile, System::UnicodeString DestFile, bool Success);

typedef void __fastcall (__closure *TOnFileNotification)(System::TObject* Sender, System::UnicodeString FileName);

typedef void __fastcall (__closure *TOnCreatePreallocatedFileCompleted)(System::TObject* Sender, System::UnicodeString FileName, bool Success);

typedef void __fastcall (__closure *TOnResizeVideo)(System::TObject* Sender, System::LongInt SourceWidth, System::LongInt SourceHeight);

typedef void __fastcall (__closure *TOnRecordingCompleted)(System::TObject* Sender, System::UnicodeString FileName, bool Success);

typedef void __fastcall (__closure *TOnThreadSync)(System::TObject* Sender, TThreadSyncPoint ThreadSyncPoint);

typedef void __fastcall (__closure *TOnVideoFromBitmapsNextFrameNeeded)(System::TObject* Sender, bool FirstSample);

typedef void __fastcall (__closure *TOnDVCommandCompleted)(System::TObject* Sender, System::LongInt NewStateValue, System::UnicodeString NewStateLabel);

typedef void __fastcall (__closure *TOnDeviceArrivalOrRemoval)(System::TObject* Sender, bool IsDeviceArrival, bool IsVideoDevice, System::UnicodeString DeviceName, System::LongInt DeviceIndex);

typedef void __fastcall (__closure *TOnPlayerBufferingData)(System::TObject* Sender, bool StartingToBuffer);

typedef void __fastcall (__closure *TOnDirectNetworkStreamingHostUrl)(System::TObject* Sender, System::UnicodeString HostUrl, System::UnicodeString HostName, System::LongInt HostPort);

typedef void __fastcall (__closure *TOnAuthenticationNeeded)(System::TObject* Sender, TAuthenticationType AuthenticationType, System::UnicodeString Realm, System::UnicodeString Server, System::UnicodeString &Username, System::UnicodeString &Password);

typedef void __fastcall (__closure *TOnVideoCompressionSettings)(System::TObject* Sender, bool CanKeyFrameRate, bool CanPFramesPerKeyFrame, bool CanQuality, bool CanWindowSize, bool CanSpecifyDataRate, System::LongInt DefaultFrameRate, System::LongInt DefaultPFramesPerKey, double DefaultQuality, System::LongInt DefaultWindowSize, System::LongInt DefaultDataRate);

typedef void __fastcall (__closure *TOnColorKeyChange)(System::TObject* Sender, System::Uitypes::TColor ColorKey);

typedef void __fastcall (__closure *TOnOpenURLAsyncStatusChanged)(System::TObject* Sender, TOpenURLAsyncStatus OldStatus, TOpenURLAsyncStatus NewStatus, TCurrentState TargetState);

typedef void __fastcall (__closure *TOnPlayerStateChanged)(System::TObject* Sender, TPlayerState OldPlayerState, TPlayerState NewPlayerState);

typedef void __fastcall (__closure *TOnTVChannelSelected)(System::TObject* Sender, System::LongInt Channel, bool Locked, System::LongInt DefaultVideoFrequency, System::LongInt OverriddenVideoFrequency, System::LongInt TunerVideoFrequency, System::LongInt TunerAudioFrequency);

typedef void __fastcall (__closure *TOnTVChannelScanStarted)(System::TObject* Sender, System::LongInt MinChannel, System::LongInt MaxChannel);

typedef void __fastcall (__closure *TOnThirdPartyFilterAdded)(System::TObject* Sender, TThirdPartyFilterList Location, System::_di_IInterface Intf, bool &ShowDialog, bool &SaveFilterProperties);

typedef void __fastcall (__closure *TOnThirdPartyFilterConnected)(System::TObject* Sender, TThirdPartyFilterList Location, System::_di_IInterface Intf);

typedef void __fastcall (__closure *TOnThirdPartyFilterConnected2)(System::TObject* Sender, System::UnicodeString FilterName, System::_di_IInterface Intf);

typedef void __fastcall (__closure *TOnFilterSelected)(System::TObject* Sender, System::UnicodeString FilterName, bool &RejectFilter);

typedef void __fastcall (__closure *TOnFrameCaptureCompleted)(System::TObject* Sender, void * FrameBitmap, System::LongInt BitmapWidth, System::LongInt BitmapHeight, System::LongWord FrameNumber, LargeInteger FrameTime, TFrameCaptureDest DestType, System::UnicodeString FileName, bool Success, System::LongInt FrameId);

typedef void __fastcall (__closure *TOnFrameProgress)(System::TObject* Sender, System::LongWord FrameNumber, LargeInteger FrameTime, System::LongInt FrameId);

typedef void __fastcall (__closure *TOnAVIDurationUpdated)(System::TObject* Sender, System::UnicodeString FileName, System::LongWord FrameCount, double &FrameRate, LargeInteger &Duration);

typedef void __fastcall (__closure *TOnMotionDetected)(System::TObject* Sender, double GlobalMotionRatio, System::LongInt MaxMotionCellX, System::LongInt MaxMotionCellY, void * FrameBitmap, System::LongWord FrameNumber, LargeInteger FrameTime, System::LongInt FrameId, bool &CaptureFrame);

typedef void __fastcall (__closure *TOnMotionNotDetected)(System::TObject* Sender, void * FrameBitmap, System::LongWord FrameNumber, LargeInteger FrameTime, System::LongInt FrameId, bool &CaptureFrame);

typedef void __fastcall (__closure *TOnProgress)(System::TObject* Sender, System::LongInt Percent, LargeInteger Position, LargeInteger Duration);

typedef void __fastcall (__closure *TOnProgressCommented)(System::TObject* Sender, System::LongInt Percent, LargeInteger Position, LargeInteger Duration, System::UnicodeString Comment);

typedef void __fastcall (__closure *TOnFrameOverlayUsingDC)(System::TObject* Sender, HDC Dc, System::LongWord FrameNumber, LargeInteger FrameTime, System::LongInt FrameId);

typedef void __fastcall (__closure *TOnFrameOverlayUsingDIB)(System::TObject* Sender, HBITMAP FrameBitmapHandle, System::LongWord FrameNumber, LargeInteger FrameTime, System::LongInt FrameId);

typedef void __fastcall (__closure *TOnFrameOverlayUsingVIDEOHDR)(System::TObject* Sender, System::LongWord FrameNumber, LargeInteger FrameTime, System::LongInt FrameId, const TVideoHdr &VideoHdr);

typedef void __fastcall (__closure *TOnRawAudioSample)(System::TObject* Sender, void * pSampleBuffer, System::LongInt SampleBufferSize, System::LongInt SampleDataLength, TFormatType FormatType, void * pFormat, void * pWaveFormatEx, LargeInteger SampleStartTime, LargeInteger SampleStopTime);

typedef void __fastcall (__closure *TOnRawVideoSample)(System::TObject* Sender, void * pSampleBuffer, System::LongInt SampleBufferSize, System::LongInt SampleDataLength, TFormatType FormatType, void * pFormat, void * pBitmapInfoHeader, LargeInteger SampleStartTime, LargeInteger SampleStopTime);

typedef void __fastcall (__closure *TOnVideoKeyPress)(System::TObject* Sender, System::LongInt VideoWindow, System::WideChar &Key, System::LongInt PhysicalKey, System::Classes::TShiftState ShiftState);

typedef void __fastcall (__closure *TOnVideoMouseUpDown)(System::TObject* Sender, System::LongInt VideoWindow, System::Uitypes::TMouseButton Button, System::Classes::TShiftState Shift, System::LongInt X, System::LongInt Y);

typedef void __fastcall (__closure *TOnVideoMouseMove)(System::TObject* Sender, System::LongInt VideoWindow, System::Classes::TShiftState Shift, System::LongInt X, System::LongInt Y);

typedef void __fastcall (__closure *TOnONVIFDiscoveryCompletedNotification)(System::TObject* Sender, TDiscoveryCallbackStatus DiscoveryCallbackStatus, System::LongInt CameraCount);

typedef void __fastcall (__closure *TOnVideoMouseEvent)(System::TObject* Sender, System::LongInt VideoWindow);

typedef void __fastcall (__closure *TOnMouseWheel)(System::TObject* Sender, System::LongInt VideoWindow, bool DirectionUp, System::LongInt X, System::LongInt Y);

typedef void __fastcall (__closure *TOnMultipurposeEncoderNotification)(System::TObject* Sender, TMultipurposeEncoderInstance MultipurposeEncoderInstance);

typedef void __fastcall (__closure *TOnTextOverlayScrollingCompleted)(System::TObject* Sender, System::LongInt TextOverlayIndex);

typedef void __fastcall (__closure *TOnEnumerateWindows)(System::TObject* Sender, void * WindowHandle, System::UnicodeString WindowName, System::UnicodeString WindowClass);

typedef void __fastcall (__closure *TOnFrameBitmap)(System::TObject* Sender, pFrameInfo FrameInfo, pFrameBitmapInfo BitmapInfo);

typedef void __fastcall (__closure *TOnFrameProgress2)(System::TObject* Sender, pFrameInfo FrameInfo);

typedef void __fastcall (__closure *TOnNTPTimeStamp)(System::TObject* Sender, __int64 last_rtcp_ntp_time, unsigned last_rtcp_timestamp, __int64 delta_rtcp_ntp_time, unsigned delta_rtcp_timestamp, System::TDateTime UTCDateTime, System::TDateTime LocalDateTime);

class PASCALIMPLEMENTATION TVideoGrabber : public Vcl::Extctrls::TCustomPanel
{
	typedef Vcl::Extctrls::TCustomPanel inherited;
	
public:
	bool __fastcall GetImageOverlay_AlphaBlend(System::LongInt Index);
	System::LongInt __fastcall GetImageOverlay_AlphaBlendValue(System::LongInt Index);
	bool __fastcall GetImageOverlay_ChromaKey(System::LongInt Index);
	System::LongInt __fastcall GetImageOverlay_ChromaKeyLeewayPercent(System::LongInt Index);
	System::LongInt __fastcall GetImageOverlay_ChromaKeyRGBColor(System::LongInt Index);
	System::LongInt __fastcall GetImageOverlay_Height(System::LongInt Index);
	System::LongInt __fastcall GetImageOverlay_LeftLocation(System::LongInt Index);
	double __fastcall GetImageOverlay_RotationAngle(System::LongInt Index);
	bool __fastcall GetImageOverlay_StretchToVideoSize(System::LongInt Index);
	System::LongInt __fastcall GetImageOverlay_TargetDisplay(System::LongInt Index);
	System::LongInt __fastcall GetImageOverlay_TopLocation(System::LongInt Index);
	bool __fastcall GetImageOverlay_Transparent(System::LongInt Index);
	System::LongInt __fastcall GetImageOverlay_TransparentColorValue(System::LongInt Index);
	bool __fastcall GetImageOverlay_UseTransparentColor(System::LongInt Index);
	TVideoAlignment __fastcall GetImageOverlay_VideoAlignment(System::LongInt Index);
	System::LongInt __fastcall GetImageOverlay_Width(System::LongInt Index);
	bool __fastcall GetImageOverlay_Enabled(System::LongInt Index);
	TTextOverlayAlign __fastcall GetTextOverlay_Align(System::LongInt Index);
	bool __fastcall GetTextOverlay_AlphaBlend(System::LongInt Index);
	System::LongInt __fastcall GetTextOverlay_AlphaBlendValue(System::LongInt Index);
	System::Uitypes::TColor __fastcall GetTextOverlay_BkColor(System::LongInt Index);
	bool __fastcall GetTextOverlay_Enabled(System::LongInt Index);
	Vcl::Graphics::TFont* __fastcall GetTextOverlay_Font(System::LongInt Index);
	System::Uitypes::TColor __fastcall GetTextOverlay_FontColor(System::LongInt Index);
	System::LongInt __fastcall GetTextOverlay_FontSize(System::LongInt Index);
	bool __fastcall GetTextOverlay_HighResFont(System::LongInt Index);
	TTextOverlayGradientMode __fastcall GetTextOverlay_GradientMode(System::LongInt Index);
	System::Uitypes::TColor __fastcall GetTextOverlay_GradientColor(System::LongInt Index);
	System::LongInt __fastcall GetTextOverlay_Left(System::LongInt Index);
	System::LongInt __fastcall GetTextOverlay_Right(System::LongInt Index);
	TTextOrientation __fastcall GetTextOverlay_Orientation(System::LongInt Index);
	bool __fastcall GetTextOverlay_Scrolling(System::LongInt Index);
	System::LongInt __fastcall GetTextOverlay_ScrollingSpeed(System::LongInt Index);
	bool __fastcall GetTextOverlay_Shadow(System::LongInt Index);
	System::Uitypes::TColor __fastcall GetTextOverlay_ShadowColor(System::LongInt Index);
	TCardinalDirection __fastcall GetTextOverlay_ShadowDirection(System::LongInt Index);
	System::UnicodeString __fastcall GetTextOverlay_String(System::LongInt Index);
	System::LongInt __fastcall GetTextOverlay_TargetDisplay(System::LongInt Index);
	System::LongInt __fastcall GetTextOverlay_Top(System::LongInt Index);
	bool __fastcall GetTextOverlay_Transparent(System::LongInt Index);
	TVideoAlignment __fastcall GetTextOverlay_VideoAlignment(System::LongInt Index);
	void __fastcall SetImageOverlay_AlphaBlend(System::LongInt Index, bool Value);
	void __fastcall SetImageOverlay_AlphaBlendValue(System::LongInt Index, System::LongInt Value);
	void __fastcall SetImageOverlay_ChromaKey(System::LongInt Index, bool Value);
	void __fastcall SetImageOverlay_ChromaKeyLeewayPercent(System::LongInt Index, System::LongInt Value);
	void __fastcall SetImageOverlay_ChromaKeyRGBColor(System::LongInt Index, System::LongInt Value);
	void __fastcall SetImageOverlay_Enabled(System::LongInt Index, bool Value);
	void __fastcall SetImageOverlay_Height(System::LongInt Index, System::LongInt Value);
	void __fastcall SetImageOverlay_LeftLocation(System::LongInt Index, System::LongInt Value);
	void __fastcall SetImageOverlay_RotationAngle(System::LongInt Index, double Value);
	void __fastcall SetImageOverlay_StretchToVideoSize(System::LongInt Index, bool Value);
	void __fastcall SetImageOverlay_TargetDisplay(System::LongInt Index, System::LongInt Value);
	void __fastcall SetImageOverlay_TopLocation(System::LongInt Index, System::LongInt Value);
	void __fastcall SetImageOverlay_Transparent(System::LongInt Index, bool Value);
	void __fastcall SetImageOverlay_TransparentColorValue(System::LongInt Index, System::LongInt Value);
	void __fastcall SetImageOverlay_UseTransparentColor(System::LongInt Index, bool Value);
	void __fastcall SetImageOverlay_VideoAlignment(System::LongInt Index, TVideoAlignment Value);
	void __fastcall SetImageOverlay_Width(System::LongInt Index, System::LongInt Value);
	void __fastcall SetTextOverlay_Align(System::LongInt Index, TTextOverlayAlign Value);
	void __fastcall SetTextOverlay_AlphaBlend(System::LongInt Index, bool Value);
	void __fastcall SetTextOverlay_AlphaBlendValue(System::LongInt Index, System::LongInt Value);
	void __fastcall SetTextOverlay_BkColor(System::LongInt Index, System::Uitypes::TColor Value);
	void __fastcall SetTextOverlay_CustomVar(System::LongInt Index, System::LongInt VarIndex, System::UnicodeString VarText);
	void __fastcall SetTextOverlay_Enabled(System::LongInt Index, bool Value);
	void __fastcall SetTextOverlay_Font(System::LongInt Index, Vcl::Graphics::TFont* Value);
	void __fastcall SetTextOverlay_FontColor(System::LongInt Index, System::Uitypes::TColor Value);
	void __fastcall SetTextOverlay_FontSize(System::LongInt Index, System::LongInt Value);
	void __fastcall SetTextOverlay_GradientMode(System::LongInt Index, TTextOverlayGradientMode Value);
	void __fastcall SetTextOverlay_GradientColor(System::LongInt Index, System::Uitypes::TColor Value);
	void __fastcall SetTextOverlay_HighResFont(System::LongInt Index, bool Value);
	void __fastcall SetTextOverlay_Left(System::LongInt Index, System::LongInt Value);
	void __fastcall SetTextOverlay_Right(System::LongInt Index, System::LongInt Value);
	void __fastcall SetTextOverlay_Orientation(System::LongInt Index, TTextOrientation Value);
	void __fastcall SetTextOverlay_Scrolling(System::LongInt Index, bool Value);
	void __fastcall SetTextOverlay_ScrollingSpeed(System::LongInt Index, System::LongInt Value);
	void __fastcall SetTextOverlay_Shadow(System::LongInt Index, bool Value);
	void __fastcall SetTextOverlay_ShadowColor(System::LongInt Index, System::Uitypes::TColor Value);
	void __fastcall SetTextOverlay_ShadowDirection(System::LongInt Index, TCardinalDirection Value);
	void __fastcall SetTextOverlay_String(System::LongInt Index, const System::UnicodeString Value);
	void __fastcall SetTextOverlay_TargetDisplay(System::LongInt Index, System::LongInt Value);
	void __fastcall SetTextOverlay_Top(System::LongInt Index, System::LongInt Value);
	void __fastcall SetTextOverlay_Transparent(System::LongInt Index, bool Value);
	void __fastcall SetTextOverlay_VideoAlignment(System::LongInt Index, TVideoAlignment Value);
	
private:
	System::TObject* _Vdgr;
	bool _VdgrInitialized;
	Winapi::Windows::THandle FCurThr;
	HRESULT FCoinit;
	bool FSettingBounds;
	TOnEventNotification FOnAudioDeviceSelected;
	TOnAudioBufferNegotiation FOnAudioBufferNegotiation;
	TOnAudioPeak FOnAudioPeak;
	TOnAuthenticationNeeded FOnAuthenticationNeeded;
	TOnAVIDurationUpdated FOnAVIDurationUpdated;
	TOnEventNotification FOnBacktimedFramesCountReached;
	TOnEventNotification FOnClick;
	TOnClientConnection FOnClientConnection;
	TOnColorKeyChange FOnColorKeyChange;
	TOnSourceFileToDestFileCompleted FOnCopyPreallocDataCompleted;
	TOnProgress FOnCopyPreallocDataProgress;
	TOnSourceFileToDestFileStarted FOnCopyPreallocDataStarted;
	TOnCreatePreallocatedFileCompleted FOnCreatePreallocFileCompleted;
	TOnProgress FOnCreatePreallocFileProgress;
	TOnFileNotification FOnCreatePreallocFileStarted;
	TOnEventNotification FOnDblClick;
	TOnDeviceArrivalOrRemoval FOnDeviceArrivalOrRemoval;
	TOnEventNotification FOnDeviceLost;
	TOnEventNotification FOnDeviceReconnecting;
	TOnEventNotification FOnDeviceReconnected;
	TOnDirectNetworkStreamingHostUrl FOnDirectNetworkStreamingHostUrl;
	TOnEventNotification FOnDiskFull;
	TOnDragDropFiles FOnDragDropFiles;
	TOnDVDiscontinuity FOnDVDiscontinuity;
	TOnEnumerateWindows FOnEnumerateWindows;
	TOnEventNotification FOnFirstFrameReceived;
	TOnFrameBitmap FOnFrameBitmap;
	TOnFrameBitmap FOnFrameBitmapRendering;
	TOnFrameOverlayUsingDC FOnFrameOverlayUsingDC;
	TOnFrameOverlayUsingDIB FOnFrameOverlayUsingDIB;
	TOnFrameProgress FOnFrameProgress;
	TOnFrameProgress2 FOnFrameProgress2;
	TOnNTPTimeStamp FOnNTPTimeStamp;
	TOnFrameOverlayUsingVIDEOHDR FOnFrameOverlayUsingVIDEOHDR;
	TOnEventNotification FOnInactive;
	TOnEventNotification FOnStoppingGraph;
	TOnEventNotification FOnStoppingGraphCompleted;
	TOnEventNotification FOnGraphBuilt;
	TOnEventNotification FOnLastCommandCompleted;
	TOnEventNotification FOnLeavingFullScreen;
	TOnLog FOnLog;
	TOnFilterSelected FOnFilterSelected;
	TOnFrameCaptureCompleted FOnFrameCaptureCompleted;
	TOnDVCommandCompleted FOnDVCommandCompleted;
	TOnVideoKeyPress FOnKeyPress;
	TOnVideoMouseUpDown FOnMouseDown;
	TOnVideoMouseEvent FOnMouseEnter;
	TOnVideoMouseEvent FOnMouseLeave;
	TOnVideoMouseMove FOnMouseMove;
	TOnVideoMouseUpDown FOnMouseUp;
	TOnMouseWheel FOnMouseWheel;
	TOnVideoMouseUpDown FOnMouseDown_Video;
	TOnVideoMouseUpDown FOnMouseDown_Window;
	TOnVideoMouseMove FOnMouseMove_Video;
	TOnVideoMouseMove FOnMouseMove_Window;
	TOnVideoMouseUpDown FOnMouseUp_Video;
	TOnVideoMouseUpDown FOnMouseUp_Window;
	TOnEventNotification FOnNoVideoDevices;
	TOnMultipurposeEncoderNotification FOnMultipurposeEncoderProgress;
	TOnMultipurposeEncoderNotification FOnMultipurposeEncoderError;
	TOnMultipurposeEncoderNotification FOnMultipurposeEncoderCompleted;
	TOnONVIFDiscoveryCompletedNotification FOnONVIFDiscoveryCompleted;
	TOnOpenURLAsyncStatusChanged FOnOpenURLAsyncStatusChanged;
	TOnPlayerStateChanged FOnPlayerStateChanged;
	TOnEventNotification FOnPlayerDurationUpdated;
	TOnEventNotification FOnPlayerEndOfStream;
	TOnEventNotification FOnPlayerEndOfPlaylist;
	TOnPlayerBufferingData FOnPlayerBufferingData;
	TOnEventNotification FOnPlayerOpened;
	TOnFrameProgress FOnPlayerUpdateTrackbarPosition;
	TOnEventNotification FOnPreviewStarted;
	TOnRawAudioSample FOnRawAudioSample;
	TOnRawVideoSample FOnRawVideoSample;
	TOnProgressCommented FOnBitmapsLoadingProgress;
	TOnRecordingCompleted FOnRecordingCompleted;
	TOnEventNotification FOnRecordingPaused;
	TOnEventNotification FOnRecordingReadyToStart;
	TOnFileNotification FOnRecordingStarted;
	TOnSourceFileToDestFileCompleted FOnReencodingCompleted;
	TOnProgress FOnReencodingProgress;
	TOnSourceFileToDestFileStarted FOnReencodingStarted;
	TOnResizeVideo FOnResizeVideo;
	TOnEventNotification FOnReinitializing;
	TOnThreadSync FOnThreadSync;
	TOnTextOverlayScrollingCompleted FOnTextOverlayScrollingCompleted;
	TOnTVChannelSelected FOnTVChannelSelected;
	TOnEventNotification FOnTVChannelScanCompleted;
	TOnTVChannelScanStarted FOnTVChannelScanStarted;
	TOnThirdPartyFilterAdded FOnThirdPartyFilterAdded;
	TOnThirdPartyFilterConnected FOnThirdPartyFilterConnected;
	TOnThirdPartyFilterConnected2 FOnThirdPartyFilterConnected2;
	TOnVideoCompressionSettings FOnVideoCompressionSettings;
	TOnEventNotification FOnVideoDeviceSelected;
	TOnVideoFromBitmapsNextFrameNeeded FOnVideoFromBitmapsNextFrameNeeded;
	TOnMotionDetected FOnMotionDetected;
	TOnMotionNotDetected FOnMotionNotDetected;
	void __fastcall UpdateBorderStyle(Vcl::Forms::TBorderStyle Value);
	void __fastcall ClearEvents();
	bool __fastcall GetAdjustOverlayAspectRatio();
	bool __fastcall GetAdjustPixelAspectRatio();
	TApplicationPriority __fastcall GetApplicationPriority();
	System::LongInt __fastcall GetASFAudioBitRate();
	System::LongInt __fastcall GetASFAudioChannels();
	System::LongInt __fastcall GetASFBufferWindow();
	TASFDeinterlaceMode __fastcall GetASFDeinterlaceMode();
	bool __fastcall GetASFDirectStreamingKeepClientsConnected();
	bool __fastcall GetASFFixedFrameRate();
	System::UnicodeString __fastcall GetASFMediaServerPublishingPoint();
	System::UnicodeString __fastcall GetASFMediaServerTemplatePublishingPoint();
	bool __fastcall GetASFMediaServerRemovePublishingPointAfterDisconnect();
	System::LongInt __fastcall GetASFNetworkPort();
	System::LongInt __fastcall GetASFNetworkMaxUsers();
	System::LongInt __fastcall GetASFProfile();
	TASFProfileVersion __fastcall GetASFProfileVersion();
	System::UnicodeString __fastcall GetASFProfileFromCustomFile();
	System::LongInt __fastcall GetASFVideoBitRate();
	double __fastcall GetASFVideoFrameRate();
	System::LongInt __fastcall GetASFVideoHeight();
	System::LongInt __fastcall GetASFVideoMaxKeyFrameSpacing();
	System::LongInt __fastcall GetASFVideoQuality();
	System::LongInt __fastcall GetASFVideoWidth();
	double __fastcall GetAspectRatioToUse();
	TAudioChannelRenderMode __fastcall GetAudioChannelRenderMode();
	bool __fastcall GetAVIDurationUpdated();
	TAero __fastcall GetAero();
	bool __fastcall GetAssociateAudioAndVideoDevices();
	System::LongInt __fastcall GetAudioDevice();
	bool __fastcall GetAudioDeviceRendering();
	TAudioFormat __fastcall GetAudioFormat();
	System::LongInt __fastcall GetAudioRenderer();
	System::LongInt __fastcall GetAudioStreamNumber();
	bool __fastcall GetAudioSyncAdjustmentEnabled();
	System::LongInt __fastcall GetAudioSyncAdjustment();
	System::LongInt __fastcall GetMixAudioSamplesLevel(System::LongInt Index);
	System::LongInt __fastcall GetMixer_MosaicLines();
	System::LongInt __fastcall GetMixer_MosaicColumns();
	bool __fastcall GetAudioPeakEvent();
	bool __fastcall GetAudioRecording();
	TAudioSource __fastcall GetAudioSource();
	bool __fastcall GetAutoConnectRelatedPins();
	TAutoFileName __fastcall GetAutoFileName();
	System::UnicodeString __fastcall GetAutoFileNameDateTimeFormat();
	System::LongInt __fastcall GetAutoFileNameMinDigits();
	System::UnicodeString __fastcall GetAutoFilePrefix();
	System::UnicodeString __fastcall GetAutoFileSuffix();
	bool __fastcall GetAutoRefreshPreview();
	bool __fastcall GetAutoStartPlayer();
	bool __fastcall GetAVIFormatOpenDML();
	bool __fastcall GetAVIFormatOpenDMLCompatibilityIndex();
	System::Uitypes::TColor __fastcall GetBackgroundColor();
	Vcl::Forms::TBorderStyle __fastcall GetBorderStyle();
	System::LongInt __fastcall GetBurstCount();
	System::LongInt __fastcall GetBurstInterval();
	bool __fastcall GetBurstMode();
	TFrameCaptureDest __fastcall GetBurstType();
	bool __fastcall GetCameraControlSettings();
	System::UnicodeString __fastcall GetCaptureFileExt();
	System::Uitypes::TColor __fastcall GetColorKey();
	bool __fastcall GetColorKeyEnabled();
	TCompressionMode __fastcall GetCompressionMode();
	TCompressionType __fastcall GetCompressionType();
	bool __fastcall GetVideoDoubleBuffered();
	System::LongInt __fastcall GetDroppedFramesPollingInterval();
	bool __fastcall GetDVDateTimeEnabled();
	System::LongInt __fastcall GetDVDiscontinuityMinimumInterval();
	System::LongInt __fastcall GetDVDTitle();
	TDVVideoFormat __fastcall GetDVEncoder_VideoFormat();
	TDVSize __fastcall GetDVEncoder_VideoResolution();
	TDVVideoStandard __fastcall GetDVEncoder_VideoStandard();
	bool __fastcall GetDVRgb219();
	bool __fastcall GetDVReduceFrameRate();
	bool __fastcall GetDVRecordingInNativeFormatSeparatesStreams();
	bool __fastcall GetDVTimeCodeEnabled();
	bool __fastcall GetEventNotificationSynchrone();
	System::UnicodeString __fastcall GetExtraDLLPath();
	bool __fastcall GetCropping_Enabled();
	System::LongInt __fastcall GetCropping_Height();
	bool __fastcall GetCropping_Outbounds();
	System::LongInt __fastcall GetCropping_Width();
	System::LongInt __fastcall GetCropping_X();
	System::LongInt __fastcall GetCropping_Y();
	double __fastcall GetCropping_Zoom();
	bool __fastcall GetFixFlickerOrBlackCapture();
	bool __fastcall GetFrameCaptureWithoutOverlay();
	System::LongInt __fastcall GetFrameCaptureHeight();
	System::LongInt __fastcall GetFrameCaptureWidth();
	System::LongInt __fastcall GetFrameCaptureZoomSize();
	TFrameGrabber __fastcall GetFrameGrabber();
	TFrameGrabberRGBFormat __fastcall GetFrameGrabberRGBFormat();
	bool __fastcall GetFrameNumberStartsFromZero();
	double __fastcall GetFrameRate();
	System::LongInt __fastcall GetFrameRateDivider();
	System::LongInt __fastcall GetGetLastFrameWaitTimeoutMs();
	bool __fastcall GetGeneratePts();
	bool __fastcall GetImageOverlayAlphaBlend();
	System::LongInt __fastcall GetImageOverlayAlphaBlendValue();
	bool __fastcall GetImageOverlayChromaKey();
	System::LongInt __fastcall GetImageOverlayChromaKeyLeewayPercent();
	System::LongInt __fastcall GetImageOverlayChromaKeyRGBColor();
	System::LongInt __fastcall GetImageOverlayHeight();
	System::LongInt __fastcall GetImageOverlayLeftLocation();
	TVideoAlignment __fastcall GetImageOverlayVideoAlignment();
	double __fastcall GetImageOverlayRotationAngle();
	System::LongInt __fastcall GetImageOverlaySelector();
	bool __fastcall GetImageOverlayStretchToVideoSize();
	System::LongInt __fastcall GetImageOverlayTargetDisplay();
	System::LongInt __fastcall GetImageOverlayTopLocation();
	bool __fastcall GetImageOverlayTransparent();
	System::LongInt __fastcall GetImageOverlayTransparentColorValue();
	bool __fastcall GetImageOverlayUseTransparentColor();
	System::LongInt __fastcall GetImageOverlayWidth();
	bool __fastcall GetImageOverlayEnabled();
	System::UnicodeString __fastcall GetIPCameraURL();
	TJPEGPerformance __fastcall GetJPEGPerformance();
	bool __fastcall GetJPEGProgressiveDisplay();
	System::LongInt __fastcall GetJPEGQuality();
	System::UnicodeString __fastcall GetLicenseString();
	bool __fastcall GetLogoDisplayed();
	TLogoLayout __fastcall GetLogoLayout();
	System::UnicodeString __fastcall GetMotionDetector_Grid();
	bool __fastcall GetMotionDetector_ReduceVideoNoise();
	bool __fastcall GetMotionDetector_CompareBlue();
	bool __fastcall GetMotionDetector_CompareGreen();
	bool __fastcall GetMotionDetector_CompareRed();
	bool __fastcall GetMotionDetector_GreyScale();
	bool __fastcall GetMotionDetector_Enabled();
	double __fastcall GetMotionDetector_MaxDetectionsPerSecond();
	System::LongInt __fastcall GetMotionDetector_ReduceCPULoad();
	System::LongInt __fastcall GetMotionDetector_MotionResetMs();
	bool __fastcall GetMotionDetector_Triggered();
	bool __fastcall GetMouseWheelEventEnabled();
	bool __fastcall GetMouseWheelControlsZoomAtCursor();
	bool __fastcall GetMuteAudioRendering();
	bool __fastcall GetMultiplexedInputEmulation();
	TMultiplexedRole __fastcall GetMultiplexedRole();
	System::LongInt __fastcall GetMultiplexedSwitchDelay();
	System::LongInt __fastcall GetMultiplexedStabilizationDelay();
	System::LongInt __fastcall GetMultiplexer();
	System::UnicodeString __fastcall GetNDIGroups();
	System::UnicodeString __fastcall GetNDIName();
	TNDIBandwidthType __fastcall GetNDIBandwidthType();
	TNDIFormatType __fastcall GetNDIFormatType();
	System::LongInt __fastcall GetNDIReceiveTimeoutMs();
	TNetworkStreaming __fastcall GetNetworkStreaming();
	TNetworkStreamingType __fastcall GetNetworkStreamingType();
	TNotificationMethod __fastcall GetNotificationMethod();
	System::LongInt __fastcall GetNotificationSleepTime();
	System::Classes::TThreadPriority __fastcall GetNotificationPriority();
	bool __fastcall GetOnFrameBitmapEventSynchrone();
	bool __fastcall GetOpenURLAsync();
	bool __fastcall GetOverlayAfterTransform();
	bool __fastcall GetPlayerAudioRendering();
	TDVSize __fastcall GetPlayerDVSize();
	System::LongInt __fastcall GetPlayerFastSeekSpeedRatio();
	System::UnicodeString __fastcall GetPlayerFileName();
	System::UnicodeString __fastcall GetPlayerForcedCodec();
	THwAccel __fastcall GetPlayerHwAccel();
	bool __fastcall GetPlayerRefreshPausedDisplay();
	double __fastcall GetPlayerRefreshPausedDisplayFrameRate();
	double __fastcall GetPlayerSpeedRatio();
	bool __fastcall GetPlayerSpeedRatioConstantAudioPitch();
	Vcl::Comctrls::TTrackBar* __fastcall GetPlayerTrackBar();
	double __fastcall GetPlayerTrackBarScale();
	Vcl::Menus::TPopupMenu* __fastcall Get_PopupMenu();
	System::Classes::TComponent* __fastcall GetPropertyPageSaver();
	bool __fastcall GetPlayerTrackBarSynchrone();
	bool __fastcall GetPreallocCapFileCopiedAfterRecording();
	bool __fastcall GetPreallocCapFileEnabled();
	System::UnicodeString __fastcall GetPreallocCapFileName();
	System::LongInt __fastcall GetPreallocCapFileSizeInMB();
	System::LongInt __fastcall GetPreviewZoomSize();
	System::LongInt __fastcall GetRecordingAudioBitRate();
	System::LongInt __fastcall GetRecordingVideoBitRate();
	System::UnicodeString __fastcall GetRecordingFileName();
	bool __fastcall GetRecordingInNativeFormat();
	System::LongInt __fastcall GetRecordingFileSizeMaxInMB();
	TRecordingMethod __fastcall GetRecordingMethod();
	bool __fastcall GetRecordingPauseCreatesNewFile();
	bool __fastcall GetRecordingOnMotion_Enabled();
	double __fastcall GetRecordingOnMotion_MotionThreshold();
	System::LongInt __fastcall GetRecordingOnMotion_NoMotionPauseDelayMs();
	TRecordingTimer __fastcall GetRecordingTimer();
	System::LongInt __fastcall GetRecordingTimerInterval();
	bool __fastcall GetReencodingIncludeAudioStream();
	bool __fastcall GetReencodingIncludeVideoStream();
	TRecordingMethod __fastcall GetReencodingMethod();
	System::UnicodeString __fastcall GetReencodingNewVideoClip();
	System::UnicodeString __fastcall GetReencodingSourceVideoClip();
	bool __fastcall GetReencodingUseAudioCompressor();
	bool __fastcall GetReencodingUseFrameGrabber();
	bool __fastcall GetReencodingUseVideoCompressor();
	bool __fastcall GetReencodingWMVOutput();
	bool __fastcall GetQuickDeviceInitialization();
	bool __fastcall GetRawAudioSampleCapture();
	bool __fastcall GetRawCaptureAsyncEvent();
	TRawSampleCaptureLocation __fastcall GetRawSampleCaptureLocation();
	bool __fastcall GetRawVideoSampleCapture();
	TRecordingSize __fastcall GetRecordingSize();
	System::LongInt __fastcall GetScreenRecordingSizePercent();
	bool __fastcall GetScreenRecordingLayeredWindows();
	System::LongInt __fastcall GetScreenRecordingMonitor();
	bool __fastcall GetScreenRecordingNonVisibleWindows();
	bool __fastcall GetScreenRecordingThroughClipboard();
	bool __fastcall GetScreenRecordingWithCursor();
	Vcl::Extctrls::TShape* __fastcall GetShapeOverlay();
	bool __fastcall GetShapeOverlayEnabled();
	bool __fastcall GetSpeakerControl();
	System::UnicodeString __fastcall GetStoragePath();
	TStoragePathMode __fastcall GetStoragePathMode();
	bool __fastcall GetStoreDeviceSettingsInRegistry();
	System::Classes::TStream* __fastcall GetSourceStream();
	TSynchronizationRole __fastcall GetSynchronizationRole();
	bool __fastcall GetSynchronized();
	bool __fastcall GetSyncCommands();
	TSyncPreview __fastcall GetSyncPreview();
	TTextOverlayAlign __fastcall GetTextOverlayAlign();
	bool __fastcall GetTextOverlayAlphaBlend();
	System::LongInt __fastcall GetTextOverlayAlphaBlendValue();
	System::Uitypes::TColor __fastcall GetTextOverlayBkColor();
	bool __fastcall GetTextOverlayEnabled();
	Vcl::Graphics::TFont* __fastcall GetTextOverlayFont();
	System::Uitypes::TColor __fastcall GetTextOverlayFontColor();
	System::LongInt __fastcall GetTextOverlayFontSize();
	TTextOverlayGradientMode __fastcall GetTextOverlayGradientMode();
	System::Uitypes::TColor __fastcall GetTextOverlayGradientColor();
	bool __fastcall GetTextOverlayHighResFont();
	System::LongInt __fastcall GetTextOverlayLeft();
	TVideoAlignment __fastcall GetTextOverlayVideoAlignment();
	TTextOrientation __fastcall GetTextOverlayOrientation();
	System::LongInt __fastcall GetTextOverlayRight();
	bool __fastcall GetTextOverlayScrolling();
	System::LongInt __fastcall GetTextOverlayScrollingSpeed();
	System::LongInt __fastcall GetTextOverlaySelector();
	bool __fastcall GetTextOverlayShadow();
	System::Uitypes::TColor __fastcall GetTextOverlayShadowColor();
	TCardinalDirection __fastcall GetTextOverlayShadowDirection();
	System::UnicodeString __fastcall GetTextOverlayString();
	System::LongInt __fastcall GetTextOverlayTargetDisplay();
	System::LongInt __fastcall GetTextOverlayTop();
	bool __fastcall GetTextOverlayTransparent();
	System::UnicodeString __fastcall GetThirdPartyDeinterlacer();
	bool __fastcall GetTranslateMouseCoordinates();
	bool __fastcall GetTVUseFrequencyOverrides();
	System::LongInt __fastcall GetTunerFrequency();
	bool __fastcall GetUseClock();
	System::UnicodeString __fastcall GetVersion();
	System::LongInt __fastcall GetVideoCompression_DataRate();
	System::LongInt __fastcall GetVideoCompression_KeyFrameRate();
	System::LongInt __fastcall GetVideoCompression_PFramesPerKeyFrame();
	double __fastcall GetVideoCompression_Quality();
	System::LongInt __fastcall GetVideoCompression_WindowSize();
	bool __fastcall GetVideoControlSettings();
	LargeInteger __fastcall GetVideoDelay();
	bool __fastcall GetVideoFromImages_RepeatIndefinitely();
	System::UnicodeString __fastcall GetVideoFromImages_SourceDirectory();
	TFileSort __fastcall GetVideoFromImages_BitmapsSortedBy();
	System::UnicodeString __fastcall GetVideoFromImages_TemporaryFile();
	bool __fastcall Getv360_Enabled();
	TV360_MouseAction __fastcall Getv360_MouseAction();
	System::LongInt __fastcall Getv360_MouseActionPercent();
	Tv360_Angle __fastcall Getv360_MasterAngle();
	double __fastcall Getv360_AspectRatio();
	System::LongInt __fastcall GetVideoDevice();
	System::LongInt __fastcall GetAnalogVideoStandard();
	System::LongInt __fastcall GetAudioCompressor();
	System::LongInt __fastcall GetAudioInput();
	System::LongInt __fastcall GetVideoCompressor();
	System::LongInt __fastcall GetVideoFormat();
	System::LongInt __fastcall GetVideoInput();
	System::LongInt __fastcall GetVideoSize();
	System::LongInt __fastcall GetVideoSubtype();
	bool __fastcall GetVideoPlayableWhileRecording();
	System::LongInt __fastcall GetVideoProcessingBrightness();
	System::LongInt __fastcall GetVideoProcessingContrast();
	TVideoDeinterlacing __fastcall GetVideoProcessingDeinterlacing();
	bool __fastcall GetVideoProcessingGrayScale();
	System::LongInt __fastcall GetVideoProcessingHue();
	bool __fastcall GetVideoProcessingInvertColors();
	bool __fastcall GetVideoProcessingLeftRight();
	System::LongInt __fastcall GetVideoProcessingPixellization();
	TVideoRotation __fastcall GetVideoProcessingRotation();
	double __fastcall GetVideoProcessingRotationCustomAngle();
	System::LongInt __fastcall GetVideoProcessingSaturation();
	bool __fastcall GetVideoProcessingTopDown();
	bool __fastcall GetVideoQualitySettings();
	TVideoRenderer __fastcall GetVideoRenderer();
	TVideoRendererExternal __fastcall GetVideoRendererExternal();
	System::LongInt __fastcall GetVideoRendererExternalIndex();
	TVideoRendererPriority __fastcall GetVideoRendererPriority();
	TVideoSource __fastcall GetVideoSource();
	System::UnicodeString __fastcall GetVideoSource_FileOrURL();
	LargeInteger __fastcall GetVideoSource_FileOrURL_StartTime();
	LargeInteger __fastcall GetVideoSource_FileOrURL_StopTime();
	System::UnicodeString __fastcall GetStreamInterface_Format();
	double __fastcall GetStreamInterface_FrameRate();
	bool __fastcall GetStreamInterface_IsRealTime();
	System::LongInt __fastcall GetVideoStreamNumber();
	bool __fastcall GetVideoVisibleWhenStopped();
	System::LongInt __fastcall GetVirtualVideoStreamControl();
	System::LongInt __fastcall GetVirtualAudioStreamControl();
	TVuMeter __fastcall GetVuMeter();
	TWebcamStillCaptureButton __fastcall GetWebcamStillCaptureButton();
	System::LongInt __fastcall GetZoomCoeff();
	System::LongInt __fastcall GetZoomXCenter();
	System::LongInt __fastcall GetZoomYCenter();
	void __fastcall SetAdjustOverlayAspectRatio(bool Value);
	void __fastcall SetAdjustPixelAspectRatio(bool Value);
	void __fastcall SetApplicationPriority(TApplicationPriority Value);
	void __fastcall SetASFAudioBitRate(System::LongInt Value);
	void __fastcall SetASFAudioChannels(System::LongInt Value);
	void __fastcall SetASFBufferWindow(System::LongInt Value);
	void __fastcall SetASFDeinterlaceMode(TASFDeinterlaceMode Value);
	void __fastcall SetASFDirectStreamingKeepClientsConnected(bool Value);
	void __fastcall SetASFFixedFrameRate(bool Value);
	void __fastcall SetASFMediaServerPublishingPoint(System::UnicodeString Value);
	void __fastcall SetASFMediaServerTemplatePublishingPoint(System::UnicodeString Value);
	void __fastcall SetASFMediaServerRemovePublishingPointAfterDisconnect(bool Value);
	void __fastcall SetASFNetworkPort(System::LongInt Value);
	void __fastcall SetASFNetworkMaxUsers(System::LongInt Value);
	void __fastcall SetASFProfile(System::LongInt Value);
	void __fastcall SetASFProfileVersion(TASFProfileVersion Value);
	void __fastcall SetASFProfileFromCustomFile(System::UnicodeString Value);
	void __fastcall SetASFVideoBitRate(System::LongInt Value);
	void __fastcall SetASFVideoFrameRate(double Value);
	void __fastcall SetASFVideoHeight(System::LongInt Value);
	void __fastcall SetASFVideoMaxKeyFrameSpacing(System::LongInt Value);
	void __fastcall SetASFVideoQuality(System::LongInt Value);
	void __fastcall SetASFVideoWidth(System::LongInt Value);
	void __fastcall SetAspectRatioToUse(double Value);
	void __fastcall SetAVIDurationUpdated(bool Value);
	void __fastcall SetAero(TAero Value);
	void __fastcall SetAssociateAudioAndVideoDevices(bool Value);
	void __fastcall SetAudioDevice(System::LongInt Value);
	void __fastcall SetAudioRenderer(System::LongInt Value);
	void __fastcall SetAudioStreamNumber(System::LongInt Value);
	void __fastcall SetAudioSyncAdjustmentEnabled(bool Value);
	void __fastcall SetAudioSyncAdjustment(System::LongInt Value);
	void __fastcall SetAudioDeviceRendering(bool Value);
	void __fastcall SetAudioFormat(TAudioFormat Value);
	void __fastcall SetMixAudioSamplesLevel(System::LongInt Index, System::LongInt Value);
	void __fastcall SetMixer_MosaicLines(System::LongInt Value);
	void __fastcall SetMixer_MosaicColumns(System::LongInt Value);
	void __fastcall SetAudioChannelRenderMode(TAudioChannelRenderMode Value);
	void __fastcall SetAudioPeakEvent(bool Value);
	void __fastcall SetAudioRecording(bool Value);
	void __fastcall SetAudioSource(TAudioSource Value);
	void __fastcall SetAutoConnectRelatedPins(bool Value);
	void __fastcall SetAutoFileName(TAutoFileName Value);
	void __fastcall SetAutoFileNameDateTimeFormat(System::UnicodeString Value);
	void __fastcall SetAutoFileNameMinDigits(System::LongInt Value);
	void __fastcall SetAutoFilePrefix(System::UnicodeString Value);
	void __fastcall SetAutoFileSuffix(System::UnicodeString Value);
	void __fastcall SetAutoRefreshPreview(bool Value);
	void __fastcall SetAutoStartPlayer(bool Value);
	void __fastcall SetAVIFormatOpenDML(bool Value);
	void __fastcall SetAVIFormatOpenDMLCompatibilityIndex(bool Value);
	void __fastcall SetBackgroundColor(System::Uitypes::TColor Value);
	HIDESBASE void __fastcall SetBorderStyle(Vcl::Forms::TBorderStyle Value);
	void __fastcall SetBurstCount(System::LongInt Value);
	void __fastcall SetBurstInterval(System::LongInt Value);
	void __fastcall SetBurstMode(bool Value);
	void __fastcall SetBurstType(TFrameCaptureDest Value);
	void __fastcall SetCameraControlSettings(bool Value);
	void __fastcall SetCaptureFileExt(System::UnicodeString Value);
	void __fastcall SetColorKey(System::Uitypes::TColor Value);
	void __fastcall SetColorKeyEnabled(bool Value);
	void __fastcall SetCompressionMode(TCompressionMode Value);
	void __fastcall SetCompressionType(TCompressionType Value);
	void __fastcall SetVideoDoubleBuffered(bool Value);
	void __fastcall SetDroppedFramesPollingInterval(System::LongInt Value);
	void __fastcall SetDVDateTimeEnabled(bool Value);
	void __fastcall SetDVDiscontinuityMinimumInterval(System::LongInt Value);
	void __fastcall SetDVDTitle(System::LongInt Value);
	void __fastcall SetDVEncoder_VideoFormat(TDVVideoFormat Value);
	void __fastcall SetDVEncoder_VideoResolution(TDVSize Value);
	void __fastcall SetDVEncoder_VideoStandard(TDVVideoStandard Value);
	void __fastcall SetDVReduceFrameRate(bool Value);
	void __fastcall SetDVRecordingInNativeFormatSeparatesStreams(bool Value);
	void __fastcall SetDVTimeCodeEnabled(bool Value);
	void __fastcall SetDVRgb219(bool Value);
	void __fastcall SetEventNotificationSynchrone(bool Value);
	void __fastcall SetExtraDLLPath(System::UnicodeString Value);
	void __fastcall SetCropping_Enabled(bool Value);
	void __fastcall SetCropping_Height(System::LongInt Value);
	void __fastcall SetCropping_Outbounds(bool Value);
	void __fastcall SetCropping_Width(System::LongInt Value);
	void __fastcall SetCropping_X(System::LongInt Value);
	void __fastcall SetCropping_Y(System::LongInt Value);
	void __fastcall SetCropping_Zoom(double Value);
	void __fastcall SetFixFlickerOrBlackCapture(bool Value);
	void __fastcall SetFrameCaptureWithoutOverlay(bool Value);
	void __fastcall SetFrameCaptureHeight(System::LongInt Value);
	void __fastcall SetFrameCaptureWidth(System::LongInt Value);
	void __fastcall SetFrameCaptureZoomSize(System::LongInt Value);
	void __fastcall SetFrameGrabber(TFrameGrabber Value);
	void __fastcall SetFrameGrabberRGBFormat(TFrameGrabberRGBFormat Value);
	void __fastcall SetFrameNumberStartsFromZero(bool Value);
	void __fastcall SetFrameRate(double Value);
	void __fastcall SetFrameRateDivider(System::LongInt Value);
	void __fastcall SetGetLastFrameWaitTimeoutMs(System::LongInt Value);
	void __fastcall SetGeneratePts(bool Value);
	void __fastcall SetImageOverlayAlphaBlend(bool Value);
	void __fastcall SetImageOverlayAlphaBlendValue(System::LongInt Value);
	void __fastcall SetImageOverlayChromaKey(bool Value);
	void __fastcall SetImageOverlayChromaKeyLeewayPercent(System::LongInt Value);
	void __fastcall SetImageOverlayChromaKeyRGBColor(System::LongInt Value);
	void __fastcall SetImageOverlayHeight(System::LongInt Value);
	void __fastcall SetImageOverlayLeftLocation(System::LongInt Value);
	void __fastcall SetImageOverlayVideoAlignment(TVideoAlignment Value);
	void __fastcall SetImageOverlayRotationAngle(double Value);
	void __fastcall SetImageOverlaySelector(System::LongInt Value);
	void __fastcall SetImageOverlayStretchToVideoSize(bool Value);
	void __fastcall SetImageOverlayTargetDisplay(System::LongInt Value);
	void __fastcall SetImageOverlayTopLocation(System::LongInt Value);
	void __fastcall SetImageOverlayTransparent(bool Value);
	void __fastcall SetImageOverlayTransparentColorValue(System::LongInt Value);
	void __fastcall SetImageOverlayUseTransparentColor(bool Value);
	void __fastcall SetImageOverlayWidth(System::LongInt Value);
	void __fastcall SetImageOverlayEnabled(bool Value);
	void __fastcall SetIPCameraURL(System::UnicodeString Value);
	void __fastcall SetJPEGPerformance(TJPEGPerformance Value);
	void __fastcall SetJPEGProgressiveDisplay(bool Value);
	void __fastcall SetJPEGQuality(System::LongInt Value);
	void __fastcall SetLicenseString(System::UnicodeString PassedValue);
	void __fastcall SetLogoDisplayed(bool Value);
	void __fastcall SetLogoLayout(TLogoLayout Value);
	void __fastcall SetMotionDetector_Grid(System::UnicodeString Value);
	void __fastcall SetMotionDetector_CompareBlue(bool Value);
	void __fastcall SetMotionDetector_CompareGreen(bool Value);
	void __fastcall SetMotionDetector_GreyScale(bool Value);
	void __fastcall SetMotionDetector_CompareRed(bool Value);
	void __fastcall SetMotionDetector_Enabled(bool Value);
	void __fastcall SetMotionDetector_MaxDetectionsPerSecond(double Value);
	void __fastcall SetMotionDetector_ReduceVideoNoise(bool Value);
	void __fastcall SetMotionDetector_ReduceCPULoad(System::LongInt Value);
	void __fastcall SetMotionDetector_MotionResetMs(System::LongInt Value);
	void __fastcall SetMotionDetector_Triggered(bool Value);
	void __fastcall SetMouseWheelEventEnabled(bool Value);
	void __fastcall SetMouseWheelControlsZoomAtCursor(bool Value);
	void __fastcall SetMultiplexedInputEmulation(bool Value);
	void __fastcall SetMultiplexedRole(TMultiplexedRole Value);
	void __fastcall SetMultiplexedSwitchDelay(System::LongInt Value);
	void __fastcall SetMultiplexedStabilizationDelay(System::LongInt Value);
	void __fastcall SetMultiplexer(System::LongInt Value);
	void __fastcall SetMuteAudioRendering(bool Value);
	void __fastcall SetNDIGroups(System::UnicodeString Value);
	void __fastcall SetNDIName(System::UnicodeString Value);
	void __fastcall SetNDIBandwidthType(TNDIBandwidthType Value);
	void __fastcall SetNDIFormatType(TNDIFormatType Value);
	void __fastcall SetNDIReceiveTimeoutMs(System::LongInt Value);
	void __fastcall SetNetworkStreaming(TNetworkStreaming Value);
	void __fastcall SetNetworkStreamingType(TNetworkStreamingType Value);
	void __fastcall SetNotificationMethod(TNotificationMethod Value);
	void __fastcall SetNotificationSleepTime(System::LongInt Value);
	void __fastcall SetNotificationPriority(System::Classes::TThreadPriority Value);
	void __fastcall SetOnFrameBitmapEventSynchrone(bool Value);
	void __fastcall Set_OnDeviceArrivalOrRemoval(TOnDeviceArrivalOrRemoval Value);
	void __fastcall SetOpenURLAsync(bool Value);
	void __fastcall SetOverlayAfterTransform(bool Value);
	void __fastcall SetPlayerAudioRendering(bool Value);
	void __fastcall SetPlayerDVSize(TDVSize Value);
	void __fastcall SetPlayerFastSeekSpeedRatio(System::LongInt Value);
	void __fastcall SetPlayerFileName(System::UnicodeString Value);
	void __fastcall SetPlayerForcedCodec(System::UnicodeString Value);
	void __fastcall SetPlayerHwAccel(THwAccel Value);
	void __fastcall SetPlayerRefreshPausedDisplay(bool Value);
	void __fastcall SetPlayerRefreshPausedDisplayFrameRate(double Value);
	void __fastcall SetPlayerSpeedRatio(double Value);
	void __fastcall SetPlayerSpeedRatioConstantAudioPitch(bool Value);
	void __fastcall SetPlayerTrackBar(Vcl::Comctrls::TTrackBar* Value);
	HIDESBASE void __fastcall SetPopupMenu(Vcl::Menus::TPopupMenu* Value);
	void __fastcall SetPropertyPageSaver(System::Classes::TComponent* Value);
	void __fastcall SetPlayerTrackBarSynchrone(bool Value);
	void __fastcall SetPreallocCapFileCopiedAfterRecording(bool Value);
	void __fastcall SetPreallocCapFileEnabled(bool Value);
	void __fastcall SetPreallocCapFileName(System::UnicodeString Value);
	void __fastcall SetPreallocCapFileSizeInMB(System::LongInt Value);
	void __fastcall SetPreviewZoomSize(System::LongInt Value);
	void __fastcall SetRecordingAudioBitRate(System::LongInt Value);
	void __fastcall SetRecordingVideoBitRate(System::LongInt Value);
	void __fastcall SetRecordingFileName(System::UnicodeString Value);
	void __fastcall SetRecordingFileSizeMaxInMB(System::LongInt Value);
	void __fastcall SetRecordingInNativeFormat(bool Value);
	void __fastcall SetRecordingMethod(TRecordingMethod Value);
	void __fastcall SetRecordingPauseCreatesNewFile(bool Value);
	void __fastcall SetRecordingOnMotion_Enabled(bool Value);
	void __fastcall SetRecordingOnMotion_MotionThreshold(double Value);
	void __fastcall SetRecordingOnMotion_NoMotionPauseDelayMs(System::LongInt Value);
	void __fastcall SetRecordingTimer(TRecordingTimer Value);
	void __fastcall SetRecordingTimerInterval(System::LongInt Value);
	void __fastcall SetReencodingNewVideoClip(System::UnicodeString Value);
	void __fastcall SetReencodingSourceVideoClip(System::UnicodeString Value);
	void __fastcall SetReencodingIncludeAudioStream(bool Value);
	void __fastcall SetReencodingIncludeVideoStream(bool Value);
	void __fastcall SetReencodingMethod(TRecordingMethod Value);
	void __fastcall SetReencodingUseAudioCompressor(bool Value);
	void __fastcall SetReencodingUseFrameGrabber(bool Value);
	void __fastcall SetReencodingUseVideoCompressor(bool Value);
	void __fastcall SetReencodingWMVOutput(bool Value);
	void __fastcall SetQuickDeviceInitialization(bool Value);
	void __fastcall SetRawAudioSampleCapture(bool Value);
	void __fastcall SetRawCaptureAsyncEvent(bool Value);
	void __fastcall SetRawSampleCaptureLocation(TRawSampleCaptureLocation Value);
	void __fastcall SetRawVideoSampleCapture(bool Value);
	void __fastcall SetRecordingSize(TRecordingSize Value);
	void __fastcall SetScreenRecordingSizePercent(System::LongInt Value);
	void __fastcall SetScreenRecordingLayeredWindows(bool Value);
	void __fastcall SetScreenRecordingMonitor(System::LongInt Value);
	void __fastcall SetScreenRecordingNonVisibleWindows(bool Value);
	void __fastcall SetScreenRecordingThroughClipboard(bool Value);
	void __fastcall SetScreenRecordingWithCursor(bool Value);
	void __fastcall SetShapeOverlay(Vcl::Extctrls::TShape* Value);
	void __fastcall SetShapeOverlayEnabled(bool Value);
	void __fastcall SetSpeakerControl(bool Value);
	void __fastcall SetStoragePath(System::UnicodeString Value);
	void __fastcall SetStoragePathMode(TStoragePathMode Value);
	void __fastcall SetStoreDeviceSettingsInRegistry(bool Value);
	void __fastcall SetSourceStream(System::Classes::TStream* Value);
	void __fastcall SetSynchronizationRole(TSynchronizationRole Value);
	void __fastcall SetSynchronized(bool Value);
	void __fastcall SetSyncCommands(bool Value);
	void __fastcall SetSyncPreview(TSyncPreview Value);
	void __fastcall SetTextOverlayAlign(TTextOverlayAlign Value);
	void __fastcall SetTextOverlayAlphaBlend(bool Value);
	void __fastcall SetTextOverlayAlphaBlendValue(System::LongInt Value);
	void __fastcall SetTextOverlayBkColor(System::Uitypes::TColor Value);
	void __fastcall SetTextOverlayEnabled(bool Value);
	void __fastcall SetTextOverlayFont(Vcl::Graphics::TFont* Value);
	void __fastcall SetTextOverlayFontColor(System::Uitypes::TColor Value);
	void __fastcall SetTextOverlayFontSize(System::LongInt Value);
	void __fastcall SetTextOverlayGradientMode(TTextOverlayGradientMode Value);
	void __fastcall SetTextOverlayGradientColor(System::Uitypes::TColor Value);
	void __fastcall SetTextOverlayHighResFont(bool Value);
	void __fastcall SetTextOverlayLeft(System::LongInt Value);
	void __fastcall SetTextOverlayVideoAlignment(TVideoAlignment Value);
	void __fastcall SetTextOverlayRight(System::LongInt Value);
	void __fastcall SetTextOverlayOrientation(TTextOrientation Value);
	void __fastcall SetTextOverlayScrolling(bool Value);
	void __fastcall SetTextOverlayScrollingSpeed(System::LongInt Value);
	void __fastcall SetTextOverlaySelector(System::LongInt Value);
	void __fastcall SetTextOverlayShadow(bool Value);
	void __fastcall SetTextOverlayShadowColor(System::Uitypes::TColor Value);
	void __fastcall SetTextOverlayShadowDirection(TCardinalDirection Value);
	void __fastcall SetTextOverlayString(System::UnicodeString Value);
	void __fastcall SetTextOverlayTargetDisplay(System::LongInt Value);
	void __fastcall SetTextOverlayTop(System::LongInt Value);
	void __fastcall SetTextOverlayTransparent(bool Value);
	void __fastcall SetThirdPartyDeinterlacer(System::UnicodeString Value);
	void __fastcall SetTranslateMouseCoordinates(bool Value);
	void __fastcall SetTVUseFrequencyOverrides(bool Value);
	void __fastcall SetTunerFrequency(System::LongInt Value);
	void __fastcall SetUseClock(bool Value);
	void __fastcall SetVersion(System::UnicodeString Value);
	void __fastcall SetVideoCompression_DataRate(System::LongInt Value);
	void __fastcall SetVideoCompression_KeyFrameRate(System::LongInt Value);
	void __fastcall SetVideoCompression_PFramesPerKeyFrame(System::LongInt Value);
	void __fastcall SetVideoCompression_Quality(double Value);
	void __fastcall SetVideoCompression_WindowSize(System::LongInt Value);
	void __fastcall SetVideoControlSettings(bool Value);
	void __fastcall SetVideoDelay(LargeInteger Value);
	void __fastcall Setv360_Enabled(bool Value);
	void __fastcall Setv360_MouseAction(TV360_MouseAction Value);
	void __fastcall Setv360_MouseActionPercent(System::LongInt Value);
	void __fastcall Setv360_MasterAngle(Tv360_Angle Value);
	void __fastcall Setv360_AspectRatio(double Value);
	void __fastcall SetVideoDevice(System::LongInt Value);
	void __fastcall SetAnalogVideoStandard(System::LongInt Value);
	void __fastcall SetAudioCompressor(System::LongInt Value);
	void __fastcall SetAudioInput(System::LongInt Value);
	void __fastcall SetVideoCompressor(System::LongInt Value);
	void __fastcall SetVideoFormat(System::LongInt Value);
	void __fastcall SetVideoInput(System::LongInt Value);
	void __fastcall SetVideoSize(System::LongInt Value);
	void __fastcall SetVideoSubtype(System::LongInt Value);
	void __fastcall SetVideoFromImages_SourceDirectory(System::UnicodeString Value);
	void __fastcall SetVideoFromImages_TemporaryFile(System::UnicodeString Value);
	void __fastcall SetVideoFromImages_BitmapsSortedBy(TFileSort Value);
	void __fastcall SetVideoFromImages_RepeatIndefinitely(bool Value);
	void __fastcall SetVideoPlayableWhileRecording(bool Value);
	void __fastcall SetVideoProcessingBrightness(System::LongInt Value);
	void __fastcall SetVideoProcessingContrast(System::LongInt Value);
	void __fastcall SetVideoProcessingDeinterlacing(TVideoDeinterlacing Value);
	void __fastcall SetVideoProcessingGrayScale(bool Value);
	void __fastcall SetVideoProcessingHue(System::LongInt Value);
	void __fastcall SetVideoProcessingInvertColors(bool Value);
	void __fastcall SetVideoProcessingLeftRight(bool Value);
	void __fastcall SetVideoProcessingPixellization(System::LongInt Value);
	void __fastcall SetVideoProcessingRotationCustomAngle(double Value);
	void __fastcall SetVideoProcessingRotation(TVideoRotation Value);
	void __fastcall SetVideoProcessingSaturation(System::LongInt Value);
	void __fastcall SetVideoProcessingTopDown(bool Value);
	void __fastcall SetVideoQualitySettings(bool Value);
	void __fastcall SetVideoRenderer(TVideoRenderer Value);
	void __fastcall SetVideoRendererExternal(TVideoRendererExternal Value);
	void __fastcall SetVideoRendererExternalIndex(System::LongInt Value);
	void __fastcall SetVideoRendererPriority(TVideoRendererPriority Value);
	void __fastcall SetVideoSource(TVideoSource Value);
	void __fastcall SetVideoSource_FileOrURL(System::UnicodeString Value);
	void __fastcall SetVideoSource_FileOrURL_StartTime(LargeInteger Value);
	void __fastcall SetVideoSource_FileOrURL_StopTime(LargeInteger Value);
	void __fastcall SetStreamInterface_Format(System::UnicodeString Value);
	void __fastcall SetStreamInterface_FrameRate(double Value);
	void __fastcall SetStreamInterface_IsRealTime(bool Value);
	void __fastcall SetVideoStreamNumber(System::LongInt Value);
	void __fastcall SetVideoVisibleWhenStopped(bool Value);
	void __fastcall SetVirtualVideoStreamControl(System::LongInt Value);
	void __fastcall SetVirtualAudioStreamControl(System::LongInt Value);
	void __fastcall SetVuMeter(TVuMeter Value);
	void __fastcall SetWebcamStillCaptureButton(TWebcamStillCaptureButton Value);
	void __fastcall SetZoomXCenter(System::LongInt Value);
	void __fastcall SetZoomYCenter(System::LongInt Value);
	void __fastcall SetZoomCoeff(System::LongInt Value);
	System::Uitypes::TCursor __fastcall GetBusyCursor();
	void __fastcall SetBusyCursor(System::Uitypes::TCursor Value);
	System::Uitypes::TCursor __fastcall GetVideoCursor();
	void __fastcall SetVideoCursor(System::Uitypes::TCursor Value);
	System::Uitypes::TCursor __fastcall GetNormalCursor();
	void __fastcall SetNormalCursor(System::Uitypes::TCursor Value);
	System::UnicodeString __fastcall GetAnalogVideoStandards();
	System::LongInt __fastcall GetAnalogVideoStandardsCount();
	System::LongInt __fastcall GetBufferCount();
	System::UnicodeString __fastcall GetASFProfiles();
	System::LongInt __fastcall GetASFProfilesCount();
	System::LongInt __fastcall GetAudioBalance();
	System::UnicodeString __fastcall GetAudioCompressorName();
	System::LongInt __fastcall GetAudioInputBalance();
	System::LongInt __fastcall GetAudioInputLevel();
	bool __fastcall GetAudioInputMono();
	System::UnicodeString __fastcall GetAudioInputs();
	System::LongInt __fastcall GetAudioInputsCount();
	System::UnicodeString __fastcall GetAudioDeviceName();
	System::UnicodeString __fastcall GetAudioFormats();
	System::UnicodeString __fastcall GetAudioRendererName();
	System::LongInt __fastcall GetAudioVolume();
	bool __fastcall GetAudioVolumeEnabled();
	bool __fastcall GetBusy();
	System::LongInt __fastcall GetCropping_YMax();
	System::LongInt __fastcall GetCropping_XMax();
	double __fastcall GetCurrentFrameRate();
	TCurrentState __fastcall GetCurrentState();
	LargeInteger __fastcall GetDeliveredFrames();
	System::UnicodeString __fastcall GetDirectShowFilters();
	System::LongInt __fastcall GetDirectShowFiltersCount();
	System::LongInt __fastcall GetDroppedFrameCount();
	System::UnicodeString __fastcall GetAudioCompressors();
	System::LongInt __fastcall GetAudioCompressorsCount();
	System::UnicodeString __fastcall GetAudioDevices();
	System::LongInt __fastcall GetAudioDevicesCount();
	System::UnicodeString __fastcall GetAudioRenderers();
	System::LongInt __fastcall GetAudioRenderersCount();
	TFrameGrabberRGBFormat __fastcall GetFrameGrabberCurrentRGBFormat();
	bool __fastcall GetHoldRecording();
	double __fastcall GetImageRatio();
	bool __fastcall GetInFrameProgressEvent();
	bool __fastcall GetIsAnalogVideoDecoderAvailable();
	bool __fastcall GetIsAudioCrossbarAvailable();
	TTriState __fastcall GetIsAudioInputBalanceAvailable();
	bool __fastcall GetIsCameraControlAvailable();
	bool __fastcall GetIsDigitalVideoIn();
	bool __fastcall GetIsDVCommandAvailable();
	bool __fastcall GetIsHorizontalSyncLocked();
	bool __fastcall GetIsMpegStream();
	TTriState __fastcall GetIsPlayerAudioStreamAvailable();
	TTriState __fastcall GetIsPlayerVideoStreamAvailable();
	bool __fastcall GetIsRecordingPaused();
	bool __fastcall GetTimeCodeReaderAvailable();
	bool __fastcall GetIsTVAudioAvailable();
	bool __fastcall GetIsTVAutoTuneRunning();
	bool __fastcall GetIsTVTunerAvailable();
	bool __fastcall GetIsVideoControlAvailable();
	bool __fastcall GetIsVideoCrossbarAvailable();
	bool __fastcall GetIsVideoQualityAvailable();
	bool __fastcall GetIsVideoPortAvailable();
	bool __fastcall GetIsVideoInterlaced();
	bool __fastcall GetIsWDMVideoDriver();
	System::UnicodeString __fastcall GetLast_BurstFrameCapture_FileName();
	System::UnicodeString __fastcall GetLast_CaptureFrameTo_FileName();
	System::UnicodeString __fastcall GetLast_Recording_FileName();
	System::UnicodeString __fastcall GetLast_Clip_Played();
	double __fastcall GetMotionDetector_GlobalMotionRatio();
	System::LongInt __fastcall GetMotionDetector_GridXCount();
	System::LongInt __fastcall GetMotionDetector_GridYCount();
	bool __fastcall GetMotionDetector_IsGridValid();
	TMpegStreamType __fastcall GetMpegStreamType();
	System::UnicodeString __fastcall GetMultiplexerName();
	System::UnicodeString __fastcall GetMultiplexers();
	System::LongInt __fastcall GetMultiplexersCount();
	System::LongInt __fastcall GetPlaylistIndex();
	LargeInteger __fastcall GetPlayerDuration();
	LargeInteger __fastcall GetPlayerFrameCount();
	LargeInteger __fastcall GetPlayerFramePosition();
	LargeInteger __fastcall GetPlayerTimePosition();
	double __fastcall GetPlayerFrameRate();
	TPlayerState __fastcall GetPlayerState();
	System::UnicodeString __fastcall GetPropertyPageSaverGroup();
	System::LongInt __fastcall GetRecordingBacktimedFramesCount();
	bool __fastcall GetRecordingCanPause();
	double __fastcall GetRecordingDuration();
	System::UnicodeString __fastcall GetRecordingFourCC();
	System::LongInt __fastcall GetRecordingHeight();
	System::LongInt __fastcall GetRecordingWidth();
	LargeInteger __fastcall GetReencodingStartFrame();
	LargeInteger __fastcall GetReencodingStartTime();
	LargeInteger __fastcall GetReencodingStopFrame();
	LargeInteger __fastcall GetReencodingStopTime();
	System::LongInt __fastcall GetSendToDV_DeviceIndex();
	System::LongInt __fastcall GetSpeakerBalance();
	System::LongInt __fastcall GetSpeakerVolume();
	System::UnicodeString __fastcall GetStreamingURL();
	System::UnicodeString __fastcall GetSystemTempPath();
	System::LongInt __fastcall GetTVChannel();
	System::LongInt __fastcall GetTVCountryCode();
	TTunerInput __fastcall GetTVTunerInputType();
	TTunerMode __fastcall GetTunerMode();
	System::LongInt __fastcall GetUniqueID();
	bool __fastcall GetVCRHorizontalLocking();
	System::UnicodeString __fastcall GetVideoCompressorName();
	System::UnicodeString __fastcall GetVideoCompressors();
	System::LongInt __fastcall GetVideoCompressorsCount();
	System::UnicodeString __fastcall GetVideoDevices();
	System::UnicodeString __fastcall GetVideoDevicesId();
	System::LongInt __fastcall GetVideoDevicesCount();
	System::UnicodeString __fastcall GetVideoFormats();
	System::LongInt __fastcall GetVideoFormatsCount();
	System::UnicodeString __fastcall GetVideoInputs();
	System::LongInt __fastcall GetVideoInputsCount();
	System::UnicodeString __fastcall GetVideoDeviceName();
	System::UnicodeString __fastcall GetVideoSizes();
	System::LongInt __fastcall GetVideoSizesCount();
	System::LongInt __fastcall GetVideoHeight();
	System::LongInt __fastcall GetVideoHeight_PreferredAspectRatio();
	System::LongInt __fastcall GetVideoWidth();
	System::LongInt __fastcall GetVideoWidth_PreferredAspectRatio();
	System::UnicodeString __fastcall GetVideoSources();
	System::LongInt __fastcall GetVideoSourcesCount();
	System::UnicodeString __fastcall GetVideoSubtypes();
	System::LongInt __fastcall GetVideoSubtypesCount();
	void __fastcall SetAudioBalance(System::LongInt Value);
	void __fastcall SetAudioInputBalance(System::LongInt Value);
	void __fastcall SetAudioInputLevel(System::LongInt Value);
	void __fastcall SetAudioInputMono(bool Value);
	void __fastcall SetAudioVolume(System::LongInt Value);
	void __fastcall SetAudioVolumeEnabled(bool Value);
	void __fastcall SetBufferCount(System::LongInt Value);
	void __fastcall SetHoldRecording(bool Value);
	void __fastcall SetMpegStreamType(TMpegStreamType Value);
	void __fastcall SetPlaylistIndex(System::LongInt Value);
	void __fastcall SetPlayerDuration(LargeInteger Value);
	void __fastcall SetPlayerFramePosition(LargeInteger Value);
	void __fastcall SetPlayerTimePosition(LargeInteger Value);
	void __fastcall SetPropertyPageSaverGroup(System::UnicodeString Value);
	void __fastcall SetRecordingBacktimedFramesCount(System::LongInt Value);
	void __fastcall SetRecordingCanPause(bool Value);
	void __fastcall SetReencodingStartFrame(LargeInteger Value);
	void __fastcall SetReencodingStartTime(LargeInteger Value);
	void __fastcall SetReencodingStopFrame(LargeInteger Value);
	void __fastcall SetReencodingStopTime(LargeInteger Value);
	void __fastcall SetSendToDV_DeviceIndex(System::LongInt Value);
	void __fastcall SetSpeakerBalance(System::LongInt Value);
	void __fastcall SetSpeakerVolume(System::LongInt Value);
	void __fastcall SetTVChannel(System::LongInt Value);
	void __fastcall SetTVCountryCode(System::LongInt Value);
	void __fastcall SetTVTunerInputType(TTunerInput Value);
	void __fastcall SetTunerMode(TTunerMode Value);
	void __fastcall SetVCRHorizontalLocking(bool Value);
	
public:
	void __fastcall zReservedInternal4(void * Param1, void * Param2);
	virtual void __fastcall BeforeDestruction();
	virtual void __fastcall SetBounds(int ALeft, int ATop, int AWidth, int AHeight);
	void __fastcall About();
	System::LongInt __fastcall AnalogVideoStandardIndex(System::UnicodeString Value);
	System::UnicodeString __fastcall ASFStreaming_GetAuthorizationList();
	System::UnicodeString __fastcall ASFStreaming_GetConnectedClients();
	System::LongInt __fastcall ASFStreaming_GetConnectedClientsCount();
	bool __fastcall ASFStreaming_ResetAuthorizations();
	bool __fastcall ASFStreaming_SetAuthorization(bool Allowed, System::UnicodeString IP, System::UnicodeString Mask);
	bool __fastcall AssociateMultiplexedSlave(System::LongInt InputNumber, System::LongInt SlaveUniqueID);
	System::LongInt __fastcall AudioCompressorIndex(System::UnicodeString Value);
	System::LongInt __fastcall AudioDeviceIndex(System::UnicodeString Value);
	System::LongInt __fastcall AudioRendererIndex(System::UnicodeString Value);
	System::LongInt __fastcall AudioInputIndex(System::UnicodeString Value);
	System::UnicodeString __fastcall AVIInfo2(System::UnicodeString AVIFile, TAVIInfoType AVIInfoType);
	System::UnicodeString __fastcall AVIHeaderInfo(System::UnicodeString AVIFile, THeaderAttribute HeaderAttribute);
	System::LongInt __fastcall CameraControlValue(TCameraControl Setting);
	bool __fastcall CameraControlAuto(TCameraControl Setting);
	System::LongInt __fastcall CameraControlDefault(TCameraControl Setting);
	System::LongInt __fastcall CameraControlMin(TCameraControl Setting);
	System::LongInt __fastcall CameraControlMax(TCameraControl Setting);
	System::LongInt __fastcall CameraControlStep(TCameraControl Setting);
	bool __fastcall Cancel();
	bool __fastcall CanProcessMessages();
	bool __fastcall CaptureFrameTo(TFrameCaptureDest Dest, System::UnicodeString FileName);
	bool __fastcall CaptureFrameRenderedTo(System::LongInt DisplayIndex, TFrameCaptureDest Dest, System::UnicodeString FileName);
	bool __fastcall CaptureFrameSyncTo(TFrameCaptureDest Dest, System::UnicodeString FileName);
	void __fastcall ClearHeaderAttributes();
	void __fastcall ClosePlayer();
	void __fastcall ContinueProcessing();
	double __fastcall RealProcessingFrameRate();
	System::UnicodeString __fastcall GetLastErrorMessage();
	HBITMAP __fastcall GetLastFrameAsHBITMAP(System::LongInt BufferIndex, bool WithOverlays, System::LongInt SrcLeftLocation, System::LongInt SrcTopLocation, System::LongInt SrcWidth, System::LongInt SrcHeight, System::LongInt DestWidth, System::LongInt DestHeight, System::LongInt BitmapColorBitCount);
	void * __fastcall GetLastFrameBitmapBits(System::LongInt BufferIndex, bool WithOverlays, bool ReleaseFrame);
	void * __fastcall GetLastFrameBitmapBits2(System::LongInt BufferIndex, bool WithOverlays, bool ReleaseFrame, /* out */ System::LongInt &BitmapWidth, /* out */ System::LongInt &BitmapHeight, /* out */ System::LongInt &BitmapLineSize, /* out */ System::LongInt &BitmapSize, /* out */ System::LongInt &BitmapBitsPerPixel);
	void * __fastcall GetLastFrameBitmapBits3(System::LongInt BufferIndex, bool WithOverlays, /* out */ System::LongInt &BitmapWidth, /* out */ System::LongInt &BitmapHeight, /* out */ System::LongInt &BitmapLineSize, /* out */ System::LongInt &BitmapSize, /* out */ System::LongInt &BitmapBitsPerPixel, /* out */ void * &BitmapBits);
	void __fastcall ReleaseGetLastFrameBitmapBits3(void * FramePtr);
	void * __fastcall WaitForLastFrameBitmapBits(System::LongInt BufferIndex, bool WithOverlays, bool ReleaseFrame, /* out */ System::LongInt &BitmapWidth, /* out */ System::LongInt &BitmapHeight, /* out */ System::LongInt &BitmapLineSize, /* out */ System::LongInt &BitmapSize, /* out */ System::LongInt &BitmapBitsPerPixel, /* out */ LargeInteger &FrameTime, /* out */ LargeInteger &FrameNumber);
	Vcl::Graphics::TBitmap* __fastcall GetLastFrameAsTBitmap(System::LongInt BufferIndex, bool WithOverlays, System::LongInt SrcLeftLocation, System::LongInt SrcTopLocation, System::LongInt SrcWidth, System::LongInt SrcHeight, System::LongInt DestWidth, System::LongInt DestHeight, System::LongInt BitmapColorBitCount);
	System::LongInt __fastcall GetFrameBitmapInfo(TFrameBitmapInfoType FrameBitmapInfoType);
	bool __fastcall CreatePreallocCapFile();
	bool __fastcall DecklinkKeyer_Enable(bool IsExternal);
	bool __fastcall DecklinkKeyer_SetLevel(System::LongInt Level_0_255);
	bool __fastcall DecklinkKeyer_RampUp(System::LongInt NumberOfFrames);
	bool __fastcall DecklinkKeyer_RampDown(System::LongInt NumberOfFrames);
	bool __fastcall DecklinkKeyer_Disable();
	bool __fastcall SetAlphaChannel(System::LongInt Value);
	double __fastcall DVDInfo(System::UnicodeString DVDRootDirectory, TDVDInfoType DVDInfoType, System::LongInt TitleNumber);
	void __fastcall Display_SetLocation(System::LongInt WindowLeft, System::LongInt WindowTop, System::LongInt WindowWidth, System::LongInt WindowHeight);
	void __fastcall DualDisplay_SetLocation(System::LongInt WindowLeft, System::LongInt WindowTop, System::LongInt WindowWidth, System::LongInt WindowHeight);
	bool __fastcall DrawBitmapOverFrame(Vcl::Graphics::TBitmap* Bitmap, bool Stretched, System::LongInt LeftLocation, System::LongInt TopLocation, System::LongInt bmWidth, System::LongInt bmHeight, bool Transparent_Enabled, bool UseTransparentColor, System::Uitypes::TColor Transparent_ColorValue, bool AlphaBlend_Enabled, System::LongInt AlphaBlend_Value, bool ChromaKey, System::LongInt ChromaKeyRGBColor, System::LongInt ChromaKeyLeewayPercent);
	bool __fastcall Encoder_CloseOutputFile(System::LongInt EncoderUniqueID);
	bool __fastcall Encoder_Pause(System::LongInt EncoderUniqueID);
	bool __fastcall Encoder_NewOutputFile(System::LongInt EncoderUniqueID, System::UnicodeString OutputFile, bool OpenPaused);
	bool __fastcall Encoder_Resume(System::LongInt EncoderUniqueID);
	System::LongInt __fastcall Encoders_CreateInstanceForRecording(System::UnicodeString OutputFile);
	System::LongInt __fastcall Encoders_CreateInstanceForStreaming(System::UnicodeString OutputURL);
	void __fastcall Encoders_RemoveAllInstances();
	bool __fastcall Encoders_RemoveInstance(System::LongInt EncoderUniqueID);
	bool __fastcall EnumerateWindows();
	bool __fastcall EnableMultiplexedInput(System::LongInt InputNumber, bool Enable);
	bool __fastcall EnableThreadMode();
	void __fastcall FastForwardPlayer();
	System::UnicodeString __fastcall Facebook_GoLive_ReturnStreamURL(System::UnicodeString EndPointURL, System::UnicodeString Title, System::UnicodeString Description, System::UnicodeString Status, System::UnicodeString AccessToken, System::UnicodeString caBundlePath);
	System::LongInt __fastcall FindIndexInListByName(System::UnicodeString List, System::UnicodeString SearchedString, bool IsSubString, bool IgnoreCase);
	bool __fastcall GetFilterInterfaceByName(System::UnicodeString FilterName, System::_di_IInterface &FilterIntf);
	System::LongInt __fastcall GetLastAverageStreamValue(TStreamType StreamType);
	System::UnicodeString __fastcall GetAudioCodec();
	double __fastcall GetCameraExposure();
	System::UnicodeString __fastcall GetCameraExposureAsString();
	bool __fastcall GetDisplayActive(System::LongInt DisplayIndex);
	bool __fastcall GetDisplayAlphaBlendEnabled(System::LongInt DisplayIndex);
	System::LongInt __fastcall GetDisplayAlphaBlendValue(System::LongInt DisplayIndex);
	bool __fastcall GetDisplayAutoSize(System::LongInt DisplayIndex);
	TAspectRatio __fastcall GetDisplayAspectRatio(System::LongInt DisplayIndex);
	bool __fastcall GetDisplayEmbedded(System::LongInt DisplayIndex);
	bool __fastcall GetDisplayEmbedded_FitParent(System::LongInt DisplayIndex);
	bool __fastcall GetDisplayFullScreen(System::LongInt DisplayIndex);
	System::LongInt __fastcall GetDisplayHeight(System::LongInt DisplayIndex);
	System::LongInt __fastcall GetDisplayLeft(System::LongInt DisplayIndex);
	System::LongInt __fastcall GetDisplayMonitor(System::LongInt DisplayIndex);
	bool __fastcall GetDisplayMouseMovesWindow(System::LongInt DisplayIndex);
	System::LongInt __fastcall GetDisplayPanScanRatio(System::LongInt DisplayIndex);
	bool __fastcall GetDisplayStayOnTop(System::LongInt DisplayIndex);
	System::LongInt __fastcall GetDisplayTop(System::LongInt DisplayIndex);
	bool __fastcall GetDisplayTransparentColorEnabled(System::LongInt DisplayIndex);
	System::LongInt __fastcall GetDisplayTransparentColorValue(System::LongInt DisplayIndex);
	System::LongInt __fastcall GetDisplayVideoHeight(System::LongInt DisplayIndex);
	System::LongInt __fastcall GetDisplayVideoWidth(System::LongInt DisplayIndex);
	bool __fastcall GetDisplayVideoPortEnabled(System::LongInt DisplayIndex);
	void * __fastcall GetDisplayVideoWindowHandle(System::LongInt DisplayIndex);
	bool __fastcall GetDisplayVisible(System::LongInt DisplayIndex);
	System::LongInt __fastcall GetDisplayWidth(System::LongInt DisplayIndex);
	LargeInteger __fastcall GetFrameInfo(System::LongInt FrameId, TFrameInfoId FrameInfoId);
	System::UnicodeString __fastcall GetFrameInfoString(TFrameInfoStringId FrameInfoStringId);
	bool __fastcall GetFWCam1394(System::UnicodeString FWCam1394ID, System::LongInt &Value, System::LongInt &Flags, unsigned &Capabilities, System::LongInt &MinValue, System::LongInt &MaxValue, System::LongInt &Default);
	System::UnicodeString __fastcall GetFWCam1394List();
	bool __fastcall SetFWCam1394(System::UnicodeString FWCam1394ID, System::LongInt Value);
	System::UnicodeString __fastcall GetItemNameFromList(System::UnicodeString List, System::LongInt ItemIndex);
	System::LongInt __fastcall GetMiscDeviceControl(TMiscDeviceControl MiscDeviceControl, System::LongInt Index);
	System::UnicodeString __fastcall GetLogString(TLogType Value);
	System::LongInt __fastcall GetNearestVideoWidth(System::LongInt PreferredVideoWidth, System::LongInt PreferredVideoHeight);
	System::LongInt __fastcall GetNearestVideoHeight(System::LongInt PreferredVideoWidth, System::LongInt PreferredVideoHeight);
	System::UnicodeString __fastcall GetNDISessions(bool AsXML, bool ReportURLInfo);
	System::UnicodeString __fastcall GetONVIFURLFromServiceURL(System::UnicodeString ServiceURL);
	System::LongInt __fastcall GetPlayerOpenProgressPercent();
	System::UnicodeString __fastcall GetPlaylist();
	bool __fastcall GetTranslatedCoordinates(System::LongInt DisplayIndex, System::LongInt NativeX, System::LongInt NativeY, System::LongInt &TranslatedX, System::LongInt &TranslatedY);
	System::LongInt __fastcall GetTVChannelInfo(TTVChannelInfo Value);
	System::UnicodeString __fastcall GetVideoCodec();
	System::LongInt __fastcall GetVideoWidthFromIndex(System::LongInt SizeIndex);
	System::LongInt __fastcall GetVideoHeightFromIndex(System::LongInt SizeIndex);
	TVuMeter __fastcall GetVuMeter_Enabled(System::LongInt Index);
	void __fastcall GetNearestVideoSize(System::LongInt PreferredVideoWidth, System::LongInt PreferredVideoHeight, /* out */ System::LongInt &NearestVideoWidth, /* out */ System::LongInt &NearestVideoHeight);
	bool __fastcall GetVMR9ImageAdjustmentBounds(bool MainDisplay, TVMR9ImageAdjustment VMR9ControlSetting, /* out */ System::LongInt &MinValue, /* out */ System::LongInt &MaxValue, /* out */ System::LongInt &StepSize, /* out */ System::LongInt &DefaultValue, /* out */ System::LongInt &CurrentValue);
	bool __fastcall GetVideoSizeFromIndex(System::LongInt SizeIndex, /* out */ System::LongInt &_VideoWidth, /* out */ System::LongInt &_VideoHeight);
	bool __fastcall AVIDuration(System::UnicodeString AVIFile, /* out */ LargeInteger &Duration, /* out */ LargeInteger &FrameCount);
	bool __fastcall AVIInfo(System::UnicodeString AVIFile, /* out */ LargeInteger &Duration, /* out */ LargeInteger &FrameCount, /* out */ System::LongInt &_VideoWidth, /* out */ System::LongInt &_VideoHeight, /* out */ double &VideoFrameRateFps, /* out */ System::LongInt &AvgBitRate, /* out */ System::LongInt &AudioChannels, /* out */ System::LongInt &AudioSamplesPerSec, /* out */ System::LongInt &AudioBitsPerSample, /* out */ System::UnicodeString &VideoCodec, /* out */ System::UnicodeString &AudioCodec);
	bool __fastcall GetVideoCompressionSettings(/* out */ System::LongInt &DataRate, /* out */ System::LongInt &KeyFrameRate, /* out */ System::LongInt &PFramesPerKeyFrame, /* out */ System::LongInt &WindowSize, /* out */ double &Quality, /* out */ bool &CanQuality, /* out */ bool &CanCrunch, /* out */ bool &CanKeyFrame, /* out */ bool &CanBFrame, /* out */ bool &CanWindow);
	bool __fastcall GetVideoControlMode(TVideoControl Mode);
	System::LongInt __fastcall GetRGBPixelAt(System::LongInt x, System::LongInt y);
	double __fastcall GetPixelsDistance(System::LongInt x1, System::LongInt y1, System::LongInt x2, System::LongInt y2);
	System::LongWord __fastcall GetVUMeterSetting(System::LongWord ChannelIndex, TVUMeterSetting VUMeterSetting);
	TGraphState __fastcall GraphState();
	bool __fastcall IsAudioDeviceConnected(System::LongInt DeviceIndex);
	bool __fastcall IsAudioDeviceASoundCard(System::LongInt DeviceIndex);
	bool __fastcall IsAudioRendererConnected(System::LongInt RendererIndex);
	bool __fastcall IsCameraControlSettingAvailable(TCameraControl Setting);
	bool __fastcall IsDialogAvailable(TDialog Dialog);
	bool __fastcall IsDirectX8OrHigherInstalled();
	bool __fastcall IsServerResponding(System::UnicodeString URL, System::LongInt Timeout_Seconds);
	bool __fastcall IsPlaylistActive();
	bool __fastcall IsPreviewStarted();
	bool __fastcall IsURLResponding();
	TTriState __fastcall IsURLVideoStreamAvailable(System::LongInt TimeOut_Ms);
	bool __fastcall IsVideoQualitySettingAvailable(TVideoQuality Setting);
	bool __fastcall IsVideoControlModeAvailable(TVideoControl Mode);
	bool __fastcall IsVMR9ImageAdjustmentAvailable(bool MainDisplay);
	bool __fastcall IsVideoDeviceConnected(System::LongInt DeviceIndex);
	bool __fastcall IsVideoSignalDetected(bool DetectConnexantBlueScreen, bool DetectCustomRGB, System::LongInt CustomR, System::LongInt CustomG, System::LongInt CustomB, bool UseAsMaxValues);
	bool __fastcall IsDVDevice(System::LongInt Index);
	bool __fastcall LoadCompressorSettingsFromDataString(bool IsVideoCompressor, System::LongInt CompressorIndex, System::UnicodeString DataString);
	bool __fastcall LoadCompressorSettingsFromTextFile(bool IsVideoCompressor, System::LongInt CompressorIndex, System::UnicodeString FileName);
	bool __fastcall EnableMultipurposeEncoder(TMultipurposeEncoderInstance MultipurposeEncoderType, bool Enable);
	bool __fastcall SetMultipurposeEncoderSettings(TMultipurposeEncoderInstance MultipurposeEncoderType, System::UnicodeString Settings);
	System::UnicodeString __fastcall MultipurposeEncoder_Convert100nsToHhMmSsZzz(LargeInteger Time100ns);
	bool __fastcall MultipurposeEncoder_QuickConfigure_UDPStreaming_H264(bool LogTofile, bool VideoEnabled, bool AudioEnabled, System::UnicodeString DestinationIP, System::LongInt DestinationPort, System::LongInt VideoBitRateKb, System::LongInt AudioBitRateKb);
	System::UnicodeString __fastcall GetMultipurposeEncoderSettings(TMultipurposeEncoderInstance MultipurposeEncoderType);
	void __fastcall SetAudioRendererAdditional(System::LongInt Value);
	bool __fastcall MixAudioSamples(void * pSampleBuffer, System::LongInt SampleBufferSize, System::LongInt SampleDataLength, TFormatType SampleFormatType, void * pFormat, LargeInteger SampleStartTime, LargeInteger SampleStopTime);
	System::LongInt __fastcall MonitorsCount();
	double __fastcall MotionDetector_CellMotionRatio(System::LongInt x, System::LongInt y);
	System::LongInt __fastcall MotionDetector_CellColorIntensity(TRGBSelector RGBSelector, System::LongInt x, System::LongInt y);
	System::UnicodeString __fastcall MotionDetector_Get2DTextGrid();
	System::UnicodeString __fastcall MotionDetector_Get2DTextMotion();
	System::LongInt __fastcall MotionDetector_GlobalColorIntensity(TRGBSelector RGBSelector);
	bool __fastcall MotionDetector_GetCellLocation(System::LongInt x, System::LongInt y, System::LongInt &XLocation, System::LongInt &YLocation);
	bool __fastcall MotionDetector_GetCellSensitivity(System::LongInt x, System::LongInt y, System::LongInt &Value);
	bool __fastcall MotionDetector_GetCellSize(System::LongInt &XSize, System::LongInt &YSize);
	bool __fastcall MotionDetector_SetCellSensitivity(System::LongInt x, System::LongInt y, System::LongInt Value);
	void __fastcall MotionDetector_SetGridSize(System::LongInt x, System::LongInt y);
	void __fastcall MotionDetector_GloballyIncOrDecSensitivity(System::LongInt Value);
	void __fastcall MotionDetector_ResetGlobalSensitivity(System::LongInt Value);
	void __fastcall MotionDetector_Reset();
	void __fastcall MotionDetector_ShowGridDialog();
	void __fastcall MotionDetector_TriggerNow();
	System::Classes::TComponent* __fastcall MotionDetector_EnumGridDialogControls(bool FirstControl);
	bool __fastcall MotionDetector_UseThisReferenceSample(Vcl::Graphics::TBitmap* Bitmap, System::UnicodeString BMPFile, System::UnicodeString JPEGFile);
	TTriState __fastcall MP4NeedsReindexing(System::UnicodeString FilePath);
	System::LongInt __fastcall MultiplexerIndex(System::UnicodeString Value);
	bool __fastcall MultipurposeEncoder_ReindexClip(System::UnicodeString CurrentFileName, System::UnicodeString NewFileName);
	System::UnicodeString __fastcall MultipurposeEncoder_GetLastLog(TMultipurposeEncoderInstance MultipurposeEncoderType);
	bool __fastcall MultipurposeEncoder_GetCurrentInfo(TMultipurposeEncoderInstance MultipurposeEncoderType, /* out */ unsigned &InputsTotalDurationMs, /* out */ unsigned &FrameCount, /* out */ double &fps, /* out */ double &quality, /* out */ double &SizeWrittenKb, /* out */ unsigned &TimeMs, /* out */ double &BitRateKbps, /* out */ unsigned &DuplicatedCount, /* out */ unsigned &DroppedCount, /* out */ System::LongInt &ExitCode);
	void __fastcall NotifyPlayerTrackbarAction(TTrackbarAction TrackbarAction);
	bool __fastcall ONVIF_GetBool(System::UnicodeString ParamIdentifier, /* out */ bool &Value);
	bool __fastcall ONVIF_GetDouble(System::UnicodeString ParamIdentifier, /* out */ double &Value);
	bool __fastcall ONVIF_GetInt(System::UnicodeString ParamIdentifier, /* out */ int &Value);
	bool __fastcall ONVIF_GetStr(System::UnicodeString ParamIdentifier, System::UnicodeString &Value);
	bool __fastcall ONVIF_SetBool(System::UnicodeString ParamIdentifier, bool Value);
	bool __fastcall ONVIF_SetDouble(System::UnicodeString ParamIdentifier, double Value);
	bool __fastcall ONVIF_SetInt(System::UnicodeString ParamIdentifier, int Value);
	bool __fastcall ONVIF_SetStr(System::UnicodeString ParamIdentifier, System::UnicodeString Value);
	bool __fastcall ONVIFPTZGetLimits(/* out */ double &Pan_Min, /* out */ double &Pan_Max, /* out */ double &Tilt_Min, /* out */ double &Tilt_Max, /* out */ double &Zoom_Min, /* out */ double &Zoom_Max);
	bool __fastcall ONVIFPTZGetPosition(/* out */ double &Pan, /* out */ double &Tilt, /* out */ double &Zoom, /* out */ LargeInteger &UTCTime, /* out */ System::LongInt &IsMoving);
	bool __fastcall ONVIFPTZSetPosition(double Pan, double Tilt, double Zoom, double SpeedRatio, bool IsRelative);
	bool __fastcall ONVIFPTZStartMove(System::UnicodeString PTZType, bool OppositeDirection, double SpeedRatio, System::LongInt DurationMs);
	bool __fastcall ONVIFPTZStopMove(System::UnicodeString PTZType);
	bool __fastcall ONVIFPTZPreset(System::UnicodeString PresetAction, System::UnicodeString PresetName);
	bool __fastcall ONVIFPTZSendAuxiliaryCommand(System::UnicodeString AuxiliaryCommand);
	bool __fastcall ONVIFSnapShot(bool OnRawVideoSampleCallbackEnabled, bool SaveToFile, System::UnicodeString FileName);
	System::UnicodeString __fastcall ONVIFDeviceInfo(TONVIFDeviceInfo ONVIFDeviceInfoType);
	bool __fastcall OpenPlayer();
	bool __fastcall OpenDVD();
	bool __fastcall OpenPlayerAtFramePositions(LargeInteger StartFrame, LargeInteger StopFrame, bool KeepBounds, bool CloseAndReopenIfAlreadyOpened);
	bool __fastcall OpenPlayerAtTimePositions(LargeInteger StartTime, LargeInteger StopTime, bool KeepBounds, bool CloseAndReopenIfAlreadyOpened);
	TOpenURLAsyncStatus __fastcall OpenURLAsyncStatus();
	bool __fastcall PauseRecording();
	void __fastcall PausePlayer();
	bool __fastcall PlayerFrameStep(System::LongInt FrameCount);
	bool __fastcall Playlist(TPlaylist PlaylistAction, System::UnicodeString VideoClip);
	bool __fastcall PreloadFilters(System::UnicodeString FilterName_or_Empty_for_All_Filters);
	System::LongWord __fastcall RecordingKBytesWrittenToDisk();
	bool __fastcall ReencodeVideoClip(System::UnicodeString SourceVideoClip, System::UnicodeString NewVideoClip, bool IncludeVideoStream, bool IncludeAudioStream, bool UseFrameGrabber, bool UseCurrentVideoCompressor, bool UseCurrentAudioCompressor);
	void __fastcall RefreshDevicesAndCompressorsLists();
	void __fastcall RefreshPlayerOverlays();
	bool __fastcall ResetVideoDeviceSettings();
	bool __fastcall ResumeRecording();
	void __fastcall RewindPlayer();
	void __fastcall RunPlayer();
	void __fastcall RunPlayerBackwards();
	bool __fastcall ScheduleNextActionAtAbsoluteDateTime(System::LongInt Year, System::LongInt Month, System::LongInt Day, System::LongInt Hour, System::LongInt Min, System::LongInt Sec, System::LongInt MSec);
	bool __fastcall ScheduleNextActionAtAbsoluteTime(System::LongInt Hour, System::LongInt Min, System::LongInt Sec, System::LongInt MSec);
	bool __fastcall ScheduleNextActionFromNow(System::LongInt Day, System::LongInt Hour, System::LongInt Min, System::LongInt Sec, System::LongInt MSec);
	void __fastcall SetDisplayActive(System::LongInt DisplayIndex, bool Value);
	void __fastcall SetDisplayAlphaBlendEnabled(System::LongInt DisplayIndex, bool Value);
	void __fastcall SetDisplayAlphaBlendValue(System::LongInt DisplayIndex, System::LongInt Value);
	bool __fastcall SetDisplayAssociatedRenderer(System::LongInt DisplayIndex, System::UnicodeString Value);
	void __fastcall SetDisplayAutoSize(System::LongInt DisplayIndex, bool Value);
	void __fastcall SetDisplayAspectRatio(System::LongInt DisplayIndex, TAspectRatio Value);
	void __fastcall SetDisplayEmbedded(System::LongInt DisplayIndex, bool Value);
	void __fastcall SetDisplayEmbedded_FitParent(System::LongInt DisplayIndex, bool Value);
	void __fastcall SetDisplayFullScreen(System::LongInt DisplayIndex, bool Value);
	void __fastcall SetDisplayHeight(System::LongInt DisplayIndex, System::LongInt Value);
	void __fastcall SetDisplayLeft(System::LongInt DisplayIndex, System::LongInt Value);
	bool __fastcall SetDisplayLocation(System::LongInt DisplayIndex, System::LongInt WindowLeft, System::LongInt WindowTop, System::LongInt WindowWidth, System::LongInt WindowHeight);
	void __fastcall SetDisplayMonitor(System::LongInt DisplayIndex, System::LongInt Value);
	void __fastcall SetDisplayMouseMovesWindow(System::LongInt DisplayIndex, bool Value);
	void __fastcall SetDisplayPanScanRatio(System::LongInt DisplayIndex, System::LongInt Value);
	bool __fastcall SetDisplayParent(System::LongInt DisplayIndex, Vcl::Controls::TWinControl* DisplayParent);
	void __fastcall SetDisplayStayOnTop(System::LongInt DisplayIndex, bool Value);
	void __fastcall SetDisplayTop(System::LongInt DisplayIndex, System::LongInt Value);
	void __fastcall SetDisplayTransparentColorEnabled(System::LongInt DisplayIndex, bool Value);
	void __fastcall SetDisplayTransparentColorValue(System::LongInt DisplayIndex, System::LongInt Value);
	void __fastcall SetDisplayVideoPortEnabled(System::LongInt DisplayIndex, bool Value);
	void __fastcall SetDisplayVisible(System::LongInt DisplayIndex, bool Value);
	void __fastcall SetDisplayWidth(System::LongInt DisplayIndex, System::LongInt Value);
	void __fastcall SetVuMeter_Enabled(System::LongInt Index, TVuMeter Value);
	bool __fastcall StartSynchronized();
	System::LongInt __fastcall VideoCompressorIndex(System::UnicodeString Value);
	System::LongInt __fastcall VideoDeviceIndex(System::UnicodeString Value);
	System::LongInt __fastcall VideoDeviceIndexFromId(System::UnicodeString Value);
	System::LongInt __fastcall VideoFormatIndex(System::UnicodeString Value);
	System::LongInt __fastcall VideoInputIndex(System::UnicodeString Value);
	System::LongInt __fastcall VideoSizeIndex(System::UnicodeString Value);
	System::LongInt __fastcall VideoSubtypeIndex(System::UnicodeString Value);
	bool __fastcall SendDVCommand(TDVCommand DVCommand);
	bool __fastcall SendIPCameraCommand(System::UnicodeString IPCameraCommand);
	System::LongInt __fastcall StreamInterface_PushData(Winapi::Windows::PByte Buffer, System::LongInt BufferSize);
	void __fastcall SetAuthentication(TAuthenticationType AuthenticationType, System::UnicodeString UserName, System::UnicodeString Password);
	System::LongInt __fastcall Mixer_AddToMixer(System::LongInt SourceUniqueID, System::LongInt SourceVideoInput, System::LongInt MosaicLine, System::LongInt MosaicColumn, System::LongInt AlternatedGroup, System::LongInt AlternatedTimeIntervalInMs, bool ReplacePreviouslyAdded, bool CanEraseBackground);
	System::LongInt __fastcall Mixer_AddAudioToMixer(System::LongInt SourceUniqueID);
	bool __fastcall Mixer_AudioActivation(System::LongInt Id, bool Activate);
	bool __fastcall Mixer_RemoveAudioFromMixer(System::LongInt Id);
	System::LongInt __fastcall Mixer_SetupPIPFromSource(System::LongInt SourceUniqueID, System::LongInt Source_Left, System::LongInt Source_Top, System::LongInt Source_Width, System::LongInt Source_Height, bool ActivatePIP, System::LongInt PIP_Left, System::LongInt PIP_Top, System::LongInt PIP_Width, System::LongInt PIP_Height, bool MoveToTop);
	bool __fastcall Mixer_Activation(System::LongInt Id, bool Activate);
	bool __fastcall Mixer_RemoveFromMixer(System::LongInt Id);
	bool __fastcall Mixer_SetOverlayAttributes(System::LongInt Id, bool Transparent_Enabled, bool UseTransparentColor, System::LongInt Transparent_ColorValue, bool AlphaBlend_Enabled, System::LongInt AlphaBlend_Value, bool ChromaKey_Enabled, System::LongInt ChromaKeyRGBColor, System::LongInt ChromaKeyLeewayPercent, double RotationAngle);
	bool __fastcall Mixer_SetOverlayRoundedCorner(System::LongInt Id, System::LongInt CornerRadiusWidth, System::LongInt CornerRadiusHeight);
	System::LongInt __fastcall MPEGProgramSetting(TMPEGProgramSetting MPEGProgramSettingValue, System::LongInt Value);
	System::UnicodeString __fastcall SaveCompressorSettingsToDataString(bool IsVideoCompressor, System::LongInt CompressorIndex);
	bool __fastcall SaveCompressorSettingsToTextFile(bool IsVideoCompressor, System::LongInt CompressorIndex, System::UnicodeString FileName);
	bool __fastcall ONVIFDiscoverCameras_Multicast(System::LongInt timeout_seconds_or_0_for_default);
	bool __fastcall ONVIFDiscoverCameras_IPRange(System::UnicodeString First_IP, System::UnicodeString Last_IP, System::LongInt timeout_seconds_or_0_for_default);
	bool __fastcall ONVIFCancelDiscovery();
	bool __fastcall ONVIFEnumCamerasDiscovered(System::LongInt CameraIndex, System::UnicodeString &CameraType, System::UnicodeString &CameraONVIFUrl);
	void __fastcall SetAVIMuxConfig(TAVIMuxConfig AVIMuxSetting, System::LongInt Value);
	bool __fastcall SetCameraControl(TCameraControl Setting, bool SetAuto, bool SetDefault, System::LongInt SetValue);
	void __fastcall SetCameraExposure(double Value);
	void __fastcall SetFrameCaptureBounds(System::LongInt LeftPosition, System::LongInt TopPosition, System::LongInt RightPosition, System::LongInt BottomPosition);
	void __fastcall SetMultiplexerFilterByName(System::UnicodeString Value);
	bool __fastcall SetVideoCompressionDefaults();
	bool __fastcall SetVideoCompressionSettings(System::LongInt DataRate, System::LongInt KeyFrameRate, System::LongInt PFramesPerKeyFrame, System::LongInt WindowSize, double Quality);
	bool __fastcall SetVideoControlMode(bool FlipHorizontal, bool FlipVertical, bool ExternalTriggerEnable, bool Trigger);
	bool __fastcall SetVideoControlMode2(TVideoControl Mode, bool Value);
	bool __fastcall SetVideoQuality(TVideoQuality Setting, bool SetAuto, bool SetDefault, System::LongInt SetValue);
	bool __fastcall SetVMR9ImageAdjustmentValue(bool MainDisplay, TVMR9ImageAdjustment VMR9ControlSetting, System::LongInt Value, bool FixRange);
	bool __fastcall ShapeOverlayList(Vcl::Extctrls::TShape* Shape, bool Add);
	bool __fastcall ShowDialog(TDialog Dialog);
	void __fastcall ShowDebugWindow(bool FullLog);
	bool __fastcall PausePreview();
	System::LongInt __fastcall PointGreyConfig(TPointGreyConfig ConfigType, System::LongWord &PGRActionValue, System::LongWord ulRegister, System::LongWord ulMode, System::LongWord ulLeft, System::LongWord ulTop, System::LongWord ulWidth, System::LongWord ulHeight, System::LongWord ulPercentage, System::LongWord ulFormat);
	bool __fastcall ResetPreview();
	bool __fastcall ResumePreview();
	bool __fastcall RecordToNewFileNow(System::UnicodeString NewRecordingFileName, bool ResetStreamTime);
	void __fastcall RetrieveInitialXYAfterRotation(System::LongInt X, System::LongInt Y, System::LongInt &OriginalX, System::LongInt &OriginalY);
	bool __fastcall SetEncryptionKey(TEncryptionMethod EncryptionMethod, System::UnicodeString KeyValue);
	bool __fastcall SetDecryptionKey(TEncryptionMethod EncryptionMethod, System::UnicodeString KeyValue);
	bool __fastcall Encrypt_File(System::UnicodeString InputFile, System::UnicodeString OutputFile, bool OverwriteIfExists);
	bool __fastcall Decrypt_File(System::UnicodeString InputFile, System::UnicodeString OutputFile, bool OverwriteIfExists);
	bool __fastcall SendImageToVideoFromBitmaps(System::UnicodeString ImageFilePath, void * BitmapHandle, bool CanFreeBitmapHandle, bool EndOfData);
	bool __fastcall SendImageToVideoFromBitmaps2(Winapi::Windows::PBitmapInfo pBtmapInfo, Winapi::Windows::PByte pBitmapBits, bool EndOfData);
	bool __fastcall SetFFmpegFilter(System::LongInt FilterIndex, System::UnicodeString VideoFilterName, System::UnicodeString Parameters);
	bool __fastcall SetFFmpegAudioFilter(System::LongInt FilterIndex, System::UnicodeString AudioFilterName, System::UnicodeString Parameters);
	void __fastcall SetHeaderAttribute(THeaderAttribute HeaderAttribute, System::UnicodeString Value);
	void __fastcall SetImageOverlay_Attributes(System::LongInt LeftLocation, System::LongInt TopLocation, System::LongInt StretchedWidth, System::LongInt StretchedHeight, bool Transparent_Enabled, bool UseTransparentColor, System::LongInt Transparent_ColorValue, bool AlphaBlend_Enabled, System::LongInt AlphaBlend_Value);
	void __fastcall SetImageOverlay_Attributes2(System::LongInt Index, System::LongInt LeftLocation, System::LongInt TopLocation, System::LongInt StretchedWidth, System::LongInt StretchedHeight, bool Transparent_Enabled, bool UseTransparentColor, System::LongInt Transparent_ColorValue, bool AlphaBlend_Enabled, System::LongInt AlphaBlend_Value);
	bool __fastcall SetImageOverlayFromImageFile(System::UnicodeString FileName);
	bool __fastcall SetImageOverlayFromImageFile2(System::LongInt Index, System::UnicodeString FileName);
	bool __fastcall SetImageOverlayFromBMPFile(System::UnicodeString FileName);
	bool __fastcall SetImageOverlayFromBMPFile2(System::LongInt Index, System::UnicodeString FileName);
	bool __fastcall SetImageOverlayFromJPEGFile(System::UnicodeString FileName);
	bool __fastcall SetImageOverlayFromJPEGFile2(System::LongInt Index, System::UnicodeString FileName);
	bool __fastcall SetImageOverlayFromHBitmap(HBITMAP Bitmap);
	bool __fastcall SetImageOverlayFromHBitmap2(System::LongInt Index, HBITMAP Bitmap);
	bool __fastcall SetImageOverlayFromHBitmap3(System::LongInt Index, HBITMAP Bitmap, bool ReleaseBitmap);
	bool __fastcall SetImageOverlayFromTBitmap(Vcl::Graphics::TBitmap* Bitmap);
	bool __fastcall SetImageOverlayFromTBitmap2(System::LongInt Index, Vcl::Graphics::TBitmap* Bitmap);
	bool __fastcall SetImageOverlayFromTImage(Vcl::Extctrls::TImage* Image);
	bool __fastcall SetImageOverlayFromTImage2(System::LongInt Index, Vcl::Extctrls::TImage* Image);
	bool __fastcall SetIPCameraSetting(TIPCameraSetting Setting, System::LongInt Value);
	bool __fastcall SetLogoFromBMPFile(System::UnicodeString FileName);
	bool __fastcall SetLogoFromJPEGFile(System::UnicodeString FileName);
	bool __fastcall SetLogoFromHBitmap(HBITMAP Bitmap);
	bool __fastcall SetLogoFromTBitmap(Vcl::Graphics::TBitmap* Bitmap);
	bool __fastcall SetLogoFromTImage(Vcl::Extctrls::TImage* Image);
	bool __fastcall Encoder_GetInt(System::LongInt EncoderID, TEncoder_int Setting, System::LongInt &Value);
	bool __fastcall Encoder_SetInt(System::LongInt EncoderID, TEncoder_int Setting, System::LongInt Value);
	bool __fastcall Encoder_SetStr(System::LongInt EncoderID, TEncoder_str Setting, System::UnicodeString Value);
	bool __fastcall ScreenRecordingUsingCoordinates(bool FunctionEnabled, System::LongInt scLeft, System::LongInt scTop, System::LongInt scWidth, System::LongInt scHeight);
	bool __fastcall SendCameraCommand(System::LongInt Pan, System::LongInt Tilt, bool Relative);
	bool __fastcall PutMiscDeviceControl(TMiscDeviceControl MiscDeviceControl, System::LongInt Index, System::LongInt Value);
	bool __fastcall SetWindowRecordingByHandle(void * Window_Handle);
	bool __fastcall SetWindowTransparency(void * WndHandle, bool UseColorKey, bool UseAlpha, System::LongInt AlphaValue);
	bool __fastcall SetWindowRecordingByName(System::UnicodeString WindowName, bool ExactMatch);
	void __fastcall SetVUMeterSetting(LongWord_ ChannelIndex, TVUMeterSetting VUMeterSetting, System::NativeInt Value);
	bool __fastcall StartAudioRecording();
	bool __fastcall StartAudioRendering();
	bool __fastcall StartPreview();
	bool __fastcall StartPTZ();
	bool __fastcall StartRecording();
	bool __fastcall StartReencoding();
	bool __fastcall Stop();
	void __fastcall StopPreview();
	void __fastcall StopPlayer();
	void __fastcall StopRecording();
	bool __fastcall StopReencoding();
	bool __fastcall TextOverlay_CreateCustomFont(System::LongInt Index, System::LongInt fHeight, System::LongInt fWidth, System::LongInt fEscapement, System::LongInt fOrientation, System::LongInt fWeight, bool fItalic, bool fUnderline, bool fStrikeOut, LongWord_ fCharSet, LongWord_ fOutputPrecision, LongWord_ fClipPrecision, LongWord_ fQuality, LongWord_ fPitchAndFamily, System::UnicodeString FontFacename);
	bool __fastcall ThirdPartyFilter_AddToList(TThirdPartyFilterList Location, System::UnicodeString GUIDString, System::UnicodeString OptionalDLLFilePath, System::UnicodeString FilterName, bool Enable, bool CanSaveFilterState);
	bool __fastcall ThirdPartyFilter_ClearList();
	bool __fastcall ThirdPartyFilter_Enable(TThirdPartyFilterList Location, System::UnicodeString GUIDString, bool Enable);
	bool __fastcall ThirdPartyFilter_RemoveFromList(TThirdPartyFilterList Location, System::UnicodeString GUIDString);
	bool __fastcall ThirdPartyFilter_ShowDialog(TThirdPartyFilterList Location, System::UnicodeString GUIDString);
	bool __fastcall TVGetMinMaxChannels(System::LongInt &MinChannel, System::LongInt &MaxChannel);
	bool __fastcall TVClearFrequencyOverrides();
	System::LongInt __fastcall TVSetChannelFrequencyOverride(System::LongInt TVChannel, System::LongInt FrequencyInHz);
	bool __fastcall TVStartAutoScan();
	bool __fastcall TVStartAutoScanChannels(System::LongInt MinChannel, System::LongInt MaxChannel, System::LongInt Interval_ms);
	bool __fastcall TVStopAutoScan();
	void __fastcall UpdateTrackbarBounds();
	void __fastcall UseNearestVideoSize(System::LongInt PreferredWidth, System::LongInt PreferredHeight, bool Stretch);
	void __fastcall v360_ResetAnglesToDefault();
	bool __fastcall v360_SetProjection(Tv360_InOut Direction, Tv360_Projection Value);
	bool __fastcall v360_SetTranspose(Tv360_InOut Direction, bool Value);
	bool __fastcall v360_SetStereoFormat(Tv360_InOut Direction, Tv360_StereoFormat Value);
	bool __fastcall v360_SetInterpolation(Tv360_Interpolation Value);
	bool __fastcall v360_SetAngle(Tv360_InOut Direction, Tv360_Angle Angle, double Value);
	double __fastcall v360_GetAngle(Tv360_InOut Direction, Tv360_Angle Angle);
	bool __fastcall v360_SetYawPitchRoll(double Yaw, double Pitch, double Roll);
	void __fastcall v360_GetYawPitchRoll(double &Yaw, double &Pitch, double &Roll);
	bool __fastcall v360_AddYawPitchRoll(double Yaw, double Pitch, double Roll);
	bool __fastcall VDECGetHorizontalLocked(/* out */ System::LongInt &plLocked);
	bool __fastcall VDECGetNumberOfLines(/* out */ System::LongInt &plNumberOfLines);
	bool __fastcall VDECGetOutputEnable(/* out */ System::LongInt &plOutputEnable);
	bool __fastcall VDECGetVCRHorizontalLocking(/* out */ System::LongInt &plVCRHorizontalLocking);
	bool __fastcall VDECPutTVFormat(System::LongInt lAnalogVideoStandard);
	bool __fastcall VDECPutOutputEnable(System::LongInt lOutputEnable);
	bool __fastcall VDECPutVCRHorizontalLocking(System::LongInt lVCRHorizontalLocking);
	bool __fastcall VideoFromImages_CreateSetOfBitmaps();
	System::LongInt __fastcall VideoQualityValue(TVideoQuality Setting);
	bool __fastcall VideoQualityAuto(TVideoQuality Setting);
	System::LongInt __fastcall VideoQualityDefault(TVideoQuality Setting);
	System::LongInt __fastcall VideoQualityMin(TVideoQuality Setting);
	System::LongInt __fastcall VideoQualityMax(TVideoQuality Setting);
	System::LongInt __fastcall VideoQualityStep(TVideoQuality Setting);
	bool __fastcall WriteScriptCommand(System::UnicodeString ScriptType, System::UnicodeString ScriptArgument);
	bool __fastcall MonitorBounds(System::LongInt MonitorNumber, Winapi::Windows::TRect &Bounds);
	System::LongInt __fastcall Monitor_Primary_Index();
	
protected:
	virtual void __fastcall SetName(const System::Classes::TComponentName Value);
	virtual void __fastcall SetParent(Vcl::Controls::TWinControl* AParent);
	virtual void __fastcall CreateHandle();
	virtual void __fastcall DestroyWindowHandle();
	virtual void __fastcall Loaded();
	HIDESBASE MESSAGE void __fastcall WMERASEBKGND(Winapi::Messages::TWMEraseBkgnd &Message);
	MESSAGE void __fastcall WMDropFiles(Winapi::Messages::TWMDropFiles &Msg);
	virtual void __fastcall Notification(System::Classes::TComponent* AComponent, System::Classes::TOperation Operation);
	virtual void __fastcall PaintWindow(HDC DC);
	virtual void __fastcall CreateWnd();
	virtual void __fastcall DestroyWnd();
	
public:
	__fastcall virtual TVideoGrabber(System::Classes::TComponent* Aowner);
	__fastcall virtual ~TVideoGrabber();
	__property System::UnicodeString AnalogVideoStandards = {read=GetAnalogVideoStandards};
	__property System::LongInt AnalogVideoStandardsCount = {read=GetAnalogVideoStandardsCount, nodefault};
	__property System::UnicodeString ASFProfiles = {read=GetASFProfiles};
	__property System::LongInt ASFProfilesCount = {read=GetASFProfilesCount, nodefault};
	__property System::LongInt AudioBalance = {read=GetAudioBalance, write=SetAudioBalance, nodefault};
	__property System::UnicodeString AudioCompressorName = {read=GetAudioCompressorName};
	__property System::UnicodeString AudioCompressors = {read=GetAudioCompressors};
	__property System::LongInt AudioCompressorsCount = {read=GetAudioCompressorsCount, nodefault};
	__property System::LongInt AudioInputBalance = {read=GetAudioInputBalance, write=SetAudioInputBalance, nodefault};
	__property System::LongInt AudioInputLevel = {read=GetAudioInputLevel, write=SetAudioInputLevel, nodefault};
	__property bool AudioInputMono = {read=GetAudioInputMono, write=SetAudioInputMono, nodefault};
	__property System::UnicodeString AudioInputs = {read=GetAudioInputs};
	__property System::LongInt AudioInputsCount = {read=GetAudioInputsCount, nodefault};
	__property System::UnicodeString AudioDeviceName = {read=GetAudioDeviceName};
	__property System::UnicodeString AudioDevices = {read=GetAudioDevices};
	__property System::LongInt AudioDevicesCount = {read=GetAudioDevicesCount, nodefault};
	__property System::UnicodeString AudioFormats = {read=GetAudioFormats};
	__property System::UnicodeString AudioRendererName = {read=GetAudioRendererName};
	__property System::UnicodeString AudioRenderers = {read=GetAudioRenderers};
	__property System::LongInt AudioRenderersCount = {read=GetAudioRenderersCount, nodefault};
	__property System::LongInt AudioVolume = {read=GetAudioVolume, write=SetAudioVolume, nodefault};
	__property bool AudioVolumeEnabled = {read=GetAudioVolumeEnabled, write=SetAudioVolumeEnabled, nodefault};
	__property System::LongInt BufferCount = {read=GetBufferCount, write=SetBufferCount, nodefault};
	__property bool Busy = {read=GetBusy, nodefault};
	__property double RecordingDuration = {read=GetRecordingDuration};
	__property System::UnicodeString RecordingFourCC = {read=GetRecordingFourCC};
	__property System::LongInt Cropping_YMax = {read=GetCropping_YMax, nodefault};
	__property System::LongInt Cropping_XMax = {read=GetCropping_XMax, nodefault};
	__property double CurrentFrameRate = {read=GetCurrentFrameRate};
	__property TCurrentState CurrentState = {read=GetCurrentState, nodefault};
	__property LargeInteger DeliveredFrames = {read=GetDeliveredFrames};
	__property System::UnicodeString DirectShowFilters = {read=GetDirectShowFilters};
	__property System::LongInt DirectShowFiltersCount = {read=GetDirectShowFiltersCount, nodefault};
	__property System::LongInt Display_VideoHeight = {read=GetDisplayVideoHeight, index=0, nodefault};
	__property System::LongInt Display_VideoWidth = {read=GetDisplayVideoWidth, index=0, nodefault};
	__property void * Display_VideoWindowHandle = {read=GetDisplayVideoWindowHandle, index=0};
	__property void * DualDisplay_VideoWindowHandle = {read=GetDisplayVideoWindowHandle, index=1};
	__property System::LongInt DroppedFrames = {read=GetDroppedFrameCount, nodefault};
	__property System::LongInt DualDisplay_VideoHeight = {read=GetDisplayVideoHeight, index=1, nodefault};
	__property System::LongInt DualDisplay_VideoWidth = {read=GetDisplayVideoWidth, index=1, nodefault};
	__property TFrameGrabberRGBFormat FrameGrabberCurrentRGBFormat = {read=GetFrameGrabberCurrentRGBFormat, nodefault};
	__property bool HoldRecording = {read=GetHoldRecording, write=SetHoldRecording, nodefault};
	__property System::LongInt ImageOverlaySelector = {read=GetImageOverlaySelector, write=SetImageOverlaySelector, nodefault};
	__property double ImageRatio = {read=GetImageRatio};
	__property bool InFrameProgressEvent = {read=GetInFrameProgressEvent, nodefault};
	__property bool IsAnalogVideoDecoderAvailable = {read=GetIsAnalogVideoDecoderAvailable, nodefault};
	__property bool IsAudioCrossbarAvailable = {read=GetIsAudioCrossbarAvailable, nodefault};
	__property TTriState IsAudioInputBalanceAvailable = {read=GetIsAudioInputBalanceAvailable, nodefault};
	__property bool IsCameraControlAvailable = {read=GetIsCameraControlAvailable, nodefault};
	__property bool IsDigitalVideoIn = {read=GetIsDigitalVideoIn, nodefault};
	__property bool IsDVCommandAvailable = {read=GetIsDVCommandAvailable, nodefault};
	__property bool IsHorizontalSyncLocked = {read=GetIsHorizontalSyncLocked, nodefault};
	__property bool IsMpegStream = {read=GetIsMpegStream, nodefault};
	__property TTriState IsPlayerAudioStreamAvailable = {read=GetIsPlayerAudioStreamAvailable, nodefault};
	__property TTriState IsPlayerVideoStreamAvailable = {read=GetIsPlayerVideoStreamAvailable, nodefault};
	__property bool IsRecordingPaused = {read=GetIsRecordingPaused, nodefault};
	__property bool IsTimeCodeReaderAvailable = {read=GetTimeCodeReaderAvailable, nodefault};
	__property bool IsTVTunerAvailable = {read=GetIsTVTunerAvailable, nodefault};
	__property bool IsTVAutoTuneRunning = {read=GetIsTVAutoTuneRunning, nodefault};
	__property bool IsTVAudioAvailable = {read=GetIsTVAudioAvailable, nodefault};
	__property bool IsVideoControlAvailable = {read=GetIsVideoControlAvailable, nodefault};
	__property bool IsVideoCrossbarAvailable = {read=GetIsVideoCrossbarAvailable, nodefault};
	__property bool IsVideoInterlaced = {read=GetIsVideoInterlaced, nodefault};
	__property bool IsVideoQualityAvailable = {read=GetIsVideoQualityAvailable, nodefault};
	__property bool IsVideoPortAvailable = {read=GetIsVideoPortAvailable, nodefault};
	__property bool IsWDMVideoDriver = {read=GetIsWDMVideoDriver, nodefault};
	__property System::UnicodeString Last_BurstFrameCapture_FileName = {read=GetLast_BurstFrameCapture_FileName};
	__property System::UnicodeString Last_CaptureFrameTo_FileName = {read=GetLast_CaptureFrameTo_FileName};
	__property System::UnicodeString Last_Recording_FileName = {read=GetLast_Recording_FileName};
	__property System::UnicodeString Last_Clip_Played = {read=GetLast_Clip_Played};
	__property double MotionDetector_GlobalMotionRatio = {read=GetMotionDetector_GlobalMotionRatio};
	__property System::LongInt MotionDetector_GridXCount = {read=GetMotionDetector_GridXCount, nodefault};
	__property System::LongInt MotionDetector_GridYCount = {read=GetMotionDetector_GridYCount, nodefault};
	__property bool MotionDetector_IsGridValid = {read=GetMotionDetector_IsGridValid, nodefault};
	__property TMpegStreamType MpegStreamType = {read=GetMpegStreamType, write=SetMpegStreamType, nodefault};
	__property System::UnicodeString MultiplexerName = {read=GetMultiplexerName};
	__property System::UnicodeString Multiplexers = {read=GetMultiplexers};
	__property System::LongInt MultiplexersCount = {read=GetMultiplexersCount, nodefault};
	__property System::LongInt PlaylistIndex = {read=GetPlaylistIndex, write=SetPlaylistIndex, nodefault};
	__property System::UnicodeString PlayerAudioCodec = {read=GetAudioCodec};
	__property LargeInteger PlayerDuration = {read=GetPlayerDuration, write=SetPlayerDuration};
	__property LargeInteger PlayerFrameCount = {read=GetPlayerFrameCount};
	__property LargeInteger PlayerFramePosition = {read=GetPlayerFramePosition, write=SetPlayerFramePosition};
	__property System::LongInt PlayerOpenProgressPercent = {read=GetPlayerOpenProgressPercent, nodefault};
	__property TPlayerState PlayerState = {read=GetPlayerState, nodefault};
	__property LargeInteger PlayerTimePosition = {read=GetPlayerTimePosition, write=SetPlayerTimePosition};
	__property double PlayerTrackBarScale = {read=GetPlayerTrackBarScale};
	__property double PlayerFrameRate = {read=GetPlayerFrameRate};
	__property System::UnicodeString PlayerVideoCodec = {read=GetVideoCodec};
	__property System::UnicodeString PropertyPageSaverGroup = {read=GetPropertyPageSaverGroup, write=SetPropertyPageSaverGroup};
	__property System::LongInt RecordingBacktimedFramesCount = {read=GetRecordingBacktimedFramesCount, write=SetRecordingBacktimedFramesCount, nodefault};
	__property bool RecordingCanPause = {read=GetRecordingCanPause, write=SetRecordingCanPause, nodefault};
	__property System::LongInt RecordingHeight = {read=GetRecordingHeight, nodefault};
	__property System::LongInt RecordingWidth = {read=GetRecordingWidth, nodefault};
	__property System::LongInt SendToDV_DeviceIndex = {read=GetSendToDV_DeviceIndex, write=SetSendToDV_DeviceIndex, nodefault};
	__property System::Classes::TStream* SourceStream = {read=GetSourceStream, write=SetSourceStream};
	__property System::LongInt SpeakerBalance = {read=GetSpeakerBalance, write=SetSpeakerBalance, nodefault};
	__property System::LongInt SpeakerVolume = {read=GetSpeakerVolume, write=SetSpeakerVolume, nodefault};
	__property System::UnicodeString StreamingURL = {read=GetStreamingURL};
	__property System::UnicodeString SystemTempPath = {read=GetSystemTempPath};
	__property System::LongInt TextOverlay_Selector = {read=GetTextOverlaySelector, write=SetTextOverlaySelector, nodefault};
	__property System::LongInt TVChannel = {read=GetTVChannel, write=SetTVChannel, nodefault};
	__property System::LongInt TVCountryCode = {read=GetTVCountryCode, write=SetTVCountryCode, nodefault};
	__property TTunerInput TVTunerInputType = {read=GetTVTunerInputType, write=SetTVTunerInputType, nodefault};
	__property TTunerMode TunerMode = {read=GetTunerMode, write=SetTunerMode, default=0};
	__property System::LongInt UniqueID = {read=GetUniqueID, nodefault};
	__property bool VCRHorizontalLocking = {read=GetVCRHorizontalLocking, write=SetVCRHorizontalLocking, nodefault};
	__property System::UnicodeString VideoCompressorName = {read=GetVideoCompressorName};
	__property System::UnicodeString VideoCompressors = {read=GetVideoCompressors};
	__property System::LongInt VideoCompressorsCount = {read=GetVideoCompressorsCount, nodefault};
	__property System::UnicodeString VideoFormats = {read=GetVideoFormats};
	__property System::LongInt VideoFormatsCount = {read=GetVideoFormatsCount, nodefault};
	__property System::UnicodeString VideoInputs = {read=GetVideoInputs};
	__property System::LongInt VideoInputsCount = {read=GetVideoInputsCount, nodefault};
	__property System::UnicodeString VideoDeviceName = {read=GetVideoDeviceName};
	__property System::UnicodeString VideoDevices = {read=GetVideoDevices};
	__property System::UnicodeString VideoDevicesId = {read=GetVideoDevicesId};
	__property System::LongInt VideoDevicesCount = {read=GetVideoDevicesCount, nodefault};
	__property System::LongInt VideoHeight = {read=GetVideoHeight, nodefault};
	__property System::LongInt VideoHeight_PreferredAspectRatio = {read=GetVideoHeight_PreferredAspectRatio, nodefault};
	__property System::LongInt VideoWidth = {read=GetVideoWidth, nodefault};
	__property System::LongInt VideoWidth_PreferredAspectRatio = {read=GetVideoWidth_PreferredAspectRatio, nodefault};
	__property System::UnicodeString VideoSizes = {read=GetVideoSizes};
	__property System::LongInt VideoSizesCount = {read=GetVideoSizesCount, nodefault};
	__property System::UnicodeString VideoSources = {read=GetVideoSources};
	__property System::LongInt VideoSourcesCount = {read=GetVideoSourcesCount, nodefault};
	__property System::UnicodeString VideoSubtypes = {read=GetVideoSubtypes};
	__property System::LongInt VideoSubtypesCount = {read=GetVideoSubtypesCount, nodefault};
	
__published:
	__property Align = {default=0};
	__property Alignment = {default=2};
	__property Caption = {default=0};
	__property Color = {default=-16777201};
	__property Enabled = {default=1};
	__property FullRepaint = {default=1};
	__property Height;
	__property Left;
	__property ParentColor = {default=0};
	__property ParentShowHint = {default=1};
	__property Tag = {default=0};
	__property Top;
	__property Visible = {default=1};
	__property Width;
	__property OnResize;
	__property OnDragDrop;
	__property OnDragOver;
	__property OnEndDrag;
	__property OnStartDrag;
	__property Anchors = {default=3};
	__property ParentBiDiMode = {default=1};
	__property OnCanResize;
	__property OnConstrainedResize;
	__property OnContextPopup;
	__property bool AdjustOverlayAspectRatio = {read=GetAdjustOverlayAspectRatio, write=SetAdjustOverlayAspectRatio, default=1};
	__property bool AdjustPixelAspectRatio = {read=GetAdjustPixelAspectRatio, write=SetAdjustPixelAspectRatio, default=1};
	__property TAero Aero = {read=GetAero, write=SetAero, default=0};
	__property System::LongInt AnalogVideoStandard = {read=GetAnalogVideoStandard, write=SetAnalogVideoStandard, default=-1};
	__property TApplicationPriority ApplicationPriority = {read=GetApplicationPriority, write=SetApplicationPriority, default=0};
	__property System::LongInt ASFAudioBitRate = {read=GetASFAudioBitRate, write=SetASFAudioBitRate, default=-1};
	__property System::LongInt ASFAudioChannels = {read=GetASFAudioChannels, write=SetASFAudioChannels, default=-1};
	__property System::LongInt ASFBufferWindow = {read=GetASFBufferWindow, write=SetASFBufferWindow, default=-1};
	__property TASFDeinterlaceMode ASFDeinterlaceMode = {read=GetASFDeinterlaceMode, write=SetASFDeinterlaceMode, default=0};
	__property bool ASFDirectStreamingKeepClientsConnected = {read=GetASFDirectStreamingKeepClientsConnected, write=SetASFDirectStreamingKeepClientsConnected, default=0};
	__property bool ASFFixedFrameRate = {read=GetASFFixedFrameRate, write=SetASFFixedFrameRate, default=1};
	__property System::UnicodeString ASFMediaServerPublishingPoint = {read=GetASFMediaServerPublishingPoint, write=SetASFMediaServerPublishingPoint};
	__property System::UnicodeString ASFMediaServerTemplatePublishingPoint = {read=GetASFMediaServerTemplatePublishingPoint, write=SetASFMediaServerTemplatePublishingPoint};
	__property bool ASFMediaServerRemovePublishingPointAfterDisconnect = {read=GetASFMediaServerRemovePublishingPointAfterDisconnect, write=SetASFMediaServerRemovePublishingPointAfterDisconnect, default=0};
	__property System::LongInt ASFNetworkPort = {read=GetASFNetworkPort, write=SetASFNetworkPort, default=0};
	__property System::LongInt ASFNetworkMaxUsers = {read=GetASFNetworkMaxUsers, write=SetASFNetworkMaxUsers, default=5};
	__property System::LongInt ASFProfile = {read=GetASFProfile, write=SetASFProfile, default=-1};
	__property System::UnicodeString ASFProfileFromCustomFile = {read=GetASFProfileFromCustomFile, write=SetASFProfileFromCustomFile};
	__property TASFProfileVersion ASFProfileVersion = {read=GetASFProfileVersion, write=SetASFProfileVersion, default=0};
	__property System::LongInt ASFVideoBitRate = {read=GetASFVideoBitRate, write=SetASFVideoBitRate, default=-1};
	__property double ASFVideoFrameRate = {read=GetASFVideoFrameRate, write=SetASFVideoFrameRate};
	__property System::LongInt ASFVideoHeight = {read=GetASFVideoHeight, write=SetASFVideoHeight, default=-1};
	__property System::LongInt ASFVideoMaxKeyFrameSpacing = {read=GetASFVideoMaxKeyFrameSpacing, write=SetASFVideoMaxKeyFrameSpacing, default=-1};
	__property System::LongInt ASFVideoQuality = {read=GetASFVideoQuality, write=SetASFVideoQuality, default=-1};
	__property System::LongInt ASFVideoWidth = {read=GetASFVideoWidth, write=SetASFVideoWidth, default=-1};
	__property double AspectRatioToUse = {read=GetAspectRatioToUse, write=SetAspectRatioToUse};
	__property bool AssociateAudioAndVideoDevices = {read=GetAssociateAudioAndVideoDevices, write=SetAssociateAudioAndVideoDevices, default=0};
	__property bool AVIDurationUpdated = {read=GetAVIDurationUpdated, write=SetAVIDurationUpdated, default=1};
	__property TAudioChannelRenderMode AudioChannelRenderMode = {read=GetAudioChannelRenderMode, write=SetAudioChannelRenderMode, default=0};
	__property System::LongInt AudioCompressor = {read=GetAudioCompressor, write=SetAudioCompressor, nodefault};
	__property System::LongInt AudioDevice = {read=GetAudioDevice, write=SetAudioDevice, default=-1};
	__property bool AudioDeviceRendering = {read=GetAudioDeviceRendering, write=SetAudioDeviceRendering, default=0};
	__property TAudioFormat AudioFormat = {read=GetAudioFormat, write=SetAudioFormat, default=0};
	__property System::LongInt AudioInput = {read=GetAudioInput, write=SetAudioInput, default=-1};
	__property bool AudioPeakEvent = {read=GetAudioPeakEvent, write=SetAudioPeakEvent, default=1};
	__property bool AudioRecording = {read=GetAudioRecording, write=SetAudioRecording, default=0};
	__property System::LongInt AudioRenderer = {read=GetAudioRenderer, write=SetAudioRenderer, default=-1};
	__property System::LongInt AudioStreamNumber = {read=GetAudioStreamNumber, write=SetAudioStreamNumber, default=-1};
	__property bool AudioSyncAdjustmentEnabled = {read=GetAudioSyncAdjustmentEnabled, write=SetAudioSyncAdjustmentEnabled, default=0};
	__property System::LongInt AudioSyncAdjustment = {read=GetAudioSyncAdjustment, write=SetAudioSyncAdjustment, default=0};
	__property TAudioSource AudioSource = {read=GetAudioSource, write=SetAudioSource, default=0};
	__property bool AutoConnectRelatedPins = {read=GetAutoConnectRelatedPins, write=SetAutoConnectRelatedPins, default=1};
	__property TAutoFileName AutoFileName = {read=GetAutoFileName, write=SetAutoFileName, default=0};
	__property System::UnicodeString AutoFileNameDateTimeFormat = {read=GetAutoFileNameDateTimeFormat, write=SetAutoFileNameDateTimeFormat};
	__property System::LongInt AutoFileNameMinDigits = {read=GetAutoFileNameMinDigits, write=SetAutoFileNameMinDigits, default=6};
	__property System::UnicodeString AutoFilePrefix = {read=GetAutoFilePrefix, write=SetAutoFilePrefix};
	__property System::UnicodeString AutoFileSuffix = {read=GetAutoFileSuffix, write=SetAutoFileSuffix};
	__property bool AutoRefreshPreview = {read=GetAutoRefreshPreview, write=SetAutoRefreshPreview, default=0};
	__property bool AutoStartPlayer = {read=GetAutoStartPlayer, write=SetAutoStartPlayer, default=1};
	__property bool AVIFormatOpenDML = {read=GetAVIFormatOpenDML, write=SetAVIFormatOpenDML, default=1};
	__property bool AVIFormatOpenDMLCompatibilityIndex = {read=GetAVIFormatOpenDMLCompatibilityIndex, write=SetAVIFormatOpenDMLCompatibilityIndex, default=1};
	__property System::Uitypes::TColor BackgroundColor = {read=GetBackgroundColor, write=SetBackgroundColor, default=0};
	__property Vcl::Forms::TBorderStyle BorderStyle = {read=GetBorderStyle, write=SetBorderStyle, default=1};
	__property System::LongInt BurstCount = {read=GetBurstCount, write=SetBurstCount, default=3};
	__property System::LongInt BurstInterval = {read=GetBurstInterval, write=SetBurstInterval, default=0};
	__property bool BurstMode = {read=GetBurstMode, write=SetBurstMode, default=0};
	__property TFrameCaptureDest BurstType = {read=GetBurstType, write=SetBurstType, default=0};
	__property System::Uitypes::TCursor BusyCursor = {read=GetBusyCursor, write=SetBusyCursor, default=-11};
	__property System::Uitypes::TCursor VideoCursor = {read=GetVideoCursor, write=SetVideoCursor, default=0};
	__property System::Uitypes::TCursor NormalCursor = {read=GetNormalCursor, write=SetNormalCursor, default=0};
	__property bool CameraControlSettings = {read=GetCameraControlSettings, write=SetCameraControlSettings, default=1};
	__property System::UnicodeString CaptureFileExt = {read=GetCaptureFileExt, write=SetCaptureFileExt};
	__property System::Uitypes::TColor ColorKey = {read=GetColorKey, write=SetColorKey, default=1048592};
	__property bool ColorKeyEnabled = {read=GetColorKeyEnabled, write=SetColorKeyEnabled, default=0};
	__property TCompressionMode CompressionMode = {read=GetCompressionMode, write=SetCompressionMode, default=1};
	__property TCompressionType CompressionType = {read=GetCompressionType, write=SetCompressionType, default=0};
	__property bool Display_Active = {read=GetDisplayActive, write=SetDisplayActive, index=0, default=1};
	__property bool Display_AlphaBlendEnabled = {read=GetDisplayAlphaBlendEnabled, write=SetDisplayAlphaBlendEnabled, index=0, default=0};
	__property System::LongInt Display_AlphaBlendValue = {read=GetDisplayAlphaBlendValue, write=SetDisplayAlphaBlendValue, index=0, default=180};
	__property bool Display_AutoSize = {read=GetDisplayAutoSize, write=SetDisplayAutoSize, index=0, default=0};
	__property TAspectRatio Display_AspectRatio = {read=GetDisplayAspectRatio, write=SetDisplayAspectRatio, index=0, default=0};
	__property bool Display_Embedded = {read=GetDisplayEmbedded, write=SetDisplayEmbedded, index=0, default=1};
	__property bool Display_Embedded_FitParent = {read=GetDisplayEmbedded_FitParent, write=SetDisplayEmbedded_FitParent, index=0, default=0};
	__property bool Display_FullScreen = {read=GetDisplayFullScreen, write=SetDisplayFullScreen, index=0, default=0};
	__property System::LongInt Display_Height = {read=GetDisplayHeight, write=SetDisplayHeight, index=0, default=720};
	__property System::LongInt Display_Left = {read=GetDisplayLeft, write=SetDisplayLeft, index=0, default=10};
	__property System::LongInt Display_Monitor = {read=GetDisplayMonitor, write=SetDisplayMonitor, index=0, default=0};
	__property bool Display_MouseMovesWindow = {read=GetDisplayMouseMovesWindow, write=SetDisplayMouseMovesWindow, index=0, default=1};
	__property System::LongInt Display_PanScanRatio = {read=GetDisplayPanScanRatio, write=SetDisplayPanScanRatio, index=0, default=50};
	__property bool Display_StayOnTop = {read=GetDisplayStayOnTop, write=SetDisplayStayOnTop, index=0, default=0};
	__property System::LongInt Display_Top = {read=GetDisplayTop, write=SetDisplayTop, index=0, default=10};
	__property bool Display_TransparentColorEnabled = {read=GetDisplayTransparentColorEnabled, write=SetDisplayTransparentColorEnabled, index=0, default=0};
	__property System::LongInt Display_TransparentColorValue = {read=GetDisplayTransparentColorValue, write=SetDisplayTransparentColorValue, index=0, default=255};
	__property bool Display_VideoPortEnabled = {read=GetDisplayVideoPortEnabled, write=SetDisplayVideoPortEnabled, index=0, default=1};
	__property bool Display_Visible = {read=GetDisplayVisible, write=SetDisplayVisible, index=0, default=1};
	__property System::LongInt Display_Width = {read=GetDisplayWidth, write=SetDisplayWidth, index=0, default=1280};
	__property bool DoubleBuffered = {read=GetVideoDoubleBuffered, write=SetVideoDoubleBuffered, default=1};
	__property System::LongInt DroppedFramesPollingInterval = {read=GetDroppedFramesPollingInterval, write=SetDroppedFramesPollingInterval, default=-1};
	__property bool DualDisplay_Active = {read=GetDisplayActive, write=SetDisplayActive, index=1, default=0};
	__property bool DualDisplay_AlphaBlendEnabled = {read=GetDisplayAlphaBlendEnabled, write=SetDisplayAlphaBlendEnabled, index=1, default=0};
	__property System::LongInt DualDisplay_AlphaBlendValue = {read=GetDisplayAlphaBlendValue, write=SetDisplayAlphaBlendValue, index=1, default=180};
	__property bool DualDisplay_AutoSize = {read=GetDisplayAutoSize, write=SetDisplayAutoSize, index=1, default=0};
	__property TAspectRatio DualDisplay_AspectRatio = {read=GetDisplayAspectRatio, write=SetDisplayAspectRatio, index=1, default=0};
	__property bool DualDisplay_Embedded = {read=GetDisplayEmbedded, write=SetDisplayEmbedded, index=1, default=0};
	__property bool DualDisplay_Embedded_FitParent = {read=GetDisplayEmbedded_FitParent, write=SetDisplayEmbedded_FitParent, index=1, default=0};
	__property bool DualDisplay_FullScreen = {read=GetDisplayFullScreen, write=SetDisplayFullScreen, index=1, default=0};
	__property System::LongInt DualDisplay_Height = {read=GetDisplayHeight, write=SetDisplayHeight, index=1, default=720};
	__property System::LongInt DualDisplay_Left = {read=GetDisplayLeft, write=SetDisplayLeft, index=1, default=20};
	__property System::LongInt DualDisplay_Monitor = {read=GetDisplayMonitor, write=SetDisplayMonitor, index=1, default=0};
	__property bool DualDisplay_MouseMovesWindow = {read=GetDisplayMouseMovesWindow, write=SetDisplayMouseMovesWindow, index=1, default=1};
	__property System::LongInt DualDisplay_PanScanRatio = {read=GetDisplayPanScanRatio, write=SetDisplayPanScanRatio, index=1, default=50};
	__property bool DualDisplay_StayOnTop = {read=GetDisplayStayOnTop, write=SetDisplayStayOnTop, index=1, default=0};
	__property System::LongInt DualDisplay_Top = {read=GetDisplayTop, write=SetDisplayTop, index=1, default=400};
	__property bool DualDisplay_TransparentColorEnabled = {read=GetDisplayTransparentColorEnabled, write=SetDisplayTransparentColorEnabled, index=1, default=0};
	__property System::LongInt DualDisplay_TransparentColorValue = {read=GetDisplayTransparentColorValue, write=SetDisplayTransparentColorValue, index=1, default=255};
	__property bool DualDisplay_VideoPortEnabled = {read=GetDisplayVideoPortEnabled, write=SetDisplayVideoPortEnabled, index=1, default=0};
	__property bool DualDisplay_Visible = {read=GetDisplayVisible, write=SetDisplayVisible, index=1, default=1};
	__property System::LongInt DualDisplay_Width = {read=GetDisplayWidth, write=SetDisplayWidth, index=1, default=1280};
	__property bool DVDateTimeEnabled = {read=GetDVDateTimeEnabled, write=SetDVDateTimeEnabled, default=1};
	__property System::LongInt DVDTitle = {read=GetDVDTitle, write=SetDVDTitle, default=0};
	__property System::LongInt DVDiscontinuityMinimumInterval = {read=GetDVDiscontinuityMinimumInterval, write=SetDVDiscontinuityMinimumInterval, default=3};
	__property TDVVideoFormat DVEncoder_VideoFormat = {read=GetDVEncoder_VideoFormat, write=SetDVEncoder_VideoFormat, default=1};
	__property TDVSize DVEncoder_VideoResolution = {read=GetDVEncoder_VideoResolution, write=SetDVEncoder_VideoResolution, default=0};
	__property TDVVideoStandard DVEncoder_VideoStandard = {read=GetDVEncoder_VideoStandard, write=SetDVEncoder_VideoStandard, default=0};
	__property bool DVRgb219 = {read=GetDVRgb219, write=SetDVRgb219, default=0};
	__property bool DVReduceFrameRate = {read=GetDVReduceFrameRate, write=SetDVReduceFrameRate, default=0};
	__property bool DVRecordingInNativeFormatSeparatesStreams = {read=GetDVRecordingInNativeFormatSeparatesStreams, write=SetDVRecordingInNativeFormatSeparatesStreams, default=0};
	__property bool DVTimeCodeEnabled = {read=GetDVTimeCodeEnabled, write=SetDVTimeCodeEnabled, default=0};
	__property System::UnicodeString ExtraDLLPath = {read=GetExtraDLLPath, write=SetExtraDLLPath};
	__property bool EventNotificationSynchrone = {read=GetEventNotificationSynchrone, write=SetEventNotificationSynchrone, default=1};
	__property bool Cropping_Enabled = {read=GetCropping_Enabled, write=SetCropping_Enabled, default=0};
	__property System::LongInt Cropping_Height = {read=GetCropping_Height, write=SetCropping_Height, default=120};
	__property bool Cropping_Outbounds = {read=GetCropping_Outbounds, write=SetCropping_Outbounds, default=1};
	__property System::LongInt Cropping_Width = {read=GetCropping_Width, write=SetCropping_Width, default=160};
	__property System::LongInt Cropping_X = {read=GetCropping_X, write=SetCropping_X, default=0};
	__property System::LongInt Cropping_Y = {read=GetCropping_Y, write=SetCropping_Y, default=0};
	__property double Cropping_Zoom = {read=GetCropping_Zoom, write=SetCropping_Zoom};
	__property bool FixFlickerOrBlackCapture = {read=GetFixFlickerOrBlackCapture, write=SetFixFlickerOrBlackCapture, default=0};
	__property bool FrameCaptureWithoutOverlay = {read=GetFrameCaptureWithoutOverlay, write=SetFrameCaptureWithoutOverlay, default=0};
	__property System::LongInt FrameCaptureHeight = {read=GetFrameCaptureHeight, write=SetFrameCaptureHeight, default=-1};
	__property System::LongInt FrameCaptureWidth = {read=GetFrameCaptureWidth, write=SetFrameCaptureWidth, default=-1};
	__property System::LongInt FrameCaptureZoomSize = {read=GetFrameCaptureZoomSize, write=SetFrameCaptureZoomSize, default=100};
	__property TFrameGrabber FrameGrabber = {read=GetFrameGrabber, write=SetFrameGrabber, default=0};
	__property TFrameGrabberRGBFormat FrameGrabberRGBFormat = {read=GetFrameGrabberRGBFormat, write=SetFrameGrabberRGBFormat, default=0};
	__property bool FrameNumberStartsFromZero = {read=GetFrameNumberStartsFromZero, write=SetFrameNumberStartsFromZero, default=0};
	__property double FrameRate = {read=GetFrameRate, write=SetFrameRate};
	__property System::LongInt FrameRateDivider = {read=GetFrameRateDivider, write=SetFrameRateDivider, default=0};
	__property System::LongInt GetLastFrameWaitTimeoutMs = {read=GetGetLastFrameWaitTimeoutMs, write=SetGetLastFrameWaitTimeoutMs, default=0};
	__property bool GeneratePts = {read=GetGeneratePts, write=SetGeneratePts, default=0};
	__property bool ImageOverlayEnabled = {read=GetImageOverlayEnabled, write=SetImageOverlayEnabled, nodefault};
	__property bool ImageOverlay_AlphaBlend = {read=GetImageOverlayAlphaBlend, write=SetImageOverlayAlphaBlend, nodefault};
	__property System::LongInt ImageOverlay_AlphaBlendValue = {read=GetImageOverlayAlphaBlendValue, write=SetImageOverlayAlphaBlendValue, nodefault};
	__property bool ImageOverlay_ChromaKey = {read=GetImageOverlayChromaKey, write=SetImageOverlayChromaKey, nodefault};
	__property System::LongInt ImageOverlay_ChromaKeyLeewayPercent = {read=GetImageOverlayChromaKeyLeewayPercent, write=SetImageOverlayChromaKeyLeewayPercent, nodefault};
	__property System::LongInt ImageOverlay_ChromaKeyRGBColor = {read=GetImageOverlayChromaKeyRGBColor, write=SetImageOverlayChromaKeyRGBColor, nodefault};
	__property System::LongInt ImageOverlay_Height = {read=GetImageOverlayHeight, write=SetImageOverlayHeight, nodefault};
	__property System::LongInt ImageOverlay_LeftLocation = {read=GetImageOverlayLeftLocation, write=SetImageOverlayLeftLocation, nodefault};
	__property TVideoAlignment ImageOverlay_VideoAlignment = {read=GetImageOverlayVideoAlignment, write=SetImageOverlayVideoAlignment, nodefault};
	__property double ImageOverlay_RotationAngle = {read=GetImageOverlayRotationAngle, write=SetImageOverlayRotationAngle};
	__property bool ImageOverlay_StretchToVideoSize = {read=GetImageOverlayStretchToVideoSize, write=SetImageOverlayStretchToVideoSize, nodefault};
	__property System::LongInt ImageOverlay_TopLocation = {read=GetImageOverlayTopLocation, write=SetImageOverlayTopLocation, nodefault};
	__property bool ImageOverlay_Transparent = {read=GetImageOverlayTransparent, write=SetImageOverlayTransparent, nodefault};
	__property System::LongInt ImageOverlay_TransparentColorValue = {read=GetImageOverlayTransparentColorValue, write=SetImageOverlayTransparentColorValue, nodefault};
	__property bool ImageOverlay_UseTransparentColor = {read=GetImageOverlayUseTransparentColor, write=SetImageOverlayUseTransparentColor, nodefault};
	__property System::LongInt ImageOverlay_Width = {read=GetImageOverlayWidth, write=SetImageOverlayWidth, nodefault};
	__property System::LongInt ImageOverlay_TargetDisplay = {read=GetImageOverlayTargetDisplay, write=SetImageOverlayTargetDisplay, nodefault};
	__property System::UnicodeString IPCameraURL = {read=GetIPCameraURL, write=SetIPCameraURL};
	__property TJPEGPerformance JPEGPerformance = {read=GetJPEGPerformance, write=SetJPEGPerformance, default=0};
	__property bool JPEGProgressiveDisplay = {read=GetJPEGProgressiveDisplay, write=SetJPEGProgressiveDisplay, default=0};
	__property System::LongInt JPEGQuality = {read=GetJPEGQuality, write=SetJPEGQuality, default=100};
	__property System::UnicodeString LicenseString = {read=GetLicenseString, write=SetLicenseString};
	__property bool LogoDisplayed = {read=GetLogoDisplayed, write=SetLogoDisplayed, default=0};
	__property TLogoLayout LogoLayout = {read=GetLogoLayout, write=SetLogoLayout, default=1};
	__property System::LongInt MixAudioSamples_CurrentSourceLevel = {read=GetMixAudioSamplesLevel, write=SetMixAudioSamplesLevel, index=0, default=100};
	__property System::LongInt MixAudioSamples_ExternalSourceLevel = {read=GetMixAudioSamplesLevel, write=SetMixAudioSamplesLevel, index=1, default=100};
	__property System::LongInt Mixer_MosaicColumns = {read=GetMixer_MosaicColumns, write=SetMixer_MosaicColumns, default=1};
	__property System::LongInt Mixer_MosaicLines = {read=GetMixer_MosaicLines, write=SetMixer_MosaicLines, default=1};
	__property bool MotionDetector_CompareBlue = {read=GetMotionDetector_CompareBlue, write=SetMotionDetector_CompareBlue, default=1};
	__property bool MotionDetector_CompareGreen = {read=GetMotionDetector_CompareGreen, write=SetMotionDetector_CompareGreen, default=1};
	__property bool MotionDetector_GreyScale = {read=GetMotionDetector_GreyScale, write=SetMotionDetector_GreyScale, default=0};
	__property bool MotionDetector_CompareRed = {read=GetMotionDetector_CompareRed, write=SetMotionDetector_CompareRed, default=1};
	__property bool MotionDetector_Enabled = {read=GetMotionDetector_Enabled, write=SetMotionDetector_Enabled, default=0};
	__property System::UnicodeString MotionDetector_Grid = {read=GetMotionDetector_Grid, write=SetMotionDetector_Grid};
	__property double MotionDetector_MaxDetectionsPerSecond = {read=GetMotionDetector_MaxDetectionsPerSecond, write=SetMotionDetector_MaxDetectionsPerSecond};
	__property System::LongInt MotionDetector_ReduceCPULoad = {read=GetMotionDetector_ReduceCPULoad, write=SetMotionDetector_ReduceCPULoad, default=1};
	__property System::LongInt MotionDetector_MotionResetMs = {read=GetMotionDetector_MotionResetMs, write=SetMotionDetector_MotionResetMs, default=0};
	__property bool MotionDetector_ReduceVideoNoise = {read=GetMotionDetector_ReduceVideoNoise, write=SetMotionDetector_ReduceVideoNoise, default=0};
	__property bool MotionDetector_Triggered = {read=GetMotionDetector_Triggered, write=SetMotionDetector_Triggered, default=0};
	__property bool MouseWheelEventEnabled = {read=GetMouseWheelEventEnabled, write=SetMouseWheelEventEnabled, default=1};
	__property bool MouseWheelControlsZoomAtCursor = {read=GetMouseWheelControlsZoomAtCursor, write=SetMouseWheelControlsZoomAtCursor, default=0};
	__property bool MultiplexedInputEmulation = {read=GetMultiplexedInputEmulation, write=SetMultiplexedInputEmulation, default=1};
	__property TMultiplexedRole MultiplexedRole = {read=GetMultiplexedRole, write=SetMultiplexedRole, default=0};
	__property System::LongInt MultiplexedSwitchDelay = {read=GetMultiplexedSwitchDelay, write=SetMultiplexedSwitchDelay, default=0};
	__property System::LongInt MultiplexedStabilizationDelay = {read=GetMultiplexedStabilizationDelay, write=SetMultiplexedStabilizationDelay, default=100};
	__property System::LongInt Multiplexer = {read=GetMultiplexer, write=SetMultiplexer, default=-1};
	__property bool MuteAudioRendering = {read=GetMuteAudioRendering, write=SetMuteAudioRendering, default=0};
	__property TNDIBandwidthType NDIBandwidthType = {read=GetNDIBandwidthType, write=SetNDIBandwidthType, default=3};
	__property TNDIFormatType NDIFormatType = {read=GetNDIFormatType, write=SetNDIFormatType, default=1};
	__property System::UnicodeString NDIGroups = {read=GetNDIGroups, write=SetNDIGroups};
	__property System::UnicodeString NDIName = {read=GetNDIName, write=SetNDIName};
	__property System::LongInt NDIReceiveTimeoutMs = {read=GetNDIReceiveTimeoutMs, write=SetNDIReceiveTimeoutMs, default=5000};
	__property TNetworkStreaming NetworkStreaming = {read=GetNetworkStreaming, write=SetNetworkStreaming, default=0};
	__property TNetworkStreamingType NetworkStreamingType = {read=GetNetworkStreamingType, write=SetNetworkStreamingType, default=0};
	__property TNotificationMethod NotificationMethod = {read=GetNotificationMethod, write=SetNotificationMethod, default=1};
	__property System::LongInt NotificationSleepTime = {read=GetNotificationSleepTime, write=SetNotificationSleepTime, default=-1};
	__property System::Classes::TThreadPriority NotificationPriority = {read=GetNotificationPriority, write=SetNotificationPriority, default=3};
	__property bool OnFrameBitmapEventSynchrone = {read=GetOnFrameBitmapEventSynchrone, write=SetOnFrameBitmapEventSynchrone, default=0};
	__property bool OpenURLAsync = {read=GetOpenURLAsync, write=SetOpenURLAsync, default=1};
	__property bool OverlayAfterTransform = {read=GetOverlayAfterTransform, write=SetOverlayAfterTransform, default=0};
	__property bool PlayerAudioRendering = {read=GetPlayerAudioRendering, write=SetPlayerAudioRendering, default=1};
	__property TDVSize PlayerDVSize = {read=GetPlayerDVSize, write=SetPlayerDVSize, default=0};
	__property System::LongInt PlayerFastSeekSpeedRatio = {read=GetPlayerFastSeekSpeedRatio, write=SetPlayerFastSeekSpeedRatio, default=4};
	__property System::UnicodeString PlayerFileName = {read=GetPlayerFileName, write=SetPlayerFileName};
	__property System::UnicodeString PlayerForcedCodec = {read=GetPlayerForcedCodec, write=SetPlayerForcedCodec};
	__property THwAccel PlayerHwAccel = {read=GetPlayerHwAccel, write=SetPlayerHwAccel, default=0};
	__property bool PlayerRefreshPausedDisplay = {read=GetPlayerRefreshPausedDisplay, write=SetPlayerRefreshPausedDisplay, default=0};
	__property double PlayerRefreshPausedDisplayFrameRate = {read=GetPlayerRefreshPausedDisplayFrameRate, write=SetPlayerRefreshPausedDisplayFrameRate};
	__property double PlayerSpeedRatio = {read=GetPlayerSpeedRatio, write=SetPlayerSpeedRatio};
	__property bool PlayerSpeedRatioConstantAudioPitch = {read=GetPlayerSpeedRatioConstantAudioPitch, write=SetPlayerSpeedRatioConstantAudioPitch, default=1};
	__property Vcl::Comctrls::TTrackBar* PlayerTrackBar = {read=GetPlayerTrackBar, write=SetPlayerTrackBar};
	__property Vcl::Menus::TPopupMenu* PopupMenu = {read=Get_PopupMenu, write=SetPopupMenu};
	__property System::Classes::TComponent* PropertyPageSaver = {read=GetPropertyPageSaver, write=SetPropertyPageSaver};
	__property bool PlayerTrackBarSynchrone = {read=GetPlayerTrackBarSynchrone, write=SetPlayerTrackBarSynchrone, default=0};
	__property bool PreallocCapFileCopiedAfterRecording = {read=GetPreallocCapFileCopiedAfterRecording, write=SetPreallocCapFileCopiedAfterRecording, default=1};
	__property bool PreallocCapFileEnabled = {read=GetPreallocCapFileEnabled, write=SetPreallocCapFileEnabled, default=0};
	__property System::UnicodeString PreallocCapFileName = {read=GetPreallocCapFileName, write=SetPreallocCapFileName};
	__property System::LongInt PreallocCapFileSizeInMB = {read=GetPreallocCapFileSizeInMB, write=SetPreallocCapFileSizeInMB, default=100};
	__property System::LongInt PreviewZoomSize = {read=GetPreviewZoomSize, write=SetPreviewZoomSize, default=100};
	__property System::LongInt RecordingAudioBitRate = {read=GetRecordingAudioBitRate, write=SetRecordingAudioBitRate, default=-1};
	__property System::LongInt RecordingVideoBitRate = {read=GetRecordingVideoBitRate, write=SetRecordingVideoBitRate, default=-1};
	__property System::UnicodeString RecordingFileName = {read=GetRecordingFileName, write=SetRecordingFileName};
	__property System::LongInt RecordingFileSizeMaxInMB = {read=GetRecordingFileSizeMaxInMB, write=SetRecordingFileSizeMaxInMB, default=0};
	__property bool RecordingInNativeFormat = {read=GetRecordingInNativeFormat, write=SetRecordingInNativeFormat, default=1};
	__property TRecordingMethod RecordingMethod = {read=GetRecordingMethod, write=SetRecordingMethod, default=5};
	__property bool RecordingPauseCreatesNewFile = {read=GetRecordingPauseCreatesNewFile, write=SetRecordingPauseCreatesNewFile, default=0};
	__property bool RecordingOnMotion_Enabled = {read=GetRecordingOnMotion_Enabled, write=SetRecordingOnMotion_Enabled, default=0};
	__property double RecordingOnMotion_MotionThreshold = {read=GetRecordingOnMotion_MotionThreshold, write=SetRecordingOnMotion_MotionThreshold};
	__property TRecordingTimer RecordingTimer = {read=GetRecordingTimer, write=SetRecordingTimer, default=0};
	__property System::LongInt RecordingTimerInterval = {read=GetRecordingTimerInterval, write=SetRecordingTimerInterval, default=60};
	__property System::LongInt RecordingOnMotion_NoMotionPauseDelayMs = {read=GetRecordingOnMotion_NoMotionPauseDelayMs, write=SetRecordingOnMotion_NoMotionPauseDelayMs, default=5000};
	__property System::UnicodeString Reencoding_NewVideoClip = {read=GetReencodingNewVideoClip, write=SetReencodingNewVideoClip};
	__property System::UnicodeString Reencoding_SourceVideoClip = {read=GetReencodingSourceVideoClip, write=SetReencodingSourceVideoClip};
	__property LargeInteger Reencoding_StartTime = {read=GetReencodingStartTime, write=SetReencodingStartTime, default=-1};
	__property LargeInteger Reencoding_StartFrame = {read=GetReencodingStartFrame, write=SetReencodingStartFrame, default=-1};
	__property LargeInteger Reencoding_StopTime = {read=GetReencodingStopTime, write=SetReencodingStopTime, default=-1};
	__property LargeInteger Reencoding_StopFrame = {read=GetReencodingStopFrame, write=SetReencodingStopFrame, default=-1};
	__property bool Reencoding_IncludeAudioStream = {read=GetReencodingIncludeAudioStream, write=SetReencodingIncludeAudioStream, default=1};
	__property bool Reencoding_IncludeVideoStream = {read=GetReencodingIncludeVideoStream, write=SetReencodingIncludeVideoStream, default=1};
	__property TRecordingMethod Reencoding_Method = {read=GetReencodingMethod, write=SetReencodingMethod, default=1};
	__property bool Reencoding_UseAudioCompressor = {read=GetReencodingUseAudioCompressor, write=SetReencodingUseAudioCompressor, default=0};
	__property bool Reencoding_UseFrameGrabber = {read=GetReencodingUseFrameGrabber, write=SetReencodingUseFrameGrabber, default=1};
	__property bool Reencoding_UseVideoCompressor = {read=GetReencodingUseVideoCompressor, write=SetReencodingUseVideoCompressor, default=0};
	__property bool Reencoding_WMVOutput = {read=GetReencodingWMVOutput, write=SetReencodingWMVOutput, default=0};
	__property bool QuickDeviceInitialization = {read=GetQuickDeviceInitialization, write=SetQuickDeviceInitialization, default=0};
	__property bool RawAudioSampleCapture = {read=GetRawAudioSampleCapture, write=SetRawAudioSampleCapture, default=0};
	__property bool RawCaptureAsyncEvent = {read=GetRawCaptureAsyncEvent, write=SetRawCaptureAsyncEvent, default=1};
	__property TRawSampleCaptureLocation RawSampleCaptureLocation = {read=GetRawSampleCaptureLocation, write=SetRawSampleCaptureLocation, default=0};
	__property bool RawVideoSampleCapture = {read=GetRawVideoSampleCapture, write=SetRawVideoSampleCapture, default=0};
	__property TRecordingSize RecordingSize = {read=GetRecordingSize, write=SetRecordingSize, default=0};
	__property System::LongInt ScreenRecordingSizePercent = {read=GetScreenRecordingSizePercent, write=SetScreenRecordingSizePercent, default=100};
	__property bool ScreenRecordingLayeredWindows = {read=GetScreenRecordingLayeredWindows, write=SetScreenRecordingLayeredWindows, default=0};
	__property System::LongInt ScreenRecordingMonitor = {read=GetScreenRecordingMonitor, write=SetScreenRecordingMonitor, default=0};
	__property bool ScreenRecordingNonVisibleWindows = {read=GetScreenRecordingNonVisibleWindows, write=SetScreenRecordingNonVisibleWindows, default=0};
	__property bool ScreenRecordingThroughClipboard = {read=GetScreenRecordingThroughClipboard, write=SetScreenRecordingThroughClipboard, default=0};
	__property bool ScreenRecordingWithCursor = {read=GetScreenRecordingWithCursor, write=SetScreenRecordingWithCursor, default=1};
	__property Vcl::Extctrls::TShape* ShapeOverlay = {read=GetShapeOverlay, write=SetShapeOverlay};
	__property bool ShapeOverlayEnabled = {read=GetShapeOverlayEnabled, write=SetShapeOverlayEnabled, default=0};
	__property bool SpeakerControl = {read=GetSpeakerControl, write=SetSpeakerControl, default=0};
	__property System::UnicodeString StoragePath = {read=GetStoragePath, write=SetStoragePath, stored=false};
	__property TStoragePathMode StoragePathMode = {read=GetStoragePathMode, write=SetStoragePathMode, default=0};
	__property bool StoreDeviceSettingsInRegistry = {read=GetStoreDeviceSettingsInRegistry, write=SetStoreDeviceSettingsInRegistry, default=1};
	__property TSynchronizationRole SynchronizationRole = {read=GetSynchronizationRole, write=SetSynchronizationRole, default=0};
	__property bool Synchronized = {read=GetSynchronized, write=SetSynchronized, default=0};
	__property bool SyncCommands = {read=GetSyncCommands, write=SetSyncCommands, default=1};
	__property TSyncPreview SyncPreview = {read=GetSyncPreview, write=SetSyncPreview, default=0};
	__property bool TextOverlay_Enabled = {read=GetTextOverlayEnabled, write=SetTextOverlayEnabled, nodefault};
	__property Vcl::Graphics::TFont* TextOverlay_Font = {read=GetTextOverlayFont, write=SetTextOverlayFont};
	__property System::Uitypes::TColor TextOverlay_FontColor = {read=GetTextOverlayFontColor, write=SetTextOverlayFontColor, nodefault};
	__property System::LongInt TextOverlay_FontSize = {read=GetTextOverlayFontSize, write=SetTextOverlayFontSize, nodefault};
	__property bool TextOverlay_HighResFont = {read=GetTextOverlayHighResFont, write=SetTextOverlayHighResFont, nodefault};
	__property System::LongInt TextOverlay_Left = {read=GetTextOverlayLeft, write=SetTextOverlayLeft, nodefault};
	__property System::LongInt TextOverlay_Top = {read=GetTextOverlayTop, write=SetTextOverlayTop, nodefault};
	__property System::LongInt TextOverlay_Right = {read=GetTextOverlayRight, write=SetTextOverlayRight, nodefault};
	__property TTextOrientation TextOverlay_Orientation = {read=GetTextOverlayOrientation, write=SetTextOverlayOrientation, nodefault};
	__property bool TextOverlay_Scrolling = {read=GetTextOverlayScrolling, write=SetTextOverlayScrolling, nodefault};
	__property System::LongInt TextOverlay_ScrollingSpeed = {read=GetTextOverlayScrollingSpeed, write=SetTextOverlayScrollingSpeed, nodefault};
	__property bool TextOverlay_Shadow = {read=GetTextOverlayShadow, write=SetTextOverlayShadow, nodefault};
	__property System::Uitypes::TColor TextOverlay_ShadowColor = {read=GetTextOverlayShadowColor, write=SetTextOverlayShadowColor, nodefault};
	__property TCardinalDirection TextOverlay_ShadowDirection = {read=GetTextOverlayShadowDirection, write=SetTextOverlayShadowDirection, nodefault};
	__property System::Uitypes::TColor TextOverlay_BkColor = {read=GetTextOverlayBkColor, write=SetTextOverlayBkColor, nodefault};
	__property TTextOverlayAlign TextOverlay_Align = {read=GetTextOverlayAlign, write=SetTextOverlayAlign, nodefault};
	__property bool TextOverlay_AlphaBlend = {read=GetTextOverlayAlphaBlend, write=SetTextOverlayAlphaBlend, nodefault};
	__property System::LongInt TextOverlay_AlphaBlendValue = {read=GetTextOverlayAlphaBlendValue, write=SetTextOverlayAlphaBlendValue, nodefault};
	__property TTextOverlayGradientMode TextOverlay_GradientMode = {read=GetTextOverlayGradientMode, write=SetTextOverlayGradientMode, nodefault};
	__property System::Uitypes::TColor TextOverlay_GradientColor = {read=GetTextOverlayGradientColor, write=SetTextOverlayGradientColor, nodefault};
	__property TVideoAlignment TextOverlay_VideoAlignment = {read=GetTextOverlayVideoAlignment, write=SetTextOverlayVideoAlignment, nodefault};
	__property System::UnicodeString TextOverlay_String = {read=GetTextOverlayString, write=SetTextOverlayString};
	__property System::LongInt TextOverlay_TargetDisplay = {read=GetTextOverlayTargetDisplay, write=SetTextOverlayTargetDisplay, nodefault};
	__property bool TextOverlay_Transparent = {read=GetTextOverlayTransparent, write=SetTextOverlayTransparent, nodefault};
	__property System::UnicodeString ThirdPartyDeinterlacer = {read=GetThirdPartyDeinterlacer, write=SetThirdPartyDeinterlacer};
	__property bool TranslateMouseCoordinates = {read=GetTranslateMouseCoordinates, write=SetTranslateMouseCoordinates, default=1};
	__property bool TVUseFrequencyOverrides = {read=GetTVUseFrequencyOverrides, write=SetTVUseFrequencyOverrides, default=0};
	__property System::LongInt TunerFrequency = {read=GetTunerFrequency, write=SetTunerFrequency, default=-1};
	__property bool UseClock = {read=GetUseClock, write=SetUseClock, default=1};
	__property System::UnicodeString Version = {read=GetVersion, write=SetVersion, stored=false};
	__property bool v360_Enabled = {read=Getv360_Enabled, write=Setv360_Enabled, default=0};
	__property double v360_AspectRatio = {read=Getv360_AspectRatio, write=Setv360_AspectRatio};
	__property System::LongInt v360_MouseActionPercent = {read=Getv360_MouseActionPercent, write=Setv360_MouseActionPercent, default=10};
	__property TV360_MouseAction v360_MouseAction = {read=Getv360_MouseAction, write=Setv360_MouseAction, default=2};
	__property Tv360_Angle v360_MasterAngle = {read=Getv360_MasterAngle, write=Setv360_MasterAngle, default=1};
	__property System::LongInt VideoDevice = {read=GetVideoDevice, write=SetVideoDevice, default=-1};
	__property System::LongInt VideoCompression_DataRate = {read=GetVideoCompression_DataRate, write=SetVideoCompression_DataRate, default=-1};
	__property System::LongInt VideoCompression_KeyFrameRate = {read=GetVideoCompression_KeyFrameRate, write=SetVideoCompression_KeyFrameRate, default=15};
	__property System::LongInt VideoCompression_PFramesPerKeyFrame = {read=GetVideoCompression_PFramesPerKeyFrame, write=SetVideoCompression_PFramesPerKeyFrame, default=0};
	__property double VideoCompression_Quality = {read=GetVideoCompression_Quality, write=SetVideoCompression_Quality};
	__property System::LongInt VideoCompression_WindowSize = {read=GetVideoCompression_WindowSize, write=SetVideoCompression_WindowSize, default=-1};
	__property System::LongInt VideoCompressor = {read=GetVideoCompressor, write=SetVideoCompressor, nodefault};
	__property bool VideoControlSettings = {read=GetVideoControlSettings, write=SetVideoControlSettings, default=1};
	__property LargeInteger VideoDelay = {read=GetVideoDelay, write=SetVideoDelay};
	__property System::LongInt VideoFormat = {read=GetVideoFormat, write=SetVideoFormat, default=-1};
	__property TFileSort VideoFromImages_BitmapsSortedBy = {read=GetVideoFromImages_BitmapsSortedBy, write=SetVideoFromImages_BitmapsSortedBy, default=0};
	__property bool VideoFromImages_RepeatIndefinitely = {read=GetVideoFromImages_RepeatIndefinitely, write=SetVideoFromImages_RepeatIndefinitely, default=0};
	__property System::UnicodeString VideoFromImages_SourceDirectory = {read=GetVideoFromImages_SourceDirectory, write=SetVideoFromImages_SourceDirectory, stored=false};
	__property System::UnicodeString VideoFromImages_TemporaryFile = {read=GetVideoFromImages_TemporaryFile, write=SetVideoFromImages_TemporaryFile};
	__property System::LongInt VideoInput = {read=GetVideoInput, write=SetVideoInput, default=-1};
	__property bool VideoPlayableWhileRecording = {read=GetVideoPlayableWhileRecording, write=SetVideoPlayableWhileRecording, default=0};
	__property System::LongInt VideoProcessing_Brightness = {read=GetVideoProcessingBrightness, write=SetVideoProcessingBrightness, default=0};
	__property System::LongInt VideoProcessing_Contrast = {read=GetVideoProcessingContrast, write=SetVideoProcessingContrast, default=0};
	__property TVideoDeinterlacing VideoProcessing_Deinterlacing = {read=GetVideoProcessingDeinterlacing, write=SetVideoProcessingDeinterlacing, default=0};
	__property bool VideoProcessing_FlipHorizontal = {read=GetVideoProcessingLeftRight, write=SetVideoProcessingLeftRight, default=0};
	__property bool VideoProcessing_FlipVertical = {read=GetVideoProcessingTopDown, write=SetVideoProcessingTopDown, default=0};
	__property bool VideoProcessing_GrayScale = {read=GetVideoProcessingGrayScale, write=SetVideoProcessingGrayScale, default=0};
	__property System::LongInt VideoProcessing_Hue = {read=GetVideoProcessingHue, write=SetVideoProcessingHue, default=0};
	__property bool VideoProcessing_InvertColors = {read=GetVideoProcessingInvertColors, write=SetVideoProcessingInvertColors, default=0};
	__property System::LongInt VideoProcessing_Pixellization = {read=GetVideoProcessingPixellization, write=SetVideoProcessingPixellization, default=1};
	__property System::LongInt VideoProcessing_Saturation = {read=GetVideoProcessingSaturation, write=SetVideoProcessingSaturation, default=0};
	__property TVideoRotation VideoProcessing_Rotation = {read=GetVideoProcessingRotation, write=SetVideoProcessingRotation, default=0};
	__property double VideoProcessing_RotationCustomAngle = {read=GetVideoProcessingRotationCustomAngle, write=SetVideoProcessingRotationCustomAngle};
	__property bool VideoQualitySettings = {read=GetVideoQualitySettings, write=SetVideoQualitySettings, default=1};
	__property TVideoRenderer VideoRenderer = {read=GetVideoRenderer, write=SetVideoRenderer, default=0};
	__property TVideoRendererExternal VideoRendererExternal = {read=GetVideoRendererExternal, write=SetVideoRendererExternal, default=0};
	__property System::LongInt VideoRendererExternalIndex = {read=GetVideoRendererExternalIndex, write=SetVideoRendererExternalIndex, default=-1};
	__property TVideoRendererPriority VideoRendererPriority = {read=GetVideoRendererPriority, write=SetVideoRendererPriority, default=2};
	__property System::LongInt VideoSize = {read=GetVideoSize, write=SetVideoSize, default=-1};
	__property TVideoSource VideoSource = {read=GetVideoSource, write=SetVideoSource, default=0};
	__property System::UnicodeString VideoSource_FileOrURL = {read=GetVideoSource_FileOrURL, write=SetVideoSource_FileOrURL};
	__property LargeInteger VideoSource_FileOrURL_StartTime = {read=GetVideoSource_FileOrURL_StartTime, write=SetVideoSource_FileOrURL_StartTime, default=-1};
	__property LargeInteger VideoSource_FileOrURL_StopTime = {read=GetVideoSource_FileOrURL_StopTime, write=SetVideoSource_FileOrURL_StopTime, default=-1};
	__property System::UnicodeString StreamInterface_Format = {read=GetStreamInterface_Format, write=SetStreamInterface_Format};
	__property double StreamInterface_FrameRate = {read=GetStreamInterface_FrameRate, write=SetStreamInterface_FrameRate};
	__property bool StreamInterface_IsRealTime = {read=GetStreamInterface_IsRealTime, write=SetStreamInterface_IsRealTime, nodefault};
	__property System::LongInt VideoStreamNumber = {read=GetVideoStreamNumber, write=SetVideoStreamNumber, default=-1};
	__property System::LongInt VideoSubtype = {read=GetVideoSubtype, write=SetVideoSubtype, default=-1};
	__property bool VideoVisibleWhenStopped = {read=GetVideoVisibleWhenStopped, write=SetVideoVisibleWhenStopped, default=0};
	__property System::LongInt VirtualVideoStreamControl = {read=GetVirtualVideoStreamControl, write=SetVirtualVideoStreamControl, default=-1};
	__property System::LongInt VirtualAudioStreamControl = {read=GetVirtualAudioStreamControl, write=SetVirtualAudioStreamControl, default=-1};
	__property TVuMeter VuMeter = {read=GetVuMeter, write=SetVuMeter, default=0};
	__property TWebcamStillCaptureButton WebcamStillCaptureButton = {read=GetWebcamStillCaptureButton, write=SetWebcamStillCaptureButton, default=0};
	__property System::LongInt ZoomCoeff = {read=GetZoomCoeff, write=SetZoomCoeff, default=1000};
	__property System::LongInt ZoomXCenter = {read=GetZoomXCenter, write=SetZoomXCenter, default=0};
	__property System::LongInt ZoomYCenter = {read=GetZoomYCenter, write=SetZoomYCenter, default=0};
	__property TOnAVIDurationUpdated OnAVIDurationUpdated = {read=FOnAVIDurationUpdated, write=FOnAVIDurationUpdated};
	__property TOnEventNotification OnAudioDeviceSelected = {read=FOnAudioDeviceSelected, write=FOnAudioDeviceSelected};
	__property TOnAudioBufferNegotiation OnAudioBufferNegotiation = {read=FOnAudioBufferNegotiation, write=FOnAudioBufferNegotiation};
	__property TOnAudioPeak OnAudioPeak = {read=FOnAudioPeak, write=FOnAudioPeak};
	__property TOnEventNotification OnBacktimedFramesCountReached = {read=FOnBacktimedFramesCountReached, write=FOnBacktimedFramesCountReached};
	__property TOnProgressCommented OnBitmapsLoadingProgress = {read=FOnBitmapsLoadingProgress, write=FOnBitmapsLoadingProgress};
	__property TOnEventNotification OnClick = {read=FOnClick, write=FOnClick};
	__property TOnEventNotification OnDblClick = {read=FOnDblClick, write=FOnDblClick};
	__property TOnClientConnection OnClientConnection = {read=FOnClientConnection, write=FOnClientConnection};
	__property TOnColorKeyChange OnColorKeyChange = {read=FOnColorKeyChange, write=FOnColorKeyChange};
	__property TOnSourceFileToDestFileCompleted OnCopyPreallocDataCompleted = {read=FOnCopyPreallocDataCompleted, write=FOnCopyPreallocDataCompleted};
	__property TOnProgress OnCopyPreallocDataProgress = {read=FOnCopyPreallocDataProgress, write=FOnCopyPreallocDataProgress};
	__property TOnSourceFileToDestFileStarted OnCopyPreallocDataStarted = {read=FOnCopyPreallocDataStarted, write=FOnCopyPreallocDataStarted};
	__property TOnCreatePreallocatedFileCompleted OnCreatePreallocFileCompleted = {read=FOnCreatePreallocFileCompleted, write=FOnCreatePreallocFileCompleted};
	__property TOnProgress OnCreatePreallocFileProgress = {read=FOnCreatePreallocFileProgress, write=FOnCreatePreallocFileProgress};
	__property TOnFileNotification OnCreatePreallocFileStarted = {read=FOnCreatePreallocFileStarted, write=FOnCreatePreallocFileStarted};
	__property TOnDeviceArrivalOrRemoval OnDeviceArrivalOrRemoval = {read=FOnDeviceArrivalOrRemoval, write=Set_OnDeviceArrivalOrRemoval};
	__property TOnEventNotification OnDeviceLost = {read=FOnDeviceLost, write=FOnDeviceLost};
	__property TOnEventNotification OnDeviceReconnecting = {read=FOnDeviceReconnecting, write=FOnDeviceReconnecting};
	__property TOnEventNotification OnDeviceReconnected = {read=FOnDeviceReconnected, write=FOnDeviceReconnected};
	__property TOnDirectNetworkStreamingHostUrl OnDirectNetworkStreamingHostUrl = {read=FOnDirectNetworkStreamingHostUrl, write=FOnDirectNetworkStreamingHostUrl};
	__property TOnEventNotification OnDiskFull = {read=FOnDiskFull, write=FOnDiskFull};
	__property TOnDragDropFiles OnDragDropFiles = {read=FOnDragDropFiles, write=FOnDragDropFiles};
	__property TOnDVDiscontinuity OnDVDiscontinuity = {read=FOnDVDiscontinuity, write=FOnDVDiscontinuity};
	__property TOnDVCommandCompleted OnDVCommandCompleted = {read=FOnDVCommandCompleted, write=FOnDVCommandCompleted};
	__property TOnEnumerateWindows OnEnumerateWindows = {read=FOnEnumerateWindows, write=FOnEnumerateWindows};
	__property TOnFilterSelected OnFilterSelected = {read=FOnFilterSelected, write=FOnFilterSelected};
	__property TOnEventNotification OnFirstFrameReceived = {read=FOnFirstFrameReceived, write=FOnFirstFrameReceived};
	__property TOnFrameBitmap OnFrameBitmap = {read=FOnFrameBitmap, write=FOnFrameBitmap};
	__property TOnFrameBitmap OnFrameBitmapRendering = {read=FOnFrameBitmapRendering, write=FOnFrameBitmapRendering};
	__property TOnFrameCaptureCompleted OnFrameCaptureCompleted = {read=FOnFrameCaptureCompleted, write=FOnFrameCaptureCompleted};
	__property TOnFrameOverlayUsingDC OnFrameOverlayUsingDC = {read=FOnFrameOverlayUsingDC, write=FOnFrameOverlayUsingDC};
	__property TOnFrameOverlayUsingDIB OnFrameOverlayUsingDIB = {read=FOnFrameOverlayUsingDIB, write=FOnFrameOverlayUsingDIB};
	__property TOnFrameOverlayUsingVIDEOHDR OnFrameOverlayUsingVIDEOHDR = {read=FOnFrameOverlayUsingVIDEOHDR, write=FOnFrameOverlayUsingVIDEOHDR};
	__property TOnFrameProgress OnFrameProgress = {read=FOnFrameProgress, write=FOnFrameProgress};
	__property TOnFrameProgress2 OnFrameProgress2 = {read=FOnFrameProgress2, write=FOnFrameProgress2};
	__property TOnEventNotification OnGraphBuilt = {read=FOnGraphBuilt, write=FOnGraphBuilt};
	__property TOnEventNotification OnInactive = {read=FOnInactive, write=FOnInactive};
	__property TOnEventNotification OnLastCommandCompleted = {read=FOnLastCommandCompleted, write=FOnLastCommandCompleted};
	__property TOnEventNotification OnLeavingFullScreen = {read=FOnLeavingFullScreen, write=FOnLeavingFullScreen};
	__property TOnVideoKeyPress OnKeyPress = {read=FOnKeyPress, write=FOnKeyPress};
	__property TOnLog OnLog = {read=FOnLog, write=FOnLog};
	__property TOnMotionDetected OnMotionDetected = {read=FOnMotionDetected, write=FOnMotionDetected};
	__property TOnMotionNotDetected OnMotionNotDetected = {read=FOnMotionNotDetected, write=FOnMotionNotDetected};
	__property TOnVideoMouseUpDown OnMouseDown = {read=FOnMouseDown, write=FOnMouseDown};
	__property TOnVideoMouseUpDown OnMouseDown_Video = {read=FOnMouseDown_Video, write=FOnMouseDown_Video};
	__property TOnVideoMouseUpDown OnMouseDown_Window = {read=FOnMouseDown_Window, write=FOnMouseDown_Window};
	__property TOnVideoMouseEvent OnMouseEnter = {read=FOnMouseEnter, write=FOnMouseEnter};
	__property TOnVideoMouseEvent OnMouseLeave = {read=FOnMouseLeave, write=FOnMouseLeave};
	__property TOnVideoMouseMove OnMouseMove = {read=FOnMouseMove, write=FOnMouseMove};
	__property TOnVideoMouseMove OnMouseMove_Video = {read=FOnMouseMove_Video, write=FOnMouseMove_Video};
	__property TOnVideoMouseMove OnMouseMove_Window = {read=FOnMouseMove_Window, write=FOnMouseMove_Window};
	__property TOnVideoMouseUpDown OnMouseUp = {read=FOnMouseUp, write=FOnMouseUp};
	__property TOnVideoMouseUpDown OnMouseUp_Video = {read=FOnMouseUp_Video, write=FOnMouseUp_Video};
	__property TOnVideoMouseUpDown OnMouseUp_Window = {read=FOnMouseUp_Window, write=FOnMouseUp_Window};
	__property TOnMouseWheel OnMouseWheel = {read=FOnMouseWheel, write=FOnMouseWheel};
	__property TOnMultipurposeEncoderNotification OnMultipurposeEncoderProgress = {read=FOnMultipurposeEncoderProgress, write=FOnMultipurposeEncoderProgress};
	__property TOnMultipurposeEncoderNotification OnMultipurposeEncoderError = {read=FOnMultipurposeEncoderError, write=FOnMultipurposeEncoderError};
	__property TOnMultipurposeEncoderNotification OnMultipurposeEncoderCompleted = {read=FOnMultipurposeEncoderCompleted, write=FOnMultipurposeEncoderCompleted};
	__property TOnONVIFDiscoveryCompletedNotification OnONVIFDiscoveryCompleted = {read=FOnONVIFDiscoveryCompleted, write=FOnONVIFDiscoveryCompleted};
	__property TOnOpenURLAsyncStatusChanged OnOpenURLAsyncStatusChanged = {read=FOnOpenURLAsyncStatusChanged, write=FOnOpenURLAsyncStatusChanged};
	__property TOnEventNotification OnNoVideoDevices = {read=FOnNoVideoDevices, write=FOnNoVideoDevices};
	__property TOnNTPTimeStamp OnNTPTimeStamp = {read=FOnNTPTimeStamp, write=FOnNTPTimeStamp};
	__property TOnPlayerBufferingData OnPlayerBufferingData = {read=FOnPlayerBufferingData, write=FOnPlayerBufferingData};
	__property TOnEventNotification OnPlayerEndOfPlaylist = {read=FOnPlayerEndOfPlaylist, write=FOnPlayerEndOfPlaylist};
	__property TOnEventNotification OnPlayerEndOfStream = {read=FOnPlayerEndOfStream, write=FOnPlayerEndOfStream};
	__property TOnEventNotification OnPlayerOpened = {read=FOnPlayerOpened, write=FOnPlayerOpened};
	__property TOnFrameProgress OnPlayerUpdateTrackbarPosition = {read=FOnPlayerUpdateTrackbarPosition, write=FOnPlayerUpdateTrackbarPosition};
	__property TOnEventNotification OnPreviewStarted = {read=FOnPreviewStarted, write=FOnPreviewStarted};
	__property TOnPlayerStateChanged OnPlayerStateChanged = {read=FOnPlayerStateChanged, write=FOnPlayerStateChanged};
	__property TOnEventNotification OnPlayerDurationUpdated = {read=FOnPlayerDurationUpdated, write=FOnPlayerDurationUpdated};
	__property TOnAuthenticationNeeded OnAuthenticationNeeded = {read=FOnAuthenticationNeeded, write=FOnAuthenticationNeeded};
	__property TOnRawAudioSample OnRawAudioSample = {read=FOnRawAudioSample, write=FOnRawAudioSample};
	__property TOnRawVideoSample OnRawVideoSample = {read=FOnRawVideoSample, write=FOnRawVideoSample};
	__property TOnRecordingCompleted OnRecordingCompleted = {read=FOnRecordingCompleted, write=FOnRecordingCompleted};
	__property TOnEventNotification OnRecordingPaused = {read=FOnRecordingPaused, write=FOnRecordingPaused};
	__property TOnEventNotification OnRecordingReadyToStart = {read=FOnRecordingReadyToStart, write=FOnRecordingReadyToStart};
	__property TOnFileNotification OnRecordingStarted = {read=FOnRecordingStarted, write=FOnRecordingStarted};
	__property TOnSourceFileToDestFileCompleted OnReencodingCompleted = {read=FOnReencodingCompleted, write=FOnReencodingCompleted};
	__property TOnProgress OnReencodingProgress = {read=FOnReencodingProgress, write=FOnReencodingProgress};
	__property TOnSourceFileToDestFileStarted OnReencodingStarted = {read=FOnReencodingStarted, write=FOnReencodingStarted};
	__property TOnEventNotification OnReinitializing = {read=FOnReinitializing, write=FOnReinitializing};
	__property TOnResizeVideo OnResizeVideo = {read=FOnResizeVideo, write=FOnResizeVideo};
	__property TOnEventNotification OnStoppingGraph = {read=FOnStoppingGraph, write=FOnStoppingGraph};
	__property TOnEventNotification OnStoppingGraphCompleted = {read=FOnStoppingGraphCompleted, write=FOnStoppingGraphCompleted};
	__property TOnTextOverlayScrollingCompleted OnTextOverlayScrollingCompleted = {read=FOnTextOverlayScrollingCompleted, write=FOnTextOverlayScrollingCompleted};
	__property TOnThirdPartyFilterAdded OnThirdPartyFilterAdded = {read=FOnThirdPartyFilterAdded, write=FOnThirdPartyFilterAdded};
	__property TOnThirdPartyFilterConnected OnThirdPartyFilterConnected = {read=FOnThirdPartyFilterConnected, write=FOnThirdPartyFilterConnected};
	__property TOnThirdPartyFilterConnected2 OnThirdPartyFilterConnected2 = {read=FOnThirdPartyFilterConnected2, write=FOnThirdPartyFilterConnected2};
	__property TOnThreadSync OnThreadSync = {read=FOnThreadSync, write=FOnThreadSync};
	__property TOnEventNotification OnTVChannelScanCompleted = {read=FOnTVChannelScanCompleted, write=FOnTVChannelScanCompleted};
	__property TOnTVChannelScanStarted OnTVChannelScanStarted = {read=FOnTVChannelScanStarted, write=FOnTVChannelScanStarted};
	__property TOnTVChannelSelected OnTVChannelSelected = {read=FOnTVChannelSelected, write=FOnTVChannelSelected};
	__property TOnVideoCompressionSettings OnVideoCompressionSettings = {read=FOnVideoCompressionSettings, write=FOnVideoCompressionSettings};
	__property TOnEventNotification OnVideoDeviceSelected = {read=FOnVideoDeviceSelected, write=FOnVideoDeviceSelected};
	__property TOnVideoFromBitmapsNextFrameNeeded OnVideoFromBitmapsNextFrameNeeded = {read=FOnVideoFromBitmapsNextFrameNeeded, write=FOnVideoFromBitmapsNextFrameNeeded};
public:
	/* TWinControl.CreateParented */ inline __fastcall TVideoGrabber(HWND ParentWindow) : Vcl::Extctrls::TCustomPanel(ParentWindow) { }
	
};


//-- var, const, procedure ---------------------------------------------------
static _DELPHI_CONST System::Int8 I_MAX_FFMPEGFILTERS = System::Int8(0x9);
static _DELPHI_CONST System::Int8 ENCODER_RECORDING_ID = System::Int8(0x0);
static _DELPHI_CONST System::Int8 ENCODER_STREAMING_ID = System::Int8(0x1);
static _DELPHI_CONST System::Int8 ENCODER_LAST_ID = System::Int8(0x1);
static _DELPHI_CONST System::Int8 ENCODER_NEXT_ID = System::Int8(0x2);
static _DELPHI_CONST bool DEF_AdjustOverlayAspectRatio = true;
static _DELPHI_CONST bool DEF_AdjustPixelAspectRatio = true;
static _DELPHI_CONST TAero DEF_Aero = (TAero)(0);
static _DELPHI_CONST TApplicationPriority DEF_ApplicationPriority = (TApplicationPriority)(0);
static _DELPHI_CONST TOpenURLAsyncStatus DEF_OpenURLAsyncStatus = (TOpenURLAsyncStatus)(3);
static _DELPHI_CONST System::Int8 DEF_ASFAudioBitRate = System::Int8(-1);
static _DELPHI_CONST System::Int8 DEF_ASFAudioChannels = System::Int8(-1);
static _DELPHI_CONST System::Int8 DEF_ASFBufferWindow = System::Int8(-1);
static _DELPHI_CONST TASFDeinterlaceMode DEF_ASFDeinterlaceMode = (TASFDeinterlaceMode)(0);
static _DELPHI_CONST bool DEF_ASFDirectStreamingKeepClientsConnected = false;
static _DELPHI_CONST bool DEF_ASFFixedFrameRate = true;
static _DELPHI_CONST bool DEF_ASFMediaServerRemovePublishingPointAfterDisconnect = false;
static _DELPHI_CONST System::Int8 DEF_ASFNetworkPort = System::Int8(0x0);
static _DELPHI_CONST System::Int8 DEF_ASFNetworkMaxUsers = System::Int8(0x5);
#define DEF_AspectRatioToUse  (-1.000000E+00)
static _DELPHI_CONST System::Int8 DEF_ASFProfile = System::Int8(-1);
static _DELPHI_CONST TASFProfileVersion DEF_ASFProfileVersion = (TASFProfileVersion)(0);
static _DELPHI_CONST System::Int8 DEF_ASFVideoBitRate = System::Int8(-1);
static _DELPHI_CONST System::Int8 DEF_ASFVideoHeight = System::Int8(-1);
static _DELPHI_CONST System::Int8 DEF_ASFVideoMaxKeyFrameSpacing = System::Int8(-1);
static _DELPHI_CONST System::Int8 DEF_ASFVideoQuality = System::Int8(-1);
static _DELPHI_CONST System::Int8 DEF_ASFVideoWidth = System::Int8(-1);
static _DELPHI_CONST bool DEF_AssociateAudioAndVideoDevices = false;
static _DELPHI_CONST System::Int8 DEF_AudioBalance = System::Int8(0x0);
static _DELPHI_CONST TAudioChannelRenderMode DEF_AudioChannelRenderMode = (TAudioChannelRenderMode)(0);
static _DELPHI_CONST System::Int8 DEF_AudioDevice = System::Int8(-1);
static _DELPHI_CONST System::Int8 DEF_AudioRenderer = System::Int8(-1);
static _DELPHI_CONST System::Word DEF_AudioVolume = System::Word(0x7fff);
static _DELPHI_CONST bool DEF_AudioVolumeEnabled = true;
static _DELPHI_CONST System::Int8 DEF_AudioStreamNumber = System::Int8(-1);
static _DELPHI_CONST TAudioFormat DEF_AudioFormat = (TAudioFormat)(0);
static _DELPHI_CONST bool DEF_AudioDeviceRendering = false;
static _DELPHI_CONST bool DEF_OpenURLAsync = true;
static _DELPHI_CONST bool DEF_AudioSyncAdjustmentEnabled = false;
static _DELPHI_CONST System::Int8 DEF_AudioSyncAdjustment = System::Int8(0x0);
static _DELPHI_CONST System::Int8 DEF_MixAudioSamplesLevel = System::Int8(0x64);
static _DELPHI_CONST System::Int8 DEF_Mixer_MosaicColumns = System::Int8(0x1);
static _DELPHI_CONST System::Int8 DEF_Mixer_MosaicLines = System::Int8(0x1);
static _DELPHI_CONST bool DEF_AudioPeakEvent = true;
static _DELPHI_CONST bool DEF_AudioRecording = false;
static _DELPHI_CONST TAudioSource DEF_AudioSource = (TAudioSource)(0);
static _DELPHI_CONST TVuMeter DEF_VuMeter = (TVuMeter)(0);
static _DELPHI_CONST bool DEF_AutoConnectRelatedPins = true;
static _DELPHI_CONST TAutoFileName DEF_AutoFileName = (TAutoFileName)(0);
static _DELPHI_CONST System::Int8 DEF_AutoFileNameMinDigits = System::Int8(0x6);
static _DELPHI_CONST bool DEF_AutoRefreshPreview = false;
static _DELPHI_CONST bool DEF_AutoStartPlayer = true;
static _DELPHI_CONST bool DEF_AVIFormatOpenDML = true;
static _DELPHI_CONST bool DEF_AVIFormatOpenDMLCompatibilityIndex = true;
static _DELPHI_CONST bool DEF_AVIDurationUpdated = true;
static _DELPHI_CONST int DEF_BackgroundColor = int(0);
static _DELPHI_CONST System::Int8 DEF_BufferCount = System::Int8(-1);
static _DELPHI_CONST System::Int8 DEF_BurstCount = System::Int8(0x3);
static _DELPHI_CONST Vcl::Forms::TFormBorderStyle DEF_BorderStyle = (Vcl::Forms::TFormBorderStyle)(1);
static _DELPHI_CONST System::Int8 DEF_BurstInterval = System::Int8(0x0);
static _DELPHI_CONST bool DEF_BurstMode = false;
static _DELPHI_CONST TFrameCaptureDest DEF_BurstType = (TFrameCaptureDest)(0);
static _DELPHI_CONST short DEF_BusyCursor = short(-11);
static _DELPHI_CONST short DEF_NormalCursor = short(0);
static _DELPHI_CONST bool DEF_CameraControlSettings = true;
static _DELPHI_CONST int DEF_ColorKey = int(0x100010);
static _DELPHI_CONST bool DEF_ColorKeyEnabled = false;
static _DELPHI_CONST TCompressionMode DEF_CompressionMode = (TCompressionMode)(1);
static _DELPHI_CONST TCompressionType DEF_CompressionType = (TCompressionType)(0);
static _DELPHI_CONST short DEF_Cursor = short(0);
static _DELPHI_CONST bool DEF_Display_Active = true;
static _DELPHI_CONST bool DEF_Display_AlphaBlendEnabled = false;
static _DELPHI_CONST System::Byte DEF_Display_AlphaBlendValue = System::Byte(0xb4);
static _DELPHI_CONST bool DEF_Display_TransparentColorEnabled = false;
static _DELPHI_CONST System::Byte DEF_Display_TransparentColorValue = System::Byte(0xff);
static _DELPHI_CONST bool DEF_Display_AutoSize = false;
static _DELPHI_CONST TAspectRatio DEF_Display_AspectRatio = (TAspectRatio)(0);
static _DELPHI_CONST bool DEF_Display_Embedded = true;
static _DELPHI_CONST bool DEF_Display_Embedded_FitParent = false;
static _DELPHI_CONST System::Int8 DEF_Display_ExternalRenderer = System::Int8(-1);
static _DELPHI_CONST bool DEF_Display_FullScreen = false;
static _DELPHI_CONST System::Word DEF_Display_Height = System::Word(0x2d0);
static _DELPHI_CONST System::Int8 DEF_Display_Left = System::Int8(0xa);
static _DELPHI_CONST bool DEF_Display_StayOnTop = false;
static _DELPHI_CONST System::Int8 DEF_Display_Monitor = System::Int8(0x0);
static _DELPHI_CONST bool DEF_Display_MouseMovesWindow = true;
static _DELPHI_CONST System::Int8 DEF_Display_PanScanRatio = System::Int8(0x32);
static _DELPHI_CONST System::Int8 DEF_Display_Top = System::Int8(0xa);
static _DELPHI_CONST bool DEF_Display_VideoPortEnabled = true;
static _DELPHI_CONST bool DEF_Display_Visible = true;
static _DELPHI_CONST System::Word DEF_Display_Width = System::Word(0x500);
static _DELPHI_CONST bool DEF_DoubleBuffered = true;
static _DELPHI_CONST bool DEF_DualDisplay_AutoSize = false;
static _DELPHI_CONST System::Int8 DEF_DualDisplay_Left = System::Int8(0x14);
static _DELPHI_CONST System::Word DEF_DualDisplay_Top = System::Word(0x190);
static _DELPHI_CONST System::Int8 DEF_DroppedFramesPollingInterval = System::Int8(-1);
static _DELPHI_CONST bool DEF_DualDisplay_Active = false;
static _DELPHI_CONST bool DEF_DualDisplay_Embedded = false;
static _DELPHI_CONST bool DEF_DualDisplay_Embedded_FitParent = false;
static _DELPHI_CONST bool DEF_DualDisplay_VideoPortEnabled = false;
static _DELPHI_CONST bool DEF_DVDateTimeEnabled = true;
static _DELPHI_CONST System::Int8 DEF_DVDTitle = System::Int8(0x0);
static _DELPHI_CONST System::Int8 DEF_DVDiscontinuityMinimumInterval = System::Int8(0x3);
static _DELPHI_CONST bool DEF_DVRgb219 = false;
static _DELPHI_CONST bool DEF_DVReduceFrameRate = false;
static _DELPHI_CONST bool DEF_DVRecordingInNativeFormatSeparatesStreams = false;
static _DELPHI_CONST bool DEF_DVTimeCodeEnabled = false;
static _DELPHI_CONST bool DEF_EventNotificationSynchrone = true;
static _DELPHI_CONST bool DEF_Cropping_Enabled = false;
static _DELPHI_CONST System::Int8 DEF_Cropping_Height = System::Int8(0x78);
static _DELPHI_CONST bool DEF_Cropping_Outbounds = true;
static _DELPHI_CONST System::Byte DEF_Cropping_Width = System::Byte(0xa0);
static _DELPHI_CONST System::Int8 DEF_Cropping_X = System::Int8(0x0);
static _DELPHI_CONST System::Int8 DEF_Cropping_Y = System::Int8(0x0);
#define DEF_Cropping_Zoom  (1.000000E+00)
static _DELPHI_CONST TDVVideoFormat DEF_DVEncoder_VideoFormat = (TDVVideoFormat)(1);
static _DELPHI_CONST TDVVideoStandard DEF_DVEncoder_VideoStandard = (TDVVideoStandard)(0);
static _DELPHI_CONST TDVSize DEF_DVEncoder_VideoResolution = (TDVSize)(0);
static _DELPHI_CONST TEncryptionMethod DEF_EncryptionMethod = (TEncryptionMethod)(0);
static _DELPHI_CONST TFiltersSet DEF_FiltersSet = (TFiltersSet)(0);
static _DELPHI_CONST bool DEF_FixFlickerOrBlackCapture = false;
static _DELPHI_CONST bool DEF_FrameCaptureWithoutOverlay = false;
static _DELPHI_CONST System::Int8 DEF_FrameCaptureZoomSize = System::Int8(0x64);
static _DELPHI_CONST System::Int8 DEF_FrameCaptureWidth = System::Int8(-1);
static _DELPHI_CONST System::Int8 DEF_FrameCaptureHeight = System::Int8(-1);
static _DELPHI_CONST bool DEF_FrameNumberStartsFromZero = false;
static _DELPHI_CONST TFrameGrabber DEF_FrameGrabber = (TFrameGrabber)(0);
static _DELPHI_CONST TFrameGrabberRGBFormat DEF_FrameGrabberRGBFormat = (TFrameGrabberRGBFormat)(0);
static _DELPHI_CONST System::Int8 DEF_FrameRateDivider = System::Int8(0x0);
static _DELPHI_CONST System::Int8 DEF_GetLastFrameWaitTimeoutMs = System::Int8(0x0);
static _DELPHI_CONST bool Def_GeneratePts = false;
static _DELPHI_CONST System::Word DEF_IPCameraConnectionTimeout = System::Word(0x4e21);
static _DELPHI_CONST System::Word DEF_IPCameraReceiveTimeout = System::Word(0x1389);
static _DELPHI_CONST System::Word DEF_StreamInterfaceConnectionTimeout = System::Word(0x7d0);
static _DELPHI_CONST System::Word DEF_StreamInterfaceReceiveTimeout = System::Word(0x7d0);
static _DELPHI_CONST bool DEF_HoldRecording = false;
static _DELPHI_CONST bool DEF_ImageOverlay_AlphaBlend = false;
static _DELPHI_CONST bool DEF_ImageOverlay_ChromaKey = false;
static _DELPHI_CONST System::Byte DEF_ImageOverlay_AlphaBlendValue = System::Byte(0xb4);
static _DELPHI_CONST System::Int8 DEF_ImageOverlay_ChromaKeyLeewayPercent = System::Int8(0x19);
static _DELPHI_CONST System::Int8 DEF_ImageOverlay_ChromaKeyRGBColor = System::Int8(0x0);
static _DELPHI_CONST System::Int8 DEF_ImageOverlay_Height = System::Int8(-1);
static _DELPHI_CONST System::Int8 DEF_ImageOverlay_LeftLocation = System::Int8(0xa);
static _DELPHI_CONST bool DEF_ImageOverlay_StretchToVideoSize = false;
static _DELPHI_CONST System::Int8 DEF_ImageOverlay_TopLocation = System::Int8(0xa);
static _DELPHI_CONST bool DEF_ImageOverlay_Transparent = false;
static _DELPHI_CONST System::Int8 DEF_ImageOverlay_TransparentColorValue = System::Int8(0x0);
static _DELPHI_CONST bool DEF_ImageOverlay_UseTransparentColor = false;
static _DELPHI_CONST System::Int8 DEF_ImageOverlay_Width = System::Int8(-1);
static _DELPHI_CONST bool DEF_ImageOverlayEnabled = false;
static _DELPHI_CONST TJPEGPerformance DEF_JPEGPerformance = (TJPEGPerformance)(0);
static _DELPHI_CONST bool DEF_JPEGProgressiveDisplay = false;
static _DELPHI_CONST System::Int8 DEF_JPEGQuality = System::Int8(0x64);
static _DELPHI_CONST bool DEF_LogoDisplayed = false;
static _DELPHI_CONST TLogoLayout DEF_LogoLayout = (TLogoLayout)(1);
static _DELPHI_CONST bool DEF_MotionDetector_CompareBlue = true;
static _DELPHI_CONST bool DEF_MotionDetector_CompareGreen = true;
static _DELPHI_CONST bool DEF_MotionDetector_GreyScale = false;
static _DELPHI_CONST bool DEF_MotionDetector_CompareRed = true;
static _DELPHI_CONST bool DEF_MotionDetector_Enabled = false;
static _DELPHI_CONST System::Int8 DEF_MotionDetector_MaxDetectionsPerSecond = System::Int8(0x0);
static _DELPHI_CONST System::Int8 DEF_MotionDetector_ReduceCPULoad = System::Int8(0x1);
static _DELPHI_CONST System::Int8 DEF_MotionDetector_MotionResetMs = System::Int8(0x0);
static _DELPHI_CONST bool DEF_MotionDetector_ReduceVideoNoise = false;
static _DELPHI_CONST bool DEF_MotionDetector_Triggered = false;
static _DELPHI_CONST bool DEF_MouseWheelEventEnabled = true;
static _DELPHI_CONST bool DEF_MouseWheelControlsZoomAtCursor = false;
static _DELPHI_CONST bool DEF_MultiplexedInputEmulation = true;
static _DELPHI_CONST TMultiplexedRole DEF_MultiplexedRole = (TMultiplexedRole)(0);
static _DELPHI_CONST System::Int8 DEF_MultiplexedSwitchDelay = System::Int8(0x0);
static _DELPHI_CONST System::Int8 DEF_MultiplexedStabilizationDelay = System::Int8(0x64);
static _DELPHI_CONST System::Int8 DEF_Multiplexer = System::Int8(-1);
static _DELPHI_CONST bool DEF_MuteAudioRendering = false;
static _DELPHI_CONST System::Word DEF_NDIReceiveTimeoutMs = System::Word(0x1388);
static _DELPHI_CONST TNDIBandwidthType DEF_NDIBandwidthType = (TNDIBandwidthType)(3);
static _DELPHI_CONST TNDIFormatType DEF_NDIFormatType = (TNDIFormatType)(1);
static _DELPHI_CONST TNetworkStreaming DEF_NetworkStreaming = (TNetworkStreaming)(0);
static _DELPHI_CONST TNetworkStreamingType DEF_NetworkStreamingType = (TNetworkStreamingType)(0);
static _DELPHI_CONST TNotificationMethod DEF_NotificationMethod = (TNotificationMethod)(1);
static _DELPHI_CONST System::Int8 DEF_NotificationSleepTime = System::Int8(-1);
static _DELPHI_CONST System::Classes::TThreadPriority DEF_NotificationPriority = (System::Classes::TThreadPriority)(3);
static _DELPHI_CONST bool DEF_OverlayAfterTransform = false;
static _DELPHI_CONST TVideoAlignment DEF_OverlayAlignment = (TVideoAlignment)(0);
static _DELPHI_CONST bool DEF_OnFrameBitmapEventSynchrone = false;
static _DELPHI_CONST bool DEF_OverlayEventCallbackAllowed = false;
static _DELPHI_CONST System::Int8 DEF_OverlayTargetDisplay = System::Int8(-1);
static _DELPHI_CONST bool DEF_PlayerAudioRendering = true;
static _DELPHI_CONST TDVSize DEF_PlayerDVSize = (TDVSize)(0);
static _DELPHI_CONST System::Int8 DEF_PlayerFastSeekSpeedRatio = System::Int8(0x4);
static _DELPHI_CONST THwAccel DEF_PlayerHwAccel = (THwAccel)(0);
static _DELPHI_CONST bool DEF_PlayerRefreshPausedDisplay = false;
#define DEF_PlayerRefreshPausedDisplayFrameRate  (0.000000E+00)
static _DELPHI_CONST System::Int8 DEF_PlayerSpeedRatio = System::Int8(0x1);
static _DELPHI_CONST bool DEF_PlayerSpeedRatioConstantAudioPitch = true;
static _DELPHI_CONST bool DEF_PreallocCapFileCopiedAfterRecording = true;
static _DELPHI_CONST bool DEF_PlayerTrackBarSynchrone = false;
static _DELPHI_CONST bool DEF_PreallocCapFileEnabled = false;
static _DELPHI_CONST System::Int8 DEF_PreallocCapFileSizeInMB = System::Int8(0x64);
static _DELPHI_CONST System::Int8 DEF_PreviewZoomSize = System::Int8(0x64);
static _DELPHI_CONST bool DEF_QuickDeviceInitialization = false;
static _DELPHI_CONST bool DEF_RawAudioSampleCapture = false;
static _DELPHI_CONST bool DEF_RawCaptureAsyncEvent = true;
static _DELPHI_CONST TRawSampleCaptureLocation DEF_RawSampleCaptureLocation = (TRawSampleCaptureLocation)(0);
static _DELPHI_CONST bool DEF_RawVideoSampleCapture = false;
static _DELPHI_CONST System::Int8 DEF_RecordingAudioBitRate = System::Int8(-1);
static _DELPHI_CONST System::Int8 DEF_RecordingVideoBitRate = System::Int8(-1);
static _DELPHI_CONST bool DEF_RecordingInNativeFormat = true;
static _DELPHI_CONST System::Int8 DEF_RecordingFileSizeMaxInMB = System::Int8(0x0);
static _DELPHI_CONST TRecordingMethod DEF_RecordingMethod = (TRecordingMethod)(5);
static _DELPHI_CONST bool DEF_RecordingPauseCreatesNewFile = false;
static _DELPHI_CONST bool DEF_RecordingOnMotion_Enabled = false;
static _DELPHI_CONST System::Int8 DEF_RecordingOnMotion_MotionThreshold = System::Int8(0x0);
static _DELPHI_CONST System::Word DEF_RecordingOnMotion_NoMotionPauseDelayMs = System::Word(0x1388);
static _DELPHI_CONST TRecordingTimer DEF_RecordingTimer = (TRecordingTimer)(0);
static _DELPHI_CONST System::Int8 DEF_RecordingTimerInterval = System::Int8(0x3c);
static _DELPHI_CONST System::Int8 DEF_NoTimeSpecified = System::Int8(-1);
static _DELPHI_CONST bool DEF_Reencoding_IncludeAudioStream = true;
static _DELPHI_CONST bool DEF_Reencoding_IncludeVideoStream = true;
static _DELPHI_CONST TRecordingMethod DEF_Reencoding_Method = (TRecordingMethod)(1);
static _DELPHI_CONST bool DEF_Reencoding_UseAudioCompressor = false;
static _DELPHI_CONST bool DEF_Reencoding_UseFrameGrabber = true;
static _DELPHI_CONST bool DEF_Reencoding_UseVideoCompressor = false;
static _DELPHI_CONST bool DEF_Reencoding_WMVOutput = false;
static _DELPHI_CONST TRecordingSize DEF_RecordingSize = (TRecordingSize)(0);
static _DELPHI_CONST System::Int8 DEF_ScreenRecordingMonitor = System::Int8(0x0);
static _DELPHI_CONST bool DEF_ScreenRecordingLayeredWindows = false;
static _DELPHI_CONST bool DEF_ScreenRecordingNonVisibleWindows = false;
static _DELPHI_CONST bool DEF_ScreenRecordingThroughClipboard = false;
static _DELPHI_CONST bool DEF_ScreenRecordingWithCursor = true;
static _DELPHI_CONST System::Int8 DEF_ScreenRecordingSizePercent = System::Int8(0x64);
static _DELPHI_CONST System::Int8 DEF_ServerLostRetryCount = System::Int8(0x0);
static _DELPHI_CONST System::Int8 DEF_ServerLostRetryInterval = System::Int8(0x5);
static _DELPHI_CONST System::Int8 DEF_SendToDV_DeviceIndex = System::Int8(-1);
static _DELPHI_CONST bool DEF_ShapeOverlayEnabled = false;
static _DELPHI_CONST bool DEF_SpeakerControl = false;
static _DELPHI_CONST bool DEF_StoreDeviceSettingsInRegistry = true;
static _DELPHI_CONST TStoragePathMode DEF_StoragePathMode = (TStoragePathMode)(0);
static _DELPHI_CONST bool DEF_Synchronized = false;
static _DELPHI_CONST TSynchronizationRole DEF_SynchronizationRole = (TSynchronizationRole)(0);
static _DELPHI_CONST bool DEF_SyncCommands = true;
static _DELPHI_CONST TSyncPreview DEF_SyncPreview = (TSyncPreview)(0);
static _DELPHI_CONST bool DEF_TextOverlay_Enabled = false;
static _DELPHI_CONST bool DEF_TextOverlay_AlphaBlend = false;
static _DELPHI_CONST System::Byte DEF_TextOverlay_AlphaBlendValue = System::Byte(0xb4);
static _DELPHI_CONST int DEF_TextOverlay_FontColor = int(0xffff00);
static _DELPHI_CONST System::Int8 DEF_TextOverlay_FontSize = System::Int8(0xc);
static _DELPHI_CONST System::Int8 DEF_TextOverlay_Left = System::Int8(0x0);
static _DELPHI_CONST System::Int8 DEF_TextOverlay_Top = System::Int8(0x0);
static _DELPHI_CONST System::Int8 DEF_TextOverlay_Right = System::Int8(-1);
static _DELPHI_CONST bool DEF_TextOverlay_Scrolling = false;
static _DELPHI_CONST System::Int8 DEF_TextOverlay_ScrollingSpeed = System::Int8(0x1);
static _DELPHI_CONST bool DEF_TextOverlay_Shadow = true;
static _DELPHI_CONST TTextOrientation DEF_TextOverlay_Orientation = (TTextOrientation)(0);
static _DELPHI_CONST int DEF_TextOverlay_ShadowColor = int(0);
static _DELPHI_CONST TCardinalDirection DEF_TextOverlay_ShadowDirection = (TCardinalDirection)(3);
static _DELPHI_CONST int DEF_TextOverlay_BkColor = int(16777215);
static _DELPHI_CONST TTextOverlayGradientMode DEF_TextOverlay_GradientMode = (TTextOverlayGradientMode)(0);
static _DELPHI_CONST int DEF_TextOverlay_GradientColor = int(8388608);
static _DELPHI_CONST TTextOverlayAlign DEF_TextOverlay_Align = (TTextOverlayAlign)(0);
static _DELPHI_CONST bool DEF_TextOverlay_HighResFont = true;
static _DELPHI_CONST bool DEF_TextOverlay_Transparent = true;
static _DELPHI_CONST bool DEF_TranslateMouseCoordinates = true;
static _DELPHI_CONST bool DEF_TVUseFrequencyOverrides = false;
static _DELPHI_CONST System::Int8 DEF_TunerFrequency = System::Int8(-1);
static _DELPHI_CONST TTunerMode DEF_TunerMode = (TTunerMode)(0);
static _DELPHI_CONST bool DEF_UseClock = true;
static _DELPHI_CONST bool DEF_v360_Enabled = false;
static _DELPHI_CONST System::Int8 DEF_v360_MouseActionPercent = System::Int8(0xa);
static _DELPHI_CONST TV360_MouseAction DEF_v360_MouseAction = (TV360_MouseAction)(2);
static _DELPHI_CONST Tv360_Angle DEF_v360_MasterAngle = (Tv360_Angle)(1);
#define DEF_v360_AspectRatio  (0.000000E+00)
static _DELPHI_CONST System::Int8 DEF_VideoDelay = System::Int8(0x0);
static _DELPHI_CONST System::Int8 DEF_VideoDevice = System::Int8(-1);
static _DELPHI_CONST System::Int8 DEF_VideoCompression_DataRate = System::Int8(-1);
static _DELPHI_CONST System::Int8 DEF_VideoCompression_KeyFrameRate = System::Int8(0xf);
static _DELPHI_CONST System::Int8 DEF_VideoCompression_PFramesPerKeyFrame = System::Int8(0x0);
static _DELPHI_CONST System::Int8 DEF_VideoCompression_Quality = System::Int8(0x1);
static _DELPHI_CONST System::Int8 DEF_VideoCompression_WindowSize = System::Int8(-1);
static _DELPHI_CONST System::Int8 DEF_StoredValueDefaults = System::Int8(-1);
static _DELPHI_CONST bool DEF_VideoControlSettings = true;
static _DELPHI_CONST TFileSort DEF_VideoFromImages_BitmapsSortedBy = (TFileSort)(0);
static _DELPHI_CONST bool DEF_VideoFromImages_RepeatIndefinitely = false;
static _DELPHI_CONST bool DEF_VideoPlayableWhileRecording = false;
static _DELPHI_CONST System::Int8 DEF_VideoProcessing_Brightness = System::Int8(0x0);
static _DELPHI_CONST System::Int8 DEF_VideoProcessing_Contrast = System::Int8(0x0);
static _DELPHI_CONST TVideoDeinterlacing DEF_VideoProcessing_Deinterlacing = (TVideoDeinterlacing)(0);
static _DELPHI_CONST bool DEF_VideoProcessing_FlipHorizontal = false;
static _DELPHI_CONST bool DEF_VideoProcessing_FlipVertical = false;
static _DELPHI_CONST bool DEF_VideoProcessing_GrayScale = false;
static _DELPHI_CONST System::Int8 DEF_VideoProcessing_Hue = System::Int8(0x0);
static _DELPHI_CONST bool DEF_VideoProcessing_InvertColors = false;
static _DELPHI_CONST System::Int8 DEF_VideoProcessing_Pixellization = System::Int8(0x1);
static _DELPHI_CONST System::Int8 DEF_VideoProcessing_Saturation = System::Int8(0x0);
static _DELPHI_CONST TVideoRotation DEF_VideoProcessing_Rotation = (TVideoRotation)(0);
#define DEF_VideoProcessing_RotationCustomAngle  (4.550000E+01)
static _DELPHI_CONST System::Int8 DEF_VideoSampling_TimeInterval_Ms = System::Int8(0x0);
static _DELPHI_CONST System::Int8 DEF_VideoSampling_FinalFrameRate_x100 = System::Int8(0x0);
static _DELPHI_CONST bool DEF_VideoQualitySettings = true;
static _DELPHI_CONST TVideoRenderer DEF_VideoRenderer = (TVideoRenderer)(0);
static _DELPHI_CONST TVideoRendererPriority DEF_VideoRendererPriority = (TVideoRendererPriority)(2);
static _DELPHI_CONST TVideoRendererExternal DEF_VideoRendererExternal = (TVideoRendererExternal)(0);
static _DELPHI_CONST System::Int8 DEF_VideoRendererExternalIndex = System::Int8(-1);
static _DELPHI_CONST TVideoSource DEF_VideoSource = (TVideoSource)(0);
static _DELPHI_CONST System::Int8 DEF_VideoStreamNumber = System::Int8(-1);
static _DELPHI_CONST bool DEF_VideoVisibleWhenStopped = false;
static _DELPHI_CONST System::Int8 DEF_VirtualVideoStreamControl = System::Int8(-1);
static _DELPHI_CONST System::Int8 DEF_VirtualAudioStreamControl = System::Int8(-1);
static _DELPHI_CONST TWebcamStillCaptureButton DEF_WebcamStillCaptureButton = (TWebcamStillCaptureButton)(0);
static _DELPHI_CONST System::Int8 DEF_ZoomYCenter = System::Int8(0x0);
static _DELPHI_CONST System::Int8 DEF_ZoomXCenter = System::Int8(0x0);
static _DELPHI_CONST System::Word DEF_ZoomCoeff = System::Word(0x3e8);
#define DATASTEADREGENTRY L"\\Software\\Datastead\\"
#define DEFAULTREGIDNAME L"\\Software\\Datastead\\TVideoGrabber\\"
extern DELPHI_PACKAGE HKEY RegRootKey;
extern DELPHI_PACKAGE System::UnicodeString RegKeyId;
extern DELPHI_PACKAGE bool _IsVgAx;
extern DELPHI_PACKAGE void __fastcall Register(void);
}	/* namespace Vidgrab */
#if !defined(DELPHIHEADER_NO_IMPLICIT_NAMESPACE_USE) && !defined(NO_USING_NAMESPACE_VIDGRAB)
using namespace Vidgrab;
#endif
#pragma pack(pop)
#pragma option pop

#pragma delphiheader end.
//-- end unit ----------------------------------------------------------------
#endif	// VidGrabHPP
