// CodeGear C++Builder
// Copyright (c) 1995, 2013 by Embarcadero Technologies, Inc.
// All rights reserved

// (DO NOT EDIT: machine generated header) 'VidGrab.pas' rev: 25.00 (Windows)

#ifndef VidgrabHPP
#define VidgrabHPP

#pragma delphiheader begin
#pragma option push
#pragma option -w-      // All warnings off
#pragma option -Vx      // Zero-length empty class member 
#pragma pack(push,8)
#include <System.hpp>	// Pascal unit
#include <SysInit.hpp>	// Pascal unit
#include <Winapi.Windows.hpp>	// Pascal unit
#include <Winapi.Messages.hpp>	// Pascal unit
#include <System.Classes.hpp>	// Pascal unit
#include <Vcl.Controls.hpp>	// Pascal unit
#include <Vcl.ComCtrls.hpp>	// Pascal unit
#include <Vcl.Menus.hpp>	// Pascal unit
#include <Vcl.Graphics.hpp>	// Pascal unit
#include <Vcl.ExtCtrls.hpp>	// Pascal unit
#include <Vcl.Forms.hpp>	// Pascal unit
#include <Winapi.ActiveX.hpp>	// Pascal unit
#include <System.UITypes.hpp>	// Pascal unit
#include <System.Types.hpp>	// Pascal unit

//-- user supplied -----------------------------------------------------------
typedef __int64 LargeInteger;
typedef __int64 Int64;

namespace Vidgrab
{
//-- type declarations -------------------------------------------------------
typedef __int64 LargeInteger;

typedef unsigned LongWord_;

enum DECLSPEC_DENUM TJPEGPerformance : unsigned int { jpBestQuality, jpBestSpeed };

enum DECLSPEC_DENUM TVideoAlignment : unsigned int { oa_LeftTop, oa_CenterTop, oa_RightTop, oa_LeftCenter, oa_Center, oa_RightCenter, oa_LeftBottom, oa_CenterBottom, oa_RightBottom };

enum DECLSPEC_DENUM TFrameGrabber : unsigned int { fg_BothStreams, fg_PreviewStream, fg_CaptureStream, fg_Disabled };

enum DECLSPEC_DENUM TFrameGrabberRGBFormat : unsigned int { fgf_Default, fgf_RGB32, fgf_RGB24, fgf_RGB565, fgf_RGB555, fgf_RGB8, fgf_ARGB32 };

enum DECLSPEC_DENUM TAutoFileName : unsigned int { fn_Sequential, fn_DateTime, fn_Counter, fn_Modulo, fn_GUID };

enum DECLSPEC_DENUM TCompressionMode : unsigned int { cm_NoCompression, cm_CompressOnTheFly, cm_CompressAfterRecording };

enum DECLSPEC_DENUM TCompressionType : unsigned int { ct_Video, ct_Audio, ct_AudioVideo };

enum DECLSPEC_DENUM TCurrentState : unsigned int { cs_Down, cs_Preview, cs_Recording, cs_Playback, cs_Reencoding };

enum DECLSPEC_DENUM TFrameCaptureDest : unsigned int { fc_TBitmap, fc_BmpFile, fc_JpegFile, fc_Clipboard, fc_TiffFile, fc_PngFile };

enum DECLSPEC_DENUM TDVSize : unsigned int { dv_Full, dv_Half, dv_Quarter, dv_DC };

enum DECLSPEC_DENUM TTVChannelInfo : unsigned int { tci_Channel, tci_DefaultVideoFrequency, tci_OverriddenVideoFrequency, tci_TunerVideoFrequency, tci_TunerAudioFrequency, tci_Locked };

enum DECLSPEC_DENUM TWebcamStillCaptureButton : unsigned int { wb_Disabled, wb_Enabled };

enum DECLSPEC_DENUM TDVVideoStandard : unsigned int { dvs_Default, dvs_PAL, dvs_NTSC };

enum DECLSPEC_DENUM TDVVideoFormat : unsigned int { dvf_Default, dvf_DVSD, dvf_DVHD, dvf_DVSL };

enum DECLSPEC_DENUM TEncryptionMethod : unsigned int { em_Fast_Encryption, em_AES_Encryption };

enum DECLSPEC_DENUM TAVIInfoType : unsigned int { av_Duration, av_FrameCount, av_VideoWidth, av_VideoHeight, av_VideoFrameRateFps, av_VideoCodec, av_AudioCodec, av_AvgBitRate, av_AudioChannels, av_AudioSamplesPerSec, av_AudioBitsPerSample, av_FileSizeInKB, av_AudioStreams };

enum DECLSPEC_DENUM TFrameBitmapInfoType : unsigned int { fb_VideoWidth, fb_VideoHeight, fb_BitmapSize, fb_BitmapStride, fb_BitsPerPixel };

enum DECLSPEC_DENUM TDVDInfoType : unsigned int { dvd_NumberOfVolumes, dvd_TotalDuration, dvd_NumberOfTitles, dvd_TitleDuration, dvd_TitleFrameRate, dvd_SourceResolutionX, dvd_SourceResolutionY, dvd_TitleFrameCount };

enum DECLSPEC_DENUM TONVIFDeviceInfo : unsigned int { onv_Manufacturer, onv_Model, onv_HardwareId, onv_SerialNumber, onv_FirmwareVersion, onv_PTZInfo, onv_PTZPresets, onv_MacAddress, onv_AuxiliaryCommands, onv_XMLReplay, onv_XMLInfo, onv_XMLProfiles, onv_CurrentProfileName, onv_CurrentProfileToken };

enum DECLSPEC_DENUM THeaderAttribute : unsigned int { ha_Title, ha_Description, ha_Author, ha_Copyright, ha_AlbumArtist, ha_AlbumTitle, ha_Composer, ha_ContentDistributor, ha_Director, ha_EncodingTime, ha_Genre, ha_Language, ha_ParentalRating, ha_Producer, ha_Provider, ha_ToolName, ha_ToolVersion, ha_Writer, ha_IARL, ha_ICMS, ha_ICMT, ha_ICRD, ha_ICRP, ha_IDIM, ha_IDPI, ha_IENG, ha_IGNR, ha_IKEY, ha_ILGT, ha_IMED, ha_IPLT, ha_IPRD, ha_ISFT, ha_ISHP, ha_ISRC, ha_ISRF, ha_ITCH };

enum DECLSPEC_DENUM TDVCommand : unsigned int { dv_Play, dv_Stop, dv_Freeze, dv_Thaw, dv_Ff, dv_Rew, dv_Record, dv_RecordFreeze, dv_RecordStrobe, dv_StepFwd, dv_StepRev, dv_ModeShuttle, dv_PlayFastestFwd, dv_PlaySlowestFwd, dv_PlayFastestRev, dv_PlaySlowestRev };

enum DECLSPEC_DENUM TDialog : unsigned int { dlg_VideoDevice, dlg_VideoCompressor, dlg_AudioCompressor, dlg_StreamConfig, dlg_VfwFormat, dlg_VfwSource, dlg_vfwDisplay, dlg_VideoCrossbar, dlg_AudioCrossbar, dlg_TVTuner, dlg_TVAudio, dlg_AudioDevice, dlg_NetShowConfig, dlg_DScaler, dlg_FFDShowVideo, dlg_FFDShowAudio, dlg_Multiplexer, dlg_None };

enum DECLSPEC_DENUM TTriState : unsigned int { ts_Undefined, ts_False, ts_True };

enum DECLSPEC_DENUM TLogoLayout : unsigned int { lg_Centered, lg_Stretched, lg_Repeated, lg_TopLeft, lg_TopRight, lg_BottomLeft, lg_BottomRight, lg_Boxed };

enum DECLSPEC_DENUM TNotificationMethod : unsigned int { nm_Timer, nm_Thread };

enum DECLSPEC_DENUM TVideoControl : unsigned int { vc_FlipHorizontal, vc_FlipVertical, vc_ExternalTriggerEnable, vc_Trigger };

enum DECLSPEC_DENUM TCardinalDirection : unsigned int { cd_North, cd_NorthEast, cd_East, cd_SouthEast, cd_South, cd_SouthWest, cd_West, cd_NorthWest, cd_Center };

enum DECLSPEC_DENUM TVideoRotation : unsigned int { rt_0_deg, rt_90_deg, rt_180_deg, rt_270_deg, rt_0_deg_mirror, rt_90_deg_mirror, rt_180_deg_mirror, rt_270_deg_mirror, rt_custom_angle, rt_custom_angle_mirror };

enum DECLSPEC_DENUM TV360_MouseAction : unsigned int { ma_Disabled, ma_MouseUp, ma_MouseMove };

enum DECLSPEC_DENUM Tv360_InOut : unsigned int { v360_in, v360_out };

enum DECLSPEC_DENUM Tv360_Angle : unsigned int { v360_fov_Diagonal, v360_fov_Horizontal, v360_fov_Vertical };

enum DECLSPEC_DENUM Tv360_StereoFormat : unsigned int { sf_2DMono, sf_SideBySide, sf_TopBottom };

enum DECLSPEC_DENUM Tv360_Projection : unsigned int { ipp_Equirectangular, ipp_Cubemap_3_2, ipp_Cubemap_6_1, ipp_Equiangular, ipp_Flat, ipp_Dual_fisheye, ipp_Barrel, ipp_Cubemap_1_6, ipp_Stereographic, ipp_Mercator, ipp_Ball, ipp_Hammer, ipp_Sinusoidal, ipp_Fisheye, ipp_Pannini, ipp_Cylindrical, ipp_Perspective, ipp_Tetrahedron, ipp_Barrel_split, ipp_Tspyramid, ipp_Hequirectangular, ipp_Equisolid, ipp_Orthographic, ipp_Octahedron };

enum DECLSPEC_DENUM Tv360_Interpolation : unsigned int { ipl_Bilinear, ipl_Nearest, ipl_Lagrange9, ipl_Bicubic, ipl_Lanczos, ipl_Spline16, ipl_Gaussian, ipl_Mitchell };

enum DECLSPEC_DENUM TVideoDeinterlacing : unsigned int { di_Disabled, di_HalfSize, di_FullSize, di_DScaler, di_AVISynth, di_FFDShow, di_ThirdPartyDeinterlacer };

enum DECLSPEC_DENUM TThirdPartyFilterList : unsigned int { tpf_VideoSource, tpf_VideoPreview, tpf_VideoRecording, tpf_AudioSource, tpf_AudioRendering, tpf_AudioRecording, tpf_VideoRendering, tpf_VideoRenderer, tpf_AudioRenderer, tpf_ThirdPartyVideoSource, tpf_ThirdPartyAudioSource, tpf_AddToGraph };

enum DECLSPEC_DENUM TRecordingSize : unsigned int { rs_Default, rs_HalfSize, rs_QuarterSize };

enum DECLSPEC_DENUM TFormatType : unsigned int { ft_VideoInfo, ft_VideoInfo2, ft_DvInfo, ft_Mpeg1Video, ft_Mpeg2Video, ft_Mpeg1Stream, ft_Mpeg2Stream, ft_MpegStreamType, ft_MpegCustom, ft_WaveFormatEx, ft_Mpeg1Audio, ft_Mpeg2Audio, ft_Mpeg3Audio, ft_OGG, ft_GSM, ft_Unknown };

typedef TFormatType *pFormatType;

enum DECLSPEC_DENUM TAudioFormat : unsigned int { af_default, af_8000_8b_1ch, af_8000_8b_2ch, af_8000_16b_1ch, af_8000_16b_2ch, af_11025_8b_1ch, af_11025_8b_2ch, af_11025_16b_1ch, af_11025_16b_2ch, af_16000_8b_1ch, af_16000_8b_2ch, af_16000_16b_1ch, af_16000_16b_2ch, af_22050_8b_1ch, af_22050_8b_2ch, af_22050_16b_1ch, af_22050_16b_2ch, af_32000_8b_1ch, af_32000_8b_2ch, af_32000_16b_1ch, af_32000_16b_2ch, af_44100_8b_1ch, af_44100_8b_2ch, af_44100_16b_1ch, af_44100_16b_2ch, af_48000_8b_1ch, af_48000_8b_2ch, af_48000_16b_1ch, af_48000_16b_2ch };

enum DECLSPEC_DENUM TAudioChannelRenderMode : unsigned int { acrm_Normal, acrm_RenderLeft, acrm_RenderRight, acrm_MuteLeft, acrm_MuteRight, acrm_Mute_All, acrm_MixLeftAndRight, acrm_PassThru };

enum DECLSPEC_DENUM TVideoRendererPriority : unsigned int { vrp_Speed, vrp_Quality, vrp_Auto };

enum DECLSPEC_DENUM TVideoRenderer : unsigned int { vr_AutoSelect, vr_EVR, vr_VMR9, vr_VMR7, vr_StandardRenderer, vr_OverlayRenderer, vr_RecordingPriority, vr_None, vr_madVR, vr_DatasteadRealtimeRenderer };

enum DECLSPEC_DENUM TVideoRendererExternal : unsigned int { vre_None, vre_Matrox_PRO, vre_Decklink_SD, vre_Decklink_Extreme, vre_Pinnacle_MovieBoard, vre_BlackMagic_Decklink, vre_AJA };

enum DECLSPEC_DENUM TRawSampleCaptureLocation : unsigned int { rl_SourceFormat, rl_AfterCompression };

enum DECLSPEC_DENUM TFiltersSet : unsigned int { fs_Datastead };

enum DECLSPEC_DENUM TPointGreyConfig : unsigned int { pgr_SetRegister, pgr_GetRegister, pgr_SetBufferSize, pgr_GetBufferSize, pgr_SetFormat, pgr_GetFormat };

enum DECLSPEC_DENUM TAuthenticationType : unsigned int { at_PublishingPoint, at_IPCamera, at_StreamingUrl };

enum DECLSPEC_DENUM TIPCameraSetting : unsigned int { ips_ConnectionTimeout, ips_ReceiveTimeout };

enum DECLSPEC_DENUM TStoragePathMode : unsigned int { spm_AutoFileNameOnly, spm_AnyFile };

enum DECLSPEC_DENUM TSynchronizationRole : unsigned int { sr_Master, sr_Slave, sr_Mixer };

enum DECLSPEC_DENUM TTextOrientation : unsigned int { to_Horizontal, to_Vertical, to_VerticalInverted };

enum DECLSPEC_DENUM TTrackbarAction : unsigned int { tba_MouseDown, tba_MouseUp, tba_KeyDown, tba_KeyUp };

enum DECLSPEC_DENUM TTextOverlayGradientMode : unsigned int { gm_Disabled, gm_Horizontal, gm_Vertical, gm_ForwardDiagonal, gm_BackwardDiagonal };

enum DECLSPEC_DENUM TMultipurposeEncoderInstance : unsigned int { mpe_Recording, mpe_Streaming, mpe_Reencoding, mpe_Edit };

enum DECLSPEC_DENUM TGPUEncoder : unsigned int { Enc_GPU_None, Enc_GPU_Auto, Enc_GPU_Intel_QSV, Enc_GPU_NVidia_NVENC, Enc_GPU_AMD_AMF };

enum DECLSPEC_DENUM TAudioPCMFormat : unsigned int { PCM_U8, PCM_S16, PCM_S32, PCM_FLT, PCM_DBL };

enum DECLSPEC_DENUM TEncoder_str : unsigned int { Enc_OutputURL, Enc_Video_Codec, Enc_Audio_Codec, Enc_Extra_Parameters };

enum DECLSPEC_DENUM TEncoder_int : unsigned int { Enc_IsActive_bool, Enc_Bytes_Written_kb_readonly, Enc_Audio_Enabled_bool, Enc_Audio_Channels, Enc_Audio_SamplesPerSec, Enc_Audio_BitsPerSample, Enc_Audio_BitRate_kb, Enc_Audio_PCM_Format, Enc_Video_Enabled_bool, Enc_Video_Width, Enc_Video_Height, Enc_Video_BitCount, Enc_Video_AvgTimePerFrame, Enc_Video_BitRate_kb, Enc_Video_rc_MinBitRate_kb, Enc_Video_rc_MaxBitRate_kb, Enc_Video_rc_BufferSize_kb, Enc_Video_IDR_Interval, Enc_Video_Max_BFrames, Enc_Video_FrameRate_x100, Enc_IsRealTime_bool, Enc_IsScreenRecording_bool, Enc_Video_Thread_Count, Enc_Video_GPU_Encoder, Enc_Video_GPU_EncoderDevice, Enc_Video_Quality_min, Enc_Video_Quality_max, Enc_Playable_While_Being_Recorded_bool, Enc_Video_Sampling_Interval_Ms, 
	Enc_Video_Sampling_FrameRate_x100, Enc_Video_Dropped_Frame_Count_readonly, Enc_Video_Encoded_Frame_Count_readonly, Enc_Video_IDR_Interval_Frames, Enc_Video_Profile, Enc_Video_Level, Enc_Video_LowLatency_bool, Enc_Video_MaxRefFrames, Enc_Video_RateControlMode, Enc_Video_H264_CABAC_Enable_bool, Enc_Video_Deblock_Enable_bool, Enc_Video_SlicesPerFrame, Enc_Video_IntraRefresh_Enable_bool, Enc_Video_IntraRefresh_Percent };

enum DECLSPEC_DENUM TVideoSource : unsigned int { vs_VideoCaptureDevice, vs_ScreenRecording, vs_VideoFileOrURL, vs_JPEGsOrBitmaps, vs_IPCamera, vs_Mixer, vs_VideoFromImages, vs_ThirdPartyFilter, vs_StreamInterface };

enum DECLSPEC_DENUM TAudioSource : unsigned int { as_Default, as_UseExternalAudio, as_UseMixAudioSample, as_SpeakerOutput, as_DefaultWithSpeakerRecording, as_Silent, as_IPcamera };

enum DECLSPEC_DENUM TDiscoveryCallbackStatus : unsigned int { dcs_CameraFound, dcs_MulticastCompleted, dcs_IPRangeCompleted };

enum DECLSPEC_DENUM TVuMeter : unsigned int { vu_Disabled, vu_Analog, vu_Bargraph, vu_AnalogOverlay, vu_BargraphOverlay };

enum DECLSPEC_DENUM TASFDeinterlaceMode : unsigned int { adm_NotInterlaced, adm_DeinterlaceNormal, adm_DeinterlaceHalfSize, adm_DeinterlaceHalfSizeDoubleRate, adm_DeinterlaceInverseTelecine, adm_DeinterlaceVerticalHalfSizeDoubleRate };

enum DECLSPEC_DENUM TASFProfileVersion : unsigned int { apv_ProfileVersion_8, apv_ProfileVersion_9 };

enum DECLSPEC_DENUM TFileSort : unsigned int { fs_TimeAsc, fs_TimeDesc, fs_NameAsc, fs_NameDesc };

enum DECLSPEC_DENUM TTunerInput : unsigned int { ti_TunerInputCable, ti_TunerInputAntenna };

enum DECLSPEC_DENUM TRGBSelector : unsigned int { rs_Red, rs_Green, rs_Blue };

enum DECLSPEC_DENUM TCameraControl : unsigned int { cc_Pan, cc_Tilt, cc_Roll, cc_Zoom, cc_Exposure, cc_Iris, cc_Focus };

enum DECLSPEC_DENUM TPlaylist : unsigned int { pl_Add, pl_Remove, pl_Clear, pl_Loop, pl_NoLoop, pl_Play, pl_Stop, pl_Next, pl_Previous, pl_SortAlpha, pl_SortRevAlpha, pl_Random, pl_Sequential, pl_SpecifyPositions, pl_Transition };

enum DECLSPEC_DENUM TVideoQuality : unsigned int { vq_Brightness, vq_Contrast, vq_Hue, vq_Saturation, vq_Sharpness, vq_Gamma, vq_ColorEnable, vq_WhiteBalance, vq_BacklightCompensation, vq_Gain };

enum DECLSPEC_DENUM THwAccel : unsigned int { hw_None, hw_Cuda, hw_QuickSync, hw_Dxva2, hw_d3d11 };

enum DECLSPEC_DENUM TMiscDeviceControl : unsigned int { mdc_GPIO, mdc_VPD, mdc_VPD_Data };

enum DECLSPEC_DENUM TAVIMuxConfig : unsigned int { avmx_SetInterleavingMode, avmx_SetInterleave, avmx_SetPreroll };

enum DECLSPEC_DENUM TApplicationPriority : unsigned int { ap_default, ap_idle, ap_normal, ap_high, ap_realtime };

enum DECLSPEC_DENUM TRecordingMethod : unsigned int { rm_AVI, rm_ASF, rm_SendToDV, rm_MKV, rm_FLV, rm_MP4, rm_WebM, rm_MPG, rm_Multiplexer, rm_MOV, rm_TS, rm_H264, rm_MP3, rm_WMA, rm_WAV };

enum DECLSPEC_DENUM TNetworkStreaming : unsigned int { ns_Disabled, ns_ASFDirectNetworkStreaming, ns_ASFStreamingToPublishingPoint, ns_NDI };

enum DECLSPEC_DENUM TNetworkStreamingType : unsigned int { nst_AudioVideoStreaming, nst_VideoStreaming, nst_AudioStreaming };

enum DECLSPEC_DENUM TSyncPreview : unsigned int { sp_Auto, sp_Disabled, sp_Enabled };

enum DECLSPEC_DENUM TGraphState : unsigned int { gs_Stopped, gs_Paused, gs_Running };

enum DECLSPEC_DENUM TPlayerState : unsigned int { ps_Closed, ps_Stopped, ps_Paused, ps_Playing, ps_PlayingBackward, ps_FastForwarding, ps_FastRewinding, ps_Downloading, ps_DownloadCompleted, ps_DownloadCancelled, ps_Opened };

enum DECLSPEC_DENUM TRecordingTimer : unsigned int { rt_Disabled, rt_RecordToNewFile, rt_StopRecording, rt_StartRecording, rt_PauseRecording, rt_FrameCapture };

enum DECLSPEC_DENUM TAero : unsigned int { ae_Default, ae_AutoBestRenderingQuality, ae_ForceOnWhenStartingVideo, ae_ForceOffWhenStartingVideo, ae_ForceOnImmediately, ae_ForceOffImmediately };

enum DECLSPEC_DENUM TMPEGProgramSetting : unsigned int { mps_Program_Number, mps_Program_PCR_PID, mps_VideoStream_PID, mps_AudioStream_PID, mps_VideoStream_Type, mps_AudioStream_Type, mps_VideoFormat_Width, mps_VideoFormat_Height, mps_VideoAspectRatio_X, mps_VideoAspectRatio_Y, mps_ReceiveTimeoutInSeconds };

enum DECLSPEC_DENUM TFrameInfoId : unsigned int { fi_FrameNumber, fi_DroppedFrameCount, fi_SampleTime_Hour, fi_SampleTime_Min, fi_SampleTime_Sec, fi_SampleTime_Hs, fi_SampleTime_TotalMin, fi_DVTimeCode_IsAvailable, fi_DVTimeCode_Hour, fi_DVTimeCode_Min, fi_DVTimeCode_Sec, fi_DVTimeCode_Ff, fi_DVTimeCode_TrackNumber, fi_DVDateTime_IsAvailable, fi_DVDateTime_Year, fi_DVDateTime_Month, fi_DVDateTime_Day, fi_DVDateTime_Hour, fi_DVDateTime_Min, fi_DVDateTime_Sec, fi_NTPFrameTime, fi_First_NTP_time_Recorded };

enum DECLSPEC_DENUM TFrameInfoStringId : unsigned int { fis_DVTimeCode, fis_DVDateTime, fis_TimeCode, fis_FrameTime, fis_FrameNumber, fis_FullInfo, fis_NTPFrameTime };

struct TFrameInfo;
typedef TFrameInfo *pFrameInfo;

struct DECLSPEC_DRECORD TFrameInfo
{
public:
	__int64 FrameTime;
	__int64 FrameTime_TotalMin;
	__int64 FrameTime_TotalSec;
	__int64 FrameTime_TotalHs;
	__int64 FrameNumber;
	int DroppedFrameCount;
	int FrameTime_Hour;
	int FrameTime_Min;
	int FrameTime_Sec;
	int FrameTime_Hs;
	int DVTimeCode_IsAvailable;
	int DVTimeCode_Hour;
	int DVTimeCode_Min;
	int DVTimeCode_Sec;
	int DVTimeCode_Ff;
	int DVTimeCode_TrackNumber;
	int DVDateTime_IsAvailable;
	int DVDateTime_Year;
	int DVDateTime_Month;
	int DVDateTime_Day;
	int DVDateTime_Hour;
	int DVDateTime_Min;
	int DVDateTime_Sec;
	TCurrentState CurrentState;
	TGraphState GraphState;
	TPlayerState PlayerState;
	int PlaylistIndex;
	__int64 NTPFrameTime;
};


struct TFrameBitmapInfo;
typedef TFrameBitmapInfo *pFrameBitmapInfo;

struct DECLSPEC_DRECORD TFrameBitmapInfo
{
public:
	int BitmapWidth;
	int BitmapHeight;
	int BitmapBitsPerPixel;
	int BitmapLineSize;
	int BitmapSize;
	int BitmapPlanes;
	NativeUInt BitmapHandle;
	System::Byte *BitmapDataPtr;
	HDC BitmapDC;
	int CurrentXMouseLocation;
	int CurrentYMouseLocation;
	int LastXMouseDownLocation;
	int LastYMouseDownLocation;
	BOOL IsMouseDown;
	System::Uitypes::TMouseButton LastMouseButtonClicked;
	int Dummy1;
	NativeUInt hSec;
	int Reserved0;
};


struct DECLSPEC_DRECORD TVideoHdr
{
public:
	System::Byte *lpData;
	unsigned dwBufferLength;
	unsigned dwBytesUsed;
	unsigned dwTimeCaptured;
	unsigned dwUser;
	unsigned dwFlags;
	System::StaticArray<System::PLongWord, 4> dwReserved;
};


enum DECLSPEC_DENUM TMultiplexedRole : unsigned int { mr_NotMultiplexed, mr_MultiplexedMosaic4, mr_MultiplexedMosaic16, mr_MultiplexedMaster, mr_MultiplexedSlave };

enum DECLSPEC_DENUM TNDIBandwidthType : unsigned int { nbt_MetadataOnly, nbt_AudioOnly, nbt_LowestBandwidth, nbt_HighestBandwidth };

enum DECLSPEC_DENUM TNDIFormatType : unsigned int { nft_interleaved, nft_progressive, nft_field_0, nft_field_1 };

enum DECLSPEC_DENUM TMpegStreamType : unsigned int { mpst_Default, mpst_Program, mpst_Program_DVD, mpst_Program_DVD_MC, mpst_Program_SVCD, mpst_MPEG1, mpst_MPEG1_VCD };

enum DECLSPEC_DENUM TLogType : unsigned int { e_add_filter, e_add_source_filter, e_audio_compressor_not_suitable, e_bind_moniker_to_filter, e_compressor_possibly_not_suitable, e_create_instance, e_ddraw_caps_not_suitable, e_device_in_use_in_another_graph, e_disk_full, e_failed, e_failed_to_allocate_recording_file, e_failed_to_bind_codec, e_failed_to_connect_crossbar_pin, e_failed_to_connect_to_server, e_failed_to_create_directory, e_failed_to_create_file, e_failed_to_create_temp, e_failed_to_bind_frame_grabber, e_failed_to_load_ASF_profile, e_failed_to_load_ASF_profile_custom_file, e_failed_to_load_set_of_bitmaps, e_failed_to_set_image_overlay, e_failed_to_set_logo, e_failed_to_play_backwards, e_failed_to_render_file, e_failed_to_renew_recording_file, 
	e_failed_to_set_player_speed_ratio_with_audio, e_failed_to_setup_network_streaming, e_failed_to_start_preview, e_failed_to_start_recording, e_file_in_use, e_file_name_not_specified, e_file_not_found, e_get_audio_format, e_get_interface, e_get_video_format, e_graph_error, e_graph_cant_run, e_graph_must_be_restarted, e_hw_deinterlace_not_supported, e_incompatible_options, e_index_out_of_range, e_invalid_directory, e_library_not_found, e_load_filter, e_no_audio_In_device, e_no_device_available, e_no_dialog, e_no_stream_control, e_no_tv_tuner, e_no_device_selected, e_no_video_input_device, e_not_allowed_during_network_streaming, e_not_allowed_with_streaming_URL, e_not_assigned, e_not_multiplexed_master, e_not_previewing, e_not_recording, e_not_reencoding, 
	e_not_streaming, e_out_of_memory, e_pause_resume_disabled, e_pin_not_found, e_interface_not_assigned, e_query_config_avi_mux, e_reencoding, e_recording_cannot_pause, e_render_audio_stream, e_render_video_stream, e_must_restart_master, e_recording_on_motion_failed, e_sendtodv_device_index_out_of_bound, e_sendtodv_deviceindex_and_videodevice_have_same_value, e_sendtodv_failed_to_bind_dv_device, e_set_filter_graph, e_set_interleaving_mode, e_set_master_stream, e_set_output_compatibility_index, e_set_output_file_name, e_set_format, e_start_preview_first, e_stop_player_first, e_stop_preview_first, e_stop_recording_first, e_stop_reencoding_first, e_storage_path_read_only, e_streaming_type_not_specified, e_third_party_filter_already_inserted, 
	e_third_party_filter_error, e_trace_log, e_tv_command_not_allowed_during_tv_tuning, e_tuner_input_not_selected, e_TVideoGrabber_Filter_obsolete, e_value_out_of_range, e_video_compressor_not_suitable, e_window_transparency_failed, e_invalid_size, e_invalid_window_handle, e_tuner_mode_not_supported, e_publishing_point_connection_failed, e_speaker_control_disabled, i_audio_device_associated_to_video_device, i_begin_discovering_device, i_binding_device_or_compressor, i_discovering_device, i_end_discovering_device, i_preallocated_file_size_large_enough, i_preallocated_file_size_changed, i_preallocated_file_not_suitable, i_streaming_to_publishing_point, i_third_party_filter_inserted, i_using_ASF_Profile, i_recording_videosubtype, i_ismpegstream, 
	i_new_recording_filename, i_using_property_group, i_streaming_client_connected, i_streaming_client_disconnected, i_refreshing_preview, i_recording_on_motion, i_window_found, i_limiting_preview, i_codec_recommended, i_tuner_mode, i_DV_date_time_discontinuity, w_cannot_connect_thirdparty_filter, w_cannot_connect_thirdparty_renderer, w_cannot_instantiate_thirdparty_filter, w_cannot_route_crossbar, w_cannot_use_color_key, w_command_delayed, w_does_not_apply_to_dv, w_find_audio_device, w_filter_does_not_save_properties, w_frame_grabber_requires_CPU, w_hold_recording, w_information, w_not_playing, w_player_audio_should_be_disabled, w_recording_cancelled_by_user, w_can_pause_and_ASF_incompatible, w_set_audio_format, w_storage_path_on_network, w_tv_tuner, 
	w_using_nearest_video_size, w_divx_codec_not_installed, w_codec_does_not_support_debugger, w_divx_codec_profile, w_device_partially_supported, w_excessive_grid_size, w_grid_too_large_for_dialog, w_operation_may_lock, w_audio_streaming_needs_audiorecording_property_enabled, w_network_streaming_disabled, w_server_lost_next_retry, w_overlay_mixer_not_available, w_network_streaming_change_requires_application_to_be_restarted, w_standard_renderer_recommended, w_window_transparency_and_recording_not_recommended, w_clip_not_seekable, w_only_WMV_recording_during_network_streaming, w_check_analog_video_standard, w_recording_timer_set, w_stream_time_beyong_script_time, w_generate_new_file, w_hires_timer_not_available, w_applies_to_the_current_recording_method, 
	i_leaving_full_screen_mode, i_stream_info, i_async_url_connection_in_progress, i_async_url_connection_cancelled, e_obsolete, i_codec_info, i_preview_started, i_recording_started, i_reencoding_started, i_recording_completed, i_reencoding_completed, i_player_opened, i_inactive, i_using_stream_index, e_failed_to_start_reencoding, e_recording_failed, e_failed_to_open_player, i_mpe_terminatedsuccess, e_mpe_terminatederror, i_mpe_logcallback, i_duration_updated, e_ptz_command_failed, i_ptz_command_result, w_potential_out_of_range, i_recording_paused, i_configuration_info, w_virtualmachine, i_recording_resumed, e_failed_to_write_sample, e_exception, e_failed_to_open_url, e_async_url_opening_in_progress, i_filter_info, e_not_implemented, w_format_not_specified, 
	e_encryption_decryption, e_facebook_go_live, w_need_reindexing };

enum DECLSPEC_DENUM TAspectRatio : unsigned int { ar_Box, ar_NoResize, ar_Stretch, ar_PanScan };

enum DECLSPEC_DENUM TStreamType : unsigned int { st_Video, st_Audio };

enum DECLSPEC_DENUM TTextOverlayAlign : unsigned int { tf_Left, tf_Center, tf_Right };

enum DECLSPEC_DENUM TVUMeterSetting : unsigned int { vu_Handle, vu_WarningPercent, vu_PeakPercent, vu_BkgndColor, vu_NormalColor, vu_WarningColor, vu_PeakColor, vu_TickSize, vu_TickInterval, vu_NeedleThickness, vu_OverlayLeft, vu_OverlayTop, vu_OverlayWidth, vu_OverlayHeight, vu_Transparent, vu_FlipVert, vu_FlipHorz, vu_CustomPercentValue, vu_LogarithmicScale };

enum DECLSPEC_DENUM TVMR9ImageAdjustment : unsigned int { vmr9_Brightness, vmr9_Contrast, vmr9_Hue, vmr9_Saturation, vmr9_Alpha };

enum DECLSPEC_DENUM TVideoWindowNotify : unsigned int { vwActive, vwVisible, vwAutoSize, vwEmbedded, vwEmbeddedFitParent, vwDisplayParent, vwColorKeyEnabled, vwAlphaBlendEnabled, vwFullScreen, vwStayOnTop, vwMouseMovesWindow, vwVideoPortEnabled, vwMonitor, vwAspectRatio, vwVideoWidth, vwVideoHeight, vwPanScanRatio, vwColorKeyValue, vwAlphaBlendValue, vwLeft, vwTop, vwLocation };

enum DECLSPEC_DENUM TTunerMode : unsigned int { tm_TVTuner, tm_FMRadioTuner, tm_AMRadioTuner, tm_DigitalSatelliteTuner };

enum DECLSPEC_DENUM TOpenURLAsyncStatus : unsigned int { oas_InProgress_Connecting, oas_InProgress_Connected, oas_Completed_Success, oas_Undefined, oas_Completed_Error, oas_Completed_Cancelled };

enum DECLSPEC_DENUM TThreadSyncPoint : unsigned int { tsp_SyncPoint1, tsp_SyncPoint2, tsp_SetParent, tsp_UnSetParent };

typedef void __fastcall (__closure *TOnDragDropFiles)(void * Sender, int FileCount, System::UnicodeString FirstFile, System::UnicodeString FilesList);

typedef void __fastcall (__closure *TOnAudioBufferNegotiation)(System::TObject* Sender, int nChannels, int nSamplesPerSec, int BitsPerSample, int &ProposedBufferSize);

typedef void __fastcall (__closure *TOnAudioPeak)(System::TObject* Sender, double Left_Percent, double Left_DB, double Right_Percent, double Right_DB);

typedef void __fastcall (__closure *TOnClientConnection)(System::TObject* Sender, bool Connected, System::UnicodeString ClientInfo);

typedef void __fastcall (__closure *TOnEventNotification)(System::TObject* Sender);

typedef void __fastcall (__closure *TOnDVDiscontinuity)(System::TObject* Sender, bool &DeliverNewFrame);

typedef void __fastcall (__closure *TOnLog)(System::TObject* Sender, TLogType LogType, System::UnicodeString Severity, System::UnicodeString InfoMsg);

typedef void __fastcall (__closure *TOnSourceFileToDestFileStarted)(System::TObject* Sender, System::UnicodeString SourceFile, System::UnicodeString DestFile);

typedef void __fastcall (__closure *TOnSourceFileToDestFileCompleted)(System::TObject* Sender, System::UnicodeString SourceFile, System::UnicodeString DestFile, bool Success);

typedef void __fastcall (__closure *TOnFileNotification)(System::TObject* Sender, System::UnicodeString FileName);

typedef void __fastcall (__closure *TOnCreatePreallocatedFileCompleted)(System::TObject* Sender, System::UnicodeString FileName, bool Success);

typedef void __fastcall (__closure *TOnResizeVideo)(System::TObject* Sender, int SourceWidth, int SourceHeight);

typedef void __fastcall (__closure *TOnRecordingCompleted)(System::TObject* Sender, System::UnicodeString FileName, bool Success);

typedef void __fastcall (__closure *TOnThreadSync)(System::TObject* Sender, TThreadSyncPoint ThreadSyncPoint);

typedef void __fastcall (__closure *TOnVideoFromBitmapsNextFrameNeeded)(System::TObject* Sender, bool FirstSample);

typedef void __fastcall (__closure *TOnDVCommandCompleted)(System::TObject* Sender, int NewStateValue, System::UnicodeString NewStateLabel);

typedef void __fastcall (__closure *TOnDeviceArrivalOrRemoval)(System::TObject* Sender, bool IsDeviceArrival, bool IsVideoDevice, System::UnicodeString DeviceName, int DeviceIndex);

typedef void __fastcall (__closure *TOnPlayerBufferingData)(System::TObject* Sender, bool StartingToBuffer);

typedef void __fastcall (__closure *TOnDirectNetworkStreamingHostUrl)(System::TObject* Sender, System::UnicodeString HostUrl, System::UnicodeString HostName, int HostPort);

typedef void __fastcall (__closure *TOnAuthenticationNeeded)(System::TObject* Sender, TAuthenticationType AuthenticationType, System::UnicodeString Realm, System::UnicodeString Server, System::UnicodeString &Username, System::UnicodeString &Password);

typedef void __fastcall (__closure *TOnVideoCompressionSettings)(System::TObject* Sender, bool CanKeyFrameRate, bool CanPFramesPerKeyFrame, bool CanQuality, bool CanWindowSize, bool CanSpecifyDataRate, int DefaultFrameRate, int DefaultPFramesPerKey, double DefaultQuality, int DefaultWindowSize, int DefaultDataRate);

typedef void __fastcall (__closure *TOnColorKeyChange)(System::TObject* Sender, System::Uitypes::TColor ColorKey);

typedef void __fastcall (__closure *TOnOpenURLAsyncStatusChanged)(System::TObject* Sender, TOpenURLAsyncStatus OldStatus, TOpenURLAsyncStatus NewStatus, TCurrentState TargetState);

typedef void __fastcall (__closure *TOnPlayerStateChanged)(System::TObject* Sender, TPlayerState OldPlayerState, TPlayerState NewPlayerState);

typedef void __fastcall (__closure *TOnTVChannelSelected)(System::TObject* Sender, int Channel, bool Locked, int DefaultVideoFrequency, int OverriddenVideoFrequency, int TunerVideoFrequency, int TunerAudioFrequency);

typedef void __fastcall (__closure *TOnTVChannelScanStarted)(System::TObject* Sender, int MinChannel, int MaxChannel);

typedef void __fastcall (__closure *TOnThirdPartyFilterAdded)(System::TObject* Sender, TThirdPartyFilterList Location, System::_di_IInterface Intf, bool &ShowDialog, bool &SaveFilterProperties);

typedef void __fastcall (__closure *TOnThirdPartyFilterConnected)(System::TObject* Sender, TThirdPartyFilterList Location, System::_di_IInterface Intf);

typedef void __fastcall (__closure *TOnThirdPartyFilterConnected2)(System::TObject* Sender, System::UnicodeString FilterName, System::_di_IInterface Intf);

typedef void __fastcall (__closure *TOnFilterSelected)(System::TObject* Sender, System::UnicodeString FilterName, bool &RejectFilter);

typedef void __fastcall (__closure *TOnFrameCaptureCompleted)(System::TObject* Sender, void * FrameBitmap, int BitmapWidth, int BitmapHeight, unsigned FrameNumber, __int64 FrameTime, TFrameCaptureDest DestType, System::UnicodeString FileName, bool Success, int FrameId);

typedef void __fastcall (__closure *TOnFrameProgress)(System::TObject* Sender, unsigned FrameNumber, __int64 FrameTime, int FrameId);

typedef void __fastcall (__closure *TOnAVIDurationUpdated)(System::TObject* Sender, System::UnicodeString FileName, unsigned FrameCount, double &FrameRate, __int64 &Duration);

typedef void __fastcall (__closure *TOnMotionDetected)(System::TObject* Sender, double GlobalMotionRatio, int MaxMotionCellX, int MaxMotionCellY, void * FrameBitmap, unsigned FrameNumber, __int64 FrameTime, int FrameId, bool &CaptureFrame);

typedef void __fastcall (__closure *TOnMotionNotDetected)(System::TObject* Sender, void * FrameBitmap, unsigned FrameNumber, __int64 FrameTime, int FrameId, bool &CaptureFrame);

typedef void __fastcall (__closure *TOnProgress)(System::TObject* Sender, int Percent, __int64 Position, __int64 Duration);

typedef void __fastcall (__closure *TOnProgressCommented)(System::TObject* Sender, int Percent, __int64 Position, __int64 Duration, System::UnicodeString Comment);

typedef void __fastcall (__closure *TOnFrameOverlayUsingDC)(System::TObject* Sender, HDC Dc, unsigned FrameNumber, __int64 FrameTime, int FrameId);

typedef void __fastcall (__closure *TOnFrameOverlayUsingDIB)(System::TObject* Sender, HBITMAP FrameBitmapHandle, unsigned FrameNumber, __int64 FrameTime, int FrameId);

typedef void __fastcall (__closure *TOnFrameOverlayUsingVIDEOHDR)(System::TObject* Sender, unsigned FrameNumber, __int64 FrameTime, int FrameId, const TVideoHdr &VideoHdr);

typedef void __fastcall (__closure *TOnRawAudioSample)(System::TObject* Sender, void * pSampleBuffer, int SampleBufferSize, int SampleDataLength, TFormatType FormatType, void * pFormat, void * pWaveFormatEx, __int64 SampleStartTime, __int64 SampleStopTime);

typedef void __fastcall (__closure *TOnRawVideoSample)(System::TObject* Sender, void * pSampleBuffer, int SampleBufferSize, int SampleDataLength, TFormatType FormatType, void * pFormat, void * pBitmapInfoHeader, __int64 SampleStartTime, __int64 SampleStopTime);

typedef void __fastcall (__closure *TOnVideoKeyPress)(System::TObject* Sender, int VideoWindow, System::WideChar &Key, int PhysicalKey, System::Classes::TShiftState ShiftState);

typedef void __fastcall (__closure *TOnVideoMouseUpDown)(System::TObject* Sender, int VideoWindow, System::Uitypes::TMouseButton Button, System::Classes::TShiftState Shift, int X, int Y);

typedef void __fastcall (__closure *TOnVideoMouseMove)(System::TObject* Sender, int VideoWindow, System::Classes::TShiftState Shift, int X, int Y);

typedef void __fastcall (__closure *TOnONVIFDiscoveryCompletedNotification)(System::TObject* Sender, TDiscoveryCallbackStatus DiscoveryCallbackStatus, int CameraCount);

typedef void __fastcall (__closure *TOnVideoMouseEvent)(System::TObject* Sender, int VideoWindow);

typedef void __fastcall (__closure *TOnMouseWheel)(System::TObject* Sender, int VideoWindow, bool DirectionUp, int X, int Y);

typedef void __fastcall (__closure *TOnMultipurposeEncoderNotification)(System::TObject* Sender, TMultipurposeEncoderInstance MultipurposeEncoderInstance);

typedef void __fastcall (__closure *TOnTextOverlayScrollingCompleted)(System::TObject* Sender, int TextOverlayIndex);

typedef void __fastcall (__closure *TOnEnumerateWindows)(System::TObject* Sender, void * WindowHandle, System::UnicodeString WindowName, System::UnicodeString WindowClass);

typedef void __fastcall (__closure *TOnFrameBitmap)(System::TObject* Sender, pFrameInfo FrameInfo, pFrameBitmapInfo BitmapInfo);

typedef void __fastcall (__closure *TOnFrameProgress2)(System::TObject* Sender, pFrameInfo FrameInfo);

typedef void __fastcall (__closure *TOnNTPTimeStamp)(System::TObject* Sender, __int64 last_rtcp_ntp_time, unsigned last_rtcp_timestamp, __int64 delta_rtcp_ntp_time, unsigned delta_rtcp_timestamp, System::TDateTime UTCDateTime, System::TDateTime LocalDateTime);

class DELPHICLASS TVideoGrabber;
class PASCALIMPLEMENTATION TVideoGrabber : public Vcl::Extctrls::TCustomPanel
{
	typedef Vcl::Extctrls::TCustomPanel inherited;
	
public:
	bool __fastcall GetImageOverlay_AlphaBlend(int Index);
	int __fastcall GetImageOverlay_AlphaBlendValue(int Index);
	bool __fastcall GetImageOverlay_ChromaKey(int Index);
	int __fastcall GetImageOverlay_ChromaKeyLeewayPercent(int Index);
	int __fastcall GetImageOverlay_ChromaKeyRGBColor(int Index);
	int __fastcall GetImageOverlay_Height(int Index);
	int __fastcall GetImageOverlay_LeftLocation(int Index);
	double __fastcall GetImageOverlay_RotationAngle(int Index);
	bool __fastcall GetImageOverlay_StretchToVideoSize(int Index);
	int __fastcall GetImageOverlay_TargetDisplay(int Index);
	int __fastcall GetImageOverlay_TopLocation(int Index);
	bool __fastcall GetImageOverlay_Transparent(int Index);
	int __fastcall GetImageOverlay_TransparentColorValue(int Index);
	bool __fastcall GetImageOverlay_UseTransparentColor(int Index);
	TVideoAlignment __fastcall GetImageOverlay_VideoAlignment(int Index);
	int __fastcall GetImageOverlay_Width(int Index);
	bool __fastcall GetImageOverlay_Enabled(int Index);
	TTextOverlayAlign __fastcall GetTextOverlay_Align(int Index);
	bool __fastcall GetTextOverlay_AlphaBlend(int Index);
	int __fastcall GetTextOverlay_AlphaBlendValue(int Index);
	System::Uitypes::TColor __fastcall GetTextOverlay_BkColor(int Index);
	bool __fastcall GetTextOverlay_Enabled(int Index);
	Vcl::Graphics::TFont* __fastcall GetTextOverlay_Font(int Index);
	System::Uitypes::TColor __fastcall GetTextOverlay_FontColor(int Index);
	int __fastcall GetTextOverlay_FontSize(int Index);
	bool __fastcall GetTextOverlay_HighResFont(int Index);
	TTextOverlayGradientMode __fastcall GetTextOverlay_GradientMode(int Index);
	System::Uitypes::TColor __fastcall GetTextOverlay_GradientColor(int Index);
	int __fastcall GetTextOverlay_Left(int Index);
	int __fastcall GetTextOverlay_Right(int Index);
	TTextOrientation __fastcall GetTextOverlay_Orientation(int Index);
	bool __fastcall GetTextOverlay_Scrolling(int Index);
	int __fastcall GetTextOverlay_ScrollingSpeed(int Index);
	bool __fastcall GetTextOverlay_Shadow(int Index);
	System::Uitypes::TColor __fastcall GetTextOverlay_ShadowColor(int Index);
	TCardinalDirection __fastcall GetTextOverlay_ShadowDirection(int Index);
	System::UnicodeString __fastcall GetTextOverlay_String(int Index);
	int __fastcall GetTextOverlay_TargetDisplay(int Index);
	int __fastcall GetTextOverlay_Top(int Index);
	bool __fastcall GetTextOverlay_Transparent(int Index);
	TVideoAlignment __fastcall GetTextOverlay_VideoAlignment(int Index);
	void __fastcall SetImageOverlay_AlphaBlend(int Index, bool Value);
	void __fastcall SetImageOverlay_AlphaBlendValue(int Index, int Value);
	void __fastcall SetImageOverlay_ChromaKey(int Index, bool Value);
	void __fastcall SetImageOverlay_ChromaKeyLeewayPercent(int Index, int Value);
	void __fastcall SetImageOverlay_ChromaKeyRGBColor(int Index, int Value);
	void __fastcall SetImageOverlay_Enabled(int Index, bool Value);
	void __fastcall SetImageOverlay_Height(int Index, int Value);
	void __fastcall SetImageOverlay_LeftLocation(int Index, int Value);
	void __fastcall SetImageOverlay_RotationAngle(int Index, double Value);
	void __fastcall SetImageOverlay_StretchToVideoSize(int Index, bool Value);
	void __fastcall SetImageOverlay_TargetDisplay(int Index, int Value);
	void __fastcall SetImageOverlay_TopLocation(int Index, int Value);
	void __fastcall SetImageOverlay_Transparent(int Index, bool Value);
	void __fastcall SetImageOverlay_TransparentColorValue(int Index, int Value);
	void __fastcall SetImageOverlay_UseTransparentColor(int Index, bool Value);
	void __fastcall SetImageOverlay_VideoAlignment(int Index, TVideoAlignment Value);
	void __fastcall SetImageOverlay_Width(int Index, int Value);
	void __fastcall SetTextOverlay_Align(int Index, TTextOverlayAlign Value);
	void __fastcall SetTextOverlay_AlphaBlend(int Index, bool Value);
	void __fastcall SetTextOverlay_AlphaBlendValue(int Index, int Value);
	void __fastcall SetTextOverlay_BkColor(int Index, System::Uitypes::TColor Value);
	void __fastcall SetTextOverlay_CustomVar(int Index, int VarIndex, System::UnicodeString VarText);
	void __fastcall SetTextOverlay_Enabled(int Index, bool Value);
	void __fastcall SetTextOverlay_Font(int Index, Vcl::Graphics::TFont* Value);
	void __fastcall SetTextOverlay_FontColor(int Index, System::Uitypes::TColor Value);
	void __fastcall SetTextOverlay_FontSize(int Index, int Value);
	void __fastcall SetTextOverlay_GradientMode(int Index, TTextOverlayGradientMode Value);
	void __fastcall SetTextOverlay_GradientColor(int Index, System::Uitypes::TColor Value);
	void __fastcall SetTextOverlay_HighResFont(int Index, bool Value);
	void __fastcall SetTextOverlay_Left(int Index, int Value);
	void __fastcall SetTextOverlay_Right(int Index, int Value);
	void __fastcall SetTextOverlay_Orientation(int Index, TTextOrientation Value);
	void __fastcall SetTextOverlay_Scrolling(int Index, bool Value);
	void __fastcall SetTextOverlay_ScrollingSpeed(int Index, int Value);
	void __fastcall SetTextOverlay_Shadow(int Index, bool Value);
	void __fastcall SetTextOverlay_ShadowColor(int Index, System::Uitypes::TColor Value);
	void __fastcall SetTextOverlay_ShadowDirection(int Index, TCardinalDirection Value);
	void __fastcall SetTextOverlay_String(int Index, const System::UnicodeString Value);
	void __fastcall SetTextOverlay_TargetDisplay(int Index, int Value);
	void __fastcall SetTextOverlay_Top(int Index, int Value);
	void __fastcall SetTextOverlay_Transparent(int Index, bool Value);
	void __fastcall SetTextOverlay_VideoAlignment(int Index, TVideoAlignment Value);
	
private:
	System::TObject* _Vdgr;
	bool _VdgrInitialized;
	NativeUInt FCurThr;
	HRESULT FCoinit;
	bool FSettingBounds;
	TOnEventNotification FOnAudioDeviceSelected;
	TOnAudioBufferNegotiation FOnAudioBufferNegotiation;
	TOnAudioPeak FOnAudioPeak;
	TOnAuthenticationNeeded FOnAuthenticationNeeded;
	TOnAVIDurationUpdated FOnAVIDurationUpdated;
	TOnEventNotification FOnBacktimedFramesCountReached;
	TOnEventNotification FOnClick;
	TOnClientConnection FOnClientConnection;
	TOnColorKeyChange FOnColorKeyChange;
	TOnSourceFileToDestFileCompleted FOnCopyPreallocDataCompleted;
	TOnProgress FOnCopyPreallocDataProgress;
	TOnSourceFileToDestFileStarted FOnCopyPreallocDataStarted;
	TOnCreatePreallocatedFileCompleted FOnCreatePreallocFileCompleted;
	TOnProgress FOnCreatePreallocFileProgress;
	TOnFileNotification FOnCreatePreallocFileStarted;
	TOnEventNotification FOnDblClick;
	TOnDeviceArrivalOrRemoval FOnDeviceArrivalOrRemoval;
	TOnEventNotification FOnDeviceLost;
	TOnEventNotification FOnDeviceReconnecting;
	TOnEventNotification FOnDeviceReconnected;
	TOnDirectNetworkStreamingHostUrl FOnDirectNetworkStreamingHostUrl;
	TOnEventNotification FOnDiskFull;
	TOnDragDropFiles FOnDragDropFiles;
	TOnDVDiscontinuity FOnDVDiscontinuity;
	TOnEnumerateWindows FOnEnumerateWindows;
	TOnEventNotification FOnFirstFrameReceived;
	TOnFrameBitmap FOnFrameBitmap;
	TOnFrameBitmap FOnFrameBitmapRendering;
	TOnFrameOverlayUsingDC FOnFrameOverlayUsingDC;
	TOnFrameOverlayUsingDIB FOnFrameOverlayUsingDIB;
	TOnFrameProgress FOnFrameProgress;
	TOnFrameProgress2 FOnFrameProgress2;
	TOnNTPTimeStamp FOnNTPTimeStamp;
	TOnFrameOverlayUsingVIDEOHDR FOnFrameOverlayUsingVIDEOHDR;
	TOnEventNotification FOnInactive;
	TOnEventNotification FOnStoppingGraph;
	TOnEventNotification FOnStoppingGraphCompleted;
	TOnEventNotification FOnGraphBuilt;
	TOnEventNotification FOnLastCommandCompleted;
	TOnEventNotification FOnLeavingFullScreen;
	TOnLog FOnLog;
	TOnFilterSelected FOnFilterSelected;
	TOnFrameCaptureCompleted FOnFrameCaptureCompleted;
	TOnDVCommandCompleted FOnDVCommandCompleted;
	TOnVideoKeyPress FOnKeyPress;
	TOnVideoMouseUpDown FOnMouseDown;
	TOnVideoMouseEvent FOnMouseEnter;
	TOnVideoMouseEvent FOnMouseLeave;
	TOnVideoMouseMove FOnMouseMove;
	TOnVideoMouseUpDown FOnMouseUp;
	TOnMouseWheel FOnMouseWheel;
	TOnVideoMouseUpDown FOnMouseDown_Video;
	TOnVideoMouseUpDown FOnMouseDown_Window;
	TOnVideoMouseMove FOnMouseMove_Video;
	TOnVideoMouseMove FOnMouseMove_Window;
	TOnVideoMouseUpDown FOnMouseUp_Video;
	TOnVideoMouseUpDown FOnMouseUp_Window;
	TOnEventNotification FOnNoVideoDevices;
	TOnMultipurposeEncoderNotification FOnMultipurposeEncoderProgress;
	TOnMultipurposeEncoderNotification FOnMultipurposeEncoderError;
	TOnMultipurposeEncoderNotification FOnMultipurposeEncoderCompleted;
	TOnONVIFDiscoveryCompletedNotification FOnONVIFDiscoveryCompleted;
	TOnOpenURLAsyncStatusChanged FOnOpenURLAsyncStatusChanged;
	TOnPlayerStateChanged FOnPlayerStateChanged;
	TOnEventNotification FOnPlayerDurationUpdated;
	TOnEventNotification FOnPlayerEndOfStream;
	TOnEventNotification FOnPlayerEndOfPlaylist;
	TOnPlayerBufferingData FOnPlayerBufferingData;
	TOnEventNotification FOnPlayerOpened;
	TOnFrameProgress FOnPlayerUpdateTrackbarPosition;
	TOnEventNotification FOnPreviewStarted;
	TOnRawAudioSample FOnRawAudioSample;
	TOnRawVideoSample FOnRawVideoSample;
	TOnProgressCommented FOnBitmapsLoadingProgress;
	TOnRecordingCompleted FOnRecordingCompleted;
	TOnEventNotification FOnRecordingPaused;
	TOnEventNotification FOnRecordingReadyToStart;
	TOnFileNotification FOnRecordingStarted;
	TOnSourceFileToDestFileCompleted FOnReencodingCompleted;
	TOnProgress FOnReencodingProgress;
	TOnSourceFileToDestFileStarted FOnReencodingStarted;
	TOnResizeVideo FOnResizeVideo;
	TOnEventNotification FOnReinitializing;
	TOnThreadSync FOnThreadSync;
	TOnTextOverlayScrollingCompleted FOnTextOverlayScrollingCompleted;
	TOnTVChannelSelected FOnTVChannelSelected;
	TOnEventNotification FOnTVChannelScanCompleted;
	TOnTVChannelScanStarted FOnTVChannelScanStarted;
	TOnThirdPartyFilterAdded FOnThirdPartyFilterAdded;
	TOnThirdPartyFilterConnected FOnThirdPartyFilterConnected;
	TOnThirdPartyFilterConnected2 FOnThirdPartyFilterConnected2;
	TOnVideoCompressionSettings FOnVideoCompressionSettings;
	TOnEventNotification FOnVideoDeviceSelected;
	TOnVideoFromBitmapsNextFrameNeeded FOnVideoFromBitmapsNextFrameNeeded;
	TOnMotionDetected FOnMotionDetected;
	TOnMotionNotDetected FOnMotionNotDetected;
	void __fastcall UpdateBorderStyle(Vcl::Forms::TBorderStyle Value);
	void __fastcall ClearEvents(void);
	bool __fastcall GetAdjustOverlayAspectRatio(void);
	bool __fastcall GetAdjustPixelAspectRatio(void);
	TApplicationPriority __fastcall GetApplicationPriority(void);
	int __fastcall GetASFAudioBitRate(void);
	int __fastcall GetASFAudioChannels(void);
	int __fastcall GetASFBufferWindow(void);
	TASFDeinterlaceMode __fastcall GetASFDeinterlaceMode(void);
	bool __fastcall GetASFDirectStreamingKeepClientsConnected(void);
	bool __fastcall GetASFFixedFrameRate(void);
	System::UnicodeString __fastcall GetASFMediaServerPublishingPoint(void);
	System::UnicodeString __fastcall GetASFMediaServerTemplatePublishingPoint(void);
	bool __fastcall GetASFMediaServerRemovePublishingPointAfterDisconnect(void);
	int __fastcall GetASFNetworkPort(void);
	int __fastcall GetASFNetworkMaxUsers(void);
	int __fastcall GetASFProfile(void);
	TASFProfileVersion __fastcall GetASFProfileVersion(void);
	System::UnicodeString __fastcall GetASFProfileFromCustomFile(void);
	int __fastcall GetASFVideoBitRate(void);
	double __fastcall GetASFVideoFrameRate(void);
	int __fastcall GetASFVideoHeight(void);
	int __fastcall GetASFVideoMaxKeyFrameSpacing(void);
	int __fastcall GetASFVideoQuality(void);
	int __fastcall GetASFVideoWidth(void);
	double __fastcall GetAspectRatioToUse(void);
	TAudioChannelRenderMode __fastcall GetAudioChannelRenderMode(void);
	bool __fastcall GetAVIDurationUpdated(void);
	TAero __fastcall GetAero(void);
	bool __fastcall GetAssociateAudioAndVideoDevices(void);
	int __fastcall GetAudioDevice(void);
	bool __fastcall GetAudioDeviceRendering(void);
	TAudioFormat __fastcall GetAudioFormat(void);
	int __fastcall GetAudioRenderer(void);
	int __fastcall GetAudioStreamNumber(void);
	bool __fastcall GetAudioSyncAdjustmentEnabled(void);
	int __fastcall GetAudioSyncAdjustment(void);
	int __fastcall GetMixAudioSamplesLevel(int Index);
	int __fastcall GetMixer_MosaicLines(void);
	int __fastcall GetMixer_MosaicColumns(void);
	bool __fastcall GetAudioPeakEvent(void);
	bool __fastcall GetAudioRecording(void);
	TAudioSource __fastcall GetAudioSource(void);
	bool __fastcall GetAutoConnectRelatedPins(void);
	TAutoFileName __fastcall GetAutoFileName(void);
	System::UnicodeString __fastcall GetAutoFileNameDateTimeFormat(void);
	int __fastcall GetAutoFileNameMinDigits(void);
	System::UnicodeString __fastcall GetAutoFilePrefix(void);
	System::UnicodeString __fastcall GetAutoFileSuffix(void);
	bool __fastcall GetAutoRefreshPreview(void);
	bool __fastcall GetAutoStartPlayer(void);
	bool __fastcall GetAVIFormatOpenDML(void);
	bool __fastcall GetAVIFormatOpenDMLCompatibilityIndex(void);
	System::Uitypes::TColor __fastcall GetBackgroundColor(void);
	Vcl::Forms::TBorderStyle __fastcall GetBorderStyle(void);
	int __fastcall GetBurstCount(void);
	int __fastcall GetBurstInterval(void);
	bool __fastcall GetBurstMode(void);
	TFrameCaptureDest __fastcall GetBurstType(void);
	bool __fastcall GetCameraControlSettings(void);
	System::UnicodeString __fastcall GetCaptureFileExt(void);
	System::Uitypes::TColor __fastcall GetColorKey(void);
	bool __fastcall GetColorKeyEnabled(void);
	TCompressionMode __fastcall GetCompressionMode(void);
	TCompressionType __fastcall GetCompressionType(void);
	bool __fastcall GetVideoDoubleBuffered(void);
	int __fastcall GetDroppedFramesPollingInterval(void);
	bool __fastcall GetDVDateTimeEnabled(void);
	int __fastcall GetDVDiscontinuityMinimumInterval(void);
	int __fastcall GetDVDTitle(void);
	TDVVideoFormat __fastcall GetDVEncoder_VideoFormat(void);
	TDVSize __fastcall GetDVEncoder_VideoResolution(void);
	TDVVideoStandard __fastcall GetDVEncoder_VideoStandard(void);
	bool __fastcall GetDVRgb219(void);
	bool __fastcall GetDVReduceFrameRate(void);
	bool __fastcall GetDVRecordingInNativeFormatSeparatesStreams(void);
	bool __fastcall GetDVTimeCodeEnabled(void);
	bool __fastcall GetEventNotificationSynchrone(void);
	System::UnicodeString __fastcall GetExtraDLLPath(void);
	bool __fastcall GetCropping_Enabled(void);
	int __fastcall GetCropping_Height(void);
	bool __fastcall GetCropping_Outbounds(void);
	int __fastcall GetCropping_Width(void);
	int __fastcall GetCropping_X(void);
	int __fastcall GetCropping_Y(void);
	double __fastcall GetCropping_Zoom(void);
	bool __fastcall GetFixFlickerOrBlackCapture(void);
	bool __fastcall GetFrameCaptureWithoutOverlay(void);
	int __fastcall GetFrameCaptureHeight(void);
	int __fastcall GetFrameCaptureWidth(void);
	int __fastcall GetFrameCaptureZoomSize(void);
	TFrameGrabber __fastcall GetFrameGrabber(void);
	TFrameGrabberRGBFormat __fastcall GetFrameGrabberRGBFormat(void);
	bool __fastcall GetFrameNumberStartsFromZero(void);
	double __fastcall GetFrameRate(void);
	int __fastcall GetFrameRateDivider(void);
	int __fastcall GetGetLastFrameWaitTimeoutMs(void);
	bool __fastcall GetGeneratePts(void);
	bool __fastcall GetImageOverlayAlphaBlend(void);
	int __fastcall GetImageOverlayAlphaBlendValue(void);
	bool __fastcall GetImageOverlayChromaKey(void);
	int __fastcall GetImageOverlayChromaKeyLeewayPercent(void);
	int __fastcall GetImageOverlayChromaKeyRGBColor(void);
	int __fastcall GetImageOverlayHeight(void);
	int __fastcall GetImageOverlayLeftLocation(void);
	TVideoAlignment __fastcall GetImageOverlayVideoAlignment(void);
	double __fastcall GetImageOverlayRotationAngle(void);
	int __fastcall GetImageOverlaySelector(void);
	bool __fastcall GetImageOverlayStretchToVideoSize(void);
	int __fastcall GetImageOverlayTargetDisplay(void);
	int __fastcall GetImageOverlayTopLocation(void);
	bool __fastcall GetImageOverlayTransparent(void);
	int __fastcall GetImageOverlayTransparentColorValue(void);
	bool __fastcall GetImageOverlayUseTransparentColor(void);
	int __fastcall GetImageOverlayWidth(void);
	bool __fastcall GetImageOverlayEnabled(void);
	System::UnicodeString __fastcall GetIPCameraURL(void);
	TJPEGPerformance __fastcall GetJPEGPerformance(void);
	bool __fastcall GetJPEGProgressiveDisplay(void);
	int __fastcall GetJPEGQuality(void);
	System::UnicodeString __fastcall GetLicenseString(void);
	bool __fastcall GetLogoDisplayed(void);
	TLogoLayout __fastcall GetLogoLayout(void);
	System::UnicodeString __fastcall GetMotionDetector_Grid(void);
	bool __fastcall GetMotionDetector_ReduceVideoNoise(void);
	bool __fastcall GetMotionDetector_CompareBlue(void);
	bool __fastcall GetMotionDetector_CompareGreen(void);
	bool __fastcall GetMotionDetector_CompareRed(void);
	bool __fastcall GetMotionDetector_GreyScale(void);
	bool __fastcall GetMotionDetector_Enabled(void);
	double __fastcall GetMotionDetector_MaxDetectionsPerSecond(void);
	int __fastcall GetMotionDetector_ReduceCPULoad(void);
	int __fastcall GetMotionDetector_MotionResetMs(void);
	bool __fastcall GetMotionDetector_Triggered(void);
	bool __fastcall GetMouseWheelEventEnabled(void);
	bool __fastcall GetMouseWheelControlsZoomAtCursor(void);
	bool __fastcall GetMuteAudioRendering(void);
	bool __fastcall GetMultiplexedInputEmulation(void);
	TMultiplexedRole __fastcall GetMultiplexedRole(void);
	int __fastcall GetMultiplexedSwitchDelay(void);
	int __fastcall GetMultiplexedStabilizationDelay(void);
	int __fastcall GetMultiplexer(void);
	System::UnicodeString __fastcall GetNDIGroups(void);
	System::UnicodeString __fastcall GetNDIName(void);
	TNDIBandwidthType __fastcall GetNDIBandwidthType(void);
	TNDIFormatType __fastcall GetNDIFormatType(void);
	int __fastcall GetNDIReceiveTimeoutMs(void);
	TNetworkStreaming __fastcall GetNetworkStreaming(void);
	TNetworkStreamingType __fastcall GetNetworkStreamingType(void);
	TNotificationMethod __fastcall GetNotificationMethod(void);
	int __fastcall GetNotificationSleepTime(void);
	System::Classes::TThreadPriority __fastcall GetNotificationPriority(void);
	bool __fastcall GetOnFrameBitmapEventSynchrone(void);
	bool __fastcall GetOpenURLAsync(void);
	bool __fastcall GetOverlayAfterTransform(void);
	bool __fastcall GetPlayerAudioRendering(void);
	TDVSize __fastcall GetPlayerDVSize(void);
	int __fastcall GetPlayerFastSeekSpeedRatio(void);
	System::UnicodeString __fastcall GetPlayerFileName(void);
	System::UnicodeString __fastcall GetPlayerForcedCodec(void);
	THwAccel __fastcall GetPlayerHwAccel(void);
	bool __fastcall GetPlayerRefreshPausedDisplay(void);
	double __fastcall GetPlayerRefreshPausedDisplayFrameRate(void);
	double __fastcall GetPlayerSpeedRatio(void);
	bool __fastcall GetPlayerSpeedRatioConstantAudioPitch(void);
	Vcl::Comctrls::TTrackBar* __fastcall GetPlayerTrackBar(void);
	double __fastcall GetPlayerTrackBarScale(void);
	Vcl::Menus::TPopupMenu* __fastcall Get_PopupMenu(void);
	System::Classes::TComponent* __fastcall GetPropertyPageSaver(void);
	bool __fastcall GetPlayerTrackBarSynchrone(void);
	bool __fastcall GetPreallocCapFileCopiedAfterRecording(void);
	bool __fastcall GetPreallocCapFileEnabled(void);
	System::UnicodeString __fastcall GetPreallocCapFileName(void);
	int __fastcall GetPreallocCapFileSizeInMB(void);
	int __fastcall GetPreviewZoomSize(void);
	int __fastcall GetRecordingAudioBitRate(void);
	int __fastcall GetRecordingVideoBitRate(void);
	System::UnicodeString __fastcall GetRecordingFileName(void);
	bool __fastcall GetRecordingInNativeFormat(void);
	int __fastcall GetRecordingFileSizeMaxInMB(void);
	TRecordingMethod __fastcall GetRecordingMethod(void);
	bool __fastcall GetRecordingPauseCreatesNewFile(void);
	bool __fastcall GetRecordingOnMotion_Enabled(void);
	double __fastcall GetRecordingOnMotion_MotionThreshold(void);
	int __fastcall GetRecordingOnMotion_NoMotionPauseDelayMs(void);
	TRecordingTimer __fastcall GetRecordingTimer(void);
	int __fastcall GetRecordingTimerInterval(void);
	bool __fastcall GetReencodingIncludeAudioStream(void);
	bool __fastcall GetReencodingIncludeVideoStream(void);
	TRecordingMethod __fastcall GetReencodingMethod(void);
	System::UnicodeString __fastcall GetReencodingNewVideoClip(void);
	System::UnicodeString __fastcall GetReencodingSourceVideoClip(void);
	bool __fastcall GetReencodingUseAudioCompressor(void);
	bool __fastcall GetReencodingUseFrameGrabber(void);
	bool __fastcall GetReencodingUseVideoCompressor(void);
	bool __fastcall GetReencodingWMVOutput(void);
	bool __fastcall GetQuickDeviceInitialization(void);
	bool __fastcall GetRawAudioSampleCapture(void);
	bool __fastcall GetRawCaptureAsyncEvent(void);
	TRawSampleCaptureLocation __fastcall GetRawSampleCaptureLocation(void);
	bool __fastcall GetRawVideoSampleCapture(void);
	TRecordingSize __fastcall GetRecordingSize(void);
	int __fastcall GetScreenRecordingSizePercent(void);
	bool __fastcall GetScreenRecordingLayeredWindows(void);
	int __fastcall GetScreenRecordingMonitor(void);
	bool __fastcall GetScreenRecordingNonVisibleWindows(void);
	bool __fastcall GetScreenRecordingThroughClipboard(void);
	bool __fastcall GetScreenRecordingWithCursor(void);
	Vcl::Extctrls::TShape* __fastcall GetShapeOverlay(void);
	bool __fastcall GetShapeOverlayEnabled(void);
	bool __fastcall GetSpeakerControl(void);
	System::UnicodeString __fastcall GetStoragePath(void);
	TStoragePathMode __fastcall GetStoragePathMode(void);
	bool __fastcall GetStoreDeviceSettingsInRegistry(void);
	System::Classes::TStream* __fastcall GetSourceStream(void);
	TSynchronizationRole __fastcall GetSynchronizationRole(void);
	bool __fastcall GetSynchronized(void);
	bool __fastcall GetSyncCommands(void);
	TSyncPreview __fastcall GetSyncPreview(void);
	TTextOverlayAlign __fastcall GetTextOverlayAlign(void);
	bool __fastcall GetTextOverlayAlphaBlend(void);
	int __fastcall GetTextOverlayAlphaBlendValue(void);
	System::Uitypes::TColor __fastcall GetTextOverlayBkColor(void);
	bool __fastcall GetTextOverlayEnabled(void);
	Vcl::Graphics::TFont* __fastcall GetTextOverlayFont(void);
	System::Uitypes::TColor __fastcall GetTextOverlayFontColor(void);
	int __fastcall GetTextOverlayFontSize(void);
	TTextOverlayGradientMode __fastcall GetTextOverlayGradientMode(void);
	System::Uitypes::TColor __fastcall GetTextOverlayGradientColor(void);
	bool __fastcall GetTextOverlayHighResFont(void);
	int __fastcall GetTextOverlayLeft(void);
	TVideoAlignment __fastcall GetTextOverlayVideoAlignment(void);
	TTextOrientation __fastcall GetTextOverlayOrientation(void);
	int __fastcall GetTextOverlayRight(void);
	bool __fastcall GetTextOverlayScrolling(void);
	int __fastcall GetTextOverlayScrollingSpeed(void);
	int __fastcall GetTextOverlaySelector(void);
	bool __fastcall GetTextOverlayShadow(void);
	System::Uitypes::TColor __fastcall GetTextOverlayShadowColor(void);
	TCardinalDirection __fastcall GetTextOverlayShadowDirection(void);
	System::UnicodeString __fastcall GetTextOverlayString(void);
	int __fastcall GetTextOverlayTargetDisplay(void);
	int __fastcall GetTextOverlayTop(void);
	bool __fastcall GetTextOverlayTransparent(void);
	System::UnicodeString __fastcall GetThirdPartyDeinterlacer(void);
	bool __fastcall GetTranslateMouseCoordinates(void);
	bool __fastcall GetTVUseFrequencyOverrides(void);
	int __fastcall GetTunerFrequency(void);
	bool __fastcall GetUseClock(void);
	System::UnicodeString __fastcall GetVersion(void);
	int __fastcall GetVideoCompression_DataRate(void);
	int __fastcall GetVideoCompression_KeyFrameRate(void);
	int __fastcall GetVideoCompression_PFramesPerKeyFrame(void);
	double __fastcall GetVideoCompression_Quality(void);
	int __fastcall GetVideoCompression_WindowSize(void);
	bool __fastcall GetVideoControlSettings(void);
	__int64 __fastcall GetVideoDelay(void);
	bool __fastcall GetVideoFromImages_RepeatIndefinitely(void);
	System::UnicodeString __fastcall GetVideoFromImages_SourceDirectory(void);
	TFileSort __fastcall GetVideoFromImages_BitmapsSortedBy(void);
	System::UnicodeString __fastcall GetVideoFromImages_TemporaryFile(void);
	bool __fastcall Getv360_Enabled(void);
	TV360_MouseAction __fastcall Getv360_MouseAction(void);
	int __fastcall Getv360_MouseActionPercent(void);
	Tv360_Angle __fastcall Getv360_MasterAngle(void);
	double __fastcall Getv360_AspectRatio(void);
	int __fastcall GetVideoDevice(void);
	int __fastcall GetAnalogVideoStandard(void);
	int __fastcall GetAudioCompressor(void);
	int __fastcall GetAudioInput(void);
	int __fastcall GetVideoCompressor(void);
	int __fastcall GetVideoFormat(void);
	int __fastcall GetVideoInput(void);
	int __fastcall GetVideoSize(void);
	int __fastcall GetVideoSubtype(void);
	bool __fastcall GetVideoPlayableWhileRecording(void);
	int __fastcall GetVideoProcessingBrightness(void);
	int __fastcall GetVideoProcessingContrast(void);
	TVideoDeinterlacing __fastcall GetVideoProcessingDeinterlacing(void);
	bool __fastcall GetVideoProcessingGrayScale(void);
	int __fastcall GetVideoProcessingHue(void);
	bool __fastcall GetVideoProcessingInvertColors(void);
	bool __fastcall GetVideoProcessingLeftRight(void);
	int __fastcall GetVideoProcessingPixellization(void);
	TVideoRotation __fastcall GetVideoProcessingRotation(void);
	double __fastcall GetVideoProcessingRotationCustomAngle(void);
	int __fastcall GetVideoProcessingSaturation(void);
	bool __fastcall GetVideoProcessingTopDown(void);
	bool __fastcall GetVideoQualitySettings(void);
	TVideoRenderer __fastcall GetVideoRenderer(void);
	TVideoRendererExternal __fastcall GetVideoRendererExternal(void);
	int __fastcall GetVideoRendererExternalIndex(void);
	TVideoRendererPriority __fastcall GetVideoRendererPriority(void);
	TVideoSource __fastcall GetVideoSource(void);
	System::UnicodeString __fastcall GetVideoSource_FileOrURL(void);
	__int64 __fastcall GetVideoSource_FileOrURL_StartTime(void);
	__int64 __fastcall GetVideoSource_FileOrURL_StopTime(void);
	System::UnicodeString __fastcall GetStreamInterface_Format(void);
	double __fastcall GetStreamInterface_FrameRate(void);
	bool __fastcall GetStreamInterface_IsRealTime(void);
	int __fastcall GetVideoStreamNumber(void);
	bool __fastcall GetVideoVisibleWhenStopped(void);
	int __fastcall GetVirtualVideoStreamControl(void);
	int __fastcall GetVirtualAudioStreamControl(void);
	TVuMeter __fastcall GetVuMeter(void);
	TWebcamStillCaptureButton __fastcall GetWebcamStillCaptureButton(void);
	int __fastcall GetZoomCoeff(void);
	int __fastcall GetZoomXCenter(void);
	int __fastcall GetZoomYCenter(void);
	void __fastcall SetAdjustOverlayAspectRatio(bool Value);
	void __fastcall SetAdjustPixelAspectRatio(bool Value);
	void __fastcall SetApplicationPriority(TApplicationPriority Value);
	void __fastcall SetASFAudioBitRate(int Value);
	void __fastcall SetASFAudioChannels(int Value);
	void __fastcall SetASFBufferWindow(int Value);
	void __fastcall SetASFDeinterlaceMode(TASFDeinterlaceMode Value);
	void __fastcall SetASFDirectStreamingKeepClientsConnected(bool Value);
	void __fastcall SetASFFixedFrameRate(bool Value);
	void __fastcall SetASFMediaServerPublishingPoint(System::UnicodeString Value);
	void __fastcall SetASFMediaServerTemplatePublishingPoint(System::UnicodeString Value);
	void __fastcall SetASFMediaServerRemovePublishingPointAfterDisconnect(bool Value);
	void __fastcall SetASFNetworkPort(int Value);
	void __fastcall SetASFNetworkMaxUsers(int Value);
	void __fastcall SetASFProfile(int Value);
	void __fastcall SetASFProfileVersion(TASFProfileVersion Value);
	void __fastcall SetASFProfileFromCustomFile(System::UnicodeString Value);
	void __fastcall SetASFVideoBitRate(int Value);
	void __fastcall SetASFVideoFrameRate(double Value);
	void __fastcall SetASFVideoHeight(int Value);
	void __fastcall SetASFVideoMaxKeyFrameSpacing(int Value);
	void __fastcall SetASFVideoQuality(int Value);
	void __fastcall SetASFVideoWidth(int Value);
	void __fastcall SetAspectRatioToUse(double Value);
	void __fastcall SetAVIDurationUpdated(bool Value);
	void __fastcall SetAero(TAero Value);
	void __fastcall SetAssociateAudioAndVideoDevices(bool Value);
	void __fastcall SetAudioDevice(int Value);
	void __fastcall SetAudioRenderer(int Value);
	void __fastcall SetAudioStreamNumber(int Value);
	void __fastcall SetAudioSyncAdjustmentEnabled(bool Value);
	void __fastcall SetAudioSyncAdjustment(int Value);
	void __fastcall SetAudioDeviceRendering(bool Value);
	void __fastcall SetAudioFormat(TAudioFormat Value);
	void __fastcall SetMixAudioSamplesLevel(int Index, int Value);
	void __fastcall SetMixer_MosaicLines(int Value);
	void __fastcall SetMixer_MosaicColumns(int Value);
	void __fastcall SetAudioChannelRenderMode(TAudioChannelRenderMode Value);
	void __fastcall SetAudioPeakEvent(bool Value);
	void __fastcall SetAudioRecording(bool Value);
	void __fastcall SetAudioSource(TAudioSource Value);
	void __fastcall SetAutoConnectRelatedPins(bool Value);
	void __fastcall SetAutoFileName(TAutoFileName Value);
	void __fastcall SetAutoFileNameDateTimeFormat(System::UnicodeString Value);
	void __fastcall SetAutoFileNameMinDigits(int Value);
	void __fastcall SetAutoFilePrefix(System::UnicodeString Value);
	void __fastcall SetAutoFileSuffix(System::UnicodeString Value);
	void __fastcall SetAutoRefreshPreview(bool Value);
	void __fastcall SetAutoStartPlayer(bool Value);
	void __fastcall SetAVIFormatOpenDML(bool Value);
	void __fastcall SetAVIFormatOpenDMLCompatibilityIndex(bool Value);
	void __fastcall SetBackgroundColor(System::Uitypes::TColor Value);
	HIDESBASE void __fastcall SetBorderStyle(Vcl::Forms::TBorderStyle Value);
	void __fastcall SetBurstCount(int Value);
	void __fastcall SetBurstInterval(int Value);
	void __fastcall SetBurstMode(bool Value);
	void __fastcall SetBurstType(TFrameCaptureDest Value);
	void __fastcall SetCameraControlSettings(bool Value);
	void __fastcall SetCaptureFileExt(System::UnicodeString Value);
	void __fastcall SetColorKey(System::Uitypes::TColor Value);
	void __fastcall SetColorKeyEnabled(bool Value);
	void __fastcall SetCompressionMode(TCompressionMode Value);
	void __fastcall SetCompressionType(TCompressionType Value);
	void __fastcall SetVideoDoubleBuffered(bool Value);
	void __fastcall SetDroppedFramesPollingInterval(int Value);
	void __fastcall SetDVDateTimeEnabled(bool Value);
	void __fastcall SetDVDiscontinuityMinimumInterval(int Value);
	void __fastcall SetDVDTitle(int Value);
	void __fastcall SetDVEncoder_VideoFormat(TDVVideoFormat Value);
	void __fastcall SetDVEncoder_VideoResolution(TDVSize Value);
	void __fastcall SetDVEncoder_VideoStandard(TDVVideoStandard Value);
	void __fastcall SetDVReduceFrameRate(bool Value);
	void __fastcall SetDVRecordingInNativeFormatSeparatesStreams(bool Value);
	void __fastcall SetDVTimeCodeEnabled(bool Value);
	void __fastcall SetDVRgb219(bool Value);
	void __fastcall SetEventNotificationSynchrone(bool Value);
	void __fastcall SetExtraDLLPath(System::UnicodeString Value);
	void __fastcall SetCropping_Enabled(bool Value);
	void __fastcall SetCropping_Height(int Value);
	void __fastcall SetCropping_Outbounds(bool Value);
	void __fastcall SetCropping_Width(int Value);
	void __fastcall SetCropping_X(int Value);
	void __fastcall SetCropping_Y(int Value);
	void __fastcall SetCropping_Zoom(double Value);
	void __fastcall SetFixFlickerOrBlackCapture(bool Value);
	void __fastcall SetFrameCaptureWithoutOverlay(bool Value);
	void __fastcall SetFrameCaptureHeight(int Value);
	void __fastcall SetFrameCaptureWidth(int Value);
	void __fastcall SetFrameCaptureZoomSize(int Value);
	void __fastcall SetFrameGrabber(TFrameGrabber Value);
	void __fastcall SetFrameGrabberRGBFormat(TFrameGrabberRGBFormat Value);
	void __fastcall SetFrameNumberStartsFromZero(bool Value);
	void __fastcall SetFrameRate(double Value);
	void __fastcall SetFrameRateDivider(int Value);
	void __fastcall SetGetLastFrameWaitTimeoutMs(int Value);
	void __fastcall SetGeneratePts(bool Value);
	void __fastcall SetImageOverlayAlphaBlend(bool Value);
	void __fastcall SetImageOverlayAlphaBlendValue(int Value);
	void __fastcall SetImageOverlayChromaKey(bool Value);
	void __fastcall SetImageOverlayChromaKeyLeewayPercent(int Value);
	void __fastcall SetImageOverlayChromaKeyRGBColor(int Value);
	void __fastcall SetImageOverlayHeight(int Value);
	void __fastcall SetImageOverlayLeftLocation(int Value);
	void __fastcall SetImageOverlayVideoAlignment(TVideoAlignment Value);
	void __fastcall SetImageOverlayRotationAngle(double Value);
	void __fastcall SetImageOverlaySelector(int Value);
	void __fastcall SetImageOverlayStretchToVideoSize(bool Value);
	void __fastcall SetImageOverlayTargetDisplay(int Value);
	void __fastcall SetImageOverlayTopLocation(int Value);
	void __fastcall SetImageOverlayTransparent(bool Value);
	void __fastcall SetImageOverlayTransparentColorValue(int Value);
	void __fastcall SetImageOverlayUseTransparentColor(bool Value);
	void __fastcall SetImageOverlayWidth(int Value);
	void __fastcall SetImageOverlayEnabled(bool Value);
	void __fastcall SetIPCameraURL(System::UnicodeString Value);
	void __fastcall SetJPEGPerformance(TJPEGPerformance Value);
	void __fastcall SetJPEGProgressiveDisplay(bool Value);
	void __fastcall SetJPEGQuality(int Value);
	void __fastcall SetLicenseString(System::UnicodeString PassedValue);
	void __fastcall SetLogoDisplayed(bool Value);
	void __fastcall SetLogoLayout(TLogoLayout Value);
	void __fastcall SetMotionDetector_Grid(System::UnicodeString Value);
	void __fastcall SetMotionDetector_CompareBlue(bool Value);
	void __fastcall SetMotionDetector_CompareGreen(bool Value);
	void __fastcall SetMotionDetector_GreyScale(bool Value);
	void __fastcall SetMotionDetector_CompareRed(bool Value);
	void __fastcall SetMotionDetector_Enabled(bool Value);
	void __fastcall SetMotionDetector_MaxDetectionsPerSecond(double Value);
	void __fastcall SetMotionDetector_ReduceVideoNoise(bool Value);
	void __fastcall SetMotionDetector_ReduceCPULoad(int Value);
	void __fastcall SetMotionDetector_MotionResetMs(int Value);
	void __fastcall SetMotionDetector_Triggered(bool Value);
	void __fastcall SetMouseWheelEventEnabled(bool Value);
	void __fastcall SetMouseWheelControlsZoomAtCursor(bool Value);
	void __fastcall SetMultiplexedInputEmulation(bool Value);
	void __fastcall SetMultiplexedRole(TMultiplexedRole Value);
	void __fastcall SetMultiplexedSwitchDelay(int Value);
	void __fastcall SetMultiplexedStabilizationDelay(int Value);
	void __fastcall SetMultiplexer(int Value);
	void __fastcall SetMuteAudioRendering(bool Value);
	void __fastcall SetNDIGroups(System::UnicodeString Value);
	void __fastcall SetNDIName(System::UnicodeString Value);
	void __fastcall SetNDIBandwidthType(TNDIBandwidthType Value);
	void __fastcall SetNDIFormatType(TNDIFormatType Value);
	void __fastcall SetNDIReceiveTimeoutMs(int Value);
	void __fastcall SetNetworkStreaming(TNetworkStreaming Value);
	void __fastcall SetNetworkStreamingType(TNetworkStreamingType Value);
	void __fastcall SetNotificationMethod(TNotificationMethod Value);
	void __fastcall SetNotificationSleepTime(int Value);
	void __fastcall SetNotificationPriority(System::Classes::TThreadPriority Value);
	void __fastcall SetOnFrameBitmapEventSynchrone(bool Value);
	void __fastcall Set_OnDeviceArrivalOrRemoval(TOnDeviceArrivalOrRemoval Value);
	void __fastcall SetOpenURLAsync(bool Value);
	void __fastcall SetOverlayAfterTransform(bool Value);
	void __fastcall SetPlayerAudioRendering(bool Value);
	void __fastcall SetPlayerDVSize(TDVSize Value);
	void __fastcall SetPlayerFastSeekSpeedRatio(int Value);
	void __fastcall SetPlayerFileName(System::UnicodeString Value);
	void __fastcall SetPlayerForcedCodec(System::UnicodeString Value);
	void __fastcall SetPlayerHwAccel(THwAccel Value);
	void __fastcall SetPlayerRefreshPausedDisplay(bool Value);
	void __fastcall SetPlayerRefreshPausedDisplayFrameRate(double Value);
	void __fastcall SetPlayerSpeedRatio(double Value);
	void __fastcall SetPlayerSpeedRatioConstantAudioPitch(bool Value);
	void __fastcall SetPlayerTrackBar(Vcl::Comctrls::TTrackBar* Value);
	HIDESBASE void __fastcall SetPopupMenu(Vcl::Menus::TPopupMenu* Value);
	void __fastcall SetPropertyPageSaver(System::Classes::TComponent* Value);
	void __fastcall SetPlayerTrackBarSynchrone(bool Value);
	void __fastcall SetPreallocCapFileCopiedAfterRecording(bool Value);
	void __fastcall SetPreallocCapFileEnabled(bool Value);
	void __fastcall SetPreallocCapFileName(System::UnicodeString Value);
	void __fastcall SetPreallocCapFileSizeInMB(int Value);
	void __fastcall SetPreviewZoomSize(int Value);
	void __fastcall SetRecordingAudioBitRate(int Value);
	void __fastcall SetRecordingVideoBitRate(int Value);
	void __fastcall SetRecordingFileName(System::UnicodeString Value);
	void __fastcall SetRecordingFileSizeMaxInMB(int Value);
	void __fastcall SetRecordingInNativeFormat(bool Value);
	void __fastcall SetRecordingMethod(TRecordingMethod Value);
	void __fastcall SetRecordingPauseCreatesNewFile(bool Value);
	void __fastcall SetRecordingOnMotion_Enabled(bool Value);
	void __fastcall SetRecordingOnMotion_MotionThreshold(double Value);
	void __fastcall SetRecordingOnMotion_NoMotionPauseDelayMs(int Value);
	void __fastcall SetRecordingTimer(TRecordingTimer Value);
	void __fastcall SetRecordingTimerInterval(int Value);
	void __fastcall SetReencodingNewVideoClip(System::UnicodeString Value);
	void __fastcall SetReencodingSourceVideoClip(System::UnicodeString Value);
	void __fastcall SetReencodingIncludeAudioStream(bool Value);
	void __fastcall SetReencodingIncludeVideoStream(bool Value);
	void __fastcall SetReencodingMethod(TRecordingMethod Value);
	void __fastcall SetReencodingUseAudioCompressor(bool Value);
	void __fastcall SetReencodingUseFrameGrabber(bool Value);
	void __fastcall SetReencodingUseVideoCompressor(bool Value);
	void __fastcall SetReencodingWMVOutput(bool Value);
	void __fastcall SetQuickDeviceInitialization(bool Value);
	void __fastcall SetRawAudioSampleCapture(bool Value);
	void __fastcall SetRawCaptureAsyncEvent(bool Value);
	void __fastcall SetRawSampleCaptureLocation(TRawSampleCaptureLocation Value);
	void __fastcall SetRawVideoSampleCapture(bool Value);
	void __fastcall SetRecordingSize(TRecordingSize Value);
	void __fastcall SetScreenRecordingSizePercent(int Value);
	void __fastcall SetScreenRecordingLayeredWindows(bool Value);
	void __fastcall SetScreenRecordingMonitor(int Value);
	void __fastcall SetScreenRecordingNonVisibleWindows(bool Value);
	void __fastcall SetScreenRecordingThroughClipboard(bool Value);
	void __fastcall SetScreenRecordingWithCursor(bool Value);
	void __fastcall SetShapeOverlay(Vcl::Extctrls::TShape* Value);
	void __fastcall SetShapeOverlayEnabled(bool Value);
	void __fastcall SetSpeakerControl(bool Value);
	void __fastcall SetStoragePath(System::UnicodeString Value);
	void __fastcall SetStoragePathMode(TStoragePathMode Value);
	void __fastcall SetStoreDeviceSettingsInRegistry(bool Value);
	void __fastcall SetSourceStream(System::Classes::TStream* Value);
	void __fastcall SetSynchronizationRole(TSynchronizationRole Value);
	void __fastcall SetSynchronized(bool Value);
	void __fastcall SetSyncCommands(bool Value);
	void __fastcall SetSyncPreview(TSyncPreview Value);
	void __fastcall SetTextOverlayAlign(TTextOverlayAlign Value);
	void __fastcall SetTextOverlayAlphaBlend(bool Value);
	void __fastcall SetTextOverlayAlphaBlendValue(int Value);
	void __fastcall SetTextOverlayBkColor(System::Uitypes::TColor Value);
	void __fastcall SetTextOverlayEnabled(bool Value);
	void __fastcall SetTextOverlayFont(Vcl::Graphics::TFont* Value);
	void __fastcall SetTextOverlayFontColor(System::Uitypes::TColor Value);
	void __fastcall SetTextOverlayFontSize(int Value);
	void __fastcall SetTextOverlayGradientMode(TTextOverlayGradientMode Value);
	void __fastcall SetTextOverlayGradientColor(System::Uitypes::TColor Value);
	void __fastcall SetTextOverlayHighResFont(bool Value);
	void __fastcall SetTextOverlayLeft(int Value);
	void __fastcall SetTextOverlayVideoAlignment(TVideoAlignment Value);
	void __fastcall SetTextOverlayRight(int Value);
	void __fastcall SetTextOverlayOrientation(TTextOrientation Value);
	void __fastcall SetTextOverlayScrolling(bool Value);
	void __fastcall SetTextOverlayScrollingSpeed(int Value);
	void __fastcall SetTextOverlaySelector(int Value);
	void __fastcall SetTextOverlayShadow(bool Value);
	void __fastcall SetTextOverlayShadowColor(System::Uitypes::TColor Value);
	void __fastcall SetTextOverlayShadowDirection(TCardinalDirection Value);
	void __fastcall SetTextOverlayString(System::UnicodeString Value);
	void __fastcall SetTextOverlayTargetDisplay(int Value);
	void __fastcall SetTextOverlayTop(int Value);
	void __fastcall SetTextOverlayTransparent(bool Value);
	void __fastcall SetThirdPartyDeinterlacer(System::UnicodeString Value);
	void __fastcall SetTranslateMouseCoordinates(bool Value);
	void __fastcall SetTVUseFrequencyOverrides(bool Value);
	void __fastcall SetTunerFrequency(int Value);
	void __fastcall SetUseClock(bool Value);
	void __fastcall SetVersion(System::UnicodeString Value);
	void __fastcall SetVideoCompression_DataRate(int Value);
	void __fastcall SetVideoCompression_KeyFrameRate(int Value);
	void __fastcall SetVideoCompression_PFramesPerKeyFrame(int Value);
	void __fastcall SetVideoCompression_Quality(double Value);
	void __fastcall SetVideoCompression_WindowSize(int Value);
	void __fastcall SetVideoControlSettings(bool Value);
	void __fastcall SetVideoDelay(__int64 Value);
	void __fastcall Setv360_Enabled(bool Value);
	void __fastcall Setv360_MouseAction(TV360_MouseAction Value);
	void __fastcall Setv360_MouseActionPercent(int Value);
	void __fastcall Setv360_MasterAngle(Tv360_Angle Value);
	void __fastcall Setv360_AspectRatio(double Value);
	void __fastcall SetVideoDevice(int Value);
	void __fastcall SetAnalogVideoStandard(int Value);
	void __fastcall SetAudioCompressor(int Value);
	void __fastcall SetAudioInput(int Value);
	void __fastcall SetVideoCompressor(int Value);
	void __fastcall SetVideoFormat(int Value);
	void __fastcall SetVideoInput(int Value);
	void __fastcall SetVideoSize(int Value);
	void __fastcall SetVideoSubtype(int Value);
	void __fastcall SetVideoFromImages_SourceDirectory(System::UnicodeString Value);
	void __fastcall SetVideoFromImages_TemporaryFile(System::UnicodeString Value);
	void __fastcall SetVideoFromImages_BitmapsSortedBy(TFileSort Value);
	void __fastcall SetVideoFromImages_RepeatIndefinitely(bool Value);
	void __fastcall SetVideoPlayableWhileRecording(bool Value);
	void __fastcall SetVideoProcessingBrightness(int Value);
	void __fastcall SetVideoProcessingContrast(int Value);
	void __fastcall SetVideoProcessingDeinterlacing(TVideoDeinterlacing Value);
	void __fastcall SetVideoProcessingGrayScale(bool Value);
	void __fastcall SetVideoProcessingHue(int Value);
	void __fastcall SetVideoProcessingInvertColors(bool Value);
	void __fastcall SetVideoProcessingLeftRight(bool Value);
	void __fastcall SetVideoProcessingPixellization(int Value);
	void __fastcall SetVideoProcessingRotationCustomAngle(double Value);
	void __fastcall SetVideoProcessingRotation(TVideoRotation Value);
	void __fastcall SetVideoProcessingSaturation(int Value);
	void __fastcall SetVideoProcessingTopDown(bool Value);
	void __fastcall SetVideoQualitySettings(bool Value);
	void __fastcall SetVideoRenderer(TVideoRenderer Value);
	void __fastcall SetVideoRendererExternal(TVideoRendererExternal Value);
	void __fastcall SetVideoRendererExternalIndex(int Value);
	void __fastcall SetVideoRendererPriority(TVideoRendererPriority Value);
	void __fastcall SetVideoSource(TVideoSource Value);
	void __fastcall SetVideoSource_FileOrURL(System::UnicodeString Value);
	void __fastcall SetVideoSource_FileOrURL_StartTime(__int64 Value);
	void __fastcall SetVideoSource_FileOrURL_StopTime(__int64 Value);
	void __fastcall SetStreamInterface_Format(System::UnicodeString Value);
	void __fastcall SetStreamInterface_FrameRate(double Value);
	void __fastcall SetStreamInterface_IsRealTime(bool Value);
	void __fastcall SetVideoStreamNumber(int Value);
	void __fastcall SetVideoVisibleWhenStopped(bool Value);
	void __fastcall SetVirtualVideoStreamControl(int Value);
	void __fastcall SetVirtualAudioStreamControl(int Value);
	void __fastcall SetVuMeter(TVuMeter Value);
	void __fastcall SetWebcamStillCaptureButton(TWebcamStillCaptureButton Value);
	void __fastcall SetZoomXCenter(int Value);
	void __fastcall SetZoomYCenter(int Value);
	void __fastcall SetZoomCoeff(int Value);
	System::Uitypes::TCursor __fastcall GetBusyCursor(void);
	void __fastcall SetBusyCursor(System::Uitypes::TCursor Value);
	System::Uitypes::TCursor __fastcall GetVideoCursor(void);
	void __fastcall SetVideoCursor(System::Uitypes::TCursor Value);
	System::Uitypes::TCursor __fastcall GetNormalCursor(void);
	void __fastcall SetNormalCursor(System::Uitypes::TCursor Value);
	System::UnicodeString __fastcall GetAnalogVideoStandards(void);
	int __fastcall GetAnalogVideoStandardsCount(void);
	int __fastcall GetBufferCount(void);
	System::UnicodeString __fastcall GetASFProfiles(void);
	int __fastcall GetASFProfilesCount(void);
	int __fastcall GetAudioBalance(void);
	System::UnicodeString __fastcall GetAudioCompressorName(void);
	int __fastcall GetAudioInputBalance(void);
	int __fastcall GetAudioInputLevel(void);
	bool __fastcall GetAudioInputMono(void);
	System::UnicodeString __fastcall GetAudioInputs(void);
	int __fastcall GetAudioInputsCount(void);
	System::UnicodeString __fastcall GetAudioDeviceName(void);
	System::UnicodeString __fastcall GetAudioFormats(void);
	System::UnicodeString __fastcall GetAudioRendererName(void);
	int __fastcall GetAudioVolume(void);
	bool __fastcall GetAudioVolumeEnabled(void);
	bool __fastcall GetBusy(void);
	int __fastcall GetCropping_YMax(void);
	int __fastcall GetCropping_XMax(void);
	double __fastcall GetCurrentFrameRate(void);
	TCurrentState __fastcall GetCurrentState(void);
	__int64 __fastcall GetDeliveredFrames(void);
	System::UnicodeString __fastcall GetDirectShowFilters(void);
	int __fastcall GetDirectShowFiltersCount(void);
	int __fastcall GetDroppedFrameCount(void);
	System::UnicodeString __fastcall GetAudioCompressors(void);
	int __fastcall GetAudioCompressorsCount(void);
	System::UnicodeString __fastcall GetAudioDevices(void);
	int __fastcall GetAudioDevicesCount(void);
	System::UnicodeString __fastcall GetAudioRenderers(void);
	int __fastcall GetAudioRenderersCount(void);
	TFrameGrabberRGBFormat __fastcall GetFrameGrabberCurrentRGBFormat(void);
	bool __fastcall GetHoldRecording(void);
	double __fastcall GetImageRatio(void);
	bool __fastcall GetInFrameProgressEvent(void);
	bool __fastcall GetIsAnalogVideoDecoderAvailable(void);
	bool __fastcall GetIsAudioCrossbarAvailable(void);
	TTriState __fastcall GetIsAudioInputBalanceAvailable(void);
	bool __fastcall GetIsCameraControlAvailable(void);
	bool __fastcall GetIsDigitalVideoIn(void);
	bool __fastcall GetIsDVCommandAvailable(void);
	bool __fastcall GetIsHorizontalSyncLocked(void);
	bool __fastcall GetIsMpegStream(void);
	TTriState __fastcall GetIsPlayerAudioStreamAvailable(void);
	TTriState __fastcall GetIsPlayerVideoStreamAvailable(void);
	bool __fastcall GetIsRecordingPaused(void);
	bool __fastcall GetTimeCodeReaderAvailable(void);
	bool __fastcall GetIsTVAudioAvailable(void);
	bool __fastcall GetIsTVAutoTuneRunning(void);
	bool __fastcall GetIsTVTunerAvailable(void);
	bool __fastcall GetIsVideoControlAvailable(void);
	bool __fastcall GetIsVideoCrossbarAvailable(void);
	bool __fastcall GetIsVideoQualityAvailable(void);
	bool __fastcall GetIsVideoPortAvailable(void);
	bool __fastcall GetIsVideoInterlaced(void);
	bool __fastcall GetIsWDMVideoDriver(void);
	System::UnicodeString __fastcall GetLast_BurstFrameCapture_FileName(void);
	System::UnicodeString __fastcall GetLast_CaptureFrameTo_FileName(void);
	System::UnicodeString __fastcall GetLast_Recording_FileName(void);
	System::UnicodeString __fastcall GetLast_Clip_Played(void);
	double __fastcall GetMotionDetector_GlobalMotionRatio(void);
	int __fastcall GetMotionDetector_GridXCount(void);
	int __fastcall GetMotionDetector_GridYCount(void);
	bool __fastcall GetMotionDetector_IsGridValid(void);
	TMpegStreamType __fastcall GetMpegStreamType(void);
	System::UnicodeString __fastcall GetMultiplexerName(void);
	System::UnicodeString __fastcall GetMultiplexers(void);
	int __fastcall GetMultiplexersCount(void);
	int __fastcall GetPlaylistIndex(void);
	__int64 __fastcall GetPlayerDuration(void);
	__int64 __fastcall GetPlayerFrameCount(void);
	__int64 __fastcall GetPlayerFramePosition(void);
	__int64 __fastcall GetPlayerTimePosition(void);
	double __fastcall GetPlayerFrameRate(void);
	TPlayerState __fastcall GetPlayerState(void);
	System::UnicodeString __fastcall GetPropertyPageSaverGroup(void);
	int __fastcall GetRecordingBacktimedFramesCount(void);
	bool __fastcall GetRecordingCanPause(void);
	double __fastcall GetRecordingDuration(void);
	System::UnicodeString __fastcall GetRecordingFourCC(void);
	int __fastcall GetRecordingHeight(void);
	int __fastcall GetRecordingWidth(void);
	__int64 __fastcall GetReencodingStartFrame(void);
	__int64 __fastcall GetReencodingStartTime(void);
	__int64 __fastcall GetReencodingStopFrame(void);
	__int64 __fastcall GetReencodingStopTime(void);
	int __fastcall GetSendToDV_DeviceIndex(void);
	int __fastcall GetSpeakerBalance(void);
	int __fastcall GetSpeakerVolume(void);
	System::UnicodeString __fastcall GetStreamingURL(void);
	System::UnicodeString __fastcall GetSystemTempPath(void);
	int __fastcall GetTVChannel(void);
	int __fastcall GetTVCountryCode(void);
	TTunerInput __fastcall GetTVTunerInputType(void);
	TTunerMode __fastcall GetTunerMode(void);
	int __fastcall GetUniqueID(void);
	bool __fastcall GetVCRHorizontalLocking(void);
	System::UnicodeString __fastcall GetVideoCompressorName(void);
	System::UnicodeString __fastcall GetVideoCompressors(void);
	int __fastcall GetVideoCompressorsCount(void);
	System::UnicodeString __fastcall GetVideoDevices(void);
	System::UnicodeString __fastcall GetVideoDevicesId(void);
	int __fastcall GetVideoDevicesCount(void);
	System::UnicodeString __fastcall GetVideoFormats(void);
	int __fastcall GetVideoFormatsCount(void);
	System::UnicodeString __fastcall GetVideoInputs(void);
	int __fastcall GetVideoInputsCount(void);
	System::UnicodeString __fastcall GetVideoDeviceName(void);
	System::UnicodeString __fastcall GetVideoSizes(void);
	int __fastcall GetVideoSizesCount(void);
	int __fastcall GetVideoHeight(void);
	int __fastcall GetVideoHeight_PreferredAspectRatio(void);
	int __fastcall GetVideoWidth(void);
	int __fastcall GetVideoWidth_PreferredAspectRatio(void);
	System::UnicodeString __fastcall GetVideoSources(void);
	int __fastcall GetVideoSourcesCount(void);
	System::UnicodeString __fastcall GetVideoSubtypes(void);
	int __fastcall GetVideoSubtypesCount(void);
	void __fastcall SetAudioBalance(int Value);
	void __fastcall SetAudioInputBalance(int Value);
	void __fastcall SetAudioInputLevel(int Value);
	void __fastcall SetAudioInputMono(bool Value);
	void __fastcall SetAudioVolume(int Value);
	void __fastcall SetAudioVolumeEnabled(bool Value);
	void __fastcall SetBufferCount(int Value);
	void __fastcall SetHoldRecording(bool Value);
	void __fastcall SetMpegStreamType(TMpegStreamType Value);
	void __fastcall SetPlaylistIndex(int Value);
	void __fastcall SetPlayerDuration(__int64 Value);
	void __fastcall SetPlayerFramePosition(__int64 Value);
	void __fastcall SetPlayerTimePosition(__int64 Value);
	void __fastcall SetPropertyPageSaverGroup(System::UnicodeString Value);
	void __fastcall SetRecordingBacktimedFramesCount(int Value);
	void __fastcall SetRecordingCanPause(bool Value);
	void __fastcall SetReencodingStartFrame(__int64 Value);
	void __fastcall SetReencodingStartTime(__int64 Value);
	void __fastcall SetReencodingStopFrame(__int64 Value);
	void __fastcall SetReencodingStopTime(__int64 Value);
	void __fastcall SetSendToDV_DeviceIndex(int Value);
	void __fastcall SetSpeakerBalance(int Value);
	void __fastcall SetSpeakerVolume(int Value);
	void __fastcall SetTVChannel(int Value);
	void __fastcall SetTVCountryCode(int Value);
	void __fastcall SetTVTunerInputType(TTunerInput Value);
	void __fastcall SetTunerMode(TTunerMode Value);
	void __fastcall SetVCRHorizontalLocking(bool Value);
	
public:
	void __fastcall zReservedInternal4(void * Param1, void * Param2);
	virtual void __fastcall BeforeDestruction(void);
	virtual void __fastcall SetBounds(int ALeft, int ATop, int AWidth, int AHeight);
	void __fastcall About(void);
	int __fastcall AnalogVideoStandardIndex(System::UnicodeString Value);
	System::UnicodeString __fastcall ASFStreaming_GetAuthorizationList(void);
	System::UnicodeString __fastcall ASFStreaming_GetConnectedClients(void);
	int __fastcall ASFStreaming_GetConnectedClientsCount(void);
	bool __fastcall ASFStreaming_ResetAuthorizations(void);
	bool __fastcall ASFStreaming_SetAuthorization(bool Allowed, System::UnicodeString IP, System::UnicodeString Mask);
	bool __fastcall AssociateMultiplexedSlave(int InputNumber, int SlaveUniqueID);
	int __fastcall AudioCompressorIndex(System::UnicodeString Value);
	int __fastcall AudioDeviceIndex(System::UnicodeString Value);
	int __fastcall AudioRendererIndex(System::UnicodeString Value);
	int __fastcall AudioInputIndex(System::UnicodeString Value);
	System::UnicodeString __fastcall AVIInfo2(System::UnicodeString AVIFile, TAVIInfoType AVIInfoType);
	System::UnicodeString __fastcall AVIHeaderInfo(System::UnicodeString AVIFile, THeaderAttribute HeaderAttribute);
	int __fastcall CameraControlValue(TCameraControl Setting);
	bool __fastcall CameraControlAuto(TCameraControl Setting);
	int __fastcall CameraControlDefault(TCameraControl Setting);
	int __fastcall CameraControlMin(TCameraControl Setting);
	int __fastcall CameraControlMax(TCameraControl Setting);
	int __fastcall CameraControlStep(TCameraControl Setting);
	bool __fastcall Cancel(void);
	bool __fastcall CanProcessMessages(void);
	bool __fastcall CaptureFrameTo(TFrameCaptureDest Dest, System::UnicodeString FileName);
	bool __fastcall CaptureFrameRenderedTo(int DisplayIndex, TFrameCaptureDest Dest, System::UnicodeString FileName);
	bool __fastcall CaptureFrameSyncTo(TFrameCaptureDest Dest, System::UnicodeString FileName);
	void __fastcall ClearHeaderAttributes(void);
	void __fastcall ClosePlayer(void);
	void __fastcall ContinueProcessing(void);
	double __fastcall RealProcessingFrameRate(void);
	System::UnicodeString __fastcall GetLastErrorMessage(void);
	HBITMAP __fastcall GetLastFrameAsHBITMAP(int BufferIndex, bool WithOverlays, int SrcLeftLocation, int SrcTopLocation, int SrcWidth, int SrcHeight, int DestWidth, int DestHeight, int BitmapColorBitCount);
	void * __fastcall GetLastFrameBitmapBits(int BufferIndex, bool WithOverlays, bool ReleaseFrame);
	void * __fastcall GetLastFrameBitmapBits2(int BufferIndex, bool WithOverlays, bool ReleaseFrame, /* out */ int &BitmapWidth, /* out */ int &BitmapHeight, /* out */ int &BitmapLineSize, /* out */ int &BitmapSize, /* out */ int &BitmapBitsPerPixel);
	void * __fastcall GetLastFrameBitmapBits3(int BufferIndex, bool WithOverlays, /* out */ int &BitmapWidth, /* out */ int &BitmapHeight, /* out */ int &BitmapLineSize, /* out */ int &BitmapSize, /* out */ int &BitmapBitsPerPixel, /* out */ void * &BitmapBits);
	void __fastcall ReleaseGetLastFrameBitmapBits3(void * FramePtr);
	void * __fastcall WaitForLastFrameBitmapBits(int BufferIndex, bool WithOverlays, bool ReleaseFrame, /* out */ int &BitmapWidth, /* out */ int &BitmapHeight, /* out */ int &BitmapLineSize, /* out */ int &BitmapSize, /* out */ int &BitmapBitsPerPixel, /* out */ __int64 &FrameTime, /* out */ __int64 &FrameNumber);
	Vcl::Graphics::TBitmap* __fastcall GetLastFrameAsTBitmap(int BufferIndex, bool WithOverlays, int SrcLeftLocation, int SrcTopLocation, int SrcWidth, int SrcHeight, int DestWidth, int DestHeight, int BitmapColorBitCount);
	int __fastcall GetFrameBitmapInfo(TFrameBitmapInfoType FrameBitmapInfoType);
	bool __fastcall CreatePreallocCapFile(void);
	bool __fastcall DecklinkKeyer_Enable(bool IsExternal);
	bool __fastcall DecklinkKeyer_SetLevel(int Level_0_255);
	bool __fastcall DecklinkKeyer_RampUp(int NumberOfFrames);
	bool __fastcall DecklinkKeyer_RampDown(int NumberOfFrames);
	bool __fastcall DecklinkKeyer_Disable(void);
	bool __fastcall SetAlphaChannel(int Value);
	double __fastcall DVDInfo(System::UnicodeString DVDRootDirectory, TDVDInfoType DVDInfoType, int TitleNumber);
	void __fastcall Display_SetLocation(int WindowLeft, int WindowTop, int WindowWidth, int WindowHeight);
	void __fastcall DualDisplay_SetLocation(int WindowLeft, int WindowTop, int WindowWidth, int WindowHeight);
	bool __fastcall DrawBitmapOverFrame(Vcl::Graphics::TBitmap* Bitmap, bool Stretched, int LeftLocation, int TopLocation, int bmWidth, int bmHeight, bool Transparent_Enabled, bool UseTransparentColor, System::Uitypes::TColor Transparent_ColorValue, bool AlphaBlend_Enabled, int AlphaBlend_Value, bool ChromaKey, int ChromaKeyRGBColor, int ChromaKeyLeewayPercent);
	bool __fastcall Encoder_CloseOutputFile(int EncoderUniqueID);
	bool __fastcall Encoder_Pause(int EncoderUniqueID);
	bool __fastcall Encoder_NewOutputFile(int EncoderUniqueID, System::UnicodeString OutputFile, bool OpenPaused);
	bool __fastcall Encoder_Resume(int EncoderUniqueID);
	int __fastcall Encoders_CreateInstanceForRecording(System::UnicodeString OutputFile);
	int __fastcall Encoders_CreateInstanceForStreaming(System::UnicodeString OutputURL);
	void __fastcall Encoders_RemoveAllInstances(void);
	bool __fastcall Encoders_RemoveInstance(int EncoderUniqueID);
	bool __fastcall EnumerateWindows(void);
	bool __fastcall EnableMultiplexedInput(int InputNumber, bool Enable);
	bool __fastcall EnableThreadMode(void);
	void __fastcall FastForwardPlayer(void);
	System::UnicodeString __fastcall Facebook_GoLive_ReturnStreamURL(System::UnicodeString EndPointURL, System::UnicodeString Title, System::UnicodeString Description, System::UnicodeString Status, System::UnicodeString AccessToken, System::UnicodeString caBundlePath);
	int __fastcall FindIndexInListByName(System::UnicodeString List, System::UnicodeString SearchedString, bool IsSubString, bool IgnoreCase);
	bool __fastcall GetFilterInterfaceByName(System::UnicodeString FilterName, System::_di_IInterface &FilterIntf);
	int __fastcall GetLastAverageStreamValue(TStreamType StreamType);
	System::UnicodeString __fastcall GetAudioCodec(void);
	double __fastcall GetCameraExposure(void);
	System::UnicodeString __fastcall GetCameraExposureAsString(void);
	bool __fastcall GetDisplayActive(int DisplayIndex);
	bool __fastcall GetDisplayAlphaBlendEnabled(int DisplayIndex);
	int __fastcall GetDisplayAlphaBlendValue(int DisplayIndex);
	bool __fastcall GetDisplayAutoSize(int DisplayIndex);
	TAspectRatio __fastcall GetDisplayAspectRatio(int DisplayIndex);
	bool __fastcall GetDisplayEmbedded(int DisplayIndex);
	bool __fastcall GetDisplayEmbedded_FitParent(int DisplayIndex);
	bool __fastcall GetDisplayFullScreen(int DisplayIndex);
	int __fastcall GetDisplayHeight(int DisplayIndex);
	int __fastcall GetDisplayLeft(int DisplayIndex);
	int __fastcall GetDisplayMonitor(int DisplayIndex);
	bool __fastcall GetDisplayMouseMovesWindow(int DisplayIndex);
	int __fastcall GetDisplayPanScanRatio(int DisplayIndex);
	bool __fastcall GetDisplayStayOnTop(int DisplayIndex);
	int __fastcall GetDisplayTop(int DisplayIndex);
	bool __fastcall GetDisplayTransparentColorEnabled(int DisplayIndex);
	int __fastcall GetDisplayTransparentColorValue(int DisplayIndex);
	int __fastcall GetDisplayVideoHeight(int DisplayIndex);
	int __fastcall GetDisplayVideoWidth(int DisplayIndex);
	bool __fastcall GetDisplayVideoPortEnabled(int DisplayIndex);
	void * __fastcall GetDisplayVideoWindowHandle(int DisplayIndex);
	bool __fastcall GetDisplayVisible(int DisplayIndex);
	int __fastcall GetDisplayWidth(int DisplayIndex);
	__int64 __fastcall GetFrameInfo(int FrameId, TFrameInfoId FrameInfoId);
	System::UnicodeString __fastcall GetFrameInfoString(TFrameInfoStringId FrameInfoStringId);
	bool __fastcall GetFWCam1394(System::UnicodeString FWCam1394ID, int &Value, int &Flags, unsigned &Capabilities, int &MinValue, int &MaxValue, int &Default);
	System::UnicodeString __fastcall GetFWCam1394List(void);
	bool __fastcall SetFWCam1394(System::UnicodeString FWCam1394ID, int Value);
	System::UnicodeString __fastcall GetItemNameFromList(System::UnicodeString List, int ItemIndex);
	int __fastcall GetMiscDeviceControl(TMiscDeviceControl MiscDeviceControl, int Index);
	System::UnicodeString __fastcall GetLogString(TLogType Value);
	int __fastcall GetNearestVideoWidth(int PreferredVideoWidth, int PreferredVideoHeight);
	int __fastcall GetNearestVideoHeight(int PreferredVideoWidth, int PreferredVideoHeight);
	System::UnicodeString __fastcall GetNDISessions(bool AsXML, bool ReportURLInfo);
	System::UnicodeString __fastcall GetONVIFURLFromServiceURL(System::UnicodeString ServiceURL);
	int __fastcall GetPlayerOpenProgressPercent(void);
	System::UnicodeString __fastcall GetPlaylist(void);
	bool __fastcall GetTranslatedCoordinates(int DisplayIndex, int NativeX, int NativeY, int &TranslatedX, int &TranslatedY);
	int __fastcall GetTVChannelInfo(TTVChannelInfo Value);
	System::UnicodeString __fastcall GetVideoCodec(void);
	int __fastcall GetVideoWidthFromIndex(int SizeIndex);
	int __fastcall GetVideoHeightFromIndex(int SizeIndex);
	TVuMeter __fastcall GetVuMeter_Enabled(int Index);
	void __fastcall GetNearestVideoSize(int PreferredVideoWidth, int PreferredVideoHeight, /* out */ int &NearestVideoWidth, /* out */ int &NearestVideoHeight);
	bool __fastcall GetVMR9ImageAdjustmentBounds(bool MainDisplay, TVMR9ImageAdjustment VMR9ControlSetting, /* out */ int &MinValue, /* out */ int &MaxValue, /* out */ int &StepSize, /* out */ int &DefaultValue, /* out */ int &CurrentValue);
	bool __fastcall GetVideoSizeFromIndex(int SizeIndex, /* out */ int &_VideoWidth, /* out */ int &_VideoHeight);
	bool __fastcall AVIDuration(System::UnicodeString AVIFile, /* out */ __int64 &Duration, /* out */ __int64 &FrameCount);
	bool __fastcall AVIInfo(System::UnicodeString AVIFile, /* out */ __int64 &Duration, /* out */ __int64 &FrameCount, /* out */ int &_VideoWidth, /* out */ int &_VideoHeight, /* out */ double &VideoFrameRateFps, /* out */ int &AvgBitRate, /* out */ int &AudioChannels, /* out */ int &AudioSamplesPerSec, /* out */ int &AudioBitsPerSample, /* out */ System::UnicodeString &VideoCodec, /* out */ System::UnicodeString &AudioCodec);
	bool __fastcall GetVideoCompressionSettings(/* out */ int &DataRate, /* out */ int &KeyFrameRate, /* out */ int &PFramesPerKeyFrame, /* out */ int &WindowSize, /* out */ double &Quality, /* out */ bool &CanQuality, /* out */ bool &CanCrunch, /* out */ bool &CanKeyFrame, /* out */ bool &CanBFrame, /* out */ bool &CanWindow);
	bool __fastcall GetVideoControlMode(TVideoControl Mode);
	int __fastcall GetRGBPixelAt(int x, int y);
	double __fastcall GetPixelsDistance(int x1, int y1, int x2, int y2);
	unsigned __fastcall GetVUMeterSetting(unsigned ChannelIndex, TVUMeterSetting VUMeterSetting);
	TGraphState __fastcall GraphState(void);
	bool __fastcall IsAudioDeviceConnected(int DeviceIndex);
	bool __fastcall IsAudioDeviceASoundCard(int DeviceIndex);
	bool __fastcall IsAudioRendererConnected(int RendererIndex);
	bool __fastcall IsCameraControlSettingAvailable(TCameraControl Setting);
	bool __fastcall IsDialogAvailable(TDialog Dialog);
	bool __fastcall IsDirectX8OrHigherInstalled(void);
	bool __fastcall IsServerResponding(System::UnicodeString URL, int Timeout_Seconds);
	bool __fastcall IsPlaylistActive(void);
	bool __fastcall IsPreviewStarted(void);
	bool __fastcall IsURLResponding(void);
	TTriState __fastcall IsURLVideoStreamAvailable(int TimeOut_Ms);
	bool __fastcall IsVideoQualitySettingAvailable(TVideoQuality Setting);
	bool __fastcall IsVideoControlModeAvailable(TVideoControl Mode);
	bool __fastcall IsVMR9ImageAdjustmentAvailable(bool MainDisplay);
	bool __fastcall IsVideoDeviceConnected(int DeviceIndex);
	bool __fastcall IsVideoSignalDetected(bool DetectConnexantBlueScreen, bool DetectCustomRGB, int CustomR, int CustomG, int CustomB, bool UseAsMaxValues);
	bool __fastcall IsDVDevice(int Index);
	bool __fastcall LoadCompressorSettingsFromDataString(bool IsVideoCompressor, int CompressorIndex, System::UnicodeString DataString);
	bool __fastcall LoadCompressorSettingsFromTextFile(bool IsVideoCompressor, int CompressorIndex, System::UnicodeString FileName);
	bool __fastcall EnableMultipurposeEncoder(TMultipurposeEncoderInstance MultipurposeEncoderType, bool Enable);
	bool __fastcall SetMultipurposeEncoderSettings(TMultipurposeEncoderInstance MultipurposeEncoderType, System::UnicodeString Settings);
	System::UnicodeString __fastcall MultipurposeEncoder_Convert100nsToHhMmSsZzz(__int64 Time100ns);
	bool __fastcall MultipurposeEncoder_QuickConfigure_UDPStreaming_H264(bool LogTofile, bool VideoEnabled, bool AudioEnabled, System::UnicodeString DestinationIP, int DestinationPort, int VideoBitRateKb, int AudioBitRateKb);
	System::UnicodeString __fastcall GetMultipurposeEncoderSettings(TMultipurposeEncoderInstance MultipurposeEncoderType);
	void __fastcall SetAudioRendererAdditional(int Value);
	bool __fastcall MixAudioSamples(void * pSampleBuffer, int SampleBufferSize, int SampleDataLength, TFormatType SampleFormatType, void * pFormat, __int64 SampleStartTime, __int64 SampleStopTime);
	int __fastcall MonitorsCount(void);
	double __fastcall MotionDetector_CellMotionRatio(int x, int y);
	int __fastcall MotionDetector_CellColorIntensity(TRGBSelector RGBSelector, int x, int y);
	System::UnicodeString __fastcall MotionDetector_Get2DTextGrid(void);
	System::UnicodeString __fastcall MotionDetector_Get2DTextMotion(void);
	int __fastcall MotionDetector_GlobalColorIntensity(TRGBSelector RGBSelector);
	bool __fastcall MotionDetector_GetCellLocation(int x, int y, int &XLocation, int &YLocation);
	bool __fastcall MotionDetector_GetCellSensitivity(int x, int y, int &Value);
	bool __fastcall MotionDetector_GetCellSize(int &XSize, int &YSize);
	bool __fastcall MotionDetector_SetCellSensitivity(int x, int y, int Value);
	void __fastcall MotionDetector_SetGridSize(int x, int y);
	void __fastcall MotionDetector_GloballyIncOrDecSensitivity(int Value);
	void __fastcall MotionDetector_ResetGlobalSensitivity(int Value);
	void __fastcall MotionDetector_Reset(void);
	void __fastcall MotionDetector_ShowGridDialog(void);
	void __fastcall MotionDetector_TriggerNow(void);
	System::Classes::TComponent* __fastcall MotionDetector_EnumGridDialogControls(bool FirstControl);
	bool __fastcall MotionDetector_UseThisReferenceSample(Vcl::Graphics::TBitmap* Bitmap, System::UnicodeString BMPFile, System::UnicodeString JPEGFile);
	TTriState __fastcall MP4NeedsReindexing(System::UnicodeString FilePath);
	int __fastcall MultiplexerIndex(System::UnicodeString Value);
	bool __fastcall MultipurposeEncoder_ReindexClip(System::UnicodeString CurrentFileName, System::UnicodeString NewFileName);
	System::UnicodeString __fastcall MultipurposeEncoder_GetLastLog(TMultipurposeEncoderInstance MultipurposeEncoderType);
	bool __fastcall MultipurposeEncoder_GetCurrentInfo(TMultipurposeEncoderInstance MultipurposeEncoderType, /* out */ unsigned &InputsTotalDurationMs, /* out */ unsigned &FrameCount, /* out */ double &fps, /* out */ double &quality, /* out */ double &SizeWrittenKb, /* out */ unsigned &TimeMs, /* out */ double &BitRateKbps, /* out */ unsigned &DuplicatedCount, /* out */ unsigned &DroppedCount, /* out */ int &ExitCode);
	void __fastcall NotifyPlayerTrackbarAction(TTrackbarAction TrackbarAction);
	bool __fastcall ONVIF_GetBool(System::UnicodeString ParamIdentifier, /* out */ bool &Value);
	bool __fastcall ONVIF_GetDouble(System::UnicodeString ParamIdentifier, /* out */ double &Value);
	bool __fastcall ONVIF_GetInt(System::UnicodeString ParamIdentifier, /* out */ int &Value);
	bool __fastcall ONVIF_GetStr(System::UnicodeString ParamIdentifier, System::UnicodeString &Value);
	bool __fastcall ONVIF_SetBool(System::UnicodeString ParamIdentifier, bool Value);
	bool __fastcall ONVIF_SetDouble(System::UnicodeString ParamIdentifier, double Value);
	bool __fastcall ONVIF_SetInt(System::UnicodeString ParamIdentifier, int Value);
	bool __fastcall ONVIF_SetStr(System::UnicodeString ParamIdentifier, System::UnicodeString Value);
	bool __fastcall ONVIFPTZGetLimits(/* out */ double &Pan_Min, /* out */ double &Pan_Max, /* out */ double &Tilt_Min, /* out */ double &Tilt_Max, /* out */ double &Zoom_Min, /* out */ double &Zoom_Max);
	bool __fastcall ONVIFPTZGetPosition(/* out */ double &Pan, /* out */ double &Tilt, /* out */ double &Zoom, /* out */ __int64 &UTCTime, /* out */ int &IsMoving);
	bool __fastcall ONVIFPTZSetPosition(double Pan, double Tilt, double Zoom, double SpeedRatio, bool IsRelative);
	bool __fastcall ONVIFPTZStartMove(System::UnicodeString PTZType, bool OppositeDirection, double SpeedRatio, int DurationMs);
	bool __fastcall ONVIFPTZStopMove(System::UnicodeString PTZType);
	bool __fastcall ONVIFPTZPreset(System::UnicodeString PresetAction, System::UnicodeString PresetName);
	bool __fastcall ONVIFPTZSendAuxiliaryCommand(System::UnicodeString AuxiliaryCommand);
	bool __fastcall ONVIFSnapShot(bool OnRawVideoSampleCallbackEnabled, bool SaveToFile, System::UnicodeString FileName);
	System::UnicodeString __fastcall ONVIFDeviceInfo(TONVIFDeviceInfo ONVIFDeviceInfoType);
	bool __fastcall OpenPlayer(void);
	bool __fastcall OpenDVD(void);
	bool __fastcall OpenPlayerAtFramePositions(__int64 StartFrame, __int64 StopFrame, bool KeepBounds, bool CloseAndReopenIfAlreadyOpened);
	bool __fastcall OpenPlayerAtTimePositions(__int64 StartTime, __int64 StopTime, bool KeepBounds, bool CloseAndReopenIfAlreadyOpened);
	TOpenURLAsyncStatus __fastcall OpenURLAsyncStatus(void);
	bool __fastcall PauseRecording(void);
	void __fastcall PausePlayer(void);
	bool __fastcall PlayerFrameStep(int FrameCount);
	bool __fastcall Playlist(TPlaylist PlaylistAction, System::UnicodeString VideoClip);
	bool __fastcall PreloadFilters(System::UnicodeString FilterName_or_Empty_for_All_Filters);
	unsigned __fastcall RecordingKBytesWrittenToDisk(void);
	bool __fastcall ReencodeVideoClip(System::UnicodeString SourceVideoClip, System::UnicodeString NewVideoClip, bool IncludeVideoStream, bool IncludeAudioStream, bool UseFrameGrabber, bool UseCurrentVideoCompressor, bool UseCurrentAudioCompressor);
	void __fastcall RefreshDevicesAndCompressorsLists(void);
	void __fastcall RefreshPlayerOverlays(void);
	bool __fastcall ResetVideoDeviceSettings(void);
	bool __fastcall ResumeRecording(void);
	void __fastcall RewindPlayer(void);
	void __fastcall RunPlayer(void);
	void __fastcall RunPlayerBackwards(void);
	bool __fastcall ScheduleNextActionAtAbsoluteDateTime(int Year, int Month, int Day, int Hour, int Min, int Sec, int MSec);
	bool __fastcall ScheduleNextActionAtAbsoluteTime(int Hour, int Min, int Sec, int MSec);
	bool __fastcall ScheduleNextActionFromNow(int Day, int Hour, int Min, int Sec, int MSec);
	void __fastcall SetDisplayActive(int DisplayIndex, bool Value);
	void __fastcall SetDisplayAlphaBlendEnabled(int DisplayIndex, bool Value);
	void __fastcall SetDisplayAlphaBlendValue(int DisplayIndex, int Value);
	bool __fastcall SetDisplayAssociatedRenderer(int DisplayIndex, System::UnicodeString Value);
	void __fastcall SetDisplayAutoSize(int DisplayIndex, bool Value);
	void __fastcall SetDisplayAspectRatio(int DisplayIndex, TAspectRatio Value);
	void __fastcall SetDisplayEmbedded(int DisplayIndex, bool Value);
	void __fastcall SetDisplayEmbedded_FitParent(int DisplayIndex, bool Value);
	void __fastcall SetDisplayFullScreen(int DisplayIndex, bool Value);
	void __fastcall SetDisplayHeight(int DisplayIndex, int Value);
	void __fastcall SetDisplayLeft(int DisplayIndex, int Value);
	bool __fastcall SetDisplayLocation(int DisplayIndex, int WindowLeft, int WindowTop, int WindowWidth, int WindowHeight);
	void __fastcall SetDisplayMonitor(int DisplayIndex, int Value);
	void __fastcall SetDisplayMouseMovesWindow(int DisplayIndex, bool Value);
	void __fastcall SetDisplayPanScanRatio(int DisplayIndex, int Value);
	bool __fastcall SetDisplayParent(int DisplayIndex, Vcl::Controls::TWinControl* DisplayParent);
	void __fastcall SetDisplayStayOnTop(int DisplayIndex, bool Value);
	void __fastcall SetDisplayTop(int DisplayIndex, int Value);
	void __fastcall SetDisplayTransparentColorEnabled(int DisplayIndex, bool Value);
	void __fastcall SetDisplayTransparentColorValue(int DisplayIndex, int Value);
	void __fastcall SetDisplayVideoPortEnabled(int DisplayIndex, bool Value);
	void __fastcall SetDisplayVisible(int DisplayIndex, bool Value);
	void __fastcall SetDisplayWidth(int DisplayIndex, int Value);
	void __fastcall SetVuMeter_Enabled(int Index, TVuMeter Value);
	bool __fastcall StartSynchronized(void);
	int __fastcall VideoCompressorIndex(System::UnicodeString Value);
	int __fastcall VideoDeviceIndex(System::UnicodeString Value);
	int __fastcall VideoDeviceIndexFromId(System::UnicodeString Value);
	int __fastcall VideoFormatIndex(System::UnicodeString Value);
	int __fastcall VideoInputIndex(System::UnicodeString Value);
	int __fastcall VideoSizeIndex(System::UnicodeString Value);
	int __fastcall VideoSubtypeIndex(System::UnicodeString Value);
	bool __fastcall SendDVCommand(TDVCommand DVCommand);
	bool __fastcall SendIPCameraCommand(System::UnicodeString IPCameraCommand);
	int __fastcall StreamInterface_PushData(System::PByte Buffer, int BufferSize);
	void __fastcall SetAuthentication(TAuthenticationType AuthenticationType, System::UnicodeString UserName, System::UnicodeString Password);
	int __fastcall Mixer_AddToMixer(int SourceUniqueID, int SourceVideoInput, int MosaicLine, int MosaicColumn, int AlternatedGroup, int AlternatedTimeIntervalInMs, bool ReplacePreviouslyAdded, bool CanEraseBackground);
	int __fastcall Mixer_AddAudioToMixer(int SourceUniqueID);
	bool __fastcall Mixer_AudioActivation(int Id, bool Activate);
	bool __fastcall Mixer_RemoveAudioFromMixer(int Id);
	int __fastcall Mixer_SetupPIPFromSource(int SourceUniqueID, int Source_Left, int Source_Top, int Source_Width, int Source_Height, bool ActivatePIP, int PIP_Left, int PIP_Top, int PIP_Width, int PIP_Height, bool MoveToTop);
	bool __fastcall Mixer_Activation(int Id, bool Activate);
	bool __fastcall Mixer_RemoveFromMixer(int Id);
	bool __fastcall Mixer_SetOverlayAttributes(int Id, bool Transparent_Enabled, bool UseTransparentColor, int Transparent_ColorValue, bool AlphaBlend_Enabled, int AlphaBlend_Value, bool ChromaKey_Enabled, int ChromaKeyRGBColor, int ChromaKeyLeewayPercent, double RotationAngle);
	bool __fastcall Mixer_SetOverlayRoundedCorner(int Id, int CornerRadiusWidth, int CornerRadiusHeight);
	int __fastcall MPEGProgramSetting(TMPEGProgramSetting MPEGProgramSettingValue, int Value);
	System::UnicodeString __fastcall SaveCompressorSettingsToDataString(bool IsVideoCompressor, int CompressorIndex);
	bool __fastcall SaveCompressorSettingsToTextFile(bool IsVideoCompressor, int CompressorIndex, System::UnicodeString FileName);
	bool __fastcall ONVIFDiscoverCameras_Multicast(int timeout_seconds_or_0_for_default);
	bool __fastcall ONVIFDiscoverCameras_IPRange(System::UnicodeString First_IP, System::UnicodeString Last_IP, int timeout_seconds_or_0_for_default);
	bool __fastcall ONVIFCancelDiscovery(void);
	bool __fastcall ONVIFEnumCamerasDiscovered(int CameraIndex, System::UnicodeString &CameraType, System::UnicodeString &CameraONVIFUrl);
	void __fastcall SetAVIMuxConfig(TAVIMuxConfig AVIMuxSetting, int Value);
	bool __fastcall SetCameraControl(TCameraControl Setting, bool SetAuto, bool SetDefault, int SetValue);
	void __fastcall SetCameraExposure(double Value);
	void __fastcall SetFrameCaptureBounds(int LeftPosition, int TopPosition, int RightPosition, int BottomPosition);
	void __fastcall SetMultiplexerFilterByName(System::UnicodeString Value);
	bool __fastcall SetVideoCompressionDefaults(void);
	bool __fastcall SetVideoCompressionSettings(int DataRate, int KeyFrameRate, int PFramesPerKeyFrame, int WindowSize, double Quality);
	bool __fastcall SetVideoControlMode(bool FlipHorizontal, bool FlipVertical, bool ExternalTriggerEnable, bool Trigger);
	bool __fastcall SetVideoControlMode2(TVideoControl Mode, bool Value);
	bool __fastcall SetVideoQuality(TVideoQuality Setting, bool SetAuto, bool SetDefault, int SetValue);
	bool __fastcall SetVMR9ImageAdjustmentValue(bool MainDisplay, TVMR9ImageAdjustment VMR9ControlSetting, int Value, bool FixRange);
	bool __fastcall ShapeOverlayList(Vcl::Extctrls::TShape* Shape, bool Add);
	bool __fastcall ShowDialog(TDialog Dialog);
	void __fastcall ShowDebugWindow(bool FullLog);
	bool __fastcall PausePreview(void);
	int __fastcall PointGreyConfig(TPointGreyConfig ConfigType, unsigned &PGRActionValue, unsigned ulRegister, unsigned ulMode, unsigned ulLeft, unsigned ulTop, unsigned ulWidth, unsigned ulHeight, unsigned ulPercentage, unsigned ulFormat);
	bool __fastcall ResetPreview(void);
	bool __fastcall ResumePreview(void);
	bool __fastcall RecordToNewFileNow(System::UnicodeString NewRecordingFileName, bool ResetStreamTime);
	void __fastcall RetrieveInitialXYAfterRotation(int X, int Y, int &OriginalX, int &OriginalY);
	bool __fastcall SetEncryptionKey(TEncryptionMethod EncryptionMethod, System::UnicodeString KeyValue);
	bool __fastcall SetDecryptionKey(TEncryptionMethod EncryptionMethod, System::UnicodeString KeyValue);
	bool __fastcall Encrypt_File(System::UnicodeString InputFile, System::UnicodeString OutputFile, bool OverwriteIfExists);
	bool __fastcall Decrypt_File(System::UnicodeString InputFile, System::UnicodeString OutputFile, bool OverwriteIfExists);
	bool __fastcall SendImageToVideoFromBitmaps(System::UnicodeString ImageFilePath, void * BitmapHandle, bool CanFreeBitmapHandle, bool EndOfData);
	bool __fastcall SendImageToVideoFromBitmaps2(Winapi::Windows::PBitmapInfo pBtmapInfo, System::PByte pBitmapBits, bool EndOfData);
	bool __fastcall SetFFmpegFilter(int FilterIndex, System::UnicodeString VideoFilterName, System::UnicodeString Parameters);
	bool __fastcall SetFFmpegAudioFilter(int FilterIndex, System::UnicodeString AudioFilterName, System::UnicodeString Parameters);
	void __fastcall SetHeaderAttribute(THeaderAttribute HeaderAttribute, System::UnicodeString Value);
	void __fastcall SetImageOverlay_Attributes(int LeftLocation, int TopLocation, int StretchedWidth, int StretchedHeight, bool Transparent_Enabled, bool UseTransparentColor, int Transparent_ColorValue, bool AlphaBlend_Enabled, int AlphaBlend_Value);
	void __fastcall SetImageOverlay_Attributes2(int Index, int LeftLocation, int TopLocation, int StretchedWidth, int StretchedHeight, bool Transparent_Enabled, bool UseTransparentColor, int Transparent_ColorValue, bool AlphaBlend_Enabled, int AlphaBlend_Value);
	bool __fastcall SetImageOverlayFromImageFile(System::UnicodeString FileName);
	bool __fastcall SetImageOverlayFromImageFile2(int Index, System::UnicodeString FileName);
	bool __fastcall SetImageOverlayFromBMPFile(System::UnicodeString FileName);
	bool __fastcall SetImageOverlayFromBMPFile2(int Index, System::UnicodeString FileName);
	bool __fastcall SetImageOverlayFromJPEGFile(System::UnicodeString FileName);
	bool __fastcall SetImageOverlayFromJPEGFile2(int Index, System::UnicodeString FileName);
	bool __fastcall SetImageOverlayFromHBitmap(HBITMAP Bitmap);
	bool __fastcall SetImageOverlayFromHBitmap2(int Index, HBITMAP Bitmap);
	bool __fastcall SetImageOverlayFromHBitmap3(int Index, HBITMAP Bitmap, bool ReleaseBitmap);
	bool __fastcall SetImageOverlayFromTBitmap(Vcl::Graphics::TBitmap* Bitmap);
	bool __fastcall SetImageOverlayFromTBitmap2(int Index, Vcl::Graphics::TBitmap* Bitmap);
	bool __fastcall SetImageOverlayFromTImage(Vcl::Extctrls::TImage* Image);
	bool __fastcall SetImageOverlayFromTImage2(int Index, Vcl::Extctrls::TImage* Image);
	bool __fastcall SetIPCameraSetting(TIPCameraSetting Setting, int Value);
	bool __fastcall SetLogoFromBMPFile(System::UnicodeString FileName);
	bool __fastcall SetLogoFromJPEGFile(System::UnicodeString FileName);
	bool __fastcall SetLogoFromHBitmap(HBITMAP Bitmap);
	bool __fastcall SetLogoFromTBitmap(Vcl::Graphics::TBitmap* Bitmap);
	bool __fastcall SetLogoFromTImage(Vcl::Extctrls::TImage* Image);
	bool __fastcall Encoder_GetInt(int EncoderID, TEncoder_int Setting, int &Value);
	bool __fastcall Encoder_SetInt(int EncoderID, TEncoder_int Setting, int Value);
	bool __fastcall Encoder_SetStr(int EncoderID, TEncoder_str Setting, System::UnicodeString Value);
	bool __fastcall ScreenRecordingUsingCoordinates(bool FunctionEnabled, int scLeft, int scTop, int scWidth, int scHeight);
	bool __fastcall SendCameraCommand(int Pan, int Tilt, bool Relative);
	bool __fastcall PutMiscDeviceControl(TMiscDeviceControl MiscDeviceControl, int Index, int Value);
	bool __fastcall SetWindowRecordingByHandle(void * Window_Handle);
	bool __fastcall SetWindowTransparency(void * WndHandle, bool UseColorKey, bool UseAlpha, int AlphaValue);
	bool __fastcall SetWindowRecordingByName(System::UnicodeString WindowName, bool ExactMatch);
	void __fastcall SetVUMeterSetting(unsigned ChannelIndex, TVUMeterSetting VUMeterSetting, NativeInt Value);
	bool __fastcall StartAudioRecording(void);
	bool __fastcall StartAudioRendering(void);
	bool __fastcall StartPreview(void);
	bool __fastcall StartPTZ(void);
	bool __fastcall StartRecording(void);
	bool __fastcall StartReencoding(void);
	bool __fastcall Stop(void);
	void __fastcall StopPreview(void);
	void __fastcall StopPlayer(void);
	void __fastcall StopRecording(void);
	bool __fastcall StopReencoding(void);
	bool __fastcall TextOverlay_CreateCustomFont(int Index, int fHeight, int fWidth, int fEscapement, int fOrientation, int fWeight, bool fItalic, bool fUnderline, bool fStrikeOut, unsigned fCharSet, unsigned fOutputPrecision, unsigned fClipPrecision, unsigned fQuality, unsigned fPitchAndFamily, System::UnicodeString FontFacename);
	bool __fastcall ThirdPartyFilter_AddToList(TThirdPartyFilterList Location, System::UnicodeString GUIDString, System::UnicodeString OptionalDLLFilePath, System::UnicodeString FilterName, bool Enable, bool CanSaveFilterState);
	bool __fastcall ThirdPartyFilter_ClearList(void);
	bool __fastcall ThirdPartyFilter_Enable(TThirdPartyFilterList Location, System::UnicodeString GUIDString, bool Enable);
	bool __fastcall ThirdPartyFilter_RemoveFromList(TThirdPartyFilterList Location, System::UnicodeString GUIDString);
	bool __fastcall ThirdPartyFilter_ShowDialog(TThirdPartyFilterList Location, System::UnicodeString GUIDString);
	bool __fastcall TVGetMinMaxChannels(int &MinChannel, int &MaxChannel);
	bool __fastcall TVClearFrequencyOverrides(void);
	int __fastcall TVSetChannelFrequencyOverride(int TVChannel, int FrequencyInHz);
	bool __fastcall TVStartAutoScan(void);
	bool __fastcall TVStartAutoScanChannels(int MinChannel, int MaxChannel, int Interval_ms);
	bool __fastcall TVStopAutoScan(void);
	void __fastcall UpdateTrackbarBounds(void);
	void __fastcall UseNearestVideoSize(int PreferredWidth, int PreferredHeight, bool Stretch);
	void __fastcall v360_ResetAnglesToDefault(void);
	bool __fastcall v360_SetProjection(Tv360_InOut Direction, Tv360_Projection Value);
	bool __fastcall v360_SetTranspose(Tv360_InOut Direction, bool Value);
	bool __fastcall v360_SetStereoFormat(Tv360_InOut Direction, Tv360_StereoFormat Value);
	bool __fastcall v360_SetInterpolation(Tv360_Interpolation Value);
	bool __fastcall v360_SetAngle(Tv360_InOut Direction, Tv360_Angle Angle, double Value);
	double __fastcall v360_GetAngle(Tv360_InOut Direction, Tv360_Angle Angle);
	bool __fastcall v360_SetYawPitchRoll(double Yaw, double Pitch, double Roll);
	void __fastcall v360_GetYawPitchRoll(double &Yaw, double &Pitch, double &Roll);
	bool __fastcall v360_AddYawPitchRoll(double Yaw, double Pitch, double Roll);
	bool __fastcall VDECGetHorizontalLocked(/* out */ int &plLocked);
	bool __fastcall VDECGetNumberOfLines(/* out */ int &plNumberOfLines);
	bool __fastcall VDECGetOutputEnable(/* out */ int &plOutputEnable);
	bool __fastcall VDECGetVCRHorizontalLocking(/* out */ int &plVCRHorizontalLocking);
	bool __fastcall VDECPutTVFormat(int lAnalogVideoStandard);
	bool __fastcall VDECPutOutputEnable(int lOutputEnable);
	bool __fastcall VDECPutVCRHorizontalLocking(int lVCRHorizontalLocking);
	bool __fastcall VideoFromImages_CreateSetOfBitmaps(void);
	int __fastcall VideoQualityValue(TVideoQuality Setting);
	bool __fastcall VideoQualityAuto(TVideoQuality Setting);
	int __fastcall VideoQualityDefault(TVideoQuality Setting);
	int __fastcall VideoQualityMin(TVideoQuality Setting);
	int __fastcall VideoQualityMax(TVideoQuality Setting);
	int __fastcall VideoQualityStep(TVideoQuality Setting);
	bool __fastcall WriteScriptCommand(System::UnicodeString ScriptType, System::UnicodeString ScriptArgument);
	bool __fastcall MonitorBounds(int MonitorNumber, System::Types::TRect &Bounds);
	int __fastcall Monitor_Primary_Index(void);
	
protected:
	virtual void __fastcall SetName(const System::Classes::TComponentName Value);
	virtual void __fastcall SetParent(Vcl::Controls::TWinControl* AParent);
	virtual void __fastcall CreateHandle(void);
	virtual void __fastcall DestroyWindowHandle(void);
	virtual void __fastcall Loaded(void);
	HIDESBASE MESSAGE void __fastcall WMERASEBKGND(Winapi::Messages::TWMEraseBkgnd &Message);
	MESSAGE void __fastcall WMDropFiles(Winapi::Messages::TWMDropFiles &Msg);
	virtual void __fastcall Notification(System::Classes::TComponent* AComponent, System::Classes::TOperation Operation);
	virtual void __fastcall PaintWindow(HDC DC);
	virtual void __fastcall CreateWnd(void);
	virtual void __fastcall DestroyWnd(void);
	
public:
	__fastcall virtual TVideoGrabber(System::Classes::TComponent* Aowner);
	__fastcall virtual ~TVideoGrabber(void);
	__property System::UnicodeString AnalogVideoStandards = {read=GetAnalogVideoStandards};
	__property int AnalogVideoStandardsCount = {read=GetAnalogVideoStandardsCount, nodefault};
	__property System::UnicodeString ASFProfiles = {read=GetASFProfiles};
	__property int ASFProfilesCount = {read=GetASFProfilesCount, nodefault};
	__property int AudioBalance = {read=GetAudioBalance, write=SetAudioBalance, nodefault};
	__property System::UnicodeString AudioCompressorName = {read=GetAudioCompressorName};
	__property System::UnicodeString AudioCompressors = {read=GetAudioCompressors};
	__property int AudioCompressorsCount = {read=GetAudioCompressorsCount, nodefault};
	__property int AudioInputBalance = {read=GetAudioInputBalance, write=SetAudioInputBalance, nodefault};
	__property int AudioInputLevel = {read=GetAudioInputLevel, write=SetAudioInputLevel, nodefault};
	__property bool AudioInputMono = {read=GetAudioInputMono, write=SetAudioInputMono, nodefault};
	__property System::UnicodeString AudioInputs = {read=GetAudioInputs};
	__property int AudioInputsCount = {read=GetAudioInputsCount, nodefault};
	__property System::UnicodeString AudioDeviceName = {read=GetAudioDeviceName};
	__property System::UnicodeString AudioDevices = {read=GetAudioDevices};
	__property int AudioDevicesCount = {read=GetAudioDevicesCount, nodefault};
	__property System::UnicodeString AudioFormats = {read=GetAudioFormats};
	__property System::UnicodeString AudioRendererName = {read=GetAudioRendererName};
	__property System::UnicodeString AudioRenderers = {read=GetAudioRenderers};
	__property int AudioRenderersCount = {read=GetAudioRenderersCount, nodefault};
	__property int AudioVolume = {read=GetAudioVolume, write=SetAudioVolume, nodefault};
	__property bool AudioVolumeEnabled = {read=GetAudioVolumeEnabled, write=SetAudioVolumeEnabled, nodefault};
	__property int BufferCount = {read=GetBufferCount, write=SetBufferCount, nodefault};
	__property bool Busy = {read=GetBusy, nodefault};
	__property double RecordingDuration = {read=GetRecordingDuration};
	__property System::UnicodeString RecordingFourCC = {read=GetRecordingFourCC};
	__property int Cropping_YMax = {read=GetCropping_YMax, nodefault};
	__property int Cropping_XMax = {read=GetCropping_XMax, nodefault};
	__property double CurrentFrameRate = {read=GetCurrentFrameRate};
	__property TCurrentState CurrentState = {read=GetCurrentState, nodefault};
	__property __int64 DeliveredFrames = {read=GetDeliveredFrames};
	__property System::UnicodeString DirectShowFilters = {read=GetDirectShowFilters};
	__property int DirectShowFiltersCount = {read=GetDirectShowFiltersCount, nodefault};
	__property int Display_VideoHeight = {read=GetDisplayVideoHeight, index=0, nodefault};
	__property int Display_VideoWidth = {read=GetDisplayVideoWidth, index=0, nodefault};
	__property void * Display_VideoWindowHandle = {read=GetDisplayVideoWindowHandle, index=0};
	__property void * DualDisplay_VideoWindowHandle = {read=GetDisplayVideoWindowHandle, index=1};
	__property int DroppedFrames = {read=GetDroppedFrameCount, nodefault};
	__property int DualDisplay_VideoHeight = {read=GetDisplayVideoHeight, index=1, nodefault};
	__property int DualDisplay_VideoWidth = {read=GetDisplayVideoWidth, index=1, nodefault};
	__property TFrameGrabberRGBFormat FrameGrabberCurrentRGBFormat = {read=GetFrameGrabberCurrentRGBFormat, nodefault};
	__property bool HoldRecording = {read=GetHoldRecording, write=SetHoldRecording, nodefault};
	__property int ImageOverlaySelector = {read=GetImageOverlaySelector, write=SetImageOverlaySelector, nodefault};
	__property double ImageRatio = {read=GetImageRatio};
	__property bool InFrameProgressEvent = {read=GetInFrameProgressEvent, nodefault};
	__property bool IsAnalogVideoDecoderAvailable = {read=GetIsAnalogVideoDecoderAvailable, nodefault};
	__property bool IsAudioCrossbarAvailable = {read=GetIsAudioCrossbarAvailable, nodefault};
	__property TTriState IsAudioInputBalanceAvailable = {read=GetIsAudioInputBalanceAvailable, nodefault};
	__property bool IsCameraControlAvailable = {read=GetIsCameraControlAvailable, nodefault};
	__property bool IsDigitalVideoIn = {read=GetIsDigitalVideoIn, nodefault};
	__property bool IsDVCommandAvailable = {read=GetIsDVCommandAvailable, nodefault};
	__property bool IsHorizontalSyncLocked = {read=GetIsHorizontalSyncLocked, nodefault};
	__property bool IsMpegStream = {read=GetIsMpegStream, nodefault};
	__property TTriState IsPlayerAudioStreamAvailable = {read=GetIsPlayerAudioStreamAvailable, nodefault};
	__property TTriState IsPlayerVideoStreamAvailable = {read=GetIsPlayerVideoStreamAvailable, nodefault};
	__property bool IsRecordingPaused = {read=GetIsRecordingPaused, nodefault};
	__property bool IsTimeCodeReaderAvailable = {read=GetTimeCodeReaderAvailable, nodefault};
	__property bool IsTVTunerAvailable = {read=GetIsTVTunerAvailable, nodefault};
	__property bool IsTVAutoTuneRunning = {read=GetIsTVAutoTuneRunning, nodefault};
	__property bool IsTVAudioAvailable = {read=GetIsTVAudioAvailable, nodefault};
	__property bool IsVideoControlAvailable = {read=GetIsVideoControlAvailable, nodefault};
	__property bool IsVideoCrossbarAvailable = {read=GetIsVideoCrossbarAvailable, nodefault};
	__property bool IsVideoInterlaced = {read=GetIsVideoInterlaced, nodefault};
	__property bool IsVideoQualityAvailable = {read=GetIsVideoQualityAvailable, nodefault};
	__property bool IsVideoPortAvailable = {read=GetIsVideoPortAvailable, nodefault};
	__property bool IsWDMVideoDriver = {read=GetIsWDMVideoDriver, nodefault};
	__property System::UnicodeString Last_BurstFrameCapture_FileName = {read=GetLast_BurstFrameCapture_FileName};
	__property System::UnicodeString Last_CaptureFrameTo_FileName = {read=GetLast_CaptureFrameTo_FileName};
	__property System::UnicodeString Last_Recording_FileName = {read=GetLast_Recording_FileName};
	__property System::UnicodeString Last_Clip_Played = {read=GetLast_Clip_Played};
	__property double MotionDetector_GlobalMotionRatio = {read=GetMotionDetector_GlobalMotionRatio};
	__property int MotionDetector_GridXCount = {read=GetMotionDetector_GridXCount, nodefault};
	__property int MotionDetector_GridYCount = {read=GetMotionDetector_GridYCount, nodefault};
	__property bool MotionDetector_IsGridValid = {read=GetMotionDetector_IsGridValid, nodefault};
	__property TMpegStreamType MpegStreamType = {read=GetMpegStreamType, write=SetMpegStreamType, nodefault};
	__property System::UnicodeString MultiplexerName = {read=GetMultiplexerName};
	__property System::UnicodeString Multiplexers = {read=GetMultiplexers};
	__property int MultiplexersCount = {read=GetMultiplexersCount, nodefault};
	__property int PlaylistIndex = {read=GetPlaylistIndex, write=SetPlaylistIndex, nodefault};
	__property System::UnicodeString PlayerAudioCodec = {read=GetAudioCodec};
	__property __int64 PlayerDuration = {read=GetPlayerDuration, write=SetPlayerDuration};
	__property __int64 PlayerFrameCount = {read=GetPlayerFrameCount};
	__property __int64 PlayerFramePosition = {read=GetPlayerFramePosition, write=SetPlayerFramePosition};
	__property int PlayerOpenProgressPercent = {read=GetPlayerOpenProgressPercent, nodefault};
	__property TPlayerState PlayerState = {read=GetPlayerState, nodefault};
	__property __int64 PlayerTimePosition = {read=GetPlayerTimePosition, write=SetPlayerTimePosition};
	__property double PlayerTrackBarScale = {read=GetPlayerTrackBarScale};
	__property double PlayerFrameRate = {read=GetPlayerFrameRate};
	__property System::UnicodeString PlayerVideoCodec = {read=GetVideoCodec};
	__property System::UnicodeString PropertyPageSaverGroup = {read=GetPropertyPageSaverGroup, write=SetPropertyPageSaverGroup};
	__property int RecordingBacktimedFramesCount = {read=GetRecordingBacktimedFramesCount, write=SetRecordingBacktimedFramesCount, nodefault};
	__property bool RecordingCanPause = {read=GetRecordingCanPause, write=SetRecordingCanPause, nodefault};
	__property int RecordingHeight = {read=GetRecordingHeight, nodefault};
	__property int RecordingWidth = {read=GetRecordingWidth, nodefault};
	__property int SendToDV_DeviceIndex = {read=GetSendToDV_DeviceIndex, write=SetSendToDV_DeviceIndex, nodefault};
	__property System::Classes::TStream* SourceStream = {read=GetSourceStream, write=SetSourceStream};
	__property int SpeakerBalance = {read=GetSpeakerBalance, write=SetSpeakerBalance, nodefault};
	__property int SpeakerVolume = {read=GetSpeakerVolume, write=SetSpeakerVolume, nodefault};
	__property System::UnicodeString StreamingURL = {read=GetStreamingURL};
	__property System::UnicodeString SystemTempPath = {read=GetSystemTempPath};
	__property int TextOverlay_Selector = {read=GetTextOverlaySelector, write=SetTextOverlaySelector, nodefault};
	__property int TVChannel = {read=GetTVChannel, write=SetTVChannel, nodefault};
	__property int TVCountryCode = {read=GetTVCountryCode, write=SetTVCountryCode, nodefault};
	__property TTunerInput TVTunerInputType = {read=GetTVTunerInputType, write=SetTVTunerInputType, nodefault};
	__property TTunerMode TunerMode = {read=GetTunerMode, write=SetTunerMode, default=0};
	__property int UniqueID = {read=GetUniqueID, nodefault};
	__property bool VCRHorizontalLocking = {read=GetVCRHorizontalLocking, write=SetVCRHorizontalLocking, nodefault};
	__property System::UnicodeString VideoCompressorName = {read=GetVideoCompressorName};
	__property System::UnicodeString VideoCompressors = {read=GetVideoCompressors};
	__property int VideoCompressorsCount = {read=GetVideoCompressorsCount, nodefault};
	__property System::UnicodeString VideoFormats = {read=GetVideoFormats};
	__property int VideoFormatsCount = {read=GetVideoFormatsCount, nodefault};
	__property System::UnicodeString VideoInputs = {read=GetVideoInputs};
	__property int VideoInputsCount = {read=GetVideoInputsCount, nodefault};
	__property System::UnicodeString VideoDeviceName = {read=GetVideoDeviceName};
	__property System::UnicodeString VideoDevices = {read=GetVideoDevices};
	__property System::UnicodeString VideoDevicesId = {read=GetVideoDevicesId};
	__property int VideoDevicesCount = {read=GetVideoDevicesCount, nodefault};
	__property int VideoHeight = {read=GetVideoHeight, nodefault};
	__property int VideoHeight_PreferredAspectRatio = {read=GetVideoHeight_PreferredAspectRatio, nodefault};
	__property int VideoWidth = {read=GetVideoWidth, nodefault};
	__property int VideoWidth_PreferredAspectRatio = {read=GetVideoWidth_PreferredAspectRatio, nodefault};
	__property System::UnicodeString VideoSizes = {read=GetVideoSizes};
	__property int VideoSizesCount = {read=GetVideoSizesCount, nodefault};
	__property System::UnicodeString VideoSources = {read=GetVideoSources};
	__property int VideoSourcesCount = {read=GetVideoSourcesCount, nodefault};
	__property System::UnicodeString VideoSubtypes = {read=GetVideoSubtypes};
	__property int VideoSubtypesCount = {read=GetVideoSubtypesCount, nodefault};
	
__published:
	__property Align = {default=0};
	__property Alignment = {default=2};
	__property Caption = {default=0};
	__property Color = {default=-16777201};
	__property Enabled = {default=1};
	__property FullRepaint = {default=1};
	__property Height;
	__property Left;
	__property ParentColor = {default=0};
	__property ParentShowHint = {default=1};
	__property Tag = {default=0};
	__property Top;
	__property Visible = {default=1};
	__property Width;
	__property OnResize;
	__property OnDragDrop;
	__property OnDragOver;
	__property OnEndDrag;
	__property OnStartDrag;
	__property Anchors = {default=3};
	__property ParentBiDiMode = {default=1};
	__property OnCanResize;
	__property OnConstrainedResize;
	__property OnContextPopup;
	__property bool AdjustOverlayAspectRatio = {read=GetAdjustOverlayAspectRatio, write=SetAdjustOverlayAspectRatio, default=1};
	__property bool AdjustPixelAspectRatio = {read=GetAdjustPixelAspectRatio, write=SetAdjustPixelAspectRatio, default=1};
	__property TAero Aero = {read=GetAero, write=SetAero, default=0};
	__property int AnalogVideoStandard = {read=GetAnalogVideoStandard, write=SetAnalogVideoStandard, default=-1};
	__property TApplicationPriority ApplicationPriority = {read=GetApplicationPriority, write=SetApplicationPriority, default=0};
	__property int ASFAudioBitRate = {read=GetASFAudioBitRate, write=SetASFAudioBitRate, default=-1};
	__property int ASFAudioChannels = {read=GetASFAudioChannels, write=SetASFAudioChannels, default=-1};
	__property int ASFBufferWindow = {read=GetASFBufferWindow, write=SetASFBufferWindow, default=-1};
	__property TASFDeinterlaceMode ASFDeinterlaceMode = {read=GetASFDeinterlaceMode, write=SetASFDeinterlaceMode, default=0};
	__property bool ASFDirectStreamingKeepClientsConnected = {read=GetASFDirectStreamingKeepClientsConnected, write=SetASFDirectStreamingKeepClientsConnected, default=0};
	__property bool ASFFixedFrameRate = {read=GetASFFixedFrameRate, write=SetASFFixedFrameRate, default=1};
	__property System::UnicodeString ASFMediaServerPublishingPoint = {read=GetASFMediaServerPublishingPoint, write=SetASFMediaServerPublishingPoint};
	__property System::UnicodeString ASFMediaServerTemplatePublishingPoint = {read=GetASFMediaServerTemplatePublishingPoint, write=SetASFMediaServerTemplatePublishingPoint};
	__property bool ASFMediaServerRemovePublishingPointAfterDisconnect = {read=GetASFMediaServerRemovePublishingPointAfterDisconnect, write=SetASFMediaServerRemovePublishingPointAfterDisconnect, default=0};
	__property int ASFNetworkPort = {read=GetASFNetworkPort, write=SetASFNetworkPort, default=0};
	__property int ASFNetworkMaxUsers = {read=GetASFNetworkMaxUsers, write=SetASFNetworkMaxUsers, default=5};
	__property int ASFProfile = {read=GetASFProfile, write=SetASFProfile, default=-1};
	__property System::UnicodeString ASFProfileFromCustomFile = {read=GetASFProfileFromCustomFile, write=SetASFProfileFromCustomFile};
	__property TASFProfileVersion ASFProfileVersion = {read=GetASFProfileVersion, write=SetASFProfileVersion, default=0};
	__property int ASFVideoBitRate = {read=GetASFVideoBitRate, write=SetASFVideoBitRate, default=-1};
	__property double ASFVideoFrameRate = {read=GetASFVideoFrameRate, write=SetASFVideoFrameRate};
	__property int ASFVideoHeight = {read=GetASFVideoHeight, write=SetASFVideoHeight, default=-1};
	__property int ASFVideoMaxKeyFrameSpacing = {read=GetASFVideoMaxKeyFrameSpacing, write=SetASFVideoMaxKeyFrameSpacing, default=-1};
	__property int ASFVideoQuality = {read=GetASFVideoQuality, write=SetASFVideoQuality, default=-1};
	__property int ASFVideoWidth = {read=GetASFVideoWidth, write=SetASFVideoWidth, default=-1};
	__property double AspectRatioToUse = {read=GetAspectRatioToUse, write=SetAspectRatioToUse};
	__property bool AssociateAudioAndVideoDevices = {read=GetAssociateAudioAndVideoDevices, write=SetAssociateAudioAndVideoDevices, default=0};
	__property bool AVIDurationUpdated = {read=GetAVIDurationUpdated, write=SetAVIDurationUpdated, default=1};
	__property TAudioChannelRenderMode AudioChannelRenderMode = {read=GetAudioChannelRenderMode, write=SetAudioChannelRenderMode, default=0};
	__property int AudioCompressor = {read=GetAudioCompressor, write=SetAudioCompressor, nodefault};
	__property int AudioDevice = {read=GetAudioDevice, write=SetAudioDevice, default=-1};
	__property bool AudioDeviceRendering = {read=GetAudioDeviceRendering, write=SetAudioDeviceRendering, default=0};
	__property TAudioFormat AudioFormat = {read=GetAudioFormat, write=SetAudioFormat, default=0};
	__property int AudioInput = {read=GetAudioInput, write=SetAudioInput, default=-1};
	__property bool AudioPeakEvent = {read=GetAudioPeakEvent, write=SetAudioPeakEvent, default=1};
	__property bool AudioRecording = {read=GetAudioRecording, write=SetAudioRecording, default=0};
	__property int AudioRenderer = {read=GetAudioRenderer, write=SetAudioRenderer, default=-1};
	__property int AudioStreamNumber = {read=GetAudioStreamNumber, write=SetAudioStreamNumber, default=-1};
	__property bool AudioSyncAdjustmentEnabled = {read=GetAudioSyncAdjustmentEnabled, write=SetAudioSyncAdjustmentEnabled, default=0};
	__property int AudioSyncAdjustment = {read=GetAudioSyncAdjustment, write=SetAudioSyncAdjustment, default=0};
	__property TAudioSource AudioSource = {read=GetAudioSource, write=SetAudioSource, default=0};
	__property bool AutoConnectRelatedPins = {read=GetAutoConnectRelatedPins, write=SetAutoConnectRelatedPins, default=1};
	__property TAutoFileName AutoFileName = {read=GetAutoFileName, write=SetAutoFileName, default=0};
	__property System::UnicodeString AutoFileNameDateTimeFormat = {read=GetAutoFileNameDateTimeFormat, write=SetAutoFileNameDateTimeFormat};
	__property int AutoFileNameMinDigits = {read=GetAutoFileNameMinDigits, write=SetAutoFileNameMinDigits, default=6};
	__property System::UnicodeString AutoFilePrefix = {read=GetAutoFilePrefix, write=SetAutoFilePrefix};
	__property System::UnicodeString AutoFileSuffix = {read=GetAutoFileSuffix, write=SetAutoFileSuffix};
	__property bool AutoRefreshPreview = {read=GetAutoRefreshPreview, write=SetAutoRefreshPreview, default=0};
	__property bool AutoStartPlayer = {read=GetAutoStartPlayer, write=SetAutoStartPlayer, default=1};
	__property bool AVIFormatOpenDML = {read=GetAVIFormatOpenDML, write=SetAVIFormatOpenDML, default=1};
	__property bool AVIFormatOpenDMLCompatibilityIndex = {read=GetAVIFormatOpenDMLCompatibilityIndex, write=SetAVIFormatOpenDMLCompatibilityIndex, default=1};
	__property System::Uitypes::TColor BackgroundColor = {read=GetBackgroundColor, write=SetBackgroundColor, default=0};
	__property Vcl::Forms::TBorderStyle BorderStyle = {read=GetBorderStyle, write=SetBorderStyle, default=1};
	__property int BurstCount = {read=GetBurstCount, write=SetBurstCount, default=3};
	__property int BurstInterval = {read=GetBurstInterval, write=SetBurstInterval, default=0};
	__property bool BurstMode = {read=GetBurstMode, write=SetBurstMode, default=0};
	__property TFrameCaptureDest BurstType = {read=GetBurstType, write=SetBurstType, default=0};
	__property System::Uitypes::TCursor BusyCursor = {read=GetBusyCursor, write=SetBusyCursor, default=-11};
	__property System::Uitypes::TCursor VideoCursor = {read=GetVideoCursor, write=SetVideoCursor, default=0};
	__property System::Uitypes::TCursor NormalCursor = {read=GetNormalCursor, write=SetNormalCursor, default=0};
	__property bool CameraControlSettings = {read=GetCameraControlSettings, write=SetCameraControlSettings, default=1};
	__property System::UnicodeString CaptureFileExt = {read=GetCaptureFileExt, write=SetCaptureFileExt};
	__property System::Uitypes::TColor ColorKey = {read=GetColorKey, write=SetColorKey, default=1048592};
	__property bool ColorKeyEnabled = {read=GetColorKeyEnabled, write=SetColorKeyEnabled, default=0};
	__property TCompressionMode CompressionMode = {read=GetCompressionMode, write=SetCompressionMode, default=1};
	__property TCompressionType CompressionType = {read=GetCompressionType, write=SetCompressionType, default=0};
	__property bool Display_Active = {read=GetDisplayActive, write=SetDisplayActive, index=0, default=1};
	__property bool Display_AlphaBlendEnabled = {read=GetDisplayAlphaBlendEnabled, write=SetDisplayAlphaBlendEnabled, index=0, default=0};
	__property int Display_AlphaBlendValue = {read=GetDisplayAlphaBlendValue, write=SetDisplayAlphaBlendValue, index=0, default=180};
	__property bool Display_AutoSize = {read=GetDisplayAutoSize, write=SetDisplayAutoSize, index=0, default=0};
	__property TAspectRatio Display_AspectRatio = {read=GetDisplayAspectRatio, write=SetDisplayAspectRatio, index=0, default=0};
	__property bool Display_Embedded = {read=GetDisplayEmbedded, write=SetDisplayEmbedded, index=0, default=1};
	__property bool Display_Embedded_FitParent = {read=GetDisplayEmbedded_FitParent, write=SetDisplayEmbedded_FitParent, index=0, default=0};
	__property bool Display_FullScreen = {read=GetDisplayFullScreen, write=SetDisplayFullScreen, index=0, default=0};
	__property int Display_Height = {read=GetDisplayHeight, write=SetDisplayHeight, index=0, default=720};
	__property int Display_Left = {read=GetDisplayLeft, write=SetDisplayLeft, index=0, default=10};
	__property int Display_Monitor = {read=GetDisplayMonitor, write=SetDisplayMonitor, index=0, default=0};
	__property bool Display_MouseMovesWindow = {read=GetDisplayMouseMovesWindow, write=SetDisplayMouseMovesWindow, index=0, default=1};
	__property int Display_PanScanRatio = {read=GetDisplayPanScanRatio, write=SetDisplayPanScanRatio, index=0, default=50};
	__property bool Display_StayOnTop = {read=GetDisplayStayOnTop, write=SetDisplayStayOnTop, index=0, default=0};
	__property int Display_Top = {read=GetDisplayTop, write=SetDisplayTop, index=0, default=10};
	__property bool Display_TransparentColorEnabled = {read=GetDisplayTransparentColorEnabled, write=SetDisplayTransparentColorEnabled, index=0, default=0};
	__property int Display_TransparentColorValue = {read=GetDisplayTransparentColorValue, write=SetDisplayTransparentColorValue, index=0, default=255};
	__property bool Display_VideoPortEnabled = {read=GetDisplayVideoPortEnabled, write=SetDisplayVideoPortEnabled, index=0, default=1};
	__property bool Display_Visible = {read=GetDisplayVisible, write=SetDisplayVisible, index=0, default=1};
	__property int Display_Width = {read=GetDisplayWidth, write=SetDisplayWidth, index=0, default=1280};
	__property bool DoubleBuffered = {read=GetVideoDoubleBuffered, write=SetVideoDoubleBuffered, default=1};
	__property int DroppedFramesPollingInterval = {read=GetDroppedFramesPollingInterval, write=SetDroppedFramesPollingInterval, default=-1};
	__property bool DualDisplay_Active = {read=GetDisplayActive, write=SetDisplayActive, index=1, default=0};
	__property bool DualDisplay_AlphaBlendEnabled = {read=GetDisplayAlphaBlendEnabled, write=SetDisplayAlphaBlendEnabled, index=1, default=0};
	__property int DualDisplay_AlphaBlendValue = {read=GetDisplayAlphaBlendValue, write=SetDisplayAlphaBlendValue, index=1, default=180};
	__property bool DualDisplay_AutoSize = {read=GetDisplayAutoSize, write=SetDisplayAutoSize, index=1, default=0};
	__property TAspectRatio DualDisplay_AspectRatio = {read=GetDisplayAspectRatio, write=SetDisplayAspectRatio, index=1, default=0};
	__property bool DualDisplay_Embedded = {read=GetDisplayEmbedded, write=SetDisplayEmbedded, index=1, default=0};
	__property bool DualDisplay_Embedded_FitParent = {read=GetDisplayEmbedded_FitParent, write=SetDisplayEmbedded_FitParent, index=1, default=0};
	__property bool DualDisplay_FullScreen = {read=GetDisplayFullScreen, write=SetDisplayFullScreen, index=1, default=0};
	__property int DualDisplay_Height = {read=GetDisplayHeight, write=SetDisplayHeight, index=1, default=720};
	__property int DualDisplay_Left = {read=GetDisplayLeft, write=SetDisplayLeft, index=1, default=20};
	__property int DualDisplay_Monitor = {read=GetDisplayMonitor, write=SetDisplayMonitor, index=1, default=0};
	__property bool DualDisplay_MouseMovesWindow = {read=GetDisplayMouseMovesWindow, write=SetDisplayMouseMovesWindow, index=1, default=1};
	__property int DualDisplay_PanScanRatio = {read=GetDisplayPanScanRatio, write=SetDisplayPanScanRatio, index=1, default=50};
	__property bool DualDisplay_StayOnTop = {read=GetDisplayStayOnTop, write=SetDisplayStayOnTop, index=1, default=0};
	__property int DualDisplay_Top = {read=GetDisplayTop, write=SetDisplayTop, index=1, default=400};
	__property bool DualDisplay_TransparentColorEnabled = {read=GetDisplayTransparentColorEnabled, write=SetDisplayTransparentColorEnabled, index=1, default=0};
	__property int DualDisplay_TransparentColorValue = {read=GetDisplayTransparentColorValue, write=SetDisplayTransparentColorValue, index=1, default=255};
	__property bool DualDisplay_VideoPortEnabled = {read=GetDisplayVideoPortEnabled, write=SetDisplayVideoPortEnabled, index=1, default=0};
	__property bool DualDisplay_Visible = {read=GetDisplayVisible, write=SetDisplayVisible, index=1, default=1};
	__property int DualDisplay_Width = {read=GetDisplayWidth, write=SetDisplayWidth, index=1, default=1280};
	__property bool DVDateTimeEnabled = {read=GetDVDateTimeEnabled, write=SetDVDateTimeEnabled, default=1};
	__property int DVDTitle = {read=GetDVDTitle, write=SetDVDTitle, default=0};
	__property int DVDiscontinuityMinimumInterval = {read=GetDVDiscontinuityMinimumInterval, write=SetDVDiscontinuityMinimumInterval, default=3};
	__property TDVVideoFormat DVEncoder_VideoFormat = {read=GetDVEncoder_VideoFormat, write=SetDVEncoder_VideoFormat, default=1};
	__property TDVSize DVEncoder_VideoResolution = {read=GetDVEncoder_VideoResolution, write=SetDVEncoder_VideoResolution, default=0};
	__property TDVVideoStandard DVEncoder_VideoStandard = {read=GetDVEncoder_VideoStandard, write=SetDVEncoder_VideoStandard, default=0};
	__property bool DVRgb219 = {read=GetDVRgb219, write=SetDVRgb219, default=0};
	__property bool DVReduceFrameRate = {read=GetDVReduceFrameRate, write=SetDVReduceFrameRate, default=0};
	__property bool DVRecordingInNativeFormatSeparatesStreams = {read=GetDVRecordingInNativeFormatSeparatesStreams, write=SetDVRecordingInNativeFormatSeparatesStreams, default=0};
	__property bool DVTimeCodeEnabled = {read=GetDVTimeCodeEnabled, write=SetDVTimeCodeEnabled, default=0};
	__property System::UnicodeString ExtraDLLPath = {read=GetExtraDLLPath, write=SetExtraDLLPath};
	__property bool EventNotificationSynchrone = {read=GetEventNotificationSynchrone, write=SetEventNotificationSynchrone, default=1};
	__property bool Cropping_Enabled = {read=GetCropping_Enabled, write=SetCropping_Enabled, default=0};
	__property int Cropping_Height = {read=GetCropping_Height, write=SetCropping_Height, default=120};
	__property bool Cropping_Outbounds = {read=GetCropping_Outbounds, write=SetCropping_Outbounds, default=1};
	__property int Cropping_Width = {read=GetCropping_Width, write=SetCropping_Width, default=160};
	__property int Cropping_X = {read=GetCropping_X, write=SetCropping_X, default=0};
	__property int Cropping_Y = {read=GetCropping_Y, write=SetCropping_Y, default=0};
	__property double Cropping_Zoom = {read=GetCropping_Zoom, write=SetCropping_Zoom};
	__property bool FixFlickerOrBlackCapture = {read=GetFixFlickerOrBlackCapture, write=SetFixFlickerOrBlackCapture, default=0};
	__property bool FrameCaptureWithoutOverlay = {read=GetFrameCaptureWithoutOverlay, write=SetFrameCaptureWithoutOverlay, default=0};
	__property int FrameCaptureHeight = {read=GetFrameCaptureHeight, write=SetFrameCaptureHeight, default=-1};
	__property int FrameCaptureWidth = {read=GetFrameCaptureWidth, write=SetFrameCaptureWidth, default=-1};
	__property int FrameCaptureZoomSize = {read=GetFrameCaptureZoomSize, write=SetFrameCaptureZoomSize, default=100};
	__property TFrameGrabber FrameGrabber = {read=GetFrameGrabber, write=SetFrameGrabber, default=0};
	__property TFrameGrabberRGBFormat FrameGrabberRGBFormat = {read=GetFrameGrabberRGBFormat, write=SetFrameGrabberRGBFormat, default=0};
	__property bool FrameNumberStartsFromZero = {read=GetFrameNumberStartsFromZero, write=SetFrameNumberStartsFromZero, default=0};
	__property double FrameRate = {read=GetFrameRate, write=SetFrameRate};
	__property int FrameRateDivider = {read=GetFrameRateDivider, write=SetFrameRateDivider, default=0};
	__property int GetLastFrameWaitTimeoutMs = {read=GetGetLastFrameWaitTimeoutMs, write=SetGetLastFrameWaitTimeoutMs, default=0};
	__property bool GeneratePts = {read=GetGeneratePts, write=SetGeneratePts, default=0};
	__property bool ImageOverlayEnabled = {read=GetImageOverlayEnabled, write=SetImageOverlayEnabled, nodefault};
	__property bool ImageOverlay_AlphaBlend = {read=GetImageOverlayAlphaBlend, write=SetImageOverlayAlphaBlend, nodefault};
	__property int ImageOverlay_AlphaBlendValue = {read=GetImageOverlayAlphaBlendValue, write=SetImageOverlayAlphaBlendValue, nodefault};
	__property bool ImageOverlay_ChromaKey = {read=GetImageOverlayChromaKey, write=SetImageOverlayChromaKey, nodefault};
	__property int ImageOverlay_ChromaKeyLeewayPercent = {read=GetImageOverlayChromaKeyLeewayPercent, write=SetImageOverlayChromaKeyLeewayPercent, nodefault};
	__property int ImageOverlay_ChromaKeyRGBColor = {read=GetImageOverlayChromaKeyRGBColor, write=SetImageOverlayChromaKeyRGBColor, nodefault};
	__property int ImageOverlay_Height = {read=GetImageOverlayHeight, write=SetImageOverlayHeight, nodefault};
	__property int ImageOverlay_LeftLocation = {read=GetImageOverlayLeftLocation, write=SetImageOverlayLeftLocation, nodefault};
	__property TVideoAlignment ImageOverlay_VideoAlignment = {read=GetImageOverlayVideoAlignment, write=SetImageOverlayVideoAlignment, nodefault};
	__property double ImageOverlay_RotationAngle = {read=GetImageOverlayRotationAngle, write=SetImageOverlayRotationAngle};
	__property bool ImageOverlay_StretchToVideoSize = {read=GetImageOverlayStretchToVideoSize, write=SetImageOverlayStretchToVideoSize, nodefault};
	__property int ImageOverlay_TopLocation = {read=GetImageOverlayTopLocation, write=SetImageOverlayTopLocation, nodefault};
	__property bool ImageOverlay_Transparent = {read=GetImageOverlayTransparent, write=SetImageOverlayTransparent, nodefault};
	__property int ImageOverlay_TransparentColorValue = {read=GetImageOverlayTransparentColorValue, write=SetImageOverlayTransparentColorValue, nodefault};
	__property bool ImageOverlay_UseTransparentColor = {read=GetImageOverlayUseTransparentColor, write=SetImageOverlayUseTransparentColor, nodefault};
	__property int ImageOverlay_Width = {read=GetImageOverlayWidth, write=SetImageOverlayWidth, nodefault};
	__property int ImageOverlay_TargetDisplay = {read=GetImageOverlayTargetDisplay, write=SetImageOverlayTargetDisplay, nodefault};
	__property System::UnicodeString IPCameraURL = {read=GetIPCameraURL, write=SetIPCameraURL};
	__property TJPEGPerformance JPEGPerformance = {read=GetJPEGPerformance, write=SetJPEGPerformance, default=0};
	__property bool JPEGProgressiveDisplay = {read=GetJPEGProgressiveDisplay, write=SetJPEGProgressiveDisplay, default=0};
	__property int JPEGQuality = {read=GetJPEGQuality, write=SetJPEGQuality, default=100};
	__property System::UnicodeString LicenseString = {read=GetLicenseString, write=SetLicenseString};
	__property bool LogoDisplayed = {read=GetLogoDisplayed, write=SetLogoDisplayed, default=0};
	__property TLogoLayout LogoLayout = {read=GetLogoLayout, write=SetLogoLayout, default=1};
	__property int MixAudioSamples_CurrentSourceLevel = {read=GetMixAudioSamplesLevel, write=SetMixAudioSamplesLevel, index=0, default=100};
	__property int MixAudioSamples_ExternalSourceLevel = {read=GetMixAudioSamplesLevel, write=SetMixAudioSamplesLevel, index=1, default=100};
	__property int Mixer_MosaicColumns = {read=GetMixer_MosaicColumns, write=SetMixer_MosaicColumns, default=1};
	__property int Mixer_MosaicLines = {read=GetMixer_MosaicLines, write=SetMixer_MosaicLines, default=1};
	__property bool MotionDetector_CompareBlue = {read=GetMotionDetector_CompareBlue, write=SetMotionDetector_CompareBlue, default=1};
	__property bool MotionDetector_CompareGreen = {read=GetMotionDetector_CompareGreen, write=SetMotionDetector_CompareGreen, default=1};
	__property bool MotionDetector_GreyScale = {read=GetMotionDetector_GreyScale, write=SetMotionDetector_GreyScale, default=0};
	__property bool MotionDetector_CompareRed = {read=GetMotionDetector_CompareRed, write=SetMotionDetector_CompareRed, default=1};
	__property bool MotionDetector_Enabled = {read=GetMotionDetector_Enabled, write=SetMotionDetector_Enabled, default=0};
	__property System::UnicodeString MotionDetector_Grid = {read=GetMotionDetector_Grid, write=SetMotionDetector_Grid};
	__property double MotionDetector_MaxDetectionsPerSecond = {read=GetMotionDetector_MaxDetectionsPerSecond, write=SetMotionDetector_MaxDetectionsPerSecond};
	__property int MotionDetector_ReduceCPULoad = {read=GetMotionDetector_ReduceCPULoad, write=SetMotionDetector_ReduceCPULoad, default=1};
	__property int MotionDetector_MotionResetMs = {read=GetMotionDetector_MotionResetMs, write=SetMotionDetector_MotionResetMs, default=0};
	__property bool MotionDetector_ReduceVideoNoise = {read=GetMotionDetector_ReduceVideoNoise, write=SetMotionDetector_ReduceVideoNoise, default=0};
	__property bool MotionDetector_Triggered = {read=GetMotionDetector_Triggered, write=SetMotionDetector_Triggered, default=0};
	__property bool MouseWheelEventEnabled = {read=GetMouseWheelEventEnabled, write=SetMouseWheelEventEnabled, default=1};
	__property bool MouseWheelControlsZoomAtCursor = {read=GetMouseWheelControlsZoomAtCursor, write=SetMouseWheelControlsZoomAtCursor, default=0};
	__property bool MultiplexedInputEmulation = {read=GetMultiplexedInputEmulation, write=SetMultiplexedInputEmulation, default=1};
	__property TMultiplexedRole MultiplexedRole = {read=GetMultiplexedRole, write=SetMultiplexedRole, default=0};
	__property int MultiplexedSwitchDelay = {read=GetMultiplexedSwitchDelay, write=SetMultiplexedSwitchDelay, default=0};
	__property int MultiplexedStabilizationDelay = {read=GetMultiplexedStabilizationDelay, write=SetMultiplexedStabilizationDelay, default=100};
	__property int Multiplexer = {read=GetMultiplexer, write=SetMultiplexer, default=-1};
	__property bool MuteAudioRendering = {read=GetMuteAudioRendering, write=SetMuteAudioRendering, default=0};
	__property TNDIBandwidthType NDIBandwidthType = {read=GetNDIBandwidthType, write=SetNDIBandwidthType, default=3};
	__property TNDIFormatType NDIFormatType = {read=GetNDIFormatType, write=SetNDIFormatType, default=1};
	__property System::UnicodeString NDIGroups = {read=GetNDIGroups, write=SetNDIGroups};
	__property System::UnicodeString NDIName = {read=GetNDIName, write=SetNDIName};
	__property int NDIReceiveTimeoutMs = {read=GetNDIReceiveTimeoutMs, write=SetNDIReceiveTimeoutMs, default=5000};
	__property TNetworkStreaming NetworkStreaming = {read=GetNetworkStreaming, write=SetNetworkStreaming, default=0};
	__property TNetworkStreamingType NetworkStreamingType = {read=GetNetworkStreamingType, write=SetNetworkStreamingType, default=0};
	__property TNotificationMethod NotificationMethod = {read=GetNotificationMethod, write=SetNotificationMethod, default=1};
	__property int NotificationSleepTime = {read=GetNotificationSleepTime, write=SetNotificationSleepTime, default=-1};
	__property System::Classes::TThreadPriority NotificationPriority = {read=GetNotificationPriority, write=SetNotificationPriority, default=3};
	__property bool OnFrameBitmapEventSynchrone = {read=GetOnFrameBitmapEventSynchrone, write=SetOnFrameBitmapEventSynchrone, default=0};
	__property bool OpenURLAsync = {read=GetOpenURLAsync, write=SetOpenURLAsync, default=1};
	__property bool OverlayAfterTransform = {read=GetOverlayAfterTransform, write=SetOverlayAfterTransform, default=0};
	__property bool PlayerAudioRendering = {read=GetPlayerAudioRendering, write=SetPlayerAudioRendering, default=1};
	__property TDVSize PlayerDVSize = {read=GetPlayerDVSize, write=SetPlayerDVSize, default=0};
	__property int PlayerFastSeekSpeedRatio = {read=GetPlayerFastSeekSpeedRatio, write=SetPlayerFastSeekSpeedRatio, default=4};
	__property System::UnicodeString PlayerFileName = {read=GetPlayerFileName, write=SetPlayerFileName};
	__property System::UnicodeString PlayerForcedCodec = {read=GetPlayerForcedCodec, write=SetPlayerForcedCodec};
	__property THwAccel PlayerHwAccel = {read=GetPlayerHwAccel, write=SetPlayerHwAccel, default=0};
	__property bool PlayerRefreshPausedDisplay = {read=GetPlayerRefreshPausedDisplay, write=SetPlayerRefreshPausedDisplay, default=0};
	__property double PlayerRefreshPausedDisplayFrameRate = {read=GetPlayerRefreshPausedDisplayFrameRate, write=SetPlayerRefreshPausedDisplayFrameRate};
	__property double PlayerSpeedRatio = {read=GetPlayerSpeedRatio, write=SetPlayerSpeedRatio};
	__property bool PlayerSpeedRatioConstantAudioPitch = {read=GetPlayerSpeedRatioConstantAudioPitch, write=SetPlayerSpeedRatioConstantAudioPitch, default=1};
	__property Vcl::Comctrls::TTrackBar* PlayerTrackBar = {read=GetPlayerTrackBar, write=SetPlayerTrackBar};
	__property Vcl::Menus::TPopupMenu* PopupMenu = {read=Get_PopupMenu, write=SetPopupMenu};
	__property System::Classes::TComponent* PropertyPageSaver = {read=GetPropertyPageSaver, write=SetPropertyPageSaver};
	__property bool PlayerTrackBarSynchrone = {read=GetPlayerTrackBarSynchrone, write=SetPlayerTrackBarSynchrone, default=0};
	__property bool PreallocCapFileCopiedAfterRecording = {read=GetPreallocCapFileCopiedAfterRecording, write=SetPreallocCapFileCopiedAfterRecording, default=1};
	__property bool PreallocCapFileEnabled = {read=GetPreallocCapFileEnabled, write=SetPreallocCapFileEnabled, default=0};
	__property System::UnicodeString PreallocCapFileName = {read=GetPreallocCapFileName, write=SetPreallocCapFileName};
	__property int PreallocCapFileSizeInMB = {read=GetPreallocCapFileSizeInMB, write=SetPreallocCapFileSizeInMB, default=100};
	__property int PreviewZoomSize = {read=GetPreviewZoomSize, write=SetPreviewZoomSize, default=100};
	__property int RecordingAudioBitRate = {read=GetRecordingAudioBitRate, write=SetRecordingAudioBitRate, default=-1};
	__property int RecordingVideoBitRate = {read=GetRecordingVideoBitRate, write=SetRecordingVideoBitRate, default=-1};
	__property System::UnicodeString RecordingFileName = {read=GetRecordingFileName, write=SetRecordingFileName};
	__property int RecordingFileSizeMaxInMB = {read=GetRecordingFileSizeMaxInMB, write=SetRecordingFileSizeMaxInMB, default=0};
	__property bool RecordingInNativeFormat = {read=GetRecordingInNativeFormat, write=SetRecordingInNativeFormat, default=1};
	__property TRecordingMethod RecordingMethod = {read=GetRecordingMethod, write=SetRecordingMethod, default=5};
	__property bool RecordingPauseCreatesNewFile = {read=GetRecordingPauseCreatesNewFile, write=SetRecordingPauseCreatesNewFile, default=0};
	__property bool RecordingOnMotion_Enabled = {read=GetRecordingOnMotion_Enabled, write=SetRecordingOnMotion_Enabled, default=0};
	__property double RecordingOnMotion_MotionThreshold = {read=GetRecordingOnMotion_MotionThreshold, write=SetRecordingOnMotion_MotionThreshold};
	__property TRecordingTimer RecordingTimer = {read=GetRecordingTimer, write=SetRecordingTimer, default=0};
	__property int RecordingTimerInterval = {read=GetRecordingTimerInterval, write=SetRecordingTimerInterval, default=60};
	__property int RecordingOnMotion_NoMotionPauseDelayMs = {read=GetRecordingOnMotion_NoMotionPauseDelayMs, write=SetRecordingOnMotion_NoMotionPauseDelayMs, default=5000};
	__property System::UnicodeString Reencoding_NewVideoClip = {read=GetReencodingNewVideoClip, write=SetReencodingNewVideoClip};
	__property System::UnicodeString Reencoding_SourceVideoClip = {read=GetReencodingSourceVideoClip, write=SetReencodingSourceVideoClip};
	__property __int64 Reencoding_StartTime = {read=GetReencodingStartTime, write=SetReencodingStartTime, default=-1};
	__property __int64 Reencoding_StartFrame = {read=GetReencodingStartFrame, write=SetReencodingStartFrame, default=-1};
	__property __int64 Reencoding_StopTime = {read=GetReencodingStopTime, write=SetReencodingStopTime, default=-1};
	__property __int64 Reencoding_StopFrame = {read=GetReencodingStopFrame, write=SetReencodingStopFrame, default=-1};
	__property bool Reencoding_IncludeAudioStream = {read=GetReencodingIncludeAudioStream, write=SetReencodingIncludeAudioStream, default=1};
	__property bool Reencoding_IncludeVideoStream = {read=GetReencodingIncludeVideoStream, write=SetReencodingIncludeVideoStream, default=1};
	__property TRecordingMethod Reencoding_Method = {read=GetReencodingMethod, write=SetReencodingMethod, default=1};
	__property bool Reencoding_UseAudioCompressor = {read=GetReencodingUseAudioCompressor, write=SetReencodingUseAudioCompressor, default=0};
	__property bool Reencoding_UseFrameGrabber = {read=GetReencodingUseFrameGrabber, write=SetReencodingUseFrameGrabber, default=1};
	__property bool Reencoding_UseVideoCompressor = {read=GetReencodingUseVideoCompressor, write=SetReencodingUseVideoCompressor, default=0};
	__property bool Reencoding_WMVOutput = {read=GetReencodingWMVOutput, write=SetReencodingWMVOutput, default=0};
	__property bool QuickDeviceInitialization = {read=GetQuickDeviceInitialization, write=SetQuickDeviceInitialization, default=0};
	__property bool RawAudioSampleCapture = {read=GetRawAudioSampleCapture, write=SetRawAudioSampleCapture, default=0};
	__property bool RawCaptureAsyncEvent = {read=GetRawCaptureAsyncEvent, write=SetRawCaptureAsyncEvent, default=1};
	__property TRawSampleCaptureLocation RawSampleCaptureLocation = {read=GetRawSampleCaptureLocation, write=SetRawSampleCaptureLocation, default=0};
	__property bool RawVideoSampleCapture = {read=GetRawVideoSampleCapture, write=SetRawVideoSampleCapture, default=0};
	__property TRecordingSize RecordingSize = {read=GetRecordingSize, write=SetRecordingSize, default=0};
	__property int ScreenRecordingSizePercent = {read=GetScreenRecordingSizePercent, write=SetScreenRecordingSizePercent, default=100};
	__property bool ScreenRecordingLayeredWindows = {read=GetScreenRecordingLayeredWindows, write=SetScreenRecordingLayeredWindows, default=0};
	__property int ScreenRecordingMonitor = {read=GetScreenRecordingMonitor, write=SetScreenRecordingMonitor, default=0};
	__property bool ScreenRecordingNonVisibleWindows = {read=GetScreenRecordingNonVisibleWindows, write=SetScreenRecordingNonVisibleWindows, default=0};
	__property bool ScreenRecordingThroughClipboard = {read=GetScreenRecordingThroughClipboard, write=SetScreenRecordingThroughClipboard, default=0};
	__property bool ScreenRecordingWithCursor = {read=GetScreenRecordingWithCursor, write=SetScreenRecordingWithCursor, default=1};
	__property Vcl::Extctrls::TShape* ShapeOverlay = {read=GetShapeOverlay, write=SetShapeOverlay};
	__property bool ShapeOverlayEnabled = {read=GetShapeOverlayEnabled, write=SetShapeOverlayEnabled, default=0};
	__property bool SpeakerControl = {read=GetSpeakerControl, write=SetSpeakerControl, default=0};
	__property System::UnicodeString StoragePath = {read=GetStoragePath, write=SetStoragePath, stored=false};
	__property TStoragePathMode StoragePathMode = {read=GetStoragePathMode, write=SetStoragePathMode, default=0};
	__property bool StoreDeviceSettingsInRegistry = {read=GetStoreDeviceSettingsInRegistry, write=SetStoreDeviceSettingsInRegistry, default=1};
	__property TSynchronizationRole SynchronizationRole = {read=GetSynchronizationRole, write=SetSynchronizationRole, default=0};
	__property bool Synchronized = {read=GetSynchronized, write=SetSynchronized, default=0};
	__property bool SyncCommands = {read=GetSyncCommands, write=SetSyncCommands, default=1};
	__property TSyncPreview SyncPreview = {read=GetSyncPreview, write=SetSyncPreview, default=0};
	__property bool TextOverlay_Enabled = {read=GetTextOverlayEnabled, write=SetTextOverlayEnabled, nodefault};
	__property Vcl::Graphics::TFont* TextOverlay_Font = {read=GetTextOverlayFont, write=SetTextOverlayFont};
	__property System::Uitypes::TColor TextOverlay_FontColor = {read=GetTextOverlayFontColor, write=SetTextOverlayFontColor, nodefault};
	__property int TextOverlay_FontSize = {read=GetTextOverlayFontSize, write=SetTextOverlayFontSize, nodefault};
	__property bool TextOverlay_HighResFont = {read=GetTextOverlayHighResFont, write=SetTextOverlayHighResFont, nodefault};
	__property int TextOverlay_Left = {read=GetTextOverlayLeft, write=SetTextOverlayLeft, nodefault};
	__property int TextOverlay_Top = {read=GetTextOverlayTop, write=SetTextOverlayTop, nodefault};
	__property int TextOverlay_Right = {read=GetTextOverlayRight, write=SetTextOverlayRight, nodefault};
	__property TTextOrientation TextOverlay_Orientation = {read=GetTextOverlayOrientation, write=SetTextOverlayOrientation, nodefault};
	__property bool TextOverlay_Scrolling = {read=GetTextOverlayScrolling, write=SetTextOverlayScrolling, nodefault};
	__property int TextOverlay_ScrollingSpeed = {read=GetTextOverlayScrollingSpeed, write=SetTextOverlayScrollingSpeed, nodefault};
	__property bool TextOverlay_Shadow = {read=GetTextOverlayShadow, write=SetTextOverlayShadow, nodefault};
	__property System::Uitypes::TColor TextOverlay_ShadowColor = {read=GetTextOverlayShadowColor, write=SetTextOverlayShadowColor, nodefault};
	__property TCardinalDirection TextOverlay_ShadowDirection = {read=GetTextOverlayShadowDirection, write=SetTextOverlayShadowDirection, nodefault};
	__property System::Uitypes::TColor TextOverlay_BkColor = {read=GetTextOverlayBkColor, write=SetTextOverlayBkColor, nodefault};
	__property TTextOverlayAlign TextOverlay_Align = {read=GetTextOverlayAlign, write=SetTextOverlayAlign, nodefault};
	__property bool TextOverlay_AlphaBlend = {read=GetTextOverlayAlphaBlend, write=SetTextOverlayAlphaBlend, nodefault};
	__property int TextOverlay_AlphaBlendValue = {read=GetTextOverlayAlphaBlendValue, write=SetTextOverlayAlphaBlendValue, nodefault};
	__property TTextOverlayGradientMode TextOverlay_GradientMode = {read=GetTextOverlayGradientMode, write=SetTextOverlayGradientMode, nodefault};
	__property System::Uitypes::TColor TextOverlay_GradientColor = {read=GetTextOverlayGradientColor, write=SetTextOverlayGradientColor, nodefault};
	__property TVideoAlignment TextOverlay_VideoAlignment = {read=GetTextOverlayVideoAlignment, write=SetTextOverlayVideoAlignment, nodefault};
	__property System::UnicodeString TextOverlay_String = {read=GetTextOverlayString, write=SetTextOverlayString};
	__property int TextOverlay_TargetDisplay = {read=GetTextOverlayTargetDisplay, write=SetTextOverlayTargetDisplay, nodefault};
	__property bool TextOverlay_Transparent = {read=GetTextOverlayTransparent, write=SetTextOverlayTransparent, nodefault};
	__property System::UnicodeString ThirdPartyDeinterlacer = {read=GetThirdPartyDeinterlacer, write=SetThirdPartyDeinterlacer};
	__property bool TranslateMouseCoordinates = {read=GetTranslateMouseCoordinates, write=SetTranslateMouseCoordinates, default=1};
	__property bool TVUseFrequencyOverrides = {read=GetTVUseFrequencyOverrides, write=SetTVUseFrequencyOverrides, default=0};
	__property int TunerFrequency = {read=GetTunerFrequency, write=SetTunerFrequency, default=-1};
	__property bool UseClock = {read=GetUseClock, write=SetUseClock, default=1};
	__property System::UnicodeString Version = {read=GetVersion, write=SetVersion, stored=false};
	__property bool v360_Enabled = {read=Getv360_Enabled, write=Setv360_Enabled, default=0};
	__property double v360_AspectRatio = {read=Getv360_AspectRatio, write=Setv360_AspectRatio};
	__property int v360_MouseActionPercent = {read=Getv360_MouseActionPercent, write=Setv360_MouseActionPercent, default=10};
	__property TV360_MouseAction v360_MouseAction = {read=Getv360_MouseAction, write=Setv360_MouseAction, default=2};
	__property Tv360_Angle v360_MasterAngle = {read=Getv360_MasterAngle, write=Setv360_MasterAngle, default=1};
	__property int VideoDevice = {read=GetVideoDevice, write=SetVideoDevice, default=-1};
	__property int VideoCompression_DataRate = {read=GetVideoCompression_DataRate, write=SetVideoCompression_DataRate, default=-1};
	__property int VideoCompression_KeyFrameRate = {read=GetVideoCompression_KeyFrameRate, write=SetVideoCompression_KeyFrameRate, default=15};
	__property int VideoCompression_PFramesPerKeyFrame = {read=GetVideoCompression_PFramesPerKeyFrame, write=SetVideoCompression_PFramesPerKeyFrame, default=0};
	__property double VideoCompression_Quality = {read=GetVideoCompression_Quality, write=SetVideoCompression_Quality};
	__property int VideoCompression_WindowSize = {read=GetVideoCompression_WindowSize, write=SetVideoCompression_WindowSize, default=-1};
	__property int VideoCompressor = {read=GetVideoCompressor, write=SetVideoCompressor, nodefault};
	__property bool VideoControlSettings = {read=GetVideoControlSettings, write=SetVideoControlSettings, default=1};
	__property __int64 VideoDelay = {read=GetVideoDelay, write=SetVideoDelay};
	__property int VideoFormat = {read=GetVideoFormat, write=SetVideoFormat, default=-1};
	__property TFileSort VideoFromImages_BitmapsSortedBy = {read=GetVideoFromImages_BitmapsSortedBy, write=SetVideoFromImages_BitmapsSortedBy, default=0};
	__property bool VideoFromImages_RepeatIndefinitely = {read=GetVideoFromImages_RepeatIndefinitely, write=SetVideoFromImages_RepeatIndefinitely, default=0};
	__property System::UnicodeString VideoFromImages_SourceDirectory = {read=GetVideoFromImages_SourceDirectory, write=SetVideoFromImages_SourceDirectory, stored=false};
	__property System::UnicodeString VideoFromImages_TemporaryFile = {read=GetVideoFromImages_TemporaryFile, write=SetVideoFromImages_TemporaryFile};
	__property int VideoInput = {read=GetVideoInput, write=SetVideoInput, default=-1};
	__property bool VideoPlayableWhileRecording = {read=GetVideoPlayableWhileRecording, write=SetVideoPlayableWhileRecording, default=0};
	__property int VideoProcessing_Brightness = {read=GetVideoProcessingBrightness, write=SetVideoProcessingBrightness, default=0};
	__property int VideoProcessing_Contrast = {read=GetVideoProcessingContrast, write=SetVideoProcessingContrast, default=0};
	__property TVideoDeinterlacing VideoProcessing_Deinterlacing = {read=GetVideoProcessingDeinterlacing, write=SetVideoProcessingDeinterlacing, default=0};
	__property bool VideoProcessing_FlipHorizontal = {read=GetVideoProcessingLeftRight, write=SetVideoProcessingLeftRight, default=0};
	__property bool VideoProcessing_FlipVertical = {read=GetVideoProcessingTopDown, write=SetVideoProcessingTopDown, default=0};
	__property bool VideoProcessing_GrayScale = {read=GetVideoProcessingGrayScale, write=SetVideoProcessingGrayScale, default=0};
	__property int VideoProcessing_Hue = {read=GetVideoProcessingHue, write=SetVideoProcessingHue, default=0};
	__property bool VideoProcessing_InvertColors = {read=GetVideoProcessingInvertColors, write=SetVideoProcessingInvertColors, default=0};
	__property int VideoProcessing_Pixellization = {read=GetVideoProcessingPixellization, write=SetVideoProcessingPixellization, default=1};
	__property int VideoProcessing_Saturation = {read=GetVideoProcessingSaturation, write=SetVideoProcessingSaturation, default=0};
	__property TVideoRotation VideoProcessing_Rotation = {read=GetVideoProcessingRotation, write=SetVideoProcessingRotation, default=0};
	__property double VideoProcessing_RotationCustomAngle = {read=GetVideoProcessingRotationCustomAngle, write=SetVideoProcessingRotationCustomAngle};
	__property bool VideoQualitySettings = {read=GetVideoQualitySettings, write=SetVideoQualitySettings, default=1};
	__property TVideoRenderer VideoRenderer = {read=GetVideoRenderer, write=SetVideoRenderer, default=0};
	__property TVideoRendererExternal VideoRendererExternal = {read=GetVideoRendererExternal, write=SetVideoRendererExternal, default=0};
	__property int VideoRendererExternalIndex = {read=GetVideoRendererExternalIndex, write=SetVideoRendererExternalIndex, default=-1};
	__property TVideoRendererPriority VideoRendererPriority = {read=GetVideoRendererPriority, write=SetVideoRendererPriority, default=2};
	__property int VideoSize = {read=GetVideoSize, write=SetVideoSize, default=-1};
	__property TVideoSource VideoSource = {read=GetVideoSource, write=SetVideoSource, default=0};
	__property System::UnicodeString VideoSource_FileOrURL = {read=GetVideoSource_FileOrURL, write=SetVideoSource_FileOrURL};
	__property __int64 VideoSource_FileOrURL_StartTime = {read=GetVideoSource_FileOrURL_StartTime, write=SetVideoSource_FileOrURL_StartTime, default=-1};
	__property __int64 VideoSource_FileOrURL_StopTime = {read=GetVideoSource_FileOrURL_StopTime, write=SetVideoSource_FileOrURL_StopTime, default=-1};
	__property System::UnicodeString StreamInterface_Format = {read=GetStreamInterface_Format, write=SetStreamInterface_Format};
	__property double StreamInterface_FrameRate = {read=GetStreamInterface_FrameRate, write=SetStreamInterface_FrameRate};
	__property bool StreamInterface_IsRealTime = {read=GetStreamInterface_IsRealTime, write=SetStreamInterface_IsRealTime, nodefault};
	__property int VideoStreamNumber = {read=GetVideoStreamNumber, write=SetVideoStreamNumber, default=-1};
	__property int VideoSubtype = {read=GetVideoSubtype, write=SetVideoSubtype, default=-1};
	__property bool VideoVisibleWhenStopped = {read=GetVideoVisibleWhenStopped, write=SetVideoVisibleWhenStopped, default=0};
	__property int VirtualVideoStreamControl = {read=GetVirtualVideoStreamControl, write=SetVirtualVideoStreamControl, default=-1};
	__property int VirtualAudioStreamControl = {read=GetVirtualAudioStreamControl, write=SetVirtualAudioStreamControl, default=-1};
	__property TVuMeter VuMeter = {read=GetVuMeter, write=SetVuMeter, default=0};
	__property TWebcamStillCaptureButton WebcamStillCaptureButton = {read=GetWebcamStillCaptureButton, write=SetWebcamStillCaptureButton, default=0};
	__property int ZoomCoeff = {read=GetZoomCoeff, write=SetZoomCoeff, default=1000};
	__property int ZoomXCenter = {read=GetZoomXCenter, write=SetZoomXCenter, default=0};
	__property int ZoomYCenter = {read=GetZoomYCenter, write=SetZoomYCenter, default=0};
	__property TOnAVIDurationUpdated OnAVIDurationUpdated = {read=FOnAVIDurationUpdated, write=FOnAVIDurationUpdated};
	__property TOnEventNotification OnAudioDeviceSelected = {read=FOnAudioDeviceSelected, write=FOnAudioDeviceSelected};
	__property TOnAudioBufferNegotiation OnAudioBufferNegotiation = {read=FOnAudioBufferNegotiation, write=FOnAudioBufferNegotiation};
	__property TOnAudioPeak OnAudioPeak = {read=FOnAudioPeak, write=FOnAudioPeak};
	__property TOnEventNotification OnBacktimedFramesCountReached = {read=FOnBacktimedFramesCountReached, write=FOnBacktimedFramesCountReached};
	__property TOnProgressCommented OnBitmapsLoadingProgress = {read=FOnBitmapsLoadingProgress, write=FOnBitmapsLoadingProgress};
	__property TOnEventNotification OnClick = {read=FOnClick, write=FOnClick};
	__property TOnEventNotification OnDblClick = {read=FOnDblClick, write=FOnDblClick};
	__property TOnClientConnection OnClientConnection = {read=FOnClientConnection, write=FOnClientConnection};
	__property TOnColorKeyChange OnColorKeyChange = {read=FOnColorKeyChange, write=FOnColorKeyChange};
	__property TOnSourceFileToDestFileCompleted OnCopyPreallocDataCompleted = {read=FOnCopyPreallocDataCompleted, write=FOnCopyPreallocDataCompleted};
	__property TOnProgress OnCopyPreallocDataProgress = {read=FOnCopyPreallocDataProgress, write=FOnCopyPreallocDataProgress};
	__property TOnSourceFileToDestFileStarted OnCopyPreallocDataStarted = {read=FOnCopyPreallocDataStarted, write=FOnCopyPreallocDataStarted};
	__property TOnCreatePreallocatedFileCompleted OnCreatePreallocFileCompleted = {read=FOnCreatePreallocFileCompleted, write=FOnCreatePreallocFileCompleted};
	__property TOnProgress OnCreatePreallocFileProgress = {read=FOnCreatePreallocFileProgress, write=FOnCreatePreallocFileProgress};
	__property TOnFileNotification OnCreatePreallocFileStarted = {read=FOnCreatePreallocFileStarted, write=FOnCreatePreallocFileStarted};
	__property TOnDeviceArrivalOrRemoval OnDeviceArrivalOrRemoval = {read=FOnDeviceArrivalOrRemoval, write=Set_OnDeviceArrivalOrRemoval};
	__property TOnEventNotification OnDeviceLost = {read=FOnDeviceLost, write=FOnDeviceLost};
	__property TOnEventNotification OnDeviceReconnecting = {read=FOnDeviceReconnecting, write=FOnDeviceReconnecting};
	__property TOnEventNotification OnDeviceReconnected = {read=FOnDeviceReconnected, write=FOnDeviceReconnected};
	__property TOnDirectNetworkStreamingHostUrl OnDirectNetworkStreamingHostUrl = {read=FOnDirectNetworkStreamingHostUrl, write=FOnDirectNetworkStreamingHostUrl};
	__property TOnEventNotification OnDiskFull = {read=FOnDiskFull, write=FOnDiskFull};
	__property TOnDragDropFiles OnDragDropFiles = {read=FOnDragDropFiles, write=FOnDragDropFiles};
	__property TOnDVDiscontinuity OnDVDiscontinuity = {read=FOnDVDiscontinuity, write=FOnDVDiscontinuity};
	__property TOnDVCommandCompleted OnDVCommandCompleted = {read=FOnDVCommandCompleted, write=FOnDVCommandCompleted};
	__property TOnEnumerateWindows OnEnumerateWindows = {read=FOnEnumerateWindows, write=FOnEnumerateWindows};
	__property TOnFilterSelected OnFilterSelected = {read=FOnFilterSelected, write=FOnFilterSelected};
	__property TOnEventNotification OnFirstFrameReceived = {read=FOnFirstFrameReceived, write=FOnFirstFrameReceived};
	__property TOnFrameBitmap OnFrameBitmap = {read=FOnFrameBitmap, write=FOnFrameBitmap};
	__property TOnFrameBitmap OnFrameBitmapRendering = {read=FOnFrameBitmapRendering, write=FOnFrameBitmapRendering};
	__property TOnFrameCaptureCompleted OnFrameCaptureCompleted = {read=FOnFrameCaptureCompleted, write=FOnFrameCaptureCompleted};
	__property TOnFrameOverlayUsingDC OnFrameOverlayUsingDC = {read=FOnFrameOverlayUsingDC, write=FOnFrameOverlayUsingDC};
	__property TOnFrameOverlayUsingDIB OnFrameOverlayUsingDIB = {read=FOnFrameOverlayUsingDIB, write=FOnFrameOverlayUsingDIB};
	__property TOnFrameOverlayUsingVIDEOHDR OnFrameOverlayUsingVIDEOHDR = {read=FOnFrameOverlayUsingVIDEOHDR, write=FOnFrameOverlayUsingVIDEOHDR};
	__property TOnFrameProgress OnFrameProgress = {read=FOnFrameProgress, write=FOnFrameProgress};
	__property TOnFrameProgress2 OnFrameProgress2 = {read=FOnFrameProgress2, write=FOnFrameProgress2};
	__property TOnEventNotification OnGraphBuilt = {read=FOnGraphBuilt, write=FOnGraphBuilt};
	__property TOnEventNotification OnInactive = {read=FOnInactive, write=FOnInactive};
	__property TOnEventNotification OnLastCommandCompleted = {read=FOnLastCommandCompleted, write=FOnLastCommandCompleted};
	__property TOnEventNotification OnLeavingFullScreen = {read=FOnLeavingFullScreen, write=FOnLeavingFullScreen};
	__property TOnVideoKeyPress OnKeyPress = {read=FOnKeyPress, write=FOnKeyPress};
	__property TOnLog OnLog = {read=FOnLog, write=FOnLog};
	__property TOnMotionDetected OnMotionDetected = {read=FOnMotionDetected, write=FOnMotionDetected};
	__property TOnMotionNotDetected OnMotionNotDetected = {read=FOnMotionNotDetected, write=FOnMotionNotDetected};
	__property TOnVideoMouseUpDown OnMouseDown = {read=FOnMouseDown, write=FOnMouseDown};
	__property TOnVideoMouseUpDown OnMouseDown_Video = {read=FOnMouseDown_Video, write=FOnMouseDown_Video};
	__property TOnVideoMouseUpDown OnMouseDown_Window = {read=FOnMouseDown_Window, write=FOnMouseDown_Window};
	__property TOnVideoMouseEvent OnMouseEnter = {read=FOnMouseEnter, write=FOnMouseEnter};
	__property TOnVideoMouseEvent OnMouseLeave = {read=FOnMouseLeave, write=FOnMouseLeave};
	__property TOnVideoMouseMove OnMouseMove = {read=FOnMouseMove, write=FOnMouseMove};
	__property TOnVideoMouseMove OnMouseMove_Video = {read=FOnMouseMove_Video, write=FOnMouseMove_Video};
	__property TOnVideoMouseMove OnMouseMove_Window = {read=FOnMouseMove_Window, write=FOnMouseMove_Window};
	__property TOnVideoMouseUpDown OnMouseUp = {read=FOnMouseUp, write=FOnMouseUp};
	__property TOnVideoMouseUpDown OnMouseUp_Video = {read=FOnMouseUp_Video, write=FOnMouseUp_Video};
	__property TOnVideoMouseUpDown OnMouseUp_Window = {read=FOnMouseUp_Window, write=FOnMouseUp_Window};
	__property TOnMouseWheel OnMouseWheel = {read=FOnMouseWheel, write=FOnMouseWheel};
	__property TOnMultipurposeEncoderNotification OnMultipurposeEncoderProgress = {read=FOnMultipurposeEncoderProgress, write=FOnMultipurposeEncoderProgress};
	__property TOnMultipurposeEncoderNotification OnMultipurposeEncoderError = {read=FOnMultipurposeEncoderError, write=FOnMultipurposeEncoderError};
	__property TOnMultipurposeEncoderNotification OnMultipurposeEncoderCompleted = {read=FOnMultipurposeEncoderCompleted, write=FOnMultipurposeEncoderCompleted};
	__property TOnONVIFDiscoveryCompletedNotification OnONVIFDiscoveryCompleted = {read=FOnONVIFDiscoveryCompleted, write=FOnONVIFDiscoveryCompleted};
	__property TOnOpenURLAsyncStatusChanged OnOpenURLAsyncStatusChanged = {read=FOnOpenURLAsyncStatusChanged, write=FOnOpenURLAsyncStatusChanged};
	__property TOnEventNotification OnNoVideoDevices = {read=FOnNoVideoDevices, write=FOnNoVideoDevices};
	__property TOnNTPTimeStamp OnNTPTimeStamp = {read=FOnNTPTimeStamp, write=FOnNTPTimeStamp};
	__property TOnPlayerBufferingData OnPlayerBufferingData = {read=FOnPlayerBufferingData, write=FOnPlayerBufferingData};
	__property TOnEventNotification OnPlayerEndOfPlaylist = {read=FOnPlayerEndOfPlaylist, write=FOnPlayerEndOfPlaylist};
	__property TOnEventNotification OnPlayerEndOfStream = {read=FOnPlayerEndOfStream, write=FOnPlayerEndOfStream};
	__property TOnEventNotification OnPlayerOpened = {read=FOnPlayerOpened, write=FOnPlayerOpened};
	__property TOnFrameProgress OnPlayerUpdateTrackbarPosition = {read=FOnPlayerUpdateTrackbarPosition, write=FOnPlayerUpdateTrackbarPosition};
	__property TOnEventNotification OnPreviewStarted = {read=FOnPreviewStarted, write=FOnPreviewStarted};
	__property TOnPlayerStateChanged OnPlayerStateChanged = {read=FOnPlayerStateChanged, write=FOnPlayerStateChanged};
	__property TOnEventNotification OnPlayerDurationUpdated = {read=FOnPlayerDurationUpdated, write=FOnPlayerDurationUpdated};
	__property TOnAuthenticationNeeded OnAuthenticationNeeded = {read=FOnAuthenticationNeeded, write=FOnAuthenticationNeeded};
	__property TOnRawAudioSample OnRawAudioSample = {read=FOnRawAudioSample, write=FOnRawAudioSample};
	__property TOnRawVideoSample OnRawVideoSample = {read=FOnRawVideoSample, write=FOnRawVideoSample};
	__property TOnRecordingCompleted OnRecordingCompleted = {read=FOnRecordingCompleted, write=FOnRecordingCompleted};
	__property TOnEventNotification OnRecordingPaused = {read=FOnRecordingPaused, write=FOnRecordingPaused};
	__property TOnEventNotification OnRecordingReadyToStart = {read=FOnRecordingReadyToStart, write=FOnRecordingReadyToStart};
	__property TOnFileNotification OnRecordingStarted = {read=FOnRecordingStarted, write=FOnRecordingStarted};
	__property TOnSourceFileToDestFileCompleted OnReencodingCompleted = {read=FOnReencodingCompleted, write=FOnReencodingCompleted};
	__property TOnProgress OnReencodingProgress = {read=FOnReencodingProgress, write=FOnReencodingProgress};
	__property TOnSourceFileToDestFileStarted OnReencodingStarted = {read=FOnReencodingStarted, write=FOnReencodingStarted};
	__property TOnEventNotification OnReinitializing = {read=FOnReinitializing, write=FOnReinitializing};
	__property TOnResizeVideo OnResizeVideo = {read=FOnResizeVideo, write=FOnResizeVideo};
	__property TOnEventNotification OnStoppingGraph = {read=FOnStoppingGraph, write=FOnStoppingGraph};
	__property TOnEventNotification OnStoppingGraphCompleted = {read=FOnStoppingGraphCompleted, write=FOnStoppingGraphCompleted};
	__property TOnTextOverlayScrollingCompleted OnTextOverlayScrollingCompleted = {read=FOnTextOverlayScrollingCompleted, write=FOnTextOverlayScrollingCompleted};
	__property TOnThirdPartyFilterAdded OnThirdPartyFilterAdded = {read=FOnThirdPartyFilterAdded, write=FOnThirdPartyFilterAdded};
	__property TOnThirdPartyFilterConnected OnThirdPartyFilterConnected = {read=FOnThirdPartyFilterConnected, write=FOnThirdPartyFilterConnected};
	__property TOnThirdPartyFilterConnected2 OnThirdPartyFilterConnected2 = {read=FOnThirdPartyFilterConnected2, write=FOnThirdPartyFilterConnected2};
	__property TOnThreadSync OnThreadSync = {read=FOnThreadSync, write=FOnThreadSync};
	__property TOnEventNotification OnTVChannelScanCompleted = {read=FOnTVChannelScanCompleted, write=FOnTVChannelScanCompleted};
	__property TOnTVChannelScanStarted OnTVChannelScanStarted = {read=FOnTVChannelScanStarted, write=FOnTVChannelScanStarted};
	__property TOnTVChannelSelected OnTVChannelSelected = {read=FOnTVChannelSelected, write=FOnTVChannelSelected};
	__property TOnVideoCompressionSettings OnVideoCompressionSettings = {read=FOnVideoCompressionSettings, write=FOnVideoCompressionSettings};
	__property TOnEventNotification OnVideoDeviceSelected = {read=FOnVideoDeviceSelected, write=FOnVideoDeviceSelected};
	__property TOnVideoFromBitmapsNextFrameNeeded OnVideoFromBitmapsNextFrameNeeded = {read=FOnVideoFromBitmapsNextFrameNeeded, write=FOnVideoFromBitmapsNextFrameNeeded};
public:
	/* TWinControl.CreateParented */ inline __fastcall TVideoGrabber(HWND ParentWindow) : Vcl::Extctrls::TCustomPanel(ParentWindow) { }
	
};


//-- var, const, procedure ---------------------------------------------------
static const System::Int8 I_MAX_FFMPEGFILTERS = System::Int8(0x9);
static const System::Int8 ENCODER_RECORDING_ID = System::Int8(0x0);
static const System::Int8 ENCODER_STREAMING_ID = System::Int8(0x1);
static const System::Int8 ENCODER_LAST_ID = System::Int8(0x1);
static const System::Int8 ENCODER_NEXT_ID = System::Int8(0x2);
static const bool DEF_AdjustOverlayAspectRatio = true;
static const bool DEF_AdjustPixelAspectRatio = true;
static const TAero DEF_Aero = (TAero)(0);
static const TApplicationPriority DEF_ApplicationPriority = (TApplicationPriority)(0);
static const TOpenURLAsyncStatus DEF_OpenURLAsyncStatus = (TOpenURLAsyncStatus)(3);
static const System::Int8 DEF_ASFAudioBitRate = System::Int8(-1);
static const System::Int8 DEF_ASFAudioChannels = System::Int8(-1);
static const System::Int8 DEF_ASFBufferWindow = System::Int8(-1);
static const TASFDeinterlaceMode DEF_ASFDeinterlaceMode = (TASFDeinterlaceMode)(0);
static const bool DEF_ASFDirectStreamingKeepClientsConnected = false;
static const bool DEF_ASFFixedFrameRate = true;
static const bool DEF_ASFMediaServerRemovePublishingPointAfterDisconnect = false;
static const System::Int8 DEF_ASFNetworkPort = System::Int8(0x0);
static const System::Int8 DEF_ASFNetworkMaxUsers = System::Int8(0x5);
#define DEF_AspectRatioToUse  (-1.000000E+00)
static const System::Int8 DEF_ASFProfile = System::Int8(-1);
static const TASFProfileVersion DEF_ASFProfileVersion = (TASFProfileVersion)(0);
static const System::Int8 DEF_ASFVideoBitRate = System::Int8(-1);
static const System::Int8 DEF_ASFVideoHeight = System::Int8(-1);
static const System::Int8 DEF_ASFVideoMaxKeyFrameSpacing = System::Int8(-1);
static const System::Int8 DEF_ASFVideoQuality = System::Int8(-1);
static const System::Int8 DEF_ASFVideoWidth = System::Int8(-1);
static const bool DEF_AssociateAudioAndVideoDevices = false;
static const System::Int8 DEF_AudioBalance = System::Int8(0x0);
static const TAudioChannelRenderMode DEF_AudioChannelRenderMode = (TAudioChannelRenderMode)(0);
static const System::Int8 DEF_AudioDevice = System::Int8(-1);
static const System::Int8 DEF_AudioRenderer = System::Int8(-1);
static const System::Word DEF_AudioVolume = System::Word(0x7fff);
static const bool DEF_AudioVolumeEnabled = true;
static const System::Int8 DEF_AudioStreamNumber = System::Int8(-1);
static const TAudioFormat DEF_AudioFormat = (TAudioFormat)(0);
static const bool DEF_AudioDeviceRendering = false;
static const bool DEF_OpenURLAsync = true;
static const bool DEF_AudioSyncAdjustmentEnabled = false;
static const System::Int8 DEF_AudioSyncAdjustment = System::Int8(0x0);
static const System::Int8 DEF_MixAudioSamplesLevel = System::Int8(0x64);
static const System::Int8 DEF_Mixer_MosaicColumns = System::Int8(0x1);
static const System::Int8 DEF_Mixer_MosaicLines = System::Int8(0x1);
static const bool DEF_AudioPeakEvent = true;
static const bool DEF_AudioRecording = false;
static const TAudioSource DEF_AudioSource = (TAudioSource)(0);
static const TVuMeter DEF_VuMeter = (TVuMeter)(0);
static const bool DEF_AutoConnectRelatedPins = true;
static const TAutoFileName DEF_AutoFileName = (TAutoFileName)(0);
static const System::Int8 DEF_AutoFileNameMinDigits = System::Int8(0x6);
static const bool DEF_AutoRefreshPreview = false;
static const bool DEF_AutoStartPlayer = true;
static const bool DEF_AVIFormatOpenDML = true;
static const bool DEF_AVIFormatOpenDMLCompatibilityIndex = true;
static const bool DEF_AVIDurationUpdated = true;
static const int DEF_BackgroundColor = int(0);
static const System::Int8 DEF_BufferCount = System::Int8(-1);
static const System::Int8 DEF_BurstCount = System::Int8(0x3);
static const Vcl::Forms::TFormBorderStyle DEF_BorderStyle = (Vcl::Forms::TFormBorderStyle)(1);
static const System::Int8 DEF_BurstInterval = System::Int8(0x0);
static const bool DEF_BurstMode = false;
static const TFrameCaptureDest DEF_BurstType = (TFrameCaptureDest)(0);
static const short DEF_BusyCursor = short(-11);
static const short DEF_NormalCursor = short(0);
static const bool DEF_CameraControlSettings = true;
static const int DEF_ColorKey = int(0x100010);
static const bool DEF_ColorKeyEnabled = false;
static const TCompressionMode DEF_CompressionMode = (TCompressionMode)(1);
static const TCompressionType DEF_CompressionType = (TCompressionType)(0);
static const short DEF_Cursor = short(0);
static const bool DEF_Display_Active = true;
static const bool DEF_Display_AlphaBlendEnabled = false;
static const System::Byte DEF_Display_AlphaBlendValue = System::Byte(0xb4);
static const bool DEF_Display_TransparentColorEnabled = false;
static const System::Byte DEF_Display_TransparentColorValue = System::Byte(0xff);
static const bool DEF_Display_AutoSize = false;
static const TAspectRatio DEF_Display_AspectRatio = (TAspectRatio)(0);
static const bool DEF_Display_Embedded = true;
static const bool DEF_Display_Embedded_FitParent = false;
static const System::Int8 DEF_Display_ExternalRenderer = System::Int8(-1);
static const bool DEF_Display_FullScreen = false;
static const System::Word DEF_Display_Height = System::Word(0x2d0);
static const System::Int8 DEF_Display_Left = System::Int8(0xa);
static const bool DEF_Display_StayOnTop = false;
static const System::Int8 DEF_Display_Monitor = System::Int8(0x0);
static const bool DEF_Display_MouseMovesWindow = true;
static const System::Int8 DEF_Display_PanScanRatio = System::Int8(0x32);
static const System::Int8 DEF_Display_Top = System::Int8(0xa);
static const bool DEF_Display_VideoPortEnabled = true;
static const bool DEF_Display_Visible = true;
static const System::Word DEF_Display_Width = System::Word(0x500);
static const bool DEF_DoubleBuffered = true;
static const bool DEF_DualDisplay_AutoSize = false;
static const System::Int8 DEF_DualDisplay_Left = System::Int8(0x14);
static const System::Word DEF_DualDisplay_Top = System::Word(0x190);
static const System::Int8 DEF_DroppedFramesPollingInterval = System::Int8(-1);
static const bool DEF_DualDisplay_Active = false;
static const bool DEF_DualDisplay_Embedded = false;
static const bool DEF_DualDisplay_Embedded_FitParent = false;
static const bool DEF_DualDisplay_VideoPortEnabled = false;
static const bool DEF_DVDateTimeEnabled = true;
static const System::Int8 DEF_DVDTitle = System::Int8(0x0);
static const System::Int8 DEF_DVDiscontinuityMinimumInterval = System::Int8(0x3);
static const bool DEF_DVRgb219 = false;
static const bool DEF_DVReduceFrameRate = false;
static const bool DEF_DVRecordingInNativeFormatSeparatesStreams = false;
static const bool DEF_DVTimeCodeEnabled = false;
static const bool DEF_EventNotificationSynchrone = true;
static const bool DEF_Cropping_Enabled = false;
static const System::Int8 DEF_Cropping_Height = System::Int8(0x78);
static const bool DEF_Cropping_Outbounds = true;
static const System::Byte DEF_Cropping_Width = System::Byte(0xa0);
static const System::Int8 DEF_Cropping_X = System::Int8(0x0);
static const System::Int8 DEF_Cropping_Y = System::Int8(0x0);
#define DEF_Cropping_Zoom  (1.000000E+00)
static const TDVVideoFormat DEF_DVEncoder_VideoFormat = (TDVVideoFormat)(1);
static const TDVVideoStandard DEF_DVEncoder_VideoStandard = (TDVVideoStandard)(0);
static const TDVSize DEF_DVEncoder_VideoResolution = (TDVSize)(0);
static const TEncryptionMethod DEF_EncryptionMethod = (TEncryptionMethod)(0);
static const TFiltersSet DEF_FiltersSet = (TFiltersSet)(0);
static const bool DEF_FixFlickerOrBlackCapture = false;
static const bool DEF_FrameCaptureWithoutOverlay = false;
static const System::Int8 DEF_FrameCaptureZoomSize = System::Int8(0x64);
static const System::Int8 DEF_FrameCaptureWidth = System::Int8(-1);
static const System::Int8 DEF_FrameCaptureHeight = System::Int8(-1);
static const bool DEF_FrameNumberStartsFromZero = false;
static const TFrameGrabber DEF_FrameGrabber = (TFrameGrabber)(0);
static const TFrameGrabberRGBFormat DEF_FrameGrabberRGBFormat = (TFrameGrabberRGBFormat)(0);
static const System::Int8 DEF_FrameRateDivider = System::Int8(0x0);
static const System::Int8 DEF_GetLastFrameWaitTimeoutMs = System::Int8(0x0);
static const bool Def_GeneratePts = false;
static const System::Word DEF_IPCameraConnectionTimeout = System::Word(0x4e21);
static const System::Word DEF_IPCameraReceiveTimeout = System::Word(0x1389);
static const System::Word DEF_StreamInterfaceConnectionTimeout = System::Word(0x7d0);
static const System::Word DEF_StreamInterfaceReceiveTimeout = System::Word(0x7d0);
static const bool DEF_HoldRecording = false;
static const bool DEF_ImageOverlay_AlphaBlend = false;
static const bool DEF_ImageOverlay_ChromaKey = false;
static const System::Byte DEF_ImageOverlay_AlphaBlendValue = System::Byte(0xb4);
static const System::Int8 DEF_ImageOverlay_ChromaKeyLeewayPercent = System::Int8(0x19);
static const System::Int8 DEF_ImageOverlay_ChromaKeyRGBColor = System::Int8(0x0);
static const System::Int8 DEF_ImageOverlay_Height = System::Int8(-1);
static const System::Int8 DEF_ImageOverlay_LeftLocation = System::Int8(0xa);
static const bool DEF_ImageOverlay_StretchToVideoSize = false;
static const System::Int8 DEF_ImageOverlay_TopLocation = System::Int8(0xa);
static const bool DEF_ImageOverlay_Transparent = false;
static const System::Int8 DEF_ImageOverlay_TransparentColorValue = System::Int8(0x0);
static const bool DEF_ImageOverlay_UseTransparentColor = false;
static const System::Int8 DEF_ImageOverlay_Width = System::Int8(-1);
static const bool DEF_ImageOverlayEnabled = false;
static const TJPEGPerformance DEF_JPEGPerformance = (TJPEGPerformance)(0);
static const bool DEF_JPEGProgressiveDisplay = false;
static const System::Int8 DEF_JPEGQuality = System::Int8(0x64);
static const bool DEF_LogoDisplayed = false;
static const TLogoLayout DEF_LogoLayout = (TLogoLayout)(1);
static const bool DEF_MotionDetector_CompareBlue = true;
static const bool DEF_MotionDetector_CompareGreen = true;
static const bool DEF_MotionDetector_GreyScale = false;
static const bool DEF_MotionDetector_CompareRed = true;
static const bool DEF_MotionDetector_Enabled = false;
static const System::Int8 DEF_MotionDetector_MaxDetectionsPerSecond = System::Int8(0x0);
static const System::Int8 DEF_MotionDetector_ReduceCPULoad = System::Int8(0x1);
static const System::Int8 DEF_MotionDetector_MotionResetMs = System::Int8(0x0);
static const bool DEF_MotionDetector_ReduceVideoNoise = false;
static const bool DEF_MotionDetector_Triggered = false;
static const bool DEF_MouseWheelEventEnabled = true;
static const bool DEF_MouseWheelControlsZoomAtCursor = false;
static const bool DEF_MultiplexedInputEmulation = true;
static const TMultiplexedRole DEF_MultiplexedRole = (TMultiplexedRole)(0);
static const System::Int8 DEF_MultiplexedSwitchDelay = System::Int8(0x0);
static const System::Int8 DEF_MultiplexedStabilizationDelay = System::Int8(0x64);
static const System::Int8 DEF_Multiplexer = System::Int8(-1);
static const bool DEF_MuteAudioRendering = false;
static const System::Word DEF_NDIReceiveTimeoutMs = System::Word(0x1388);
static const TNDIBandwidthType DEF_NDIBandwidthType = (TNDIBandwidthType)(3);
static const TNDIFormatType DEF_NDIFormatType = (TNDIFormatType)(1);
static const TNetworkStreaming DEF_NetworkStreaming = (TNetworkStreaming)(0);
static const TNetworkStreamingType DEF_NetworkStreamingType = (TNetworkStreamingType)(0);
static const TNotificationMethod DEF_NotificationMethod = (TNotificationMethod)(1);
static const System::Int8 DEF_NotificationSleepTime = System::Int8(-1);
static const System::Classes::TThreadPriority DEF_NotificationPriority = (System::Classes::TThreadPriority)(3);
static const bool DEF_OverlayAfterTransform = false;
static const TVideoAlignment DEF_OverlayAlignment = (TVideoAlignment)(0);
static const bool DEF_OnFrameBitmapEventSynchrone = false;
static const bool DEF_OverlayEventCallbackAllowed = false;
static const System::Int8 DEF_OverlayTargetDisplay = System::Int8(-1);
static const bool DEF_PlayerAudioRendering = true;
static const TDVSize DEF_PlayerDVSize = (TDVSize)(0);
static const System::Int8 DEF_PlayerFastSeekSpeedRatio = System::Int8(0x4);
static const THwAccel DEF_PlayerHwAccel = (THwAccel)(0);
static const bool DEF_PlayerRefreshPausedDisplay = false;
#define DEF_PlayerRefreshPausedDisplayFrameRate  (0.000000E+00)
static const System::Int8 DEF_PlayerSpeedRatio = System::Int8(0x1);
static const bool DEF_PlayerSpeedRatioConstantAudioPitch = true;
static const bool DEF_PreallocCapFileCopiedAfterRecording = true;
static const bool DEF_PlayerTrackBarSynchrone = false;
static const bool DEF_PreallocCapFileEnabled = false;
static const System::Int8 DEF_PreallocCapFileSizeInMB = System::Int8(0x64);
static const System::Int8 DEF_PreviewZoomSize = System::Int8(0x64);
static const bool DEF_QuickDeviceInitialization = false;
static const bool DEF_RawAudioSampleCapture = false;
static const bool DEF_RawCaptureAsyncEvent = true;
static const TRawSampleCaptureLocation DEF_RawSampleCaptureLocation = (TRawSampleCaptureLocation)(0);
static const bool DEF_RawVideoSampleCapture = false;
static const System::Int8 DEF_RecordingAudioBitRate = System::Int8(-1);
static const System::Int8 DEF_RecordingVideoBitRate = System::Int8(-1);
static const bool DEF_RecordingInNativeFormat = true;
static const System::Int8 DEF_RecordingFileSizeMaxInMB = System::Int8(0x0);
static const TRecordingMethod DEF_RecordingMethod = (TRecordingMethod)(5);
static const bool DEF_RecordingPauseCreatesNewFile = false;
static const bool DEF_RecordingOnMotion_Enabled = false;
static const System::Int8 DEF_RecordingOnMotion_MotionThreshold = System::Int8(0x0);
static const System::Word DEF_RecordingOnMotion_NoMotionPauseDelayMs = System::Word(0x1388);
static const TRecordingTimer DEF_RecordingTimer = (TRecordingTimer)(0);
static const System::Int8 DEF_RecordingTimerInterval = System::Int8(0x3c);
static const System::Int8 DEF_NoTimeSpecified = System::Int8(-1);
static const bool DEF_Reencoding_IncludeAudioStream = true;
static const bool DEF_Reencoding_IncludeVideoStream = true;
static const TRecordingMethod DEF_Reencoding_Method = (TRecordingMethod)(1);
static const bool DEF_Reencoding_UseAudioCompressor = false;
static const bool DEF_Reencoding_UseFrameGrabber = true;
static const bool DEF_Reencoding_UseVideoCompressor = false;
static const bool DEF_Reencoding_WMVOutput = false;
static const TRecordingSize DEF_RecordingSize = (TRecordingSize)(0);
static const System::Int8 DEF_ScreenRecordingMonitor = System::Int8(0x0);
static const bool DEF_ScreenRecordingLayeredWindows = false;
static const bool DEF_ScreenRecordingNonVisibleWindows = false;
static const bool DEF_ScreenRecordingThroughClipboard = false;
static const bool DEF_ScreenRecordingWithCursor = true;
static const System::Int8 DEF_ScreenRecordingSizePercent = System::Int8(0x64);
static const System::Int8 DEF_ServerLostRetryCount = System::Int8(0x0);
static const System::Int8 DEF_ServerLostRetryInterval = System::Int8(0x5);
static const System::Int8 DEF_SendToDV_DeviceIndex = System::Int8(-1);
static const bool DEF_ShapeOverlayEnabled = false;
static const bool DEF_SpeakerControl = false;
static const bool DEF_StoreDeviceSettingsInRegistry = true;
static const TStoragePathMode DEF_StoragePathMode = (TStoragePathMode)(0);
static const bool DEF_Synchronized = false;
static const TSynchronizationRole DEF_SynchronizationRole = (TSynchronizationRole)(0);
static const bool DEF_SyncCommands = true;
static const TSyncPreview DEF_SyncPreview = (TSyncPreview)(0);
static const bool DEF_TextOverlay_Enabled = false;
static const bool DEF_TextOverlay_AlphaBlend = false;
static const System::Byte DEF_TextOverlay_AlphaBlendValue = System::Byte(0xb4);
static const int DEF_TextOverlay_FontColor = int(0xffff00);
static const System::Int8 DEF_TextOverlay_FontSize = System::Int8(0xc);
static const System::Int8 DEF_TextOverlay_Left = System::Int8(0x0);
static const System::Int8 DEF_TextOverlay_Top = System::Int8(0x0);
static const System::Int8 DEF_TextOverlay_Right = System::Int8(-1);
static const bool DEF_TextOverlay_Scrolling = false;
static const System::Int8 DEF_TextOverlay_ScrollingSpeed = System::Int8(0x1);
static const bool DEF_TextOverlay_Shadow = true;
static const TTextOrientation DEF_TextOverlay_Orientation = (TTextOrientation)(0);
static const int DEF_TextOverlay_ShadowColor = int(0);
static const TCardinalDirection DEF_TextOverlay_ShadowDirection = (TCardinalDirection)(3);
static const int DEF_TextOverlay_BkColor = int(16777215);
static const TTextOverlayGradientMode DEF_TextOverlay_GradientMode = (TTextOverlayGradientMode)(0);
static const int DEF_TextOverlay_GradientColor = int(8388608);
static const TTextOverlayAlign DEF_TextOverlay_Align = (TTextOverlayAlign)(0);
static const bool DEF_TextOverlay_HighResFont = true;
static const bool DEF_TextOverlay_Transparent = true;
static const bool DEF_TranslateMouseCoordinates = true;
static const bool DEF_TVUseFrequencyOverrides = false;
static const System::Int8 DEF_TunerFrequency = System::Int8(-1);
static const TTunerMode DEF_TunerMode = (TTunerMode)(0);
static const bool DEF_UseClock = true;
static const bool DEF_v360_Enabled = false;
static const System::Int8 DEF_v360_MouseActionPercent = System::Int8(0xa);
static const TV360_MouseAction DEF_v360_MouseAction = (TV360_MouseAction)(2);
static const Tv360_Angle DEF_v360_MasterAngle = (Tv360_Angle)(1);
#define DEF_v360_AspectRatio  (0.000000E+00)
static const System::Int8 DEF_VideoDelay = System::Int8(0x0);
static const System::Int8 DEF_VideoDevice = System::Int8(-1);
static const System::Int8 DEF_VideoCompression_DataRate = System::Int8(-1);
static const System::Int8 DEF_VideoCompression_KeyFrameRate = System::Int8(0xf);
static const System::Int8 DEF_VideoCompression_PFramesPerKeyFrame = System::Int8(0x0);
static const System::Int8 DEF_VideoCompression_Quality = System::Int8(0x1);
static const System::Int8 DEF_VideoCompression_WindowSize = System::Int8(-1);
static const System::Int8 DEF_StoredValueDefaults = System::Int8(-1);
static const bool DEF_VideoControlSettings = true;
static const TFileSort DEF_VideoFromImages_BitmapsSortedBy = (TFileSort)(0);
static const bool DEF_VideoFromImages_RepeatIndefinitely = false;
static const bool DEF_VideoPlayableWhileRecording = false;
static const System::Int8 DEF_VideoProcessing_Brightness = System::Int8(0x0);
static const System::Int8 DEF_VideoProcessing_Contrast = System::Int8(0x0);
static const TVideoDeinterlacing DEF_VideoProcessing_Deinterlacing = (TVideoDeinterlacing)(0);
static const bool DEF_VideoProcessing_FlipHorizontal = false;
static const bool DEF_VideoProcessing_FlipVertical = false;
static const bool DEF_VideoProcessing_GrayScale = false;
static const System::Int8 DEF_VideoProcessing_Hue = System::Int8(0x0);
static const bool DEF_VideoProcessing_InvertColors = false;
static const System::Int8 DEF_VideoProcessing_Pixellization = System::Int8(0x1);
static const System::Int8 DEF_VideoProcessing_Saturation = System::Int8(0x0);
static const TVideoRotation DEF_VideoProcessing_Rotation = (TVideoRotation)(0);
#define DEF_VideoProcessing_RotationCustomAngle  (4.550000E+01)
static const System::Int8 DEF_VideoSampling_TimeInterval_Ms = System::Int8(0x0);
static const System::Int8 DEF_VideoSampling_FinalFrameRate_x100 = System::Int8(0x0);
static const bool DEF_VideoQualitySettings = true;
static const TVideoRenderer DEF_VideoRenderer = (TVideoRenderer)(0);
static const TVideoRendererPriority DEF_VideoRendererPriority = (TVideoRendererPriority)(2);
static const TVideoRendererExternal DEF_VideoRendererExternal = (TVideoRendererExternal)(0);
static const System::Int8 DEF_VideoRendererExternalIndex = System::Int8(-1);
static const TVideoSource DEF_VideoSource = (TVideoSource)(0);
static const System::Int8 DEF_VideoStreamNumber = System::Int8(-1);
static const bool DEF_VideoVisibleWhenStopped = false;
static const System::Int8 DEF_VirtualVideoStreamControl = System::Int8(-1);
static const System::Int8 DEF_VirtualAudioStreamControl = System::Int8(-1);
static const TWebcamStillCaptureButton DEF_WebcamStillCaptureButton = (TWebcamStillCaptureButton)(0);
static const System::Int8 DEF_ZoomYCenter = System::Int8(0x0);
static const System::Int8 DEF_ZoomXCenter = System::Int8(0x0);
static const System::Word DEF_ZoomCoeff = System::Word(0x3e8);
#define DATASTEADREGENTRY L"\\Software\\Datastead\\"
#define DEFAULTREGIDNAME L"\\Software\\Datastead\\TVideoGrabber\\"
extern DELPHI_PACKAGE HKEY RegRootKey;
extern DELPHI_PACKAGE System::UnicodeString RegKeyId;
extern DELPHI_PACKAGE bool _IsVgAx;
extern DELPHI_PACKAGE void __fastcall Register(void);
}	/* namespace Vidgrab */
#if !defined(DELPHIHEADER_NO_IMPLICIT_NAMESPACE_USE) && !defined(NO_USING_NAMESPACE_VIDGRAB)
using namespace Vidgrab;
#endif
#pragma pack(pop)
#pragma option pop

#pragma delphiheader end.
//-- end unit ----------------------------------------------------------------
#endif	// VidgrabHPP
