/*
 * Decompiled with CFR 0.152.
 */
package com.datastead.fx;

import java.lang.reflect.Method;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.concurrent.atomic.AtomicReference;
import javafx.animation.AnimationTimer;
import javafx.application.Platform;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.image.PixelBuffer;
import javafx.scene.image.PixelFormat;
import javafx.scene.image.PixelWriter;
import javafx.scene.image.WritableImage;

public class TVideoGrabber
extends com.datastead.TVideoGrabber {
    private ImageView imageView;
    private WritableImage image;
    private PixelFormat<ByteBuffer> fmt;
    private int w;
    private int h;
    private int stride;
    private int bpp;
    private boolean gpuPipeline = false;
    private boolean zeroCopyActive = false;
    private PixelBuffer<ByteBuffer> pixelBuffer;
    private ByteBuffer pinnedBuffer;
    private final AtomicReference<ByteBuffer> readyToRender = new AtomicReference<Object>(null);
    private ByteBuffer stage0;
    private ByteBuffer stage1;
    private int stageCap = 0;
    private boolean stageToggle = false;
    private AnimationTimer pump;
    private volatile boolean acceptingFrames = false;
    private volatile boolean workerRunning = false;
    private PixelFormat<ByteBuffer> fmtFX32;
    private PixelFormat<ByteBuffer> fmtFX24;
    private long seq = 0L;
    private final AtomicReference<Frame> latest = new AtomicReference();
    private final ArrayDeque<byte[]> bufferPool = new ArrayDeque();
    private final Object poolLock = new Object();
    private int pooledCapacity = 0;
    private Thread renderThread;
    byte[] rgbRow = null;

    private native void SetOnUpdateFrame(long var1, updateFrameCB var3);

    private native void ClearOnUpdateFrame(long var1);

    @Override
    public void dispose() {
        this.ClearOnUpdateFrameBuffers();
        super.dispose();
    }

    private void OnStoppingGraph() {
        this.acceptingFrames = false;
        this.stopFrameWorker();
    }

    private void OnGraphBuilt() {
        this.acceptingFrames = true;
        this.startFrameWorker();
    }

    public TVideoGrabber() {
        if (this.nativePtr != 0L) {
            this.setOnGraphBuilt(this::OnGraphBuilt);
            this.setOnStoppingGraphCompleted(this::OnStoppingGraph);
        }
    }

    @Override
    public boolean startPreview() {
        boolean bl = this.startAsync(() -> super.startPreview());
        return bl;
    }

    @Override
    public boolean startRecording() {
        return this.startAsync(() -> super.startRecording());
    }

    public void setView(ImageView imageView) {
        this.imageView = imageView;
        if (imageView != null) {
            this.detectPipelineOnce();
            this.SetOnUpdateFrame(this.nativePtr, this::onUpdateView);
            this.startPump();
        } else {
            this.ClearOnUpdateFrameBuffers();
        }
    }

    public void ClearOnUpdateFrameBuffers() {
        this.acceptingFrames = false;
        try {
            this.ClearOnUpdateFrame(this.nativePtr);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        super.stopPreview();
        if (this.pump != null) {
            this.pump.stop();
            this.pump = null;
        }
        this.readyToRender.set(null);
        this.zeroCopyActive = false;
        this.pixelBuffer = null;
        this.pinnedBuffer = null;
        this.image = null;
        this.stage1 = null;
        this.stage0 = null;
        this.stageCap = 0;
    }

    private void startFrameWorker() {
        if (this.workerRunning) {
            return;
        }
        this.workerRunning = true;
        this.renderThread = new Thread(() -> {
            Frame frame;
            while (this.workerRunning) {
                frame = this.latest.getAndSet(null);
                if (frame == null) {
                    try {
                        Thread.sleep(1L);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                Frame frame2 = frame;
                if (frame2.bpp == 32 && this.fmtFX32 == null) {
                    this.fmtFX32 = PixelFormat.getByteBgraPreInstance();
                } else if (frame2.bpp == 24 && this.fmtFX24 == null) {
                    this.fmtFX24 = PixelFormat.getByteRgbInstance();
                }
                Platform.runLater(() -> {
                    if (this.image == null || frame.w != this.w || frame.h != this.h) {
                        this.image = new WritableImage(frame.w, frame.h);
                    }
                    this.w = frame.w;
                    this.h = frame.h;
                    PixelWriter pixelWriter = this.image.getPixelWriter();
                    int n = frame.stride;
                    byte[] byArray = frame.data;
                    if (frame.bpp == 32) {
                        for (int i = 0; i < frame.h; ++i) {
                            int n2 = (frame.h - 1 - i) * n;
                            pixelWriter.setPixels(0, i, frame.w, 1, this.fmtFX32, byArray, n2, n);
                        }
                    } else {
                        if (this.rgbRow == null || this.rgbRow.length < frame.w * 3) {
                            this.rgbRow = new byte[frame.w * 3];
                        }
                        for (int i = 0; i < frame.h; ++i) {
                            int n3 = (frame.h - 1 - i) * n;
                            int n4 = 0;
                            for (int j = 0; j < frame.w; ++j) {
                                byte by = byArray[n3++];
                                byte by2 = byArray[n3++];
                                byte by3 = byArray[n3++];
                                this.rgbRow[n4++] = by3;
                                this.rgbRow[n4++] = by2;
                                this.rgbRow[n4++] = by;
                            }
                            pixelWriter.setPixels(0, i, frame.w, 1, this.fmtFX24, this.rgbRow, 0, frame.w * 3);
                        }
                    }
                    if (this.imageView != null) {
                        this.imageView.setImage((Image)this.image);
                    }
                    this.recycle(frame.data);
                });
            }
            frame = this.latest.getAndSet(null);
            if (frame != null) {
                this.recycle(frame.data);
            }
        }, "FX-FrameRenderer");
        this.renderThread.setDaemon(true);
        this.renderThread.start();
    }

    private void stopFrameWorker() {
        this.workerRunning = false;
        if (this.renderThread != null) {
            try {
                this.renderThread.join(200L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.renderThread = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] acquire(int n) {
        Object object = this.poolLock;
        synchronized (object) {
            byte[] byArray;
            if (!this.bufferPool.isEmpty() && (byArray = this.bufferPool.pollFirst()) != null && byArray.length >= n) {
                return byArray;
            }
            if (n > this.pooledCapacity) {
                this.pooledCapacity = n;
            }
        }
        return new byte[n];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recycle(byte[] byArray) {
        if (byArray == null) {
            return;
        }
        Object object = this.poolLock;
        synchronized (object) {
            if (this.bufferPool.size() < 4) {
                this.bufferPool.addLast(byArray);
            }
        }
    }

    private void onUpdateView(ByteBuffer byteBuffer, int n, int n2, int n3, int n4) {
        if (!this.acceptingFrames || this.imageView == null || byteBuffer == null) {
            return;
        }
        if (n4 != 24 && n4 != 32) {
            return;
        }
        int n5 = n4 / 8;
        int n6 = n3 * n2;
        byte[] byArray = this.acquire(n6);
        ByteBuffer byteBuffer2 = byteBuffer.duplicate();
        byteBuffer2.clear();
        byteBuffer2.limit(n6);
        if (byteBuffer2.hasArray()) {
            System.arraycopy(byteBuffer2.array(), byteBuffer2.arrayOffset(), byArray, 0, n6);
        } else {
            byteBuffer2.get(byArray, 0, n6);
        }
        long l = ++this.seq;
        Frame frame = new Frame(byArray, n, n2, n3, n4, l);
        Frame frame2 = this.latest.getAndSet(frame);
        if (frame2 != null) {
            this.recycle(frame2.data);
        }
    }

    private void startPump() {
        if (this.pump != null) {
            return;
        }
        this.pump = new AnimationTimer(){

            public void handle(long l) {
                ByteBuffer byteBuffer = TVideoGrabber.this.readyToRender.getAndSet(null);
                if (byteBuffer == null) {
                    return;
                }
                if (TVideoGrabber.this.zeroCopyActive && TVideoGrabber.this.pixelBuffer != null) {
                    TVideoGrabber.this.pixelBuffer.updateBuffer(pixelBuffer -> null);
                    if (TVideoGrabber.this.imageView.getImage() == null) {
                        TVideoGrabber.this.imageView.setImage((Image)new WritableImage(TVideoGrabber.this.pixelBuffer));
                    }
                    return;
                }
                if (TVideoGrabber.this.image != null && TVideoGrabber.this.fmt != null) {
                    TVideoGrabber.this.image.getPixelWriter().setPixels(0, 0, TVideoGrabber.this.w, TVideoGrabber.this.h, TVideoGrabber.this.fmt, (Buffer)byteBuffer, TVideoGrabber.this.stride);
                    if (TVideoGrabber.this.imageView.getImage() != TVideoGrabber.this.image) {
                        TVideoGrabber.this.imageView.setImage((Image)TVideoGrabber.this.image);
                    }
                }
            }
        };
        this.pump.start();
    }

    private void detectPipelineOnce() {
        if (this.gpuPipeline) {
            return;
        }
        try {
            Class<?> clazz = Class.forName("com.sun.prism.GraphicsPipeline");
            Method method = clazz.getDeclaredMethod("getPipeline", new Class[0]);
            method.setAccessible(true);
            Object object = method.invoke(null, new Object[0]);
            this.gpuPipeline = object != null && !object.getClass().getName().toLowerCase().contains("swpipeline");
        }
        catch (Throwable throwable) {
            this.gpuPipeline = false;
        }
    }

    private static interface updateFrameCB {
        public void onUpdateFrame(ByteBuffer var1, int var2, int var3, int var4, int var5);
    }

    private static final class Frame {
        byte[] data;
        int w;
        int h;
        int stride;
        int bpp;
        long seq;

        Frame(byte[] byArray, int n, int n2, int n3, int n4, long l) {
            this.data = byArray;
            this.w = n;
            this.h = n2;
            this.stride = n3;
            this.bpp = n4;
            this.seq = l;
        }
    }
}

