/*
 * Decompiled with CFR 0.152.
 */
package com.datastead.swing;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JPanel;
import javax.swing.Timer;

public class TVideoGrabber
extends com.datastead.TVideoGrabber {
    private VideoPanel panel;
    private BufferedImage img0;
    private BufferedImage img1;
    private byte[] buf0;
    private byte[] buf1;
    private int w;
    private int h;
    private int stride;
    private int bpp;
    private int bytesPerPix;
    private final AtomicInteger writeIndex = new AtomicInteger(0);
    private volatile int displayIndex = -1;
    private final AtomicReference<Integer> ready = new AtomicReference<Object>(null);
    private Timer pump;
    private volatile boolean acceptingFrames = false;

    private native void SetOnUpdateFrame(long var1, updateFrameCB var3);

    private native void ClearOnUpdateFrame(long var1);

    public void setPanel(VideoPanel videoPanel) {
        this.panel = videoPanel;
        if (this.panel != null) {
            this.SetOnUpdateFrame(this.nativePtr, this::onUpdateFrame);
            this.startPump();
        } else {
            this.ClearOnUpdateFrameBuffers();
        }
    }

    @Override
    public boolean startPreview() {
        boolean bl = this.startAsync(() -> super.startPreview());
        if (bl) {
            this.acceptingFrames = true;
        }
        return bl;
    }

    @Override
    public void dispose() {
        this.ClearOnUpdateFrameBuffers();
        super.dispose();
    }

    public void ClearOnUpdateFrameBuffers() {
        this.acceptingFrames = false;
        try {
            this.ClearOnUpdateFrame(this.nativePtr);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        super.stopPreview();
        if (this.pump != null) {
            this.pump.stop();
            this.pump = null;
        }
        this.ready.set(null);
        this.img1 = null;
        this.img0 = null;
        this.buf1 = null;
        this.buf0 = null;
        this.displayIndex = -1;
    }

    private void onUpdateFrame(ByteBuffer byteBuffer, int n2, int n3, int n4, int n5) {
        int n6;
        if (!this.acceptingFrames || this.panel == null || byteBuffer == null) {
            return;
        }
        if (this.img0 == null || n2 != this.w || n3 != this.h || this.stride != n4 || this.bpp != n5) {
            this.w = n2;
            this.h = n3;
            this.stride = n4;
            this.bpp = n5;
            int n7 = this.bpp == 32 ? 4 : (this.bytesPerPix = this.bpp == 24 ? 3 : 0);
            if (this.bytesPerPix == 0) {
                return;
            }
            this.img0 = this.bpp == 24 ? new BufferedImage(this.w, this.h, 5) : new BufferedImage(this.w, this.h, 6);
            this.img1 = this.bpp == 24 ? new BufferedImage(this.w, this.h, 5) : new BufferedImage(this.w, this.h, 6);
            this.buf0 = ((DataBufferByte)this.img0.getRaster().getDataBuffer()).getData();
            this.buf1 = ((DataBufferByte)this.img1.getRaster().getDataBuffer()).getData();
            this.displayIndex = -1;
        }
        byte[] byArray = (n6 = this.writeIndex.getAndUpdate(n -> 1 - n)) == 0 ? this.buf0 : this.buf1;
        int n8 = this.h * this.stride;
        ByteBuffer byteBuffer2 = byteBuffer.duplicate();
        byteBuffer2.position(0).limit(n8);
        if (this.stride == this.w * this.bytesPerPix) {
            if (byteBuffer2.hasArray()) {
                System.arraycopy(byteBuffer2.array(), byteBuffer2.arrayOffset() + byteBuffer2.position(), byArray, 0, n8);
            } else {
                byteBuffer2.get(byArray, 0, n8);
            }
        } else {
            int n9 = this.w * this.bytesPerPix;
            int n10 = byteBuffer2.position();
            int n11 = 0;
            if (byteBuffer2.hasArray()) {
                byte[] byArray2 = byteBuffer2.array();
                int n12 = byteBuffer2.arrayOffset();
                for (int i = 0; i < this.h; ++i) {
                    System.arraycopy(byArray2, n12 + n10, byArray, n11, n9);
                    n10 += this.stride;
                    n11 += n9;
                }
            } else {
                for (int i = 0; i < this.h; ++i) {
                    byteBuffer2.position(n10).limit(n10 + n9);
                    byteBuffer2.get(byArray, n11, n9);
                    n10 += this.stride;
                    n11 += n9;
                }
            }
        }
        this.ready.set(n6);
    }

    private void startPump() {
        if (this.pump != null) {
            return;
        }
        this.pump = new Timer(16, actionEvent -> {
            Integer n = this.ready.getAndSet(null);
            if (n == null) {
                return;
            }
            if (n == this.displayIndex) {
                return;
            }
            BufferedImage bufferedImage = n == 0 ? this.img0 : this.img1;
            this.displayIndex = n;
            if (this.panel != null) {
                this.panel.setImage(bufferedImage);
            }
        });
        this.pump.setCoalesce(true);
        this.pump.start();
    }

    public static final class VideoPanel
    extends JPanel {
        private volatile BufferedImage image;
        private final Object lock = new Object();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setImage(BufferedImage bufferedImage) {
            Object object = this.lock;
            synchronized (object) {
                this.image = bufferedImage;
            }
            this.repaint();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void paintComponent(Graphics graphics) {
            BufferedImage bufferedImage;
            super.paintComponent(graphics);
            Object object = this.lock;
            synchronized (object) {
                bufferedImage = this.image;
            }
            if (bufferedImage != null) {
                int n = this.getWidth();
                int n2 = this.getHeight();
                float f = (float)n / (float)bufferedImage.getWidth();
                float f2 = (float)n2 / (float)bufferedImage.getHeight();
                float f3 = Math.min(f, f2);
                int n3 = Math.round((float)bufferedImage.getWidth() * f3);
                int n4 = Math.round((float)bufferedImage.getHeight() * f3);
                int n5 = (n - n3) / 2;
                int n6 = (n2 - n4) / 2;
                ((Graphics2D)graphics).drawImage(bufferedImage, n5, n6, n3, n4, null);
            }
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(640, 360);
        }
    }

    private static interface updateFrameCB {
        public void onUpdateFrame(ByteBuffer var1, int var2, int var3, int var4, int var5);
    }
}

