
// Explanations about the defines and functions below are located in Datastead_Multipurpose_DirectShow_Encoder.pdf 

// http://www.datastead.com/products/dsfilters/Multipurpose.html

//________________________________________________________________________________________________________
// DATASTEAD Multipurpose DIRECTSHOW ENCODER DEFINITIONS

const
   CLSID_DatasteadMultipurposeDirectShowEncoder: TGUID = '{39E3007B-6185-47FC-9839-C4B8621AC065}';


   EC_MPE_TERMINATED_SUCCESS = EC_USER + $5501;
   EC_MPE_TERMINATED_ERROR   = EC_USER + $5502;
   EC_MPE_LOGBUFFER_UPDATED  = EC_USER + $5503;

type

	IDatasteadMultipurposeDirectShowEncoder = interface(IUnknown)
    ['{43F00ED1-5F85-4C7E-98AC-AD5E13111D34}']
		function SetCommandLine             (CommandLine: POLESTR): HRESULT; stdcall;
		function GetCommandLine             (out CommandLine: POLESTR): HRESULT; stdcall;
		function Stop_PauseWhenStop         (): HRESULT; stdcall;
		function GetCurrentLog              (OnlyIfUpdated: Boolean; pBuffer: pAnsiChar; MaxBufferSize: LongInt; CurrentLogSize: pLongInt; CurrentLogFlags: pLongInt): HRESULT; stdcall;
		function IsCurrentLogUpdated        (): HRESULT; stdcall;
		function GetExitCode                (): LongInt; stdcall;
		function GetInputsTotalDurationMs   (): Cardinal; stdcall;
		function GetProgress_FrameCount     (): Cardinal; stdcall;
		function GetProgress_TimeMs         (): Cardinal; stdcall;
		function GetProgress_DuplicatedCount(): Cardinal; stdcall;
		function GetProgress_DroppedCount   (): Cardinal; stdcall;
		function GetProgress_Fps            (): double; stdcall;
		function GetProgress_Quality        (): double; stdcall;
		function GetProgress_SizeWrittenKb  (): double; stdcall;
		function GetProgress_BitRateKbps    (): double; stdcall;
		function GetConnectedVideoPinInfo   (out VideoWidth: LongInt;    out VideoHeight: LongInt;     out VideoAvgTimePerFrame: LongInt): HRESULT; stdcall;
		function GetConnectedAudioPinInfo   (out AudioChannels: LongInt; out AudioSampleRate: LongInt; out AudioBitsPerSample: LongInt): HRESULT; stdcall;
		function SetMediaEventSinkNotifyID  (Value: INT_PTR): HRESULT; stdcall;
		function Is64BitWindows             (): LONGBOOL; stdcall;
		function Is64BitApplication         (): LONGBOOL; stdcall;
	end;

	IDatasteadMultipurposeDirectShowEncoder2 = interface(IUnknown)
	 ['{61654563-047A-4DA1-979C-CFA17D36F1D2}']
		function GetVersion (): LongInt; stdcall;
	 end;

	IDatasteadMultipurposeDirectShowEncoderProcess = interface(IUnknown)
	 ['{938A2753-65A8-4FD4-9A82-9B81BB3F889B}']
		function GetMPEProcessID (out MPEProcessID: DWORD): HRESULT; stdcall;
	 end;


   IDatasteadMultipurposeDirectShowEncoderControl = interface(IUnknown)
    ['{E334D3D6-2F67-4178-BFAF-DBFA3413053E}']
      function PauseEncoder(): HRESULT; stdcall;
      function ResumeEncoder(): HRESULT; stdcall;
   end;

