using System; 
//using System.Linq;
using System.Runtime.InteropServices;
using System.ComponentModel;
//using System.Collections.Generic;

// Explanations about the defines and functions below are located in Datastead_Multipurpose_DirectShow_Encoder.pdf 

// http://www.datastead.com/products/dsfilters/multipurpose.html

//________________________________________________________________________________________________________
// DATASTEAD MULTIPURPOSE DIRECTSHOW ENCODER DEFINITIONS

namespace Datastead
{
    public class MultipurposeEncoder
    {
        const int EC_USER = 0x8000; // from DirectShow, comment this line if you get an "already defined" error

        public const int EC_MPE_TERMINATED_SUCCESS = EC_USER + 0x5501;
        public const int EC_MPE_TERMINATED_ERROR   = EC_USER + 0x5502;
        public const int EC_MPE_LOGBUFFER_UPDATED  = EC_USER + 0x5503;


        /// <summary>
        /// Datastead Multipurpose DirectShow Encoder CLSID
        /// </summary>
        public static readonly Guid CLSID_DatasteadMultipurposeDirectShowEncoder = new Guid("39E3007B-6185-47FC-9839-C4B8621AC065");

        /// <summary>
        /// IDatasteadMultipurposeDirectShowEncoder interface
        /// </summary>
        [ComImport,
            Guid("43F00ED1-5F85-4C7E-98AC-AD5E13111D34"),
            System.Security.SuppressUnmanagedCodeSecurity,
            InterfaceType(ComInterfaceType.InterfaceIsIUnknown)]
        public interface IDatasteadMultipurposeDirectShowEncoder
        {
            [PreserveSig] int    SetCommandLine([In, MarshalAs(UnmanagedType.LPWStr)] string CommandLine);
            [PreserveSig] int    GetCommandLine([Out] out IntPtr Value);
            [PreserveSig] int    Stop_PauseWhenStop();
            [PreserveSig] int    GetCurrentLog([In, MarshalAs(UnmanagedType.Bool)] bool OnlyIfUpdated,
                                               [In, MarshalAs(UnmanagedType.AnsiBStr)] IntPtr pBuffer,
                                               [In] int MaxBufferSize,
                                               [Out] out int CurrentLogSize,
                                               [Out] out int CurrentLogFlag);
            [PreserveSig] bool   IsCurrentLogUpdated();
            [PreserveSig] int    GetExitCode();
            [PreserveSig] uint   GetInputsTotalDurationMs();
            [PreserveSig] uint   GetProgress_FrameCount();
            [PreserveSig]uint    GetProgress_TimeMs();
            [PreserveSig] uint   GetProgress_DuplicatedCount();
            [PreserveSig] uint   GetProgress_DroppedCount();
            [PreserveSig] double GetProgress_Fps();
            [PreserveSig] double GetProgress_Quality();
            [PreserveSig] double GetProgress_SizeWrittenKb();
            [PreserveSig] double GetProgress_BitRateKbps();
            [PreserveSig] int    GetConnectedVideoPinInfo([Out] out int VideoWidth, [Out] out int VideoHeight, [Out] out int VideoAvgTimePerFrame);
            [PreserveSig] int    GetConnectedAudioPinInfo([Out] out int AudioChannels, [Out] out int AudioSampleRate, [Out] out int AudioBitsPerSample);
            [PreserveSig] int    SetMediaEventSinkNotifyID([In] IntPtr Value);
            [PreserveSig] bool   Is64BitWindows();
            [PreserveSig] bool   Is64BitApplication();
        }
    }
}

