#pragma once

#include "objbase.h"

// Explanations about the defines and functions below are located in Datastead_Multipurpose_DirectShow_Encoder.pdf 

// http://www.datastead.com/products/dsfilters/multipurpose.html

//________________________________________________________________________________________________________
// DATASTEAD MULTIPURPOSE DIRECTSHOW ENCODER DEFINITIONS

#define EC_MPE_TERMINATED_SUCCESS EC_USER + 0x5501
#define EC_MPE_TERMINATED_ERROR   EC_USER + 0x5502
#define EC_MPE_LOGBUFFER_UPDATED  EC_USER + 0x5503
#define EC_MPE_EVALUATION_TIMEOUT EC_USER + 0x5504

// To receive the video and/or audio samples from a DirectShow source (e.g. a webcam)
// -----------------------------------------------------
// Insert the filter in the graph, connect the video pin and/or audio pin, 
// then configure the command line with IDatasteadMultipurposeDirectShowEncoder.SetCommandLine then run the graph.
// {39E3007B-6185-47FC-9839-C4B8621AC065}
static const GUID CLSID_DatasteadMultipurposeDirectShowEncoder =
{ 0x39e3007b, 0x6185, 0x47fc, { 0x98, 0x39, 0xc4, 0xb8, 0x62, 0x1a, 0xc0, 0x65 } };

// To encode or stream from a video file (or audio file)
// -----------------------------------------------------
// No pin to connect, just add the filter in the graph, query the IFileSourceFilter interface to specify the video clip, 
// then configure the command line with IDatasteadMultipurposeDirectShowEncoder.SetCommandLine then run the graph.
// {A4EEBEBE-A375-4995-8DBC-F4E42A189D6A}
static const GUID CLSID_DatasteadMultipurposeDirectShowEncoderFromFile =
{ 0xa4eebebe, 0xa375, 0x4995, { 0x8d, 0xbc, 0xf4, 0xe4, 0x2a, 0x18, 0x9d, 0x6a } };


// To configure any of the the Datastead Multipurpose Encoder above
// -----------------------------------------------------
// The main function is SetCommandLine that lets configure the FFmpeg command line.
// {43F00ED1-5F85-4C7E-98AC-AD5E13111D34}
static const GUID IID_IDatasteadMultipurposeDirectShowEncoder =
{ 0x43f00ed1, 0x5f85, 0x4c7e, { 0x98, 0xac, 0xad, 0x5e, 0x13, 0x11, 0x1d, 0x34 } };

DECLARE_INTERFACE_(IDatasteadMultipurposeDirectShowEncoder, IUnknown)
{
	virtual HRESULT       STDMETHODCALLTYPE SetCommandLine(/*in*/ LPWSTR CommandLine) PURE;
	virtual HRESULT       STDMETHODCALLTYPE GetCommandLine(/*out*/ LPWSTR *CommandLine) PURE;
	virtual HRESULT       STDMETHODCALLTYPE Stop_PauseWhenStop() PURE;
	virtual HRESULT       STDMETHODCALLTYPE GetCurrentLog(/*in*/ bool OnlyIfUpdated, /*in*/ PCHAR pBuffer, /*in*/ int MaxBufferSize, /*out*/ int *CurrentLogSize, /*out*/ int *CurrentLogFlag) PURE;
	virtual HRESULT       STDMETHODCALLTYPE IsCurrentLogUpdated() PURE;
	virtual int           STDMETHODCALLTYPE GetExitCode() PURE;
	virtual unsigned int  STDMETHODCALLTYPE GetInputsTotalDurationMs() PURE;
	virtual unsigned int  STDMETHODCALLTYPE GetProgress_FrameCount() PURE;
	virtual unsigned int  STDMETHODCALLTYPE GetProgress_TimeMs() PURE;
	virtual unsigned int  STDMETHODCALLTYPE GetProgress_DuplicatedCount() PURE;
	virtual unsigned int  STDMETHODCALLTYPE GetProgress_DroppedCount() PURE;
	virtual double        STDMETHODCALLTYPE GetProgress_Fps() PURE;
	virtual double        STDMETHODCALLTYPE GetProgress_Quality() PURE;
	virtual double        STDMETHODCALLTYPE GetProgress_SizeWrittenKb() PURE;
	virtual double        STDMETHODCALLTYPE GetProgress_BitRateKbps() PURE;
	virtual HRESULT       STDMETHODCALLTYPE GetConnectedVideoPinInfo(/*out*/ int *VideoWidth, /*out*/ int *VideoHeight, /*out*/ int *VideoAvgTimePerFrame) PURE;
	virtual HRESULT       STDMETHODCALLTYPE GetConnectedAudioPinInfo(/*out*/ int *AudioChannels, /*out*/ int *AudioSampleRate, /*out*/ int *AudioBitsPerSample) PURE;
	virtual HRESULT       STDMETHODCALLTYPE SetMediaEventSinkNotifyID  (/*in*/ LONG_PTR Value) PURE;
	virtual BOOL          STDMETHODCALLTYPE Is64BitWindows() PURE;
	virtual BOOL          STDMETHODCALLTYPE Is64BitApplication() PURE;
};

// {61654563-047A-4DA1-979C-CFA17D36F1D2}
static const GUID IID_IDatasteadMultipurposeDirectShowEncoder2 =
{ 0x61654563, 0x47a, 0x4da1, { 0x97, 0x9c, 0xcf, 0xa1, 0x7d, 0x36, 0xf1, 0xd2 } };

DECLARE_INTERFACE_(IDatasteadMultipurposeDirectShowEncoder2, IUnknown)
{
	virtual unsigned int           STDMETHODCALLTYPE GetVersion() PURE;
};

// {F7F2BE3A-C4AC-43DB-8582-98E925CC2FE2}
static const GUID IID_IDatasteadMultipurposeDirectShowEncoderIDL =
{ 0xf7f2be3a, 0xc4ac, 0x43db, { 0x85, 0x82, 0x98, 0xe9, 0x25, 0xcc, 0x2f, 0xe2 } };

DECLARE_INTERFACE_(IDatasteadMultipurposeDirectShowEncoderIDL, IUnknown)
{
	virtual HRESULT STDMETHODCALLTYPE SetCommandLine(/*in*/ LPWSTR CommandLine) PURE;
	virtual HRESULT STDMETHODCALLTYPE GetCommandLine(/*out*/ LPWSTR * CommandLine) PURE;
	virtual HRESULT STDMETHODCALLTYPE Stop_PauseWhenStop() PURE;
	virtual HRESULT STDMETHODCALLTYPE GetCurrentLog(/*in*/ BOOL OnlyIfUpdated, /*in*/ LPCSTR pBuffer, /*in*/ int MaxBufferSize, /*out*/ int* CurrentLogSize, /*out*/ int* CurrentLogFlag) PURE;
	virtual HRESULT STDMETHODCALLTYPE IsCurrentLogUpdated() PURE;
	virtual HRESULT STDMETHODCALLTYPE GetExitCode(/*out*/ int *ExitCode) PURE;
	virtual HRESULT STDMETHODCALLTYPE GetInputsTotalDurationMs(/*out*/ unsigned int* InputsTotalDurationMs) PURE;
	virtual HRESULT STDMETHODCALLTYPE GetProgress_FrameCount(/*out*/ unsigned int* Progress_FrameCount) PURE;
	virtual HRESULT STDMETHODCALLTYPE GetProgress_TimeMs(/*out*/ unsigned int* Progress_TimeMs) PURE;
	virtual HRESULT STDMETHODCALLTYPE GetProgress_DuplicatedCount(/*out*/ unsigned int* Progress_DuplicatedCount) PURE;
	virtual HRESULT STDMETHODCALLTYPE GetProgress_DroppedCount(/*out*/ unsigned int* Progress_DroppedCount) PURE;
	virtual HRESULT STDMETHODCALLTYPE GetProgress_Fps(/*out*/ double* Progress_Fps) PURE;
	virtual HRESULT STDMETHODCALLTYPE GetProgress_Quality(/*out*/ double* Progress_Quality) PURE;
	virtual HRESULT STDMETHODCALLTYPE GetProgress_SizeWrittenKb(/*out*/ double* Progress_SizeWrittenKb) PURE;
	virtual HRESULT STDMETHODCALLTYPE GetProgress_BitRateKbps(/*out*/ double* Progress_BitRateKbps) PURE;
	virtual HRESULT STDMETHODCALLTYPE GetConnectedVideoPinInfo(/*out*/ int* VideoWidth, /*out*/ int* VideoHeight, /*out*/ int* VideoAvgTimePerFrame) PURE;
	virtual HRESULT STDMETHODCALLTYPE GetConnectedAudioPinInfo(/*out*/ int* AudioChannels, /*out*/ int* AudioSampleRate, /*out*/ int* AudioBitsPerSample) PURE;
	virtual HRESULT STDMETHODCALLTYPE SetMediaEventSinkNotifyID(/*in*/ LONG_PTR Value) PURE;
	virtual HRESULT STDMETHODCALLTYPE Is64BitWindows(/*out*/ BOOL* Is_64BitWindows) PURE;
	virtual HRESULT STDMETHODCALLTYPE Is64BitApplication(/*out*/ BOOL* Is64_BitApplication) PURE;
	virtual HRESULT STDMETHODCALLTYPE GetVersion(/*out*/ unsigned int* Version) PURE;
};

// {938A2753-65A8-4FD4-9A82-9B81BB3F889B}
static const GUID IID_IDatasteadMultipurposeDirectShowEncoderProcess =
{ 0x938a2753, 0x65a8, 0x4fd4, { 0x9a, 0x82, 0x9b, 0x81, 0xbb, 0x3f, 0x88, 0x9b } };

DECLARE_INTERFACE_(IDatasteadMultipurposeDirectShowEncoderProcess, IUnknown)
{
	virtual HRESULT       STDMETHODCALLTYPE GetMPEProcessID(/*out*/ DWORD ProcessID) PURE;
};

// {E334D3D6-2F67-4178-BFAF-DBFA3413053E}
static const GUID IID_IDatasteadMultipurposeDirectShowEncoderControl =
{ 0xe334d3d6, 0x2f67, 0x4178,{ 0xbf, 0xaf, 0xdb, 0xfa, 0x34, 0x13, 0x5, 0x3e } };

DECLARE_INTERFACE_(IDatasteadMultipurposeDirectShowEncoderControl, IUnknown)
{
	virtual HRESULT STDMETHODCALLTYPE PauseEncoder() PURE;
	virtual HRESULT STDMETHODCALLTYPE ResumeEncoder() PURE;
};
