#region license

/*
DirectShowLib - Provide access to DirectShow interfaces via .NET
Copyright (C) 2007
http://sourceforge.net/projects/directshownet/

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#endregion

using System.Runtime.InteropServices;

namespace DirectShowLib
{
    #region Declarations

    public enum EventCode
    {
        // EvCod.h
        Complete = 0x01, // EC_COMPLETE
        UserAbort = 0x02, // EC_USERABORT
        ErrorAbort = 0x03, // EC_ERRORABORT
        Time = 0x04, // EC_TIME
        Repaint = 0x05, // EC_REPAINT
        StErrStopped = 0x06, // EC_STREAM_ERROR_STOPPED
        StErrStPlaying = 0x07, // EC_STREAM_ERROR_STILLPLAYING
        ErrorStPlaying = 0x08, // EC_ERROR_STILLPLAYING
        PaletteChanged = 0x09, // EC_PALETTE_CHANGED
        VideoSizeChanged = 0x0a, // EC_VIDEO_SIZE_CHANGED
        QualityChange = 0x0b, // EC_QUALITY_CHANGE
        ShuttingDown = 0x0c, // EC_SHUTTING_DOWN
        ClockChanged = 0x0d, // EC_CLOCK_CHANGED
        Paused = 0x0e, // EC_PAUSED
        OpeningFile = 0x10, // EC_OPENING_FILE
        BufferingData = 0x11, // EC_BUFFERING_DATA
        FullScreenLost = 0x12, // EC_FULLSCREEN_LOST
        Activate = 0x13, // EC_ACTIVATE
        NeedRestart = 0x14, // EC_NEED_RESTART
        WindowDestroyed = 0x15, // EC_WINDOW_DESTROYED
        DisplayChanged = 0x16, // EC_DISPLAY_CHANGED
        Starvation = 0x17, // EC_STARVATION
        OleEvent = 0x18, // EC_OLE_EVENT
        NotifyWindow = 0x19, // EC_NOTIFY_WINDOW
        StreamControlStopped = 0x1A, // EC_STREAM_CONTROL_STOPPED
        StreamControlStarted = 0x1B, // EC_STREAM_CONTROL_STARTED
        EndOfSegment = 0x1C, // EC_END_OF_SEGMENT
        SegmentStarted = 0x1D, // EC_SEGMENT_STARTED
        LengthChanged = 0x1E, // EC_LENGTH_CHANGED
        DeviceLost = 0x1f, // EC_DEVICE_LOST
        SampleNeeded = 0x20, // EC_SAMPLE_NEEDED
        ProcessingLatency = 0x21, // EC_PROCESSING_LATENCY
        SampleLatency = 0x22, // EC_SAMPLE_LATENCY
        ScrubTime = 0x23, // EC_SCRUB_TIME
        StepComplete = 0x24, // EC_STEP_COMPLETE
        SkipFrames = 0x25, // EC_SKIP_FRAMES

        TimeCodeAvailable = 0x30, // EC_TIMECODE_AVAILABLE
        ExtDeviceModeChange = 0x31, // EC_EXTDEVICE_MODE_CHANGE
        StateChange = 0x32, // EC_STATE_CHANGE

        PleaseReOpen = 0x40, // EC_PLEASE_REOPEN
        Status = 0x41, // EC_STATUS
        MarkerHit = 0x42, // EC_MARKER_HIT
        LoadStatus = 0x43, // EC_LOADSTATUS
        FileClosed = 0x44, // EC_FILE_CLOSED
        ErrorAbortEx = 0x45, // EC_ERRORABORTEX
        EOSSoon = 0x046, // EC_EOS_SOON
        ContentPropertyChanged = 0x47, // EC_CONTENTPROPERTY_CHANGED
        BandwidthChange = 0x48, // EC_BANDWIDTHCHANGE
        VideoFrameReady = 0x49, // EC_VIDEOFRAMEREADY

        GraphChanged = 0x50, // EC_GRAPH_CHANGED
        ClockUnset = 0x51, // EC_CLOCK_UNSET
        VMRRenderDeviceSet = 0x53, // EC_VMR_RENDERDEVICE_SET
        VMRSurfaceFlipped = 0x54, // EC_VMR_SURFACE_FLIPPED
        VMRReconnectionFailed = 0x55, // EC_VMR_RECONNECTION_FAILED
        PreprocessComplete = 0x56, // EC_PREPROCESS_COMPLETE
        CodecApiEvent = 0x57, // EC_CODECAPI_EVENT

        // DVDevCod.h
        DvdDomainChange = 0x101, // EC_DVD_DOMAIN_CHANGE
        DvdTitleChange = 0x102, // EC_DVD_TITLE_CHANGE
        DvdChapterStart = 0x103, // EC_DVD_CHAPTER_START
        DvdAudioStreamChange = 0x104, // EC_DVD_AUDIO_STREAM_CHANGE
        DvdSubPicictureStreamChange = 0x105, // EC_DVD_SUBPICTURE_STREAM_CHANGE
        DvdAngleChange = 0x106, // EC_DVD_ANGLE_CHANGE
        DvdButtonChange = 0x107, // EC_DVD_BUTTON_CHANGE
        DvdValidUopsChange = 0x108, // EC_DVD_VALID_UOPS_CHANGE
        DvdStillOn = 0x109, // EC_DVD_STILL_ON
        DvdStillOff = 0x10a, // EC_DVD_STILL_OFF
        DvdCurrentTime = 0x10b, // EC_DVD_CURRENT_TIME
        DvdError = 0x10c, // EC_DVD_ERROR
        DvdWarning = 0x10d, // EC_DVD_WARNING
        DvdChapterAutoStop = 0x10e, // EC_DVD_CHAPTER_AUTOSTOP
        DvdNoFpPgc = 0x10f, // EC_DVD_NO_FP_PGC
        DvdPlaybackRateChange = 0x110, // EC_DVD_PLAYBACK_RATE_CHANGE
        DvdParentalLevelChange = 0x111, // EC_DVD_PARENTAL_LEVEL_CHANGE
        DvdPlaybackStopped = 0x112, // EC_DVD_PLAYBACK_STOPPED
        DvdAnglesAvailable = 0x113, // EC_DVD_ANGLES_AVAILABLE
        DvdPlayPeriodAutoStop = 0x114, // EC_DVD_PLAYPERIOD_AUTOSTOP
        DvdButtonAutoActivated = 0x115, // EC_DVD_BUTTON_AUTO_ACTIVATED
        DvdCmdStart = 0x116, // EC_DVD_CMD_START
        DvdCmdEnd = 0x117, // EC_DVD_CMD_END
        DvdDiscEjected = 0x118, // EC_DVD_DISC_EJECTED
        DvdDiscInserted = 0x119, // EC_DVD_DISC_INSERTED
        DvdCurrentHmsfTime = 0x11a, // EC_DVD_CURRENT_HMSF_TIME
        DvdKaraokeMode = 0x11b, // EC_DVD_KARAOKE_MODE
        DvdProgramCellChange = 0x11c, // EC_DVD_PROGRAM_CELL_CHANGE
        DvdTitleSetChange = 0x11d, // EC_DVD_TITLE_SET_CHANGE
        DvdProgramChainChange = 0x11e, // EC_DVD_PROGRAM_CHAIN_CHANGE
        DvdVOBU_Offset = 0x11f, // EC_DVD_VOBU_Offset
        DvdVOBU_Timestamp = 0x120, // EC_DVD_VOBU_Timestamp
        DvdGPRM_Change = 0x121, // EC_DVD_GPRM_Change
        DvdSPRM_Change = 0x122, // EC_DVD_SPRM_Change
        DvdBeginNavigationCommands = 0x123, // EC_DVD_BeginNavigationCommands
        DvdNavigationCommand = 0x124, // EC_DVD_NavigationCommand

        // AudEvCod.h
        SNDDEVInError = 0x200, // EC_SNDDEV_IN_ERROR
        SNDDEVOutError = 0x201, // EC_SNDDEV_OUT_ERROR

        WMTIndexEvent = 0x0251, // EC_WMT_INDEX_EVENT
        WMTEvent = 0x0252, // EC_WMT_EVENT

        Built = 0x300, // EC_BUILT
        Unbuilt = 0x301, // EC_UNBUILT

        // Sbe.h
        StreamBufferTimeHole = 0x0326, // STREAMBUFFER_EC_TIMEHOLE
        StreamBufferStaleDataRead = 0x0327, // STREAMBUFFER_EC_STALE_DATA_READ
        StreamBufferStaleFileDeleted = 0x0328, // STREAMBUFFER_EC_STALE_FILE_DELETED
        StreamBufferContentBecomingStale = 0x0329, // STREAMBUFFER_EC_CONTENT_BECOMING_STALE
        StreamBufferWriteFailure = 0x032a, // STREAMBUFFER_EC_WRITE_FAILURE
        StreamBufferReadFailure = 0x032b, // STREAMBUFFER_EC_READ_FAILURE
        StreamBufferRateChanged = 0x032c, // STREAMBUFFER_EC_RATE_CHANGED
    }

    #endregion
}
